/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmEqRef;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI31Ref;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012J\f\u0010\u0013\u001a\u0004\u0018\u00010\u0011*\u00020\u0012J\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0012H\u0002J\n\u0010\u0015\u001a\u00020\u0011*\u00020\u0012J\n\u0010\u0016\u001a\u00020\u0011*\u00020\u0012J\n\u0010\u001a\u001a\u00020\u0011*\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00110\u0018j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0011`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFileCodegenContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "getWasmFileCodegenContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "toWasmResultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "toWasmBlockResultType", "toWasmGcRefType", "toBoxedInlineClassType", "toWasmFieldType", "irBuiltInToWasmType", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "toWasmValueType", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nTypeTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeTransformer.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class WasmTypeTransformer {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmFileCodegenContext wasmFileCodegenContext;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private final HashMap<IrType, WasmType> irBuiltInToWasmType;

    public WasmTypeTransformer(@NotNull WasmBackendContext backendContext, @NotNull WasmFileCodegenContext wasmFileCodegenContext) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        Intrinsics.checkNotNullParameter(wasmFileCodegenContext, "wasmFileCodegenContext");
        this.backendContext = backendContext;
        this.wasmFileCodegenContext = wasmFileCodegenContext;
        this.builtIns = this.backendContext.getIrBuiltIns();
        this.symbols = this.backendContext.getWasmSymbols();
        Pair[] pairArray = new Pair[]{TuplesKt.to(this.builtIns.getBooleanType(), WasmI32.INSTANCE), TuplesKt.to(this.builtIns.getByteType(), WasmI32.INSTANCE), TuplesKt.to(this.builtIns.getShortType(), WasmI32.INSTANCE), TuplesKt.to(this.builtIns.getIntType(), WasmI32.INSTANCE), TuplesKt.to(this.builtIns.getCharType(), WasmI32.INSTANCE), TuplesKt.to(this.builtIns.getLongType(), WasmI64.INSTANCE), TuplesKt.to(this.builtIns.getFloatType(), WasmF32.INSTANCE), TuplesKt.to(this.builtIns.getDoubleType(), WasmF64.INSTANCE), TuplesKt.to(this.builtIns.getNothingNType(), WasmRefNullrefType.INSTANCE), TuplesKt.to(this.builtIns.getNothingType(), WasmAnyRef.INSTANCE)};
        this.irBuiltInToWasmType = MapsKt.hashMapOf(pairArray);
    }

    @NotNull
    public final WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final WasmFileCodegenContext getWasmFileCodegenContext() {
        return this.wasmFileCodegenContext;
    }

    @Nullable
    public final WasmType toWasmResultType(@NotNull IrType $this$toWasmResultType) {
        Intrinsics.checkNotNullParameter($this$toWasmResultType, "<this>");
        IrType irType = $this$toWasmResultType;
        return Intrinsics.areEqual(irType, this.builtIns.getUnitType()) || Intrinsics.areEqual(irType, this.builtIns.getNothingType()) ? null : this.toWasmValueType($this$toWasmResultType);
    }

    @Nullable
    public final WasmType toWasmBlockResultType(@NotNull IrType $this$toWasmBlockResultType) {
        Intrinsics.checkNotNullParameter($this$toWasmBlockResultType, "<this>");
        IrType irType = $this$toWasmBlockResultType;
        return Intrinsics.areEqual(irType, this.builtIns.getNothingType()) ? (WasmType)WasmUnreachableType.INSTANCE : (Intrinsics.areEqual(irType, this.symbols.getVoidType()) ? null : this.toWasmValueType($this$toWasmBlockResultType));
    }

    private final WasmType toWasmGcRefType(IrType $this$toWasmGcRefType) {
        return new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceGcType(TypeTransformerKt.getRuntimeClass($this$toWasmGcRefType, this.backendContext.getIrBuiltIns()).getSymbol())));
    }

    @NotNull
    public final WasmType toBoxedInlineClassType(@NotNull IrType $this$toBoxedInlineClassType) {
        Intrinsics.checkNotNullParameter($this$toBoxedInlineClassType, "<this>");
        return this.toWasmGcRefType($this$toBoxedInlineClassType);
    }

    @NotNull
    public final WasmType toWasmFieldType(@NotNull IrType $this$toWasmFieldType) {
        Intrinsics.checkNotNullParameter($this$toWasmFieldType, "<this>");
        IrType irType = $this$toWasmFieldType;
        return Intrinsics.areEqual(irType, this.builtIns.getBooleanType()) || Intrinsics.areEqual(irType, this.builtIns.getByteType()) ? (WasmType)WasmI8.INSTANCE : (Intrinsics.areEqual(irType, this.builtIns.getShortType()) || Intrinsics.areEqual(irType, this.builtIns.getCharType()) ? (WasmType)WasmI16.INSTANCE : this.toWasmValueType($this$toWasmFieldType));
    }

    @NotNull
    public final WasmType toWasmValueType(@NotNull IrType $this$toWasmValueType) {
        WasmType wasmType;
        block22: {
            block23: {
                IrClass klass;
                block21: {
                    Intrinsics.checkNotNullParameter($this$toWasmValueType, "<this>");
                    WasmType wasmType2 = this.irBuiltInToWasmType.get($this$toWasmValueType);
                    if (wasmType2 != null) {
                        WasmType it = wasmType2;
                        boolean bl = false;
                        return it;
                    }
                    if (Intrinsics.areEqual($this$toWasmValueType, this.symbols.getVoidType())) {
                        throw new IllegalStateException("Void type can't be used as a value".toString());
                    }
                    klass = IrTypeErasureUtilsKt.getErasedUpperBound($this$toWasmValueType);
                    if (!klass.isExternal()) break block21;
                    wasmType = !Intrinsics.areEqual(klass.getName().getIdentifier(), "JsStringRef") ? (WasmType)WasmExternRef.INSTANCE : (WasmType)new WasmRefType(WasmHeapType.Simple.Extern.INSTANCE);
                    break block22;
                }
                if (!TypeTransformerKt.isBuiltInWasmRefType($this$toWasmValueType)) break block23;
                String string = klass.getName().getIdentifier();
                Intrinsics.checkNotNullExpressionValue(string, "getIdentifier(...)");
                switch (string) {
                    case "anyref": {
                        wasmType = WasmAnyRef.INSTANCE;
                        break block22;
                    }
                    case "eqref": {
                        wasmType = WasmEqRef.INSTANCE;
                        break block22;
                    }
                    case "structref": {
                        wasmType = new WasmRefNullType(WasmHeapType.Simple.Struct.INSTANCE);
                        break block22;
                    }
                    case "i31ref": {
                        wasmType = WasmI31Ref.INSTANCE;
                        break block22;
                    }
                    case "funcref": {
                        wasmType = new WasmRefNullType(WasmHeapType.Simple.Func.INSTANCE);
                        break block22;
                    }
                    default: {
                        String name2;
                        throw new IllegalStateException(("Unknown reference type " + name2).toString());
                    }
                }
            }
            IrClass ic = this.backendContext.getInlineClassesUtils().getInlinedClass($this$toWasmValueType);
            wasmType = ic != null ? this.toWasmValueType(this.backendContext.getInlineClassesUtils().getInlineClassUnderlyingType(ic)) : this.toWasmGcRefType($this$toWasmValueType);
        }
        return wasmType;
    }
}

