/*
 * Decompiled with CFR 0.152.
 */
package oracle.nativeimage;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.jdbc.logging.annotations.DisableTrace;
import org.graalvm.nativeimage.hosted.Feature;

@DisableTrace
@AutomaticFeature
final class CharacterSetFeature
implements Feature {
    private boolean characterSetLoaded = false;

    CharacterSetFeature() {
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a2) {
        try {
            Class<?> charset = Class.forName("oracle.sql.CharacterSet");
            if (a2.isReachable(charset)) {
                if (this.characterSetLoaded) {
                    return;
                }
                this.characterSetLoaded = true;
                a2.requireAnalysisIteration();
                Field[] fields = new Field[]{charset.getDeclaredField("DEFAULT_CHARSET"), charset.getDeclaredField("US7ASCII_CHARSET"), charset.getDeclaredField("ISO_LATIN_1_CHARSET"), charset.getDeclaredField("UNICODE_1_CHARSET"), charset.getDeclaredField("WE8DEC_CHARSET"), charset.getDeclaredField("WE8ISO8859P1_CHARSET"), charset.getDeclaredField("WE8ISO8859P15_CHARSET"), charset.getDeclaredField("WE8MSWIN1252_CHARSET"), charset.getDeclaredField("UTF8_CHARSET"), charset.getDeclaredField("UTFE_CHARSET"), charset.getDeclaredField("AL32UTF8_CHARSET"), charset.getDeclaredField("AL16UTF16_CHARSET"), charset.getDeclaredField("AL16UTF16LE_CHARSET")};
                Method makeChar = charset.getDeclaredMethod("make", Integer.TYPE);
                makeChar.setAccessible(true);
                for (Field f2 : fields) {
                    int id = f2.getInt(null);
                    Object res = makeChar.invoke((Object)0, id);
                    if (res != null) continue;
                    System.out.println("Character set id " + id + " does not have data");
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e2) {
            e2.printStackTrace();
        }
    }
}

