/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.graalvm.shadowed.com.ibm.icu.charset.CharsetDecoderICU;
import org.graalvm.shadowed.com.ibm.icu.charset.CharsetEncoderICU;
import org.graalvm.shadowed.com.ibm.icu.charset.CharsetICU;
import org.graalvm.shadowed.com.ibm.icu.text.UTF16;
import org.graalvm.shadowed.com.ibm.icu.text.UnicodeSet;

class CharsetASCII
extends CharsetICU {
    protected byte[] fromUSubstitution = new byte[]{26};

    public CharsetASCII(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 1;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderASCII(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderASCII(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        setFillIn.add(0, 127);
    }

    class CharsetDecoderASCII
    extends CharsetDecoderICU {
        public CharsetDecoderASCII(CharsetICU cs) {
            super(cs);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr;
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int oldSource = source.position();
            int oldTarget = target.position();
            if (source.hasArray() && target.hasArray()) {
                int targetLength;
                int limit;
                int targetOffset;
                int targetIndex;
                int offset;
                byte[] sourceArray = source.array();
                int sourceOffset = source.arrayOffset();
                int sourceIndex = oldSource + sourceOffset;
                int sourceLength = source.limit() - oldSource;
                char[] targetArray = target.array();
                cr = this.decodeLoopCoreOptimized(source, target, sourceArray, targetArray, sourceIndex, offset = (targetIndex = oldTarget + (targetOffset = target.arrayOffset())) - sourceIndex, limit = (sourceLength < (targetLength = target.limit() - oldTarget) ? sourceLength : targetLength) + sourceIndex);
                if (cr == null) {
                    if (sourceLength <= targetLength) {
                        source.position(oldSource + sourceLength);
                        target.position(oldTarget + sourceLength);
                        cr = CoderResult.UNDERFLOW;
                    } else {
                        source.position(oldSource + targetLength);
                        target.position(oldTarget + targetLength);
                        cr = CoderResult.OVERFLOW;
                    }
                }
            } else {
                cr = this.decodeLoopCoreUnoptimized(source, target);
                if (cr == CoderResult.OVERFLOW) {
                    source.position(source.position() - 1);
                }
            }
            if (offsets != null) {
                int count = target.position() - oldTarget;
                int sourceIndex = -1;
                while (--count >= 0) {
                    offsets.put(++sourceIndex);
                }
            }
            return cr;
        }

        protected CoderResult decodeLoopCoreOptimized(ByteBuffer source, CharBuffer target, byte[] sourceArray, char[] targetArray, int oldSource, int offset, int limit) {
            int i;
            int ch = 0;
            for (i = oldSource; i < limit && ((ch = sourceArray[i] & 0xFF) & 0x80) == 0; ++i) {
                targetArray[i + offset] = (char)ch;
            }
            if ((ch & 0x80) != 0) {
                source.position(i + 1);
                target.position(i + offset);
                return this.decodeMalformedOrUnmappable(ch);
            }
            return null;
        }

        protected CoderResult decodeLoopCoreUnoptimized(ByteBuffer source, CharBuffer target) {
            int ch = 0;
            while (source.hasRemaining()) {
                ch = source.get() & 0xFF;
                if ((ch & 0x80) == 0) {
                    if (target.hasRemaining()) {
                        target.put((char)ch);
                        continue;
                    }
                    return CoderResult.OVERFLOW;
                }
                return this.decodeMalformedOrUnmappable(ch);
            }
            return CoderResult.UNDERFLOW;
        }

        protected CoderResult decodeMalformedOrUnmappable(int ch) {
            this.toUBytesArray[0] = (byte)ch;
            this.toULength = 1;
            return CoderResult.malformedForLength(1);
        }
    }

    class CharsetEncoderASCII
    extends CharsetEncoderICU {
        private static final int NEED_TO_WRITE_BOM = 1;

        public CharsetEncoderASCII(CharsetICU cs) {
            super(cs, CharsetASCII.this.fromUSubstitution);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = 1;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr;
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int oldSource = source.position();
            int oldTarget = target.position();
            if (this.fromUChar32 != 0) {
                cr = this.encodeTrail(source, (char)this.fromUChar32, flush);
            } else if (source.hasArray() && target.hasArray()) {
                int targetLength;
                int limit;
                int targetOffset;
                int targetIndex;
                int offset;
                char[] sourceArray = source.array();
                int sourceOffset = source.arrayOffset();
                int sourceIndex = oldSource + sourceOffset;
                int sourceLength = source.limit() - oldSource;
                byte[] targetArray = target.array();
                cr = this.encodeLoopCoreOptimized(source, target, sourceArray, targetArray, sourceIndex, offset = (targetIndex = oldTarget + (targetOffset = target.arrayOffset())) - sourceIndex, limit = (sourceLength < (targetLength = target.limit() - oldTarget) ? sourceLength : targetLength) + sourceIndex, flush);
                if (cr == null) {
                    if (sourceLength <= targetLength) {
                        source.position(oldSource + sourceLength);
                        target.position(oldTarget + sourceLength);
                        cr = CoderResult.UNDERFLOW;
                    } else {
                        source.position(oldSource + targetLength);
                        target.position(oldTarget + targetLength);
                        cr = CoderResult.OVERFLOW;
                    }
                }
            } else {
                cr = this.encodeLoopCoreUnoptimized(source, target, flush);
                if (cr == CoderResult.OVERFLOW) {
                    source.position(source.position() - 1);
                }
            }
            if (offsets != null) {
                int count = target.position() - oldTarget;
                int sourceIndex = -1;
                while (--count >= 0) {
                    offsets.put(++sourceIndex);
                }
            }
            return cr;
        }

        protected CoderResult encodeLoopCoreOptimized(CharBuffer source, ByteBuffer target, char[] sourceArray, byte[] targetArray, int oldSource, int offset, int limit, boolean flush) {
            int i;
            int ch = 0;
            for (i = oldSource; i < limit && ((ch = sourceArray[i]) & 0xFF80) == 0; ++i) {
                targetArray[i + offset] = (byte)ch;
            }
            if ((ch & 0xFF80) != 0) {
                source.position(i + 1 - source.arrayOffset());
                target.position(i + offset);
                return this.encodeMalformedOrUnmappable(source, ch, flush);
            }
            return null;
        }

        protected CoderResult encodeLoopCoreUnoptimized(CharBuffer source, ByteBuffer target, boolean flush) {
            while (source.hasRemaining()) {
                char ch = source.get();
                if ((ch & 0xFF80) == 0) {
                    if (target.hasRemaining()) {
                        target.put((byte)ch);
                        continue;
                    }
                    return CoderResult.OVERFLOW;
                }
                return this.encodeMalformedOrUnmappable(source, ch, flush);
            }
            return CoderResult.UNDERFLOW;
        }

        protected final CoderResult encodeMalformedOrUnmappable(CharBuffer source, int ch, boolean flush) {
            return UTF16.isSurrogate(ch) ? this.encodeTrail(source, (char)ch, flush) : CoderResult.unmappableForLength(1);
        }

        private final CoderResult encodeTrail(CharBuffer source, char lead, boolean flush) {
            CoderResult cr = this.handleSurrogates(source, lead);
            if (cr != null) {
                return cr;
            }
            return CoderResult.unmappableForLength(2);
        }
    }
}

