/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.testdb;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hsqldb.server.Server;
import schemacrawler.testdb.TestSchemaCreator;

public class TestDatabase {
    private static final Logger LOGGER = Logger.getLogger(TestDatabase.class.getName());
    private static final String CONNECTION_STRING = "jdbc:hsqldb:hsql://${host}:${port}/${database}";
    private static final String HSQLDB_SCHEMACRAWLER = "hsqldb.schemacrawler";
    private final boolean trace;
    private final String host;
    private final int port;
    private final String database;
    private final String url;

    public static TestDatabase initialize() {
        try {
            String host = "0.0.0.0";
            int port = TestDatabase.getFreePort();
            String database = "schemacrawler%d".formatted(port);
            boolean trace = false;
            TestDatabase testDatabase = new TestDatabase(false, "0.0.0.0", port, database);
            testDatabase.start();
            return testDatabase;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize test database", e);
        }
    }

    public static TestDatabase initializeStandard() {
        try {
            String host = "0.0.0.0";
            int port = 9001;
            String database = "schemacrawler";
            boolean trace = true;
            TestDatabase testDatabase = new TestDatabase(true, "0.0.0.0", 9001, "schemacrawler");
            testDatabase.start();
            return testDatabase;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize test database on default port", e);
        }
    }

    public static void main(String[] args) throws Exception {
        TestDatabase.initializeStandard();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getFreePort() {
        int defaultPort = 9001;
        try (ServerSocket socket = new ServerSocket(0);){
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            if (port <= 0) {
                int n = 9001;
                return n;
            }
            int n = port;
            return n;
        }
        catch (IOException e) {
            return 9001;
        }
    }

    private TestDatabase(boolean trace, String host, int port, String database) {
        this.trace = trace;
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.database = Objects.requireNonNull(database);
        this.url = CONNECTION_STRING.replace("${host}", host).replace("${port}", String.valueOf(port)).replace("${database}", database);
        LOGGER.log(Level.CONFIG, this.url);
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, "sa", "");
    }

    public String getConnectionUrl() {
        return this.url;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Exception {
        LOGGER.log(Level.FINE, "%s - Setting up database".formatted(this.toString()));
        this.startServer();
        this.createTestDatabase();
    }

    public void stop() {
        if (this.trace) {
            System.out.printf("Stopping HyperSQL server for database %s:%d/%s%n", this.getHost(), this.getPort(), this.getDatabase());
        }
        this.stopServer();
    }

    private void createTestDatabase() throws SQLException {
        try (Connection connection = this.getConnection();){
            TestSchemaCreator schemaCreator = new TestSchemaCreator(connection, "/hsqldb.scripts.txt", false);
            schemaCreator.run();
        }
    }

    private void startServer() throws IOException {
        PrintWriter errWriter;
        PrintWriter logWriter;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        if (this.trace) {
            logWriter = new PrintWriter(System.out);
            errWriter = new PrintWriter(System.err);
        } else {
            logWriter = null;
            errWriter = null;
        }
        Path tempDirectory = Files.createTempDirectory("%s.%s".formatted(HSQLDB_SCHEMACRAWLER, this.database), new FileAttribute[0]);
        Server server = new Server();
        server.setSilent(!this.trace);
        server.setTrace(this.trace);
        server.setLogWriter(logWriter);
        server.setErrWriter(errWriter);
        server.setAddress(this.host);
        server.setPort(this.port);
        server.setDatabaseName(0, this.database);
        server.setDatabasePath(0, "file:%s".formatted(tempDirectory));
        if (this.trace) {
            System.out.printf("Starting HyperSQL server for database %s:%d/%s at %s%n", server.getAddress(), server.getPort(), server.getDatabaseName(0, true), server.getDatabasePath(0, true));
        }
        server.start();
        server.checkRunning(true);
    }

    private void stopServer() {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("SHUTDOWN");
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        LOGGER.log(Level.INFO, "SHUTDOWN database");
    }
}

