/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.HashNotImplemented;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.contextvars.ContextBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.contextvars.ContextBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.contextvars.PContextIterator;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ContextVarsContext})
@HashNotImplemented
public final class ContextBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ContextBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ContextBuiltinsFactory.getFactories();
    }

    private static Object getContextVar(Node inliningTarget, PContextVarsContext self, Object key, Object def, PRaiseNode raise) {
        if (key instanceof PContextVar) {
            PContextVar ctxVar = (PContextVar)key;
            Object value = self.contextVarValues.lookup(key, ctxVar.getHash());
            if (value == null) {
                if (def == null) {
                    throw raise.raise(inliningTarget, PythonBuiltinClassType.KeyError, new Object[]{key});
                }
                return def;
            }
            return value;
        }
        throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CONTEXTVAR_KEY_EXPECTED, key);
    }

    @Slot(value=Slot.SlotKind.sq_contains, isComplex=true)
    @GenerateNodeFactory
    public static abstract class Contains
    extends TpSlotSqContains.SqContainsBuiltinNode {
        @Specialization
        boolean doIn(PContextVarsContext self, Object key, @Bind Node inliningTarget, @Cached PRaiseNode raise) {
            if (key instanceof PContextVar) {
                PContextVar var = (PContextVar)key;
                return self.contextVarValues.lookup(var, var.getHash()) != null;
            }
            throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CONTEXTVAR_KEY_EXPECTED, key);
        }
    }

    @Builtin(name="get", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class GetMethod
    extends PythonBuiltinNode {
        @Specialization
        Object doGetDefault(PContextVarsContext self, Object key, Object def, @Bind Node inliningTarget, @Cached InlinedConditionProfile noValueProfile, @Cached PRaiseNode raise) {
            Object defVal = noValueProfile.profile(inliningTarget, PGuards.isNoValue(def)) ? PNone.NONE : def;
            return ContextBuiltins.getContextVar(inliningTarget, self, key, defVal, raise);
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Copy
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doCopy(PContextVarsContext self, @Bind PythonLanguage language) {
            PContextVarsContext ret = PFactory.createContextVarsContext(language);
            ret.contextVarValues = self.contextVarValues;
            return ret;
        }
    }

    @Builtin(name="run", takesVarArgs=true, takesVarKeywordArgs=true, minNumOfPositionalArgs=2, parameterNames={"$self", "$callable"})
    @GenerateNodeFactory
    public static abstract class Run
    extends PythonBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object get(VirtualFrame frame, PContextVarsContext self, Object fun, Object[] args, PKeyword[] keywords, @Bind Node inliningTarget, @Bind PythonContext context, @Cached CallNode call, @Cached PRaiseNode raise) {
            PythonContext.PythonThreadState threadState = context.getThreadState(context.getLanguage(inliningTarget));
            self.enter(inliningTarget, threadState, raise);
            try {
                Object object = call.execute((Frame)frame, fun, args, keywords);
                return object;
            }
            finally {
                self.leave(threadState);
            }
        }
    }

    @Builtin(name="items", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Items
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object items(PContextVarsContext self, @Bind PythonLanguage language) {
            return PFactory.createContextIterator(language, self, PContextIterator.ItemKind.ITEMS);
        }
    }

    @Builtin(name="values", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Values
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object values(PContextVarsContext self, @Bind PythonLanguage language) {
            return PFactory.createContextIterator(language, self, PContextIterator.ItemKind.VALUES);
        }
    }

    @Builtin(name="keys", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Keys
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object keys(PContextVarsContext self, @Bind PythonLanguage language) {
            return PFactory.createContextIterator(language, self, PContextIterator.ItemKind.KEYS);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class Iter
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PContextVarsContext self, @Bind PythonLanguage language) {
            return PFactory.createContextIterator(language, self, PContextIterator.ItemKind.KEYS);
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetContextVar
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Specialization
        Object get(PContextVarsContext self, Object key, @Bind Node inliningTarget, @Cached PRaiseNode raise) {
            return ContextBuiltins.getContextVar(inliningTarget, self, key, null, raise);
        }
    }

    @Slot(value=Slot.SlotKind.mp_length)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        int len(PContextVarsContext self) {
            return self.contextVarValues.size();
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="Context", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ContextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object construct(Object cls, @Bind PythonLanguage language) {
            return PFactory.createContextVarsContext(language);
        }
    }
}

