﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/TrialComponentSource.h>
#include <aws/sagemaker/model/UserContext.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>A short summary of a trial component.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/TrialComponentSimpleSummary">AWS
 * API Reference</a></p>
 */
class TrialComponentSimpleSummary {
 public:
  AWS_SAGEMAKER_API TrialComponentSimpleSummary() = default;
  AWS_SAGEMAKER_API TrialComponentSimpleSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API TrialComponentSimpleSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the trial component.</p>
   */
  inline const Aws::String& GetTrialComponentName() const { return m_trialComponentName; }
  inline bool TrialComponentNameHasBeenSet() const { return m_trialComponentNameHasBeenSet; }
  template <typename TrialComponentNameT = Aws::String>
  void SetTrialComponentName(TrialComponentNameT&& value) {
    m_trialComponentNameHasBeenSet = true;
    m_trialComponentName = std::forward<TrialComponentNameT>(value);
  }
  template <typename TrialComponentNameT = Aws::String>
  TrialComponentSimpleSummary& WithTrialComponentName(TrialComponentNameT&& value) {
    SetTrialComponentName(std::forward<TrialComponentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the trial component.</p>
   */
  inline const Aws::String& GetTrialComponentArn() const { return m_trialComponentArn; }
  inline bool TrialComponentArnHasBeenSet() const { return m_trialComponentArnHasBeenSet; }
  template <typename TrialComponentArnT = Aws::String>
  void SetTrialComponentArn(TrialComponentArnT&& value) {
    m_trialComponentArnHasBeenSet = true;
    m_trialComponentArn = std::forward<TrialComponentArnT>(value);
  }
  template <typename TrialComponentArnT = Aws::String>
  TrialComponentSimpleSummary& WithTrialComponentArn(TrialComponentArnT&& value) {
    SetTrialComponentArn(std::forward<TrialComponentArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const TrialComponentSource& GetTrialComponentSource() const { return m_trialComponentSource; }
  inline bool TrialComponentSourceHasBeenSet() const { return m_trialComponentSourceHasBeenSet; }
  template <typename TrialComponentSourceT = TrialComponentSource>
  void SetTrialComponentSource(TrialComponentSourceT&& value) {
    m_trialComponentSourceHasBeenSet = true;
    m_trialComponentSource = std::forward<TrialComponentSourceT>(value);
  }
  template <typename TrialComponentSourceT = TrialComponentSource>
  TrialComponentSimpleSummary& WithTrialComponentSource(TrialComponentSourceT&& value) {
    SetTrialComponentSource(std::forward<TrialComponentSourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the component was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  TrialComponentSimpleSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const UserContext& GetCreatedBy() const { return m_createdBy; }
  inline bool CreatedByHasBeenSet() const { return m_createdByHasBeenSet; }
  template <typename CreatedByT = UserContext>
  void SetCreatedBy(CreatedByT&& value) {
    m_createdByHasBeenSet = true;
    m_createdBy = std::forward<CreatedByT>(value);
  }
  template <typename CreatedByT = UserContext>
  TrialComponentSimpleSummary& WithCreatedBy(CreatedByT&& value) {
    SetCreatedBy(std::forward<CreatedByT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_trialComponentName;

  Aws::String m_trialComponentArn;

  TrialComponentSource m_trialComponentSource;

  Aws::Utils::DateTime m_creationTime{};

  UserContext m_createdBy;
  bool m_trialComponentNameHasBeenSet = false;
  bool m_trialComponentArnHasBeenSet = false;
  bool m_trialComponentSourceHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_createdByHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
