# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
#
# Generation mode: Incremental
# --------------------------------------------------------------------------

# pylint: disable=unused-wildcard-import
# pylint: disable=wildcard-import, protected-access

from .generated.custom import *  # noqa: F403
try:
    from .manual.custom import *  # noqa: F403
except ImportError:
    pass
from azure.cli.core.aaz import has_value
from .aaz.latest.billing.period import List as _PeriodList, Show as _PeriodShow


def cli_billing_list_invoices(client, generate_url=False):
    """List all available invoices of the subscription"""
    return client.list(expand='downloadUrl' if generate_url else None)


def cli_billing_get_invoice(client, name=None):
    """Retrieve invoice of specific name of the subscription"""
    if name:
        return client.get(name)
    return client.get_latest()


class PeriodList(_PeriodList):
    def post_operations(self):
        args = self.ctx.args
        if has_value(args.top):
            self.ctx.vars.instance.next_link = None


class PeriodShow(_PeriodShow):
    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        args_schema = super()._build_arguments_schema(*args, **kwargs)
        args_schema.name._id_part = None
        return args_schema
