/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class TabbedPane
extends JPanel {
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel cardPanel = new JPanel(this.cardLayout);
    private final ButtonGroup buttonGroup = new ButtonGroup();

    public TabbedPane() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints cardConstraints = new GridBagConstraints();
        cardConstraints.gridx = 1;
        cardConstraints.gridy = 0;
        cardConstraints.gridheight = 0;
        cardConstraints.fill = 1;
        cardConstraints.weightx = 1.0;
        cardConstraints.weighty = 1.0;
        cardConstraints.anchor = 18;
        this.add((Component)this.cardPanel, cardConstraints);
    }

    @Override
    public Component add(final String title, Component component) {
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.gridx = 0;
        buttonConstraints.fill = 2;
        buttonConstraints.anchor = 18;
        buttonConstraints.ipadx = 10;
        buttonConstraints.ipady = 4;
        JToggleButton button = new JToggleButton(title);
        button.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public void setPressed(boolean b) {
                if (this.isPressed() == b || !this.isEnabled()) {
                    return;
                }
                if (!b && this.isArmed()) {
                    this.setSelected(!this.isSelected());
                }
                this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
                this.fireStateChanged();
                if (this.isPressed()) {
                    this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
                }
            }
        });
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedPane.this.cardLayout.show(TabbedPane.this.cardPanel, title);
            }
        });
        this.buttonGroup.add(button);
        if (this.cardPanel.getComponentCount() == 0) {
            button.setSelected(true);
        }
        this.add((Component)button, buttonConstraints);
        this.cardPanel.add(title, component);
        return component;
    }

    public Component addImage(Image image) {
        GridBagConstraints imageConstraints = new GridBagConstraints();
        imageConstraints.gridx = 0;
        imageConstraints.weighty = 1.0;
        imageConstraints.fill = 1;
        imageConstraints.anchor = 16;
        JButton component = new JButton(new ImageIcon(image));
        component.setFocusPainted(false);
        component.setFocusable(false);
        component.setRequestFocusEnabled(false);
        component.setRolloverEnabled(false);
        component.setMargin(new Insets(0, 0, 0, 0));
        component.setHorizontalAlignment(2);
        component.setVerticalAlignment(3);
        component.setPreferredSize(new Dimension(0, 0));
        this.add((Component)component, imageConstraints);
        return component;
    }

    public void first() {
        this.cardLayout.first(this.cardPanel);
        this.updateButtonSelection();
    }

    public void last() {
        this.cardLayout.last(this.cardPanel);
        this.updateButtonSelection();
    }

    public void previous() {
        this.cardLayout.previous(this.cardPanel);
        this.updateButtonSelection();
    }

    public void next() {
        this.cardLayout.next(this.cardPanel);
        this.updateButtonSelection();
    }

    private void updateButtonSelection() {
        int count = this.cardPanel.getComponentCount();
        for (int index = 0; index < count; ++index) {
            Component card = this.cardPanel.getComponent(index);
            if (!card.isShowing()) continue;
            JToggleButton button = (JToggleButton)this.getComponent(index + 1);
            button.setSelected(true);
        }
    }
}

