/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.os.Clock;
import com.jogamp.common.util.PropertyAccess;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jogamp.common.Debug;

public final class ReflectionUtil {
    public static final boolean DEBUG;
    public static final boolean DEBUG_STATS_FORNAME;
    private static final Object forNameLock;
    private static final Map<String, ClassNameLookup> forNameStats;
    private static int forNameCount;
    private static long forNameNanoCosts;
    private static final Class<?>[] zeroTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetForNameCount() {
        if (DEBUG_STATS_FORNAME) {
            Object object = forNameLock;
            synchronized (object) {
                forNameCount = 0;
                forNameNanoCosts = 0L;
                forNameStats.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder getForNameStats(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (DEBUG_STATS_FORNAME) {
            Object object = forNameLock;
            synchronized (object) {
                stringBuilder.append(String.format("ReflectionUtil.forName: %8.3f ms, %03d invoc%n", (double)forNameNanoCosts / 1000000.0, forNameCount));
                Set<Map.Entry<String, ClassNameLookup>> set = forNameStats.entrySet();
                int n = 0;
                for (Map.Entry<String, ClassNameLookup> entry : set) {
                    stringBuilder.append(String.format("ReflectionUtil.forName[%03d]: %s%n", n, entry.getValue()));
                    ++n;
                }
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getClassImpl(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        if (DEBUG_STATS_FORNAME) {
            long l = Clock.currentNanos();
            Class<?> clazz = Class.forName(string, bl, classLoader);
            long l2 = Clock.currentNanos();
            long l3 = l2 - l;
            Object object = forNameLock;
            synchronized (object) {
                ++forNameCount;
                forNameNanoCosts += l3;
                ClassNameLookup classNameLookup = forNameStats.get(string);
                if (null == classNameLookup) {
                    classNameLookup = new ClassNameLookup(string);
                    forNameStats.put(string, classNameLookup);
                }
                ++classNameLookup.count;
                classNameLookup.nanoCosts += l3;
                System.err.printf("ReflectionUtil.getClassImpl.%03d: %8.3f ms, init %b, [%s]@ Thread %s%n", forNameCount, (double)l3 / 1000000.0, bl, classNameLookup.toString(), Thread.currentThread().getName());
                if (DEBUG) {
                    ExceptionUtils.dumpStack(System.err);
                }
            }
            return clazz;
        }
        return Class.forName(string, bl, classLoader);
    }

    public static final boolean isClassAvailable(String string, ClassLoader classLoader) {
        try {
            return null != ReflectionUtil.getClassImpl(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static final Class<?> getClass(String string, boolean bl, ClassLoader classLoader) throws JogampRuntimeException {
        try {
            return ReflectionUtil.getClassImpl(string, bl, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JogampRuntimeException(string + " not available", classNotFoundException);
        }
    }

    public static final Constructor<?> getConstructor(String string, Class<?>[] classArray, boolean bl, ClassLoader classLoader) throws JogampRuntimeException {
        try {
            return ReflectionUtil.getConstructor(ReflectionUtil.getClassImpl(string, bl, classLoader), classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JogampRuntimeException(string + " not available", classNotFoundException);
        }
    }

    static final String asString(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (null != classArray) {
            for (int i = 0; i < classArray.length; ++i) {
                if (bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(classArray[i].getName());
                bl = true;
            }
        }
        return stringBuilder.toString();
    }

    public static final Constructor<?> getConstructor(Class<?> clazz, Class<?> ... classArray) throws JogampRuntimeException {
        if (null == classArray) {
            classArray = zeroTypes;
        }
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (null == constructor) {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; null == constructor && i < constructorArray.length; ++i) {
                int n;
                Constructor<?> constructor2 = constructorArray[i];
                Class<?>[] classArray2 = constructor2.getParameterTypes();
                if (classArray2.length != classArray.length) continue;
                for (n = 0; n < classArray2.length && classArray2[n].isAssignableFrom(classArray[n]); ++n) {
                }
                if (classArray2.length != n) continue;
                constructor = constructor2;
            }
        }
        if (null == constructor) {
            throw new JogampRuntimeException("Constructor: '" + clazz.getName() + "(" + ReflectionUtil.asString(classArray) + ")' not found");
        }
        return constructor;
    }

    public static final Constructor<?> getConstructor(String string, ClassLoader classLoader) throws JogampRuntimeException {
        return ReflectionUtil.getConstructor(string, null, true, classLoader);
    }

    public static final Object createInstance(Constructor<?> constructor, Object ... objectArray) throws JogampRuntimeException, RuntimeException {
        try {
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (throwable instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)throwable).getTargetException();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new JogampRuntimeException("can not create instance of " + constructor.getName(), throwable);
        }
    }

    public static final Object createInstance(Class<?> clazz, Class<?>[] classArray, Object ... objectArray) throws JogampRuntimeException, RuntimeException {
        return ReflectionUtil.createInstance(ReflectionUtil.getConstructor(clazz, classArray), objectArray);
    }

    public static final Object createInstance(Class<?> clazz, Object ... objectArray) throws JogampRuntimeException, RuntimeException {
        Class[] classArray = null;
        if (null != objectArray) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
        }
        return ReflectionUtil.createInstance(clazz, classArray, objectArray);
    }

    public static final Object createInstance(String string, Class<?>[] classArray, Object[] objectArray, ClassLoader classLoader) throws JogampRuntimeException, RuntimeException {
        try {
            return ReflectionUtil.createInstance(ReflectionUtil.getClassImpl(string, true, classLoader), classArray, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JogampRuntimeException(string + " not available", classNotFoundException);
        }
    }

    public static final Object createInstance(String string, Object[] objectArray, ClassLoader classLoader) throws JogampRuntimeException, RuntimeException {
        Class[] classArray = null;
        if (null != objectArray) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
        }
        return ReflectionUtil.createInstance(string, classArray, objectArray, classLoader);
    }

    public static final Object createInstance(String string, ClassLoader classLoader) throws JogampRuntimeException, RuntimeException {
        return ReflectionUtil.createInstance(string, null, null, classLoader);
    }

    public static final boolean instanceOf(Object object, String string) {
        return ReflectionUtil.instanceOf(object.getClass(), string);
    }

    public static final boolean instanceOf(Class<?> clazz, String string) {
        do {
            if (!clazz.getName().equals(string)) continue;
            return true;
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public static final boolean implementationOf(Object object, String string) {
        return ReflectionUtil.implementationOf(object.getClass(), string);
    }

    public static final boolean implementationOf(Class<?> clazz, String string) {
        do {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = classArray.length - 1; i >= 0; --i) {
                Class<?> clazz2 = classArray[i];
                if (!clazz2.getName().equals(string)) continue;
                return true;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public static boolean isAWTComponent(Object object) {
        return ReflectionUtil.instanceOf(object, "java.awt.Component");
    }

    public static boolean isAWTComponent(Class<?> clazz) {
        return ReflectionUtil.instanceOf(clazz, "java.awt.Component");
    }

    public static final Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) throws JogampRuntimeException, RuntimeException {
        Throwable throwable = null;
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throwable = noClassDefFoundError;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        if (null != throwable) {
            throw new JogampRuntimeException("Method: '" + clazz + "." + string + "(" + ReflectionUtil.asString(classArray) + ")' not found", throwable);
        }
        return method;
    }

    public static final Method getMethod(String string, String string2, Class<?>[] classArray, ClassLoader classLoader) throws JogampRuntimeException, RuntimeException {
        try {
            return ReflectionUtil.getMethod(ReflectionUtil.getClassImpl(string, true, classLoader), string2, classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JogampRuntimeException(string + " not available", classNotFoundException);
        }
    }

    public static final Object callMethod(Object object, Method method, Object ... objectArray) throws JogampRuntimeException, RuntimeException {
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (throwable instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)throwable).getTargetException();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new JogampRuntimeException("calling " + method + " failed", throwable);
        }
    }

    public static final Object callStaticMethod(String string, String string2, Class<?>[] classArray, Object[] objectArray, ClassLoader classLoader) throws JogampRuntimeException, RuntimeException {
        return ReflectionUtil.callMethod(null, ReflectionUtil.getMethod(string, string2, classArray, classLoader), objectArray);
    }

    static {
        forNameCount = 0;
        forNameNanoCosts = 0L;
        Debug.initSingleton();
        DEBUG = Debug.debug("ReflectionUtil");
        DEBUG_STATS_FORNAME = PropertyAccess.isPropertyDefined("jogamp.debug.ReflectionUtil.forNameStats", true);
        if (DEBUG_STATS_FORNAME) {
            forNameLock = new Object();
            forNameStats = new HashMap<String, ClassNameLookup>();
        } else {
            forNameLock = null;
            forNameStats = null;
        }
        zeroTypes = new Class[0];
    }

    private static class ClassNameLookup {
        public final String name;
        public long nanoCosts;
        public int count;

        public ClassNameLookup(String string) {
            this.name = string;
            this.nanoCosts = 0L;
            this.count = 0;
        }

        public String toString() {
            return String.format((Locale)null, "%8.3f ms, %03d invoc, %s", (double)this.nanoCosts / 1000000.0, this.count, this.name);
        }
    }

    public static class AWTNames {
        public static final String ComponentClass = "java.awt.Component";
        public static final String GraphicsEnvironmentClass = "java.awt.GraphicsEnvironment";
        public static final String isHeadlessMethod = "isHeadless";
    }

    public static class MethodAccessor {
        Method m = null;

        public MethodAccessor(Class<?> clazz, String string, Class<?> ... classArray) {
            try {
                this.m = ReflectionUtil.getMethod(clazz, string, classArray);
            }
            catch (JogampRuntimeException jogampRuntimeException) {
                // empty catch block
            }
        }

        public boolean available() {
            return null != this.m;
        }

        public Object callMethod(Object object, Object ... objectArray) {
            if (null == this.m) {
                throw new JogampRuntimeException("Method not available. Instance: " + object);
            }
            return ReflectionUtil.callMethod(object, this.m, objectArray);
        }
    }
}

