#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cassava
version:              0.5.4.1
visibility:           public
id:                   cassava-0.5.4.1-JTeQQEztkdw1YqwHXQijYa
key:                  cassava-0.5.4.1-JTeQQEztkdw1YqwHXQijYa
license:              BSD-3-Clause
copyright:
    (c) 2012 Johan Tibell
    (c) 2012 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           https://github.com/haskell-hvr/cassava
author:               Johan Tibell
homepage:             https://github.com/haskell-hvr/cassava
synopsis:             A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.

    @cassava@'\''s API includes support for

    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")

    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:

    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"

    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.

category:             Text, Web, CSV
abi:                  4e9d63ba45da108860bb427ee66c376d
exposed:              True
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming

hidden-modules:
    Data.Csv.Conversion Data.Csv.Conversion.Internal Data.Csv.Encoding
    Data.Csv.Types Data.Csv.Util

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/cassava-0.5.4.1
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/cassava-0.5.4.1
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/cassava-0.5.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cassava
hs-libraries:         HScassava-0.5.4.1-JTeQQEztkdw1YqwHXQijYa
depends:
    Only-0.1-EKDJd7lVV8nkLGYR4MAJC array-0.5.8.0
    attoparsec-0.14.4-LMUtUfKC5plL7ZZhgWxit1 base-4.18.3.0
    bytestring-0.11.5.4 containers-0.6.7 deepseq-1.4.8.1
    hashable-1.4.7.0-17jkMnZLQLs4o2IKp4JpPo
    scientific-0.3.8.0-FwKzA73aVbXJ5rDpcJgYmo text-2.0.2
    text-short-0.1.6-5u0AoagCLsOLsBq0aGFv5r
    unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg
    vector-0.13.2.0-BINMV7y6ibUKgFTnLXEi1A

haddock-interfaces:   /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html:         /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

