#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ghc-trace-events
version:              0.1.2.10
visibility:           public
id:                   ghc-trace-events-0.1.2.10-KSHh9siwmj6E6R60FlbDR4
key:                  ghc-trace-events-0.1.2.10-KSHh9siwmj6E6R60FlbDR4
license:              BSD-3-Clause
copyright:            Copyright (C) 2018-2025 Mitsutoshi Aoe
maintainer:           Mitsutoshi Aoe <me@maoe.name>
author:               Mitsutoshi Aoe
homepage:             https://github.com/maoe/ghc-trace-events
synopsis:
    Faster traceEvent and traceMarker, and binary object logging for
    eventlog

description:
    ghc-trace-events provides faster traceEvent and traceMarker as well
    as arbitrary binary object logging for the eventlog framework. Unlike the
    <http://hackage.haskell.org/package/base/docs/Debug-Trace.html#g:2 eventlog tracing functions in base>,
    all the tracing functions in this library don'\''t evaluate the input if user
    event logging (the
    <https://downloads.haskell.org/~ghc/latest/docs/html/users_guide/runtime_control.html#rts-flag--l%20⟨flags⟩ -lu>
    flag) is disabled, which can give a significant boost in performance. Take a
    look at the benchmark suite for the details.

    This library provies the following modules:

    ["Debug.Trace.String"] Drop-in replacement for the event tracing functions in
    "Debug.Trace".
    ["Debug.Trace.ByteString"] UTF-8 encoded '\''ByteString'\'' variant
    of the event tracing functions in "Debug.Trace". It'\''s faster than the '\''String'\''
    variant.
    ["Debug.Trace.Text"] '\''Text'\'' variant of the event tracing functions
    in "Debug.Trace". It'\''s faster than the '\''String'\'' variant.
    ["Debug.Trace.Binary"] Arbitary binary object logging available for GHC 8.8 or
    later. Unlike the other tracing functions '\''Debug.Trace.Binary.traceBinaryEvent'\''
    takes an arbitrary '\''ByteString'\'' object as opposed to a UTF-8
    encoded string.

category:             Development, GHC, Trace
abi:                  1e42122fe21072e61d6b566f86c17e8f
exposed:              True
exposed-modules:
    Debug.Trace.Binary Debug.Trace.ByteString Debug.Trace.Flags
    Debug.Trace.String Debug.Trace.Text

import-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/ghc-trace-events-0.1.2.10

library-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/ghc-trace-events-0.1.2.10

library-dirs-static:
    /usr/lib/ghc-9.6.7.20250817/site-local/ghc-trace-events-0.1.2.10

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ghc-trace-events
hs-libraries:         HSghc-trace-events-0.1.2.10-KSHh9siwmj6E6R60FlbDR4
depends:              base-4.18.3.0 bytestring-0.11.5.4 text-2.0.2
haddock-interfaces:
    /usr/share/doc/haskell-ghc-trace-events/html/ghc-trace-events.haddock

haddock-html:         /usr/share/doc/haskell-ghc-trace-events/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

