#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 incremental-parser
version:              0.5.1
visibility:           public
id:                   incremental-parser-0.5.1-ewptoXGsIsLofZks3AslV
key:                  incremental-parser-0.5.1-ewptoXGsIsLofZks3AslV
license:              GPL-3.0-only
copyright:            (c) 2011-2023 Mario Blazevic
maintainer:           blamario@yahoo.com
author:               Mario Blazevic
homepage:             https://github.com/blamario/incremental-parser
synopsis:
    Generic parser library capable of providing partial results from partial input.

description:
    This package defines yet another parser combinator library. This one is implemented using the concept of Brzozowski
    derivatives, tweaked and optimized to work with any monoidal input type. Lists, ByteString, and Text are supported out
    of the box, as well as any other data type for which the monoid-subclasses package defines instances. If the parser
    result is also a monoid, its chunks can be extracted incrementally, before the complete input is parsed.

category:             Parsing
abi:                  4d96df137fabf916cd34d9206b744043
exposed:              True
exposed-modules:
    Control.Applicative.Monoid Text.ParserCombinators.Incremental
    Text.ParserCombinators.Incremental.LeftBiasedLocal
    Text.ParserCombinators.Incremental.Symmetric

import-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/incremental-parser-0.5.1

library-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/incremental-parser-0.5.1

library-dirs-static:
    /usr/lib/ghc-9.6.7.20250817/site-local/incremental-parser-0.5.1

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-incremental-parser
hs-libraries:         HSincremental-parser-0.5.1-ewptoXGsIsLofZks3AslV
depends:
    base-4.18.3.0 input-parsers-0.3.0.2-6or9fbhYUTyAN21jgP9M0Z
    logict-0.8.2.0-5xXYx1oAMcTia5921nvic
    monoid-subclasses-1.2.6.1-KOQjRrL4ADk9r721B9rd8U
    parsers-0.12.12-5k7MT67aefj6qJ6rymnCGf
    rank2classes-1.5.5.1-9vLsahVrKJ1KmKNAA5ZhlR transformers-0.6.1.0

haddock-interfaces:
    /usr/share/doc/haskell-incremental-parser/html/incremental-parser.haddock

haddock-html:         /usr/share/doc/haskell-incremental-parser/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

