#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 monad-par
version:              0.3.6
visibility:           public
id:                   monad-par-0.3.6-G1ho29Jj7MQ384v7DGKBvl
key:                  monad-par-0.3.6-G1ho29Jj7MQ384v7DGKBvl
license:              BSD-3-Clause
copyright:            (c) Simon Marlow 2011
maintainer:
    Simon Marlow <marlowsd@gmail.com>, Ryan Newton <rrnewton@gmail.com>

author:               Simon Marlow, Ryan Newton
stability:            Experimental
homepage:             https://github.com/simonmar/monad-par
synopsis:             A library for parallel programming based on a monad
description:
    The '\''Par'\'' monad offers a simple API for parallel programming.  The
    library works for parallelising both pure and @IO@ computations,
    although only the pure version is deterministic.  The default
    implementation provides a work-stealing scheduler and supports
    forking tasks that are much lighter weight than IO-threads.

    For complete documentation see "Control.Monad.Par".

    Some examples of use can be found in the @examples/@ directory of
    the source package.

    Other related packages:

    * @abstract-par@ provides the type classes that abstract over different
    implementations of the @Par@ monad.

    * @monad-par-extras@ provides extra combinators and monad transformers layered on top of
    the @Par@ monad.

    Changes in 0.3.4 relative to 0.3:

    * Fix bugs that cause "thread blocked indefinitely on MVar" crashes.

    * Added "Control.Monad.Par.IO"

category:             Control,Parallelism,Monads
abi:                  ba7c3955b0c350b9c0149e9797fcbc4c
exposed:              True
exposed-modules:
    Control.Monad.Par Control.Monad.Par.IO
    Control.Monad.Par.Scheds.Direct Control.Monad.Par.Scheds.Sparks
    Control.Monad.Par.Scheds.Trace
    Control.Monad.Par.Scheds.TraceInternal

hidden-modules:       Control.Monad.Par.Scheds.DirectInternal
import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/monad-par-0.3.6
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/monad-par-0.3.6
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/monad-par-0.3.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-monad-par
hs-libraries:         HSmonad-par-0.3.6-G1ho29Jj7MQ384v7DGKBvl
depends:
    abstract-deque-0.3-IgxLMNizUKTB9oBvTSDRjD
    abstract-par-0.3.3-BqoRMPAPGx33IpgW4ZQckw array-0.5.8.0
    base-4.18.3.0 containers-0.6.7 deepseq-1.4.8.1
    monad-par-extras-0.3.3-Basf9P7wLYvEYuaIBecK8E mtl-2.3.1
    mwc-random-0.15.2.0-CLwcPUSMuPz6NyNuZ4xAID
    parallel-3.2.2.0-1WmOVBnIr281FxwaAYcL5u

haddock-interfaces:   /usr/share/doc/haskell-monad-par/html/monad-par.haddock
haddock-html:         /usr/share/doc/haskell-monad-par/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

