#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pcg-random
version:              0.1.4.0
visibility:           public
id:                   pcg-random-0.1.4.0-wdmKJ7R4GcJegfgjXaQE2
key:                  pcg-random-0.1.4.0-wdmKJ7R4GcJegfgjXaQE2
license:              BSD-3-Clause
copyright:            (c) 2014-2015. Christopher Chalmers <c.chalmers@me.com>
maintainer:           c.chalmers@me.com
author:               Christopher Chalmers
homepage:             http://github.com/cchalmers/pcg-random
synopsis:             Haskell bindings to the PCG random number generator.
description:
    PCG is a family of simple fast space-efficient statistically good
    algorithms for random number generation. Unlike many general-purpose
    RNGs, they are also hard to predict.

    This library implements bindings to the standard C implementation.
    This includes the standard, unique, fast and single variants in the
    pcg family. There is a pure implementation that can be used as a
    generator with the random package as well as a faster primitive api
    that includes functions for generating common types.

    The generators in this module are suitable for use in parallel but
    make sure threads don'\''t share the same generator or things will go
    horribly wrong.

category:             System
abi:                  5b8ec5ff31aa7a1bcd8c5c27c7dfda81
exposed:              True
exposed-modules:
    System.Random.PCG System.Random.PCG.Class System.Random.PCG.Fast
    System.Random.PCG.Fast.Pure System.Random.PCG.Pure
    System.Random.PCG.Single System.Random.PCG.Unique

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/pcg-random-0.1.4.0
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/pcg-random-0.1.4.0
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/pcg-random-0.1.4.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pcg-random
hs-libraries:         HSpcg-random-0.1.4.0-wdmKJ7R4GcJegfgjXaQE2
include-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/pcg-random-0.1.4.0/include

includes:             pcg_variants.h
depends:
    base-4.18.3.0 bytestring-0.11.5.4
    entropy-0.4.1.11-B6vgyfFcyO6Auv5AGPyVrZ
    primitive-0.9.1.0-GYJhpUEcsq4755gfDRC2m0
    random-1.2.1.3-GswEfj1SZ276IcAtylwQ0f

haddock-interfaces:   /usr/share/doc/haskell-pcg-random/html/pcg-random.haddock
haddock-html:         /usr/share/doc/haskell-pcg-random/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

