#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.51.2
visibility:           public
id:                   hledger-1.51.2-5BXszUVLZ7K4UZ5f9WSOjU
key:                  hledger-1.51.2-5BXszUVLZ7K4UZ5f9WSOjU
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  b9688fbf3a9036480cfa7e727863f098
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/hledger-1.51.2
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/hledger-1.51.2
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/hledger-1.51.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.51.2-5BXszUVLZ7K4UZ5f9WSOjU
depends:
    Decimal-0.5.2-3onDWPtp7xUFSBbOX9U0bB
    Diff-0.5-Je25SsO7JvB1yEEgbSKPbT
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj
    ansi-terminal-1.1-4EeIQsn6Wrq78PCXTndXTh base-4.18.3.0
    bytestring-0.11.5.4 cmdargs-0.10.22-1ARObHkVbOT1HJZIaJM1AG
    containers-0.6.7 data-default-0.7.1.3-HKcyKL8L1MB9BLPHC3Cuts
    directory-1.3.8.5 extra-1.7.16-6ZwXlNpxrkMIvGHgrs9GlE
    filepath-1.4.301.0 githash-0.1.6.3-I8UQTgWKBOSFNbvtVSw20Y
    hashable-1.4.7.0-17jkMnZLQLs4o2IKp4JpPo haskeline-0.8.2.1
    hledger-lib-1.51.2-3BDuGcSS1L2Bebp30yTvL7
    http-client-0.7.19-CS7nt6M2hIg4TRHBOC9VL7
    http-types-0.12.4-J3nJ0CyBWeuE063Mvy4vWu
    lucid-2.11.20250303-F7GLijWD65d8Epd5pwLj8K
    math-functions-0.3.4.4-IOpsyV3H35o8lt7KgtSzED
    megaparsec-9.7.0-6iSCkwAigkw2HX9j1KdNdR
    microlens-0.4.14.0-4ENPj0tHNR0GzcdT8Xo5Q8
    modern-uri-0.3.6.1-3956RWWKshhFQjZzYoapYq mtl-2.3.1
    process-1.6.19.0 regex-tdfa-1.3.2.5-Epq9AbwCUJF5ybNEnhsg9i
    req-3.13.4-BUkEKcjEPBqDIDUmN1x15Y
    safe-0.3.21-40SDg1d9ZKLLr4MVwyQcdM
    shakespeare-2.1.7-CiegJBbI9nEtXJOrJ9qh0
    split-0.2.5-4lwOpp22KBrAKpI1IR2DHQ
    tabular-0.2.2.8-Fk6RHZAgQbgAXbmw3wtbhl
    tasty-1.5.2-1URN3hwk0ElEsqpxhMRHaT
    temporary-1.3-3RiPejuWpFkF6pn2FQhudK text-2.0.2
    text-ansi-0.3.0.1-Amzp1IDOEk38AVbJt2cJVF time-1.12.2
    timeit-2.0-3rjf8pWUG7zHO3IF6mVMhN transformers-0.6.1.0
    unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg
    utf8-string-1.0.2-shiuprzUpU7bW4pJ3bW0
    utility-ht-0.0.17.2-JNrBgDeBpaMAiyR6m5uAgt
    wizards-1.0.3-kQD0EpqpVQ3BeMLTHRbtJ

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

