/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.HashNotImplemented;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.ByteArrayBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.bytes.ByteArrayBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.bytes.ByteArrayBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.lib.PyByteArrayCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetStateNode;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToByteNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PByteArray})
@HashNotImplemented
public final class ByteArrayBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ByteArrayBuiltinsSlotsGen.SLOTS;
    private static final TruffleString T_LATIN_1 = PythonUtils.tsLiteral("latin-1");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ByteArrayBuiltinsFactory.getFactories();
    }

    static Object commonReduce(int proto, byte[] bytes, int len, Object clazz, Object dict, PythonLanguage language, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, TruffleStringBuilder.ToStringNode toStringNode) {
        TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        BytesUtils.repr(sb, bytes, len, appendCodePointNode);
        TruffleString str = toStringNode.execute(sb);
        PTuple contents = proto < 3 ? PFactory.createTuple(language, new Object[]{str, T_LATIN_1}) : (len > 0 ? PFactory.createTuple(language, new Object[]{str, len}) : PFactory.createTuple(language, new Object[0]));
        return PFactory.createTuple(language, new Object[]{clazz, contents, dict});
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    static abstract class RichCmpNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        RichCmpNode() {
        }

        @Specialization
        static boolean cmp(PByteArray self, PBytesLike other, RichCmpOp op, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray) {
            SequenceStorage selfStorage = self.getSequenceStorage();
            SequenceStorage otherStorage = other.getSequenceStorage();
            return BytesNodes.compareByteArrays(op, getArray.execute(inliningTarget, selfStorage), selfStorage.length(), getArray.execute(inliningTarget, otherStorage), otherStorage.length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"check.execute(inliningTarget, self)", "acquireLib.hasBuffer(other)"}, limit="3")
        @HostCompilerDirectives.InliningCutoff
        static Object cmp(VirtualFrame frame, Object self, Object other, RichCmpOp op, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached.Exclusive @Cached PyByteArrayCheckNode check, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray, @CachedLibrary(value="other") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            SequenceStorage selfStorage = getBytesStorage.execute(inliningTarget, self);
            Object otherBuffer = acquireLib.acquireReadonly(other, frame, indirectCallData);
            try {
                Boolean bl = BytesNodes.compareByteArrays(op, getArray.execute(inliningTarget, selfStorage), selfStorage.length(), bufferLib.getInternalOrCopiedByteArray(otherBuffer), bufferLib.getBufferLength(otherBuffer));
                return bl;
            }
            finally {
                bufferLib.release(otherBuffer);
            }
        }

        @Specialization(guards={"check.execute(inliningTarget, self)", "!acquireLib.hasBuffer(other)"})
        static Object cmp(VirtualFrame frame, Object self, Object other, RichCmpOp op, @Bind Node inliningTarget, @Cached.Shared @Cached PyByteArrayCheckNode check, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization(guards={"!check.execute(inliningTarget, self)"})
        @HostCompilerDirectives.InliningCutoff
        static Object error(VirtualFrame frame, Object self, Object other, RichCmpOp op, @Bind Node inliningTarget, @Cached.Shared @Cached PyByteArrayCheckNode check) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, op.getPythonName(), "bytearray", self);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        protected ReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PByteArray self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached GetClassNode getClassNode, @Cached PyObjectGetStateNode getStateNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            byte[] bytes = getBytes.execute(inliningTarget, self.getSequenceStorage());
            int len = self.getSequenceStorage().length();
            Object state = getStateNode.execute(frame, inliningTarget, self);
            Object clazz = getClassNode.execute(inliningTarget, self);
            return ByteArrayBuiltins.commonReduce(2, bytes, len, clazz, state, language, appendCodePointNode, toStringNode);
        }
    }

    @Builtin(name="__alloc__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AllocNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public static int alloc(PByteArray byteArray) {
            return byteArray.getSequenceStorage().length() + 1;
        }
    }

    @Builtin(name="translate", minNumOfPositionalArgs=2, parameterNames={"self", "table", "delete"})
    @GenerateNodeFactory
    public static abstract class TranslateNode
    extends BytesNodes.BaseTranslateNode {
        @Specialization
        static PByteArray translate(VirtualFrame frame, PByteArray self, Object table, Object delete, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached InlinedConditionProfile isLenTable256Profile, @Cached InlinedBranchProfile hasTable, @Cached InlinedBranchProfile hasDelete, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached PRaiseNode raiseNode) {
            BytesNodes.BaseTranslateNode.Result result;
            byte[] bTable = null;
            if (table != PNone.NONE) {
                hasTable.enter(inliningTarget);
                bTable = toBytesNode.execute(frame, table);
                TranslateNode.checkLengthOfTable(inliningTarget, bTable, isLenTable256Profile, raiseNode);
            }
            byte[] bDelete = null;
            if (delete != PNone.NO_VALUE) {
                hasDelete.enter(inliningTarget);
                bDelete = toBytesNode.execute(frame, delete);
            }
            byte[] bSelf = toBytesNode.execute(self);
            if (bTable != null && bDelete != null) {
                result = TranslateNode.translateAndDelete(bSelf, bTable, bDelete);
            } else if (bTable != null) {
                result = TranslateNode.translate(bSelf, bTable);
            } else if (bDelete != null) {
                result = TranslateNode.delete(bSelf, bDelete);
            } else {
                return PFactory.createByteArray(language, bSelf);
            }
            return PFactory.createByteArray(language, result.array);
        }
    }

    @Builtin(name="fromhex", minNumOfPositionalArgs=2, isClassmethod=true, numOfPositionalOnlyArgs=2, parameterNames={"$cls", "string"})
    @ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class FromHexNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization(guards={"isBuiltinByteArrayType(cls)"})
        static PByteArray doBytes(Object cls, TruffleString str, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode, @Bind PythonLanguage language) {
            return PFactory.createByteArray(language, hexStringToBytesNode.execute(str));
        }

        @Specialization(guards={"!isBuiltinByteArrayType(cls)"})
        static Object doGeneric(VirtualFrame frame, Object cls, TruffleString str, @Cached CallNode callNode, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode, @Bind PythonLanguage language) {
            PByteArray byteArray = PFactory.createByteArray(language, hexStringToBytesNode.execute(str));
            return callNode.execute((Frame)frame, cls, byteArray);
        }

        protected static boolean isBuiltinByteArrayType(Object cls) {
            return cls == PythonBuiltinClassType.PByteArray;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ByteArrayBuiltinsClinicProviders.FromHexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone clear(VirtualFrame frame, PByteArray byteArray, @Bind Node inliningTarget, @Cached SequenceStorageNodes.DeleteNode deleteNode, @Cached PySliceNew sliceNode, @Cached PRaiseNode raiseNode) {
            byteArray.checkCanResize(inliningTarget, raiseNode);
            deleteNode.execute(frame, byteArray.getSequenceStorage(), sliceNode.execute(inliningTarget, PNone.NONE, PNone.NONE, 1));
            return PNone.NONE;
        }
    }

    @Builtin(name="reverse", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReverseNode
    extends PythonBuiltinNode {
        @Specialization
        static PNone reverse(PByteArray byteArray, @Bind Node inliningTarget, @Cached SequenceStorageNodes.ReverseNode reverseNode) {
            reverseNode.execute(inliningTarget, byteArray.getSequenceStorage());
            return PNone.NONE;
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonBuiltinNode {
        @Specialization
        static PByteArray copy(PByteArray byteArray, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached SequenceStorageNodes.ToByteArrayNode toByteArray) {
            Object cls = getClassNode.execute(inliningTarget, byteArray);
            return PFactory.createByteArray(language, cls, getInstanceShape.execute(cls), toByteArray.execute(inliningTarget, byteArray.getSequenceStorage()));
        }
    }

    @Builtin(name="extend", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ExtendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone doBytes(VirtualFrame frame, PByteArray self, PBytesLike source, @Bind Node inliningTarget, @Cached IteratorNodes.GetLength lenNode, @Cached(value="createExtend()") @Cached.Shared SequenceStorageNodes.ExtendNode extendNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            int len = lenNode.execute(frame, inliningTarget, source);
            ExtendNode.extend(frame, self, source, len, extendNode);
            return PNone.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isBytes(source)"}, limit="3")
        static PNone doGeneric(VirtualFrame frame, PByteArray self, Object source, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="source") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile bufferProfile, @Cached BytesNodes.IterableToByteNode iterableToByteNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached(value="createExtend()") @Cached.Shared SequenceStorageNodes.ExtendNode extendNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            byte[] b;
            self.checkCanResize(inliningTarget, raiseNode);
            if (bufferProfile.profile(inliningTarget, bufferAcquireLib.hasBuffer(source))) {
                Object buffer = bufferAcquireLib.acquireReadonly(source, frame, indirectCallData);
                try {
                    b = bufferLib.getCopiedByteArray(buffer);
                }
                finally {
                    bufferLib.release(buffer, frame, indirectCallData);
                }
            }
            try {
                b = iterableToByteNode.execute(frame, source);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonErrorType.TypeError, errorProfile);
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_EXTEND_BYTEARRAY_WITH_P, source);
            }
            PByteArray bytes = PFactory.createByteArray(language, b);
            ExtendNode.extend(frame, self, bytes, b.length, extendNode);
            return PNone.NONE;
        }

        private static void extend(VirtualFrame frame, PByteArray self, Object source, int len, SequenceStorageNodes.ExtendNode extendNode) {
            SequenceStorage execute = extendNode.execute(frame, self.getSequenceStorage(), source, len);
            assert (self.getSequenceStorage() == execute) : "Unexpected storage generalization!";
        }

        @NeverDefault
        protected static SequenceStorageNodes.ExtendNode createExtend() {
            return SequenceStorageNodes.ExtendNode.create(BytesNodes.BytesLikeNoGeneralizationNode.SUPPLIER);
        }
    }

    @Builtin(name="append", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class AppendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone append(VirtualFrame frame, PByteArray byteArray, Object arg, @Bind Node inliningTarget, @Cached(value="createCast()") CastToByteNode toByteNode, @Cached SequenceStorageNodes.AppendNode appendNode, @Cached PRaiseNode raiseNode) {
            byteArray.checkCanResize(inliningTarget, raiseNode);
            appendNode.execute(inliningTarget, byteArray.getSequenceStorage(), toByteNode.execute(frame, arg), BytesNodes.BytesLikeNoGeneralizationNode.SUPPLIER);
            return PNone.NONE;
        }

        @NeverDefault
        static CastToByteNode createCast() {
            return CastToByteNode.create((node, val) -> {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.BYTE_MUST_BE_IN_RANGE);
            }, (node, val) -> {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, "bytes");
            });
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class PopNode
    extends PythonBuiltinNode {
        @Specialization
        static Object popLast(VirtualFrame frame, PByteArray self, PNone none, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared @Cached(value="createDelete()") SequenceStorageNodes.DeleteNode deleteNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            SequenceStorage store = self.getSequenceStorage();
            Object ret = getItemNode.execute(store, -1);
            deleteNode.execute(frame, store, -1);
            return ret;
        }

        @Specialization(guards={"!isNoValue(idx)", "!isPSlice(idx)"})
        static Object doIndex(VirtualFrame frame, PByteArray self, Object idx, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared @Cached(value="createDelete()") SequenceStorageNodes.DeleteNode deleteNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            SequenceStorage store = self.getSequenceStorage();
            Object ret = getItemNode.execute(frame, store, idx);
            deleteNode.execute(frame, store, idx);
            return ret;
        }

        @Fallback
        static Object doError(Object self, Object arg, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, arg);
        }

        @NeverDefault
        protected static SequenceStorageNodes.DeleteNode createDelete() {
            return SequenceStorageNodes.DeleteNode.create(PopNode.createNormalize());
        }

        @NeverDefault
        private static IndexNodes.NormalizeIndexNode createNormalize() {
            return IndexNodes.NormalizeIndexNode.create(ErrorMessages.POP_INDEX_OUT_OF_RANGE);
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RemoveNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone remove(VirtualFrame frame, PByteArray self, Object value, @Bind Node inliningTarget, @Cached(value="createCast()") CastToByteNode cast, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached SequenceStorageNodes.DeleteNode deleteNode, @Cached PRaiseNode raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            SequenceStorage storage = self.getSequenceStorage();
            int len = storage.length();
            int pos = BytesNodes.FindNode.find(getBytes.execute(inliningTarget, self.getSequenceStorage()), len, cast.execute(frame, value), 0, len, false);
            if (pos != -1) {
                deleteNode.execute(frame, storage, pos);
                return PNone.NONE;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NOT_IN_BYTEARRAY);
        }

        @NeverDefault
        static CastToByteNode createCast() {
            return CastToByteNode.create((node, val) -> {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, ErrorMessages.BYTE_MUST_BE_IN_RANGE);
            }, (node, val) -> {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, "bytes");
            });
        }

        @Fallback
        static Object doError(Object self, Object arg, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, arg);
        }
    }

    @Slot(value=Slot.SlotKind.sq_inplace_repeat, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IMulNode
    extends TpSlotSizeArgFun.SqRepeatBuiltinNode {
        @Specialization
        static Object mul(VirtualFrame frame, PByteArray self, int times, @Bind Node inliningTarget, @Cached SequenceStorageNodes.RepeatNode repeatNode, @Cached PRaiseNode raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            SequenceStorage res = repeatNode.execute(frame, self.getSequenceStorage(), times);
            self.setSequenceStorage(res);
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.sq_inplace_concat, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IAddNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PByteArray add(PByteArray self, PBytesLike other, @Bind Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.EnsureCapacityNode ensureCapacityNode, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return IAddNode.extendWithBuffer(self, other, inliningTarget, ensureCapacityNode, bufferLib, raiseNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isBytes(other)"}, limit="3")
        static PByteArray add(VirtualFrame frame, PByteArray self, Object other, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="other") PythonBufferAcquireLibrary bufferAcquireLib, @Cached.Shared @Cached SequenceStorageNodes.EnsureCapacityNode ensureCapacityNode, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            Object otherBuffer;
            try {
                otherBuffer = bufferAcquireLib.acquireReadonly(other, frame, indirectCallData);
            }
            catch (PException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_CONCAT_P_TO_S, other, "bytearray");
            }
            try {
                PByteArray pByteArray = IAddNode.extendWithBuffer(self, otherBuffer, inliningTarget, ensureCapacityNode, bufferLib, raiseNode);
                return pByteArray;
            }
            finally {
                bufferLib.release(otherBuffer, frame, indirectCallData);
            }
        }

        private static PByteArray extendWithBuffer(PByteArray self, Object otherBuffer, Node inliningTarget, SequenceStorageNodes.EnsureCapacityNode ensureCapacityNode, PythonBufferAccessLibrary bufferLib, PRaiseNode raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            try {
                int len = self.getSequenceStorage().length();
                int otherLen = bufferLib.getBufferLength(otherBuffer);
                int newLen = PythonUtils.addExact(len, otherLen);
                ensureCapacityNode.execute(inliningTarget, self.getSequenceStorage(), newLen);
                self.getSequenceStorage().setNewLength(newLen);
                bufferLib.readIntoBuffer(otherBuffer, 0, self, len, otherLen, bufferLib);
                return self;
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.MemoryError);
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static Object repr(PByteArray self, @Bind Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached TypeNodes.GetNameNode getNameNode, @Cached GetClassNode getClassNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            SequenceStorage store = self.getSequenceStorage();
            byte[] bytes = getBytes.execute(inliningTarget, store);
            int len = store.length();
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            TruffleString typeName = getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self));
            appendStringNode.execute(sb, (AbstractTruffleString)typeName);
            appendCodePointNode.execute(sb, 40, 1, true);
            BytesUtils.reprLoop(sb, bytes, len, appendCodePointNode);
            appendCodePointNode.execute(sb, 41, 1, true);
            return toStringNode.execute(sb);
        }
    }

    @Builtin(name="insert", minNumOfPositionalArgs=3, parameterNames={"$self", "index", "item"}, numOfPositionalOnlyArgs=3)
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="index", conversion=ArgumentClinic.ClinicConversion.Index), @ArgumentClinic(name="item", conversion=ArgumentClinic.ClinicConversion.Index)})
    public static abstract class InsertNode
    extends PythonTernaryClinicBuiltinNode {
        public abstract PNone execute(VirtualFrame var1, PByteArray var2, Object var3, Object var4);

        @Specialization(guards={"isByteStorage(self)"})
        static PNone insert(VirtualFrame frame, PByteArray self, int index, int value, @Bind Node inliningTarget, @Cached.Shared @Cached CastToByteNode toByteNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            byte v = toByteNode.execute(frame, value);
            ByteSequenceStorage target = (ByteSequenceStorage)self.getSequenceStorage();
            target.insertByteItem(InsertNode.normalizeIndex(index, target.length()), v);
            return PNone.NONE;
        }

        @Specialization
        static PNone insert(VirtualFrame frame, PByteArray self, int index, int value, @Bind Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.InsertItemNode insertItemNode, @Cached.Shared @Cached CastToByteNode toByteNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            byte v = toByteNode.execute(frame, value);
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, self);
            insertItemNode.execute(inliningTarget, storage, InsertNode.normalizeIndex(index, storage.length()), v);
            return PNone.NONE;
        }

        private static int normalizeIndex(int index, int len) {
            int idx = index;
            if (idx < 0 && (idx += len) < 0) {
                idx = 0;
            }
            if (idx > len) {
                idx = len;
            }
            return idx;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ByteArrayBuiltinsClinicProviders.InsertNodeClinicProviderGen.INSTANCE;
        }
    }

    @Slot(value=Slot.SlotKind.mp_ass_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class SetSubscriptNode
    extends TpSlotMpAssSubscript.MpAssSubscriptBuiltinNode {
        SetSubscriptNode() {
        }

        @Specialization(guards={"!isPSlice(indexObj)", "!isNoValue(value)"})
        static void set(VirtualFrame frame, PByteArray self, Object indexObj, Object value, @Bind Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached(value="forBytearray()") IndexNodes.NormalizeIndexNode normalizeIndexNode, @Cached SequenceStorageNodes.SetItemScalarNode setItemNode, @Cached @Cached.Exclusive PRaiseNode raiseNode) {
            if (!indexCheckNode.execute(inliningTarget, indexObj)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "bytearray", indexObj);
            }
            int index = asSizeNode.executeExact((Frame)frame, inliningTarget, indexObj);
            index = normalizeIndexNode.execute(index, self.getSequenceStorage().length());
            setItemNode.execute(inliningTarget, self.getSequenceStorage(), index, value);
        }

        @Specialization(guards={"!isPString(value)"})
        static void doSliceSequence(VirtualFrame frame, PByteArray self, PSlice slice, PSequence value, @Bind Node inliningTarget, @Cached @Cached.Shared InlinedConditionProfile differentLenProfile, @Cached @Cached.Shared SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached @Cached.Shared SequenceStorageNodes.SetItemSliceNode setItemSliceNode, @Cached @Cached.Shared SliceNodes.CoerceToIntSlice sliceCast, @Cached @Cached.Shared SliceNodes.SliceUnpack unpack, @Cached @Cached.Shared SliceNodes.AdjustIndices adjustIndices, @Cached @Cached.Shared PRaiseNode raiseNode) {
            SequenceStorage storage = self.getSequenceStorage();
            int otherLen = getSequenceStorageNode.execute(inliningTarget, value).length();
            PSlice.SliceInfo unadjusted = unpack.execute(inliningTarget, sliceCast.execute(inliningTarget, slice));
            PSlice.SliceInfo info = adjustIndices.execute(inliningTarget, storage.length(), unadjusted);
            if (differentLenProfile.profile(inliningTarget, info.sliceLength != otherLen)) {
                self.checkCanResize(inliningTarget, raiseNode);
            }
            setItemSliceNode.execute((Frame)frame, inliningTarget, storage, info, value, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isNoValue(value)", "bufferAcquireLib.hasBuffer(value)"}, limit="3")
        static void doSliceBuffer(VirtualFrame frame, PByteArray self, PSlice slice, Object value, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="value") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached @Cached.Shared InlinedConditionProfile differentLenProfile, @Cached @Cached.Shared SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached @Cached.Shared SequenceStorageNodes.SetItemSliceNode setItemSliceNode, @Cached @Cached.Shared SliceNodes.CoerceToIntSlice sliceCast, @Cached @Cached.Shared SliceNodes.SliceUnpack unpack, @Cached @Cached.Shared SliceNodes.AdjustIndices adjustIndices, @Cached.Shared @Cached PRaiseNode raiseNode) {
            Object buffer = bufferAcquireLib.acquireReadonly(value, frame, indirectCallData);
            try {
                PBytes bytes = PFactory.createBytes(language, bufferLib.getCopiedByteArray(value));
                SetSubscriptNode.doSliceSequence(frame, self, slice, bytes, inliningTarget, differentLenProfile, getSequenceStorageNode, setItemSliceNode, sliceCast, unpack, adjustIndices, raiseNode);
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Specialization(guards={"!isNoValue(value)"}, replaces={"doSliceSequence", "doSliceBuffer"})
        static void doSliceGeneric(VirtualFrame frame, PByteArray self, PSlice slice, Object value, @Bind Node inliningTarget, @Cached @Cached.Shared InlinedConditionProfile differentLenProfile, @Cached @Cached.Shared SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached @Cached.Shared SequenceStorageNodes.SetItemSliceNode setItemSliceNode, @Cached @Cached.Shared SliceNodes.CoerceToIntSlice sliceCast, @Cached @Cached.Shared SliceNodes.SliceUnpack unpack, @Cached @Cached.Shared SliceNodes.AdjustIndices adjustIndices, @Cached ListNodes.ConstructListNode constructListNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PList values = constructListNode.execute((Frame)frame, value);
            SetSubscriptNode.doSliceSequence(frame, self, slice, values, inliningTarget, differentLenProfile, getSequenceStorageNode, setItemSliceNode, sliceCast, unpack, adjustIndices, raiseNode);
        }

        @Specialization(guards={"isNoValue(value)"})
        static void doDelete(VirtualFrame frame, PByteArray self, Object key, Object value, @Bind Node inliningTarget, @Cached SequenceStorageNodes.DeleteNode deleteNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            deleteNode.execute(frame, self.getSequenceStorage(), key);
        }
    }

    @Slot(value=Slot.SlotKind.sq_ass_item, isComplex=true)
    @GenerateNodeFactory
    static abstract class SetItemNode
    extends TpSlotSqAssItem.SqAssItemBuiltinNode {
        SetItemNode() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void set(PByteArray self, int index, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached(value="forBytearray()") IndexNodes.NormalizeIndexNode normalizeIndexNode, @Cached SequenceStorageNodes.SetItemScalarNode setItemNode) {
            index = normalizeIndexNode.execute(index, self.getSequenceStorage().length());
            setItemNode.execute(inliningTarget, self.getSequenceStorage(), index, value);
        }

        @Specialization(guards={"isNoValue(value)"})
        static void del(PByteArray self, int index, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached(value="forBytearray()") IndexNodes.NormalizeIndexNode normalizeIndexNode, @Cached SequenceStorageNodes.DeleteItemNode deleteItemNode) {
            index = normalizeIndexNode.execute(index, self.getSequenceStorage().length());
            deleteItemNode.execute(inliningTarget, self.getSequenceStorage(), index);
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class ByteArraySubcript
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        ByteArraySubcript() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object self, Object idx, @Bind Node inliningTarget, @Cached InlinedConditionProfile validProfile, @Cached PyIndexCheckNode indexCheckNode, @Cached PRaiseNode raiseNode, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.SequenceStorageMpSubscriptNode subscriptNode) {
            if (!validProfile.profile(inliningTarget, SequenceStorageNodes.SequenceStorageMpSubscriptNode.isValidIndex(inliningTarget, idx, indexCheckNode))) {
                throw ByteArraySubcript.raiseNonIntIndex(inliningTarget, raiseNode, idx);
            }
            return subscriptNode.execute(frame, inliningTarget, getBytesStorage.execute(inliningTarget, self), idx, ErrorMessages.LIST_INDEX_OUT_OF_RANGE, PFactory::createByteArray);
        }

        @HostCompilerDirectives.InliningCutoff
        private static PException raiseNonIntIndex(Node inliningTarget, PRaiseNode raiseNode, Object index) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "bytearray", index);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetitemNode
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        GetitemNode() {
        }

        @Specialization
        static Object doInt(Object self, int key, @Bind Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.SequenceStorageSqItemNode sqItemNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            return sqItemNode.execute(inliningTarget, storage, key, ErrorMessages.BYTEARRAY_OUT_OF_BOUNDS);
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="bytearray", minNumOfPositionalArgs=1, parameterNames={"$self", "source", "encoding", "errors"})
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversionClass=BytesNodes.ExpectStringNode.class, args={"\"bytearray()\""}), @ArgumentClinic(name="errors", conversionClass=BytesNodes.ExpectStringNode.class, args={"\"bytearray()\""})})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ByteArrayBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!isNone(source)"})
        static PNone doInit(VirtualFrame frame, PByteArray self, Object source, Object encoding, Object errors, @Bind Node inliningTarget, @Cached BytesNodes.BytesInitNode toBytesNode) {
            self.setSequenceStorage(new ByteSequenceStorage(toBytesNode.execute(frame, inliningTarget, source, encoding, errors)));
            return PNone.NONE;
        }

        @Specialization(guards={"isNone(self)"})
        static PNone doInit(PByteArray self, Object source, Object encoding, Object errors, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANNOT_CONVERT_P_OBJ_TO_S, source, "bytearray");
        }

        @Specialization(guards={"!isBytes(self)"})
        static PNone doInit(Object self, Object source, Object encoding, Object errors, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___INIT__, "bytearray", self);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="bytearray", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class ByteArrayNode
    extends PythonBuiltinNode {
        @Specialization
        public PByteArray setEmpty(Object cls, Object arg, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createByteArray(language, cls, getInstanceShape.execute(cls), PythonUtils.EMPTY_BYTE_ARRAY);
        }
    }
}

