/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.PZipLongest;
import com.oracle.graal.python.builtins.objects.itertools.ZipLongestBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.ZipLongestBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PZipLongest})
public final class ZipLongestBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ZipLongestBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ZipLongestBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(PZipLongest self, Object state) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            self.setFillValue(state);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PZipLongest self, @Bind Node inliningTarget, @Cached GetClassNode getClass, @Cached InlinedConditionProfile noFillValueProfile, @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedConditionProfile noItProfile, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object fillValue = self.getFillValue();
            if (noFillValueProfile.profile(inliningTarget, fillValue == null)) {
                fillValue = PNone.NONE;
            }
            Object type = getClass.execute(inliningTarget, self);
            Object[] its = new Object[self.getItTuple().length];
            loopProfile.profileCounted(inliningTarget, (long)its.length);
            int i = 0;
            while (loopProfile.profile(inliningTarget, i < its.length)) {
                Object it = self.getItTuple()[i];
                its[i] = noItProfile.profile(inliningTarget, it == PNone.NONE) ? PFactory.createEmptyTuple(language) : it;
                ++i;
            }
            PTuple tuple = PFactory.createTuple(language, its);
            return PFactory.createTuple(language, new Object[]{type, tuple, fillValue});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization(guards={"zeroSize(self)"})
        static Object nextNoFillValue(PZipLongest self) {
            throw NextNode.iteratorExhausted();
        }

        @Specialization(guards={"!zeroSize(self)"})
        static Object next(VirtualFrame frame, PZipLongest self, @Bind Node inliningTarget, @Cached PyIterNextNode nextNode, @Cached InlinedConditionProfile noItProfile, @Cached InlinedConditionProfile noActiveProfile, @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedConditionProfile isNullFillProfile) {
            Object fillValue = isNullFillProfile.profile(inliningTarget, NextNode.isNullFillValue(self)) ? PNone.NONE : self.getFillValue();
            Object[] result = new Object[self.getItTuple().length];
            loopProfile.profileCounted(inliningTarget, (long)result.length);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < result.length)) {
                Object item;
                Object it = self.getItTuple()[i];
                if (noItProfile.profile(inliningTarget, it == PNone.NONE)) {
                    item = fillValue;
                } else {
                    try {
                        item = nextNode.execute((Frame)frame, inliningTarget, it);
                    }
                    catch (IteratorExhausted e) {
                        self.setNumActive(self.getNumActive() - 1);
                        if (noActiveProfile.profile(inliningTarget, self.getNumActive() == 0)) {
                            throw NextNode.iteratorExhausted();
                        }
                        item = fillValue;
                        self.getItTuple()[i] = PNone.NONE;
                    }
                    catch (PException e) {
                        self.setNumActive(0);
                        throw e;
                    }
                }
                result[i] = item;
                ++i;
            }
            return PFactory.createTuple(PythonLanguage.get(inliningTarget), result);
        }

        protected static boolean isNullFillValue(PZipLongest self) {
            return self.getFillValue() == null;
        }

        protected static boolean zeroSize(PZipLongest self) {
            return self.getItTuple().length == 0 || self.getNumActive() == 0;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PZipLongest self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="zip_longest", minNumOfPositionalArgs=1, takesVarArgs=true, keywordOnlyNames={"fillvalue"})
    @GenerateNodeFactory
    public static abstract class ZipLongestNode
    extends PythonBuiltinNode {
        @Specialization
        static Object construct(VirtualFrame frame, Object cls, Object[] args, Object fillValueIn, @Bind Node inliningTarget, @Cached PyObjectGetIter getIterNode, @Cached InlinedConditionProfile fillIsNone, @Cached InlinedLoopConditionProfile loopProfile, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached InlinedBranchProfile errorProfile, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (!isTypeNode.execute(inliningTarget, cls)) {
                errorProfile.enter(inliningTarget);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            Object fillValue = fillValueIn;
            if (fillIsNone.profile(inliningTarget, PGuards.isPNone(fillValue))) {
                fillValue = null;
            }
            PZipLongest self = PFactory.createZipLongest(language, cls, getInstanceShape.execute(cls));
            self.setFillValue(fillValue);
            self.setNumActive(args.length);
            Object[] itTuple = new Object[args.length];
            loopProfile.profileCounted(inliningTarget, (long)itTuple.length);
            LoopNode.reportLoopCount((Node)inliningTarget, (int)itTuple.length);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < itTuple.length)) {
                itTuple[i] = getIterNode.execute((Frame)frame, inliningTarget, args[i]);
                ++i;
            }
            self.setItTuple(itTuple);
            return self;
        }
    }
}

