/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXml;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDataTypeInfo;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlMetaDataBase;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlRSColumn;
import com.ibm.db2.cmx.runtime.internal.xml.XmlBuf;
import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.tools.internal.PDQDB2Types;
import com.ibm.db2.jcc.DB2PreparedStatement;
import com.ibm.db2.jcc.DBMetaData;
import com.ibm.db2.jcc.DBPreparedStatementInfoInterface;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDQXmlResultSetMetaData
extends PDQXmlMetaDataBase
implements XmlExporter {
    private ArrayList<PDQXmlRSColumn> columns_ = new ArrayList();

    public ArrayList<PDQXmlRSColumn> getColumns() {
        return this.columns_;
    }

    public String[] getColumnNames() {
        if (this.columns_ == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i10 = 0; i10 < this.columns_.size(); ++i10) {
            arrayList.add(this.columns_.get(i10).getColumnName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setColumns(ArrayList<PDQXmlRSColumn> arrayList) {
        this.columns_ = arrayList;
    }

    public PDQXmlRSColumn getLast() {
        return this.columns_.get(this.columns_.size() - 1);
    }

    public void add(PDQXmlRSColumn pDQXmlRSColumn) {
        this.columns_.add(pDQXmlRSColumn);
    }

    public int[][] toIntArray() {
        int n2;
        int n3 = this.columns_.size();
        if (n3 == 0) {
            return null;
        }
        int[][] nArrayArray = new int[4][];
        for (n2 = 0; n2 < 4; ++n2) {
            nArrayArray[n2] = new int[n3];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray[0][n2] = this.columns_.get(n2).getJdbcType();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray[1][n2] = this.columns_.get(n2).getPrecision();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray[2][n2] = this.columns_.get(n2).getScale();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray[3][n2] = this.columns_.get(n2).getCcsid();
        }
        return nArrayArray;
    }

    public void init(PreparedStatement preparedStatement) throws SQLException {
        block5: {
            if (preparedStatement == null) {
                return;
            }
            ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
            if (resultSetMetaData != null && resultSetMetaData.getColumnCount() > 0) {
                Object object;
                int n2 = resultSetMetaData.getColumnCount();
                for (int i10 = 1; i10 <= n2; ++i10) {
                    object = new PDQXmlRSColumn();
                    ((PDQXmlDataTypeInfo)object).setJdbcType(XmlTags.getDB2TypeNumberFromJdbcType(resultSetMetaData.getColumnType(i10), resultSetMetaData.getColumnTypeName(i10)));
                    ((PDQXmlDataTypeInfo)object).setPrecision(resultSetMetaData.getPrecision(i10));
                    ((PDQXmlDataTypeInfo)object).setScale(resultSetMetaData.getScale(i10));
                    ((PDQXmlDataTypeInfo)object).setColumnName(resultSetMetaData.getColumnLabel(i10));
                    this.columns_.add((PDQXmlRSColumn)object);
                }
                try {
                    this.initColumnsFromDB2ResultSetMetaData(preparedStatement);
                }
                catch (Throwable throwable) {
                    object = Log.getLogger();
                    if (null == object) break block5;
                    ((Logger)object).log(Level.WARNING, "Error while retrieving statement result set metadata.", throwable);
                }
            }
        }
        PDQXml.currentConnection__ = preparedStatement.getConnection();
    }

    public void init(ResultSetMetaData resultSetMetaData) throws SQLException {
        block5: {
            if (resultSetMetaData != null && resultSetMetaData.getColumnCount() > 0) {
                int n2 = resultSetMetaData.getColumnCount();
                for (int i10 = 1; i10 <= n2; ++i10) {
                    PDQXmlRSColumn pDQXmlRSColumn = new PDQXmlRSColumn();
                    pDQXmlRSColumn.setColumnName(resultSetMetaData.getColumnLabel(i10));
                    pDQXmlRSColumn.setJdbcType(XmlTags.getDB2TypeNumberFromJdbcType(resultSetMetaData.getColumnType(i10), resultSetMetaData.getColumnTypeName(i10)));
                    pDQXmlRSColumn.setPrecision(resultSetMetaData.getPrecision(i10));
                    pDQXmlRSColumn.setScale(resultSetMetaData.getScale(i10));
                    this.columns_.add(pDQXmlRSColumn);
                }
            }
            try {
                if (this.columns_.size() > 0) {
                    this.initDB2MetaDataFromJdbcMetaData();
                }
            }
            catch (Throwable throwable) {
                Logger logger = Log.getLogger();
                if (null == logger) break block5;
                logger.log(Level.WARNING, "Error while computing statement resultset metadata.", throwable);
            }
        }
    }

    private void initDB2MetaDataFromJdbcMetaData() {
        SQLJColumnMetaData sQLJColumnMetaData = new SQLJColumnMetaData(this.columns_.size());
        for (int i10 = 0; i10 < this.columns_.size(); ++i10) {
            PDQXmlRSColumn pDQXmlRSColumn = this.columns_.get(i10);
            PDQDB2Types.mapDriverTypeToDB2TypeInfo(sQLJColumnMetaData, pDQXmlRSColumn.getJdbcType(), i10, false, pDQXmlRSColumn.getScale(), pDQXmlRSColumn.getPrecision());
        }
        this.initFromSqljColumnMetaData(this.columns_, sQLJColumnMetaData);
    }

    private void initColumnsFromDB2ResultSetMetaData(PreparedStatement preparedStatement) throws SQLException {
        DB2PreparedStatement dB2PreparedStatement = (DB2PreparedStatement)preparedStatement;
        DBMetaData dBMetaData = dB2PreparedStatement.getDBPreparedStatementInfo().getDBResultSetMetaData();
        this.initFromSqljColumnMetaData(this.columns_, dBMetaData);
        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = dB2PreparedStatement.getDBPreparedStatementInfo();
        if (dBPreparedStatementInfoInterface != null) {
            this.prepareOptions_ = dBPreparedStatementInfoInterface.getPrepareAttributes();
        }
    }

    @Override
    public String getXml(int n2) {
        XmlBuf xmlBuf = new XmlBuf(n2);
        xmlBuf.startElement("resultSetMetadata");
        for (int i10 = 0; i10 < this.columns_.size(); ++i10) {
            xmlBuf.addBranch(this.columns_.get(i10));
        }
        xmlBuf.endElement();
        return xmlBuf.toString();
    }

    private static Method getMethodByNameForClass(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        return clazz.getMethod(string, classArray);
    }

    private static Field getDeclaredFieldForClass(Class clazz, String string) throws NoSuchFieldException {
        return clazz.getDeclaredField(string);
    }
}

