/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.IndexNodesFactory;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class IndexNodes {
    public static void checkBounds(Node inliningTarget, PRaiseNode raiseNode, TruffleString errorMessage, int idx, int length) {
        if (idx < 0 || idx >= length) {
            IndexNodes.raiseIndexError(inliningTarget, errorMessage, raiseNode);
        }
    }

    public static void checkBounds(Node inliningTarget, PRaiseNode raiseNode, TruffleString errorMessage, long idx, long length) {
        if (idx < 0L || idx >= length) {
            IndexNodes.raiseIndexError(inliningTarget, errorMessage, raiseNode);
        }
    }

    public static void checkBounds(Node inliningTarget, PRaiseNode raiseNode, TruffleString errorMessage, int idx, long length) {
        if (idx < 0 || (long)idx >= length) {
            IndexNodes.raiseIndexError(inliningTarget, errorMessage, raiseNode);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private static void raiseIndexError(Node inliningTarget, TruffleString errorMessage, PRaiseNode raiseNode) {
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, errorMessage);
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class NormalizeIndexWithoutBoundsCheckNode
    extends NormalizeIndexCustomMessageNode {
        NormalizeIndexWithoutBoundsCheckNode() {
        }

        @Specialization
        static int doInt(int index, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared(value="negativeIndexProfile") @Cached InlinedConditionProfile negativeIndexProfile) {
            int idx = index;
            if (negativeIndexProfile.profile(inliningTarget, idx < 0)) {
                idx += length;
            }
            return idx;
        }

        @Specialization
        static int doBool(boolean index, int length, TruffleString errorMessage) {
            return PInt.intValue(index);
        }

        @Specialization(rewriteOn={OverflowException.class})
        static int doLong(long index, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared(value="negativeIndexProfile") @Cached InlinedConditionProfile negativeIndexProfile) throws OverflowException {
            int idx = PInt.intValueExact(index);
            return NormalizeIndexWithoutBoundsCheckNode.doInt(idx, length, errorMessage, inliningTarget, negativeIndexProfile);
        }

        @Specialization(replaces={"doLong"})
        static int doLongOvf(long index, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared(value="negativeIndexProfile") @Cached InlinedConditionProfile negativeIndexProfile, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                return NormalizeIndexWithoutBoundsCheckNode.doLong(index, length, errorMessage, inliningTarget, negativeIndexProfile);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, index);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static int doPInt(PInt index, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared(value="negativeIndexProfile") @Cached InlinedConditionProfile negativeIndexProfile) throws OverflowException {
            int idx = index.intValueExact();
            return NormalizeIndexWithoutBoundsCheckNode.doInt(idx, length, errorMessage, inliningTarget, negativeIndexProfile);
        }

        @Specialization(replaces={"doPInt"})
        static int doPIntOvf(PInt index, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared(value="negativeIndexProfile") @Cached InlinedConditionProfile negativeIndexProfile, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                return NormalizeIndexWithoutBoundsCheckNode.doPInt(index, length, errorMessage, inliningTarget, negativeIndexProfile);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, index);
            }
        }

        @Specialization
        static long doLongLong(long index, long length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared(value="negativeIndexProfile") @Cached InlinedConditionProfile negativeIndexProfile) {
            long idx = index;
            if (negativeIndexProfile.profile(inliningTarget, idx < 0L)) {
                idx += length;
            }
            return idx;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class NormalizeIndexWithBoundsCheckNode
    extends NormalizeIndexCustomMessageNode {
        NormalizeIndexWithBoundsCheckNode() {
        }

        @Specialization
        static int doInt(int index, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile negativeIndexProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int normalizedIndex = index;
            if (negativeIndexProfile.profile(inliningTarget, normalizedIndex < 0)) {
                normalizedIndex += length;
            }
            IndexNodes.checkBounds(inliningTarget, raiseNode, errorMessage, normalizedIndex, length);
            return normalizedIndex;
        }

        @Specialization
        static int doBool(boolean bIndex, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int index = PInt.intValue(bIndex);
            IndexNodes.checkBounds(inliningTarget, raiseNode, errorMessage, index, length);
            return index;
        }

        @Specialization(rewriteOn={OverflowException.class})
        static int doLong(long lIndex, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile negativeIndexProfile, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            int index = PInt.intValueExact(lIndex);
            return NormalizeIndexWithBoundsCheckNode.doInt(index, length, errorMessage, inliningTarget, negativeIndexProfile, raiseNode);
        }

        @Specialization(replaces={"doLong"})
        int doLongOvf(long index, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile negativeIndexProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                return NormalizeIndexWithBoundsCheckNode.doLong(index, length, errorMessage, inliningTarget, negativeIndexProfile, raiseNode);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, index);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static int doPInt(PInt index, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile negativeIndexProfile, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            int idx = index.intValueExact();
            return NormalizeIndexWithBoundsCheckNode.doInt(idx, length, errorMessage, inliningTarget, negativeIndexProfile, raiseNode);
        }

        @Specialization(replaces={"doPInt"})
        int doPIntOvf(PInt index, int length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile negativeIndexProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                return NormalizeIndexWithBoundsCheckNode.doPInt(index, length, errorMessage, inliningTarget, negativeIndexProfile, raiseNode);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, index);
            }
        }

        @Specialization
        static long doLongLong(long lIndex, long length, TruffleString errorMessage, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile negativeIndexProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            long normalizedIndex = lIndex;
            if (negativeIndexProfile.profile(inliningTarget, normalizedIndex < 0L)) {
                normalizedIndex += length;
            }
            IndexNodes.checkBounds(inliningTarget, raiseNode, errorMessage, normalizedIndex, length);
            return normalizedIndex;
        }
    }

    public static abstract class NormalizeIndexCustomMessageNode
    extends Node {
        public abstract int execute(Object var1, int var2, TruffleString var3);

        public abstract int execute(boolean var1, int var2, TruffleString var3);

        public abstract int execute(long var1, int var3, TruffleString var4);

        public abstract int execute(int var1, int var2, TruffleString var3);

        public abstract long executeLong(long var1, long var3, TruffleString var5);

        @NeverDefault
        public static NormalizeIndexCustomMessageNode create() {
            return IndexNodesFactory.NormalizeIndexWithBoundsCheckNodeGen.create();
        }

        @NeverDefault
        public static NormalizeIndexCustomMessageNode getUncached() {
            return IndexNodesFactory.NormalizeIndexWithBoundsCheckNodeGen.getUncached();
        }

        @NeverDefault
        public static NormalizeIndexCustomMessageNode getUncachedWithoutBoundsCheck() {
            return IndexNodesFactory.NormalizeIndexWithoutBoundsCheckNodeGen.getUncached();
        }
    }

    public static final class NormalizeIndexNode
    extends Node {
        @Node.Child
        private NormalizeIndexCustomMessageNode subNode;
        private final TruffleString errorMessage;

        private NormalizeIndexNode(TruffleString errorMessage, boolean boundsCheck) {
            this.errorMessage = errorMessage;
            this.subNode = boundsCheck ? IndexNodesFactory.NormalizeIndexWithBoundsCheckNodeGen.create() : IndexNodesFactory.NormalizeIndexWithoutBoundsCheckNodeGen.create();
        }

        public int execute(Object index, int length) {
            return this.subNode.execute(index, length, this.errorMessage);
        }

        public int execute(int index, int length) {
            return this.subNode.execute(index, length, this.errorMessage);
        }

        public int execute(long index, int length) {
            return this.subNode.execute(index, length, this.errorMessage);
        }

        public int execute(boolean index, int length) {
            return this.subNode.execute(index, length, this.errorMessage);
        }

        public long executeLong(long index, long length) {
            return this.subNode.executeLong(index, length, this.errorMessage);
        }

        @NeverDefault
        public static NormalizeIndexNode create() {
            return new NormalizeIndexNode(ErrorMessages.INDEX_OUT_OF_RANGE, true);
        }

        @NeverDefault
        public static NormalizeIndexNode create(TruffleString errorMessage) {
            return new NormalizeIndexNode(errorMessage, true);
        }

        @NeverDefault
        public static NormalizeIndexNode create(boolean boundsCheck) {
            return new NormalizeIndexNode(ErrorMessages.INDEX_OUT_OF_RANGE, boundsCheck);
        }

        @NeverDefault
        public static NormalizeIndexNode create(TruffleString errorMessage, boolean boundsCheck) {
            return new NormalizeIndexNode(errorMessage, boundsCheck);
        }

        @NeverDefault
        public static NormalizeIndexNode forList() {
            return NormalizeIndexNode.create(ErrorMessages.LIST_INDEX_OUT_OF_RANGE);
        }

        @NeverDefault
        public static NormalizeIndexNode forListAssign() {
            return NormalizeIndexNode.create(ErrorMessages.LIST_ASSIGMENT_INDEX_OUT_OF_RANGE);
        }

        @NeverDefault
        public static NormalizeIndexNode forTuple() {
            return NormalizeIndexNode.create(ErrorMessages.TUPLE_OUT_OF_BOUNDS);
        }

        @NeverDefault
        public static NormalizeIndexNode forArray() {
            return NormalizeIndexNode.create(ErrorMessages.ARRAY_OUT_OF_BOUNDS);
        }

        @NeverDefault
        public static NormalizeIndexNode forArrayAssign() {
            return NormalizeIndexNode.create(ErrorMessages.ARRAY_ASSIGN_OUT_OF_BOUNDS);
        }

        @NeverDefault
        public static NormalizeIndexNode forPop() {
            return NormalizeIndexNode.create(ErrorMessages.POP_INDEX_OUT_OF_RANGE);
        }

        @NeverDefault
        public static NormalizeIndexNode forRange() {
            return NormalizeIndexNode.create(ErrorMessages.RANGE_OUT_OF_BOUNDS);
        }

        @NeverDefault
        public static NormalizeIndexNode forBytearray() {
            return NormalizeIndexNode.create(ErrorMessages.BYTEARRAY_OUT_OF_BOUNDS);
        }
    }
}

