/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFListener;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.SSLSocketChannel;
import oracle.net.nt.TcpsConfigure;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHANGE_NOTIFICATION})
class NTFConnection
extends Thread {
    private static final int NS_HEADER_SIZE = 10;
    private SocketChannel channel;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer;
    private int currentNSPacketLength;
    private int currentNSPacketType;
    private ByteBuffer currentNSPacketDataBuffer;
    private boolean needsToBeClosed;
    private NTFManager ntfManager;
    private NTFListener ntfListener;
    private Selector selector;
    private Iterator<SelectionKey> iterator;
    int remotePort;
    String remoteAddress;
    String remoteName;
    int localPort;
    String localAddress;
    String localName;
    String connectionDescription;
    CharacterSet charset;
    boolean useSSL;
    static final int NSPTCN = 1;
    static final int NSPTAC = 2;
    static final int NSPTAK = 3;
    static final int NSPTRF = 4;
    static final int NSPTRD = 5;
    static final int NSPTDA = 6;
    static final int NSPTNL = 7;
    static final int NSPTAB = 9;
    static final int NSPTRS = 11;
    static final int NSPTMK = 12;
    static final int NSPTAT = 13;
    static final int NSPTCNL = 14;
    static final int NSPTHI = 19;
    static final short KPDNFY_TIMEOUT = 1;
    static final short KPDNFY_GROUPING = 2;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    NTFConnection(NTFManager _ntfManager, SocketChannel _channel, NTFListener _ntfListener) throws IOException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NTFConnection.class, $$$methodRef$$$14, null, _ntfManager, _channel, _ntfListener);
            }
            this.channel = null;
            this.inBuffer = null;
            this.outBuffer = null;
            this.needsToBeClosed = false;
            this.selector = null;
            this.iterator = null;
            this.charset = null;
            this.useSSL = false;
            try {
                this.ntfManager = _ntfManager;
                this.ntfListener = _ntfListener;
                boolean bl2 = this.useSSL = this.ntfListener.socketOptions != null;
                if (this.useSSL) {
                    this.prepareSSL(_channel);
                } else {
                    this.channel = _channel;
                }
                this.channel.configureBlocking(false);
                this.channel.socket().setKeepAlive(true);
                this.inBuffer = ByteBuffer.allocate(4096);
                this.outBuffer = ByteBuffer.allocate(2048);
                Socket socket = this.channel.socket();
                InetAddress desIa = socket.getInetAddress();
                InetAddress locIa = socket.getLocalAddress();
                this.remotePort = socket.getPort();
                this.localPort = socket.getLocalPort();
                this.remoteAddress = desIa.getHostAddress();
                this.remoteName = desIa.getHostName();
                this.localAddress = locIa.getHostAddress();
                this.localName = locIa.getHostName();
                this.connectionDescription = "local=" + this.localName + "/" + this.localAddress + ":" + this.localPort + ", remote=" + this.remoteName + "/" + this.remoteAddress + ":" + this.remotePort;
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$14, Level.FINEST, this.getClass(), $$$methodRef$$$14, "NTFConnection established: " + this.connectionDescription);
                }
            }
            catch (IOException ioex) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$14, Level.FINEST, this.getClass(), $$$methodRef$$$14, "NTFConnnection (" + this.connectionDescription + "): ERROR: got IOException in constructor: " + ioex.getMessage());
                }
                IOException iOException = ioex;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, NTFConnection.class, $$$methodRef$$$14, null, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NTFConnection.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTFConnection.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTFConnection.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void prepareSSL(SocketChannel socketChannel) throws IOException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFConnection.class, $$$methodRef$$$0, this, socketChannel);
            }
            try {
                void underlyingSocketChannel;
                SSLEngine sslEngine = CustomSSLSocketFactory.getSSLSocketEngine(null, 0, this.ntfListener.socketOptions);
                TcpsConfigure.configureVersion(null, sslEngine, (String)this.ntfListener.socketOptions.get(6), true);
                TcpsConfigure.configureCipherSuites(null, sslEngine, (String)this.ntfListener.socketOptions.get(7), true);
                sslEngine.setUseClientMode(false);
                sslEngine.setNeedClientAuth(false);
                this.channel = new SSLSocketChannel((SocketChannel)underlyingSocketChannel, sslEngine);
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$0, Level.INFO, this.getClass(), $$$methodRef$$$0, "SSL NTFConnection established successfully");
                }
            }
            catch (IOException e2) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$0, Level.SEVERE, this.getClass(), $$$methodRef$$$0, String.format("SSL NTFConnection cannot be established: %s, Reason: %s", this.connectionDescription, e2.getMessage()));
                }
                IOException iOException = e2;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFConnection.class, $$$methodRef$$$0, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFConnection.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFConnection.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block37: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFConnection.class, $$$methodRef$$$1, this, new Object[0]);
                }
                this.selector = Selector.open();
                if (this.useSSL) {
                    ((SSLSocketChannel)this.channel).getUnderlyingChannel().register(this.selector, 1);
                } else {
                    this.channel.register(this.selector, 1);
                }
                int bytesReadFromNetwork = 0;
                this.inBuffer.limit(0);
                while (!this.needsToBeClosed) {
                    if (!this.inBuffer.hasRemaining()) {
                        while ((bytesReadFromNetwork = this.readFromNetwork()) == 0) {
                        }
                    }
                    this.unmarshalOneNSPacket();
                }
                try {
                    if (!this.needsToBeClosed) {
                        this.ntfListener.releaseConnection(this);
                    }
                    if (this.selector != null) {
                        this.selector.close();
                    }
                    this.channel.close();
                }
                catch (IOException ioex2) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "NTFConnection (" + this.connectionDescription + "): ERROR: got IOException during thread execution: " + ioex2.getMessage());
                    }
                    break block37;
                }
                catch (IOException ioex) {
                    block38: {
                        if (!bl) break block38;
                        OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "NTFConnection (" + this.connectionDescription + "): ERROR: got IOException during thread execution: " + ioex.getMessage());
                    }
                    try {
                        if (!this.needsToBeClosed) {
                            this.ntfListener.releaseConnection(this);
                        }
                        if (this.selector != null) {
                            this.selector.close();
                        }
                        this.channel.close();
                    }
                    catch (IOException ioex2) {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "NTFConnection (" + this.connectionDescription + "): ERROR: got IOException during thread execution: " + ioex2.getMessage());
                        }
                        break block37;
                    }
                }
                catch (InterruptedException intex) {
                    block39: {
                        if (!bl) break block39;
                        OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "NTFConnection (" + this.connectionDescription + "): ERROR: got InterruptedException during thread execution: " + intex.getMessage());
                        {
                            catch (Throwable throwable) {
                                block40: {
                                    try {
                                        if (!this.needsToBeClosed) {
                                            this.ntfListener.releaseConnection(this);
                                        }
                                        if (this.selector != null) {
                                            this.selector.close();
                                        }
                                        this.channel.close();
                                    }
                                    catch (IOException ioex2) {
                                        if (!bl) break block40;
                                        OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "NTFConnection (" + this.connectionDescription + "): ERROR: got IOException during thread execution: " + ioex2.getMessage());
                                    }
                                }
                                Throwable throwable2 = throwable;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTFConnection.class, $$$methodRef$$$1, this, throwable2);
                                }
                                throw throwable2;
                            }
                        }
                    }
                    try {
                        if (!this.needsToBeClosed) {
                            this.ntfListener.releaseConnection(this);
                        }
                        if (this.selector != null) {
                            this.selector.close();
                        }
                        this.channel.close();
                    }
                    catch (IOException ioex2) {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "NTFConnection (" + this.connectionDescription + "): ERROR: got IOException during thread execution: " + ioex2.getMessage());
                        }
                    }
                }
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "NTFConnection (" + this.connectionDescription + "): end of run method. Thread will be closed.");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFConnection.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFConnection.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFConnection.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    private int readFromNetwork() throws IOException, InterruptedException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            int ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFConnection.class, $$$methodRef$$$2, this, new Object[0]);
            }
            this.inBuffer.compact();
            boolean needSelect = true;
            if (this.useSSL) {
                boolean bl2 = needSelect = !((SSLSocketChannel)this.channel).hasRemaining();
            }
            while (needSelect) {
                while (this.iterator == null || !this.iterator.hasNext()) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "NTFConnection (" + this.connectionDescription + ") thread: select()");
                    }
                    this.selector.select();
                    if (this.needsToBeClosed) {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "NTFConnection (" + this.connectionDescription + ") was interrupted.");
                        }
                        InterruptedException interruptedException = new InterruptedException();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFConnection.class, $$$methodRef$$$2, this, interruptedException);
                        }
                        throw interruptedException;
                    }
                    this.iterator = this.selector.selectedKeys().iterator();
                }
                SelectionKey aKey = this.iterator.next();
                if (!aKey.isReadable()) continue;
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "NTFConnection (" + this.connectionDescription + ") thread: OP_READ");
            }
            if ((ret = this.channel.read(this.inBuffer)) < 0) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "NTFConnection (" + this.connectionDescription + ") was closed by remote peer.");
                }
                EOFException eOFException = new EOFException();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFConnection.class, $$$methodRef$$$2, this, eOFException);
                }
                throw eOFException;
            }
            if (ret > 0) {
                this.inBuffer.flip();
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "NTFConnection (" + this.connectionDescription + ") received packet: \n" + this.packetToString(this.inBuffer));
                }
            }
            if (needSelect) {
                this.iterator.remove();
            }
            int n2 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFConnection.class, $$$methodRef$$$2, this, n2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFConnection.class, $$$methodRef$$$2, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFConnection.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    private void getNextNSPacket() throws IOException, InterruptedException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            int bytesReadFromNetwork;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFConnection.class, $$$methodRef$$$3, this, new Object[0]);
            }
            while (!this.inBuffer.hasRemaining() || this.inBuffer.remaining() < 10) {
                bytesReadFromNetwork = this.readFromNetwork();
            }
            this.currentNSPacketLength = this.inBuffer.getShort();
            if (bl) {
                OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "NTFConnection (" + this.connectionDescription + "): currentNSPacketLength is " + this.currentNSPacketLength);
            }
            if (this.currentNSPacketLength <= 0) {
                IOException iOException = new IOException("Invalid NS packet length.");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFConnection.class, $$$methodRef$$$3, this, iOException);
                }
                throw iOException;
            }
            this.inBuffer.position(this.inBuffer.position() + 2);
            this.currentNSPacketType = this.inBuffer.get();
            if (bl) {
                OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "NTFConnection (" + this.connectionDescription + "): currentNSPacketType is " + this.currentNSPacketType);
            }
            this.validatePacketType();
            this.inBuffer.position(this.inBuffer.position() + 5);
            while (this.inBuffer.remaining() < this.currentNSPacketLength - 10) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "NTFConnection (" + this.connectionDescription + "): need to read another " + (this.currentNSPacketLength - 10) + " bytes.");
                }
                bytesReadFromNetwork = this.readFromNetwork();
            }
            int limitBack = this.inBuffer.limit();
            int positionOfEndOfNSPacket = this.inBuffer.position() + this.currentNSPacketLength - 10;
            this.inBuffer.limit(positionOfEndOfNSPacket);
            this.currentNSPacketDataBuffer = this.inBuffer.slice();
            this.inBuffer.limit(limitBack);
            this.inBuffer.position(positionOfEndOfNSPacket);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFConnection.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFConnection.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFConnection.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unmarshalOneNSPacket() throws IOException, InterruptedException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFConnection.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.getNextNSPacket();
            if (this.currentNSPacketDataBuffer.hasRemaining()) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "NTFConnection (" + this.connectionDescription + "): switching on packet type " + this.currentNSPacketType);
                }
                switch (this.currentNSPacketType) {
                    case 1: {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "NTFConnection (" + this.connectionDescription + ") got a NSPTCN packet.");
                        }
                        byte[] answer = new byte[]{0, 24, 0, 0, 2, 0, 0, 0, 1, 52, 0, 0, 8, 0, 127, -1, 1, 0, 0, 0, 0, 24, 65, 1};
                        this.outBuffer.clear();
                        this.outBuffer.put(answer);
                        this.outBuffer.limit(24);
                        this.outBuffer.rewind();
                        this.channel.write(this.outBuffer);
                        break;
                    }
                    case 6: {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "NTFConnection (" + this.connectionDescription + ") got a NSPTDA packet.");
                        }
                        if (this.currentNSPacketDataBuffer.get(0) == -34 && this.currentNSPacketDataBuffer.get(1) == -83) {
                            if (bl) {
                                OracleLog.debug($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "NTFConnection (" + this.connectionDescription + "): NSPTDA packet is DEADBEEF");
                            }
                            byte[] anoAnswer = new byte[]{0, 127, 0, 0, 6, 0, 0, 0, 0, 0, -34, -83, -66, -17, 0, 117, 10, 32, 1, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, 0, 31, 0, 14, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 2, 0, 4, 0, 1, 0, 1, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, -5, -1, 0, 2, 0, 2, 0, 0, 49, 106, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0};
                            this.outBuffer.clear();
                            this.outBuffer.put(anoAnswer);
                            this.outBuffer.limit(anoAnswer.length);
                            this.outBuffer.rewind();
                            this.channel.write(this.outBuffer);
                            if (!bl) break;
                            OracleLog.debug($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "NTFConnection (" + this.connectionDescription + "): Response to DEADBEEF sent.");
                            break;
                        }
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "NTFConnection (" + this.connectionDescription + "): Got a notification.");
                        }
                        this.unmarshalNSDataPacket();
                        break;
                    }
                }
            } else if (bl) {
                OracleLog.debug($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "NTFConnection (" + this.connectionDescription + "): there was no NS data.");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFConnection.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFConnection.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFConnection.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    private void unmarshalNSDataPacket() throws IOException, InterruptedException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            int i2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFConnection.class, $$$methodRef$$$5, this, new Object[0]);
            }
            short nbOfHandles = this.readShort();
            int lengthOfHeaderHandler = this.readInt();
            byte csidType = this.readByte();
            int csidLength = this.readInt();
            short csid = this.readShort();
            if (this.charset == null || this.charset.getOracleId() != csid) {
                this.charset = CharacterSet.make(csid);
            }
            byte presentationType = this.readByte();
            int presentationLength = this.readInt();
            short presentation = this.readShort();
            byte versionType = this.readByte();
            int versionLength = this.readInt();
            short version = this.readShort();
            int nbOfRegistrations = (lengthOfHeaderHandler - 21) / 9;
            int[] contextArr = new int[nbOfRegistrations];
            for (int i3 = 0; i3 < nbOfRegistrations; ++i3) {
                byte contextType = this.readByte();
                int contextLength = this.readInt();
                byte[] contextBuffer = new byte[contextLength];
                this.readBuffer(contextBuffer, 0, contextLength);
                for (int j2 = 0; j2 < contextLength; ++j2) {
                    if (j2 >= 4) continue;
                    int n2 = i3;
                    contextArr[n2] = contextArr[n2] | (contextBuffer[j2] & 0xFF) << 8 * (contextLength - j2 - 1);
                }
            }
            NTFDCNEvent dcnevent = null;
            NTFAQEvent aqevent = null;
            int namespace = 0;
            short databaseVersion = 0;
            NTFRegistration[] ntfRegistrationArr = null;
            if (nbOfHandles >= 2) {
                short ignore = this.readShort();
                ntfRegistrationArr = new NTFRegistration[contextArr.length];
                for (i2 = 0; i2 < contextArr.length; ++i2) {
                    ntfRegistrationArr[i2] = this.ntfManager.getRegistration(contextArr[i2]);
                    if (ntfRegistrationArr[i2] == null) continue;
                    namespace = ntfRegistrationArr[i2].getNamespace();
                    databaseVersion = ntfRegistrationArr[i2].getDatabaseVersion();
                }
                if (namespace == 2) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFConnection (" + this.connectionDescription + "): Got a DCN notification.");
                    }
                    dcnevent = new NTFDCNEvent(this, databaseVersion);
                } else if (namespace == 1) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFConnection (" + this.connectionDescription + "): Got an AQ notification.");
                    }
                    aqevent = new NTFAQEvent(this, databaseVersion);
                } else if (namespace == 0) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFConnection (" + this.connectionDescription + "): Got an ANONYMOUS notification.");
                    }
                } else if (bl) {
                    OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFConnection (" + this.connectionDescription + "): ERROR: unrecognized namespace.");
                }
            }
            short notifyDescriptor = 0;
            if (nbOfHandles >= 3) {
                short ignore = this.readShort();
                int lengthThirdHandle = this.readInt();
                byte ttype = this.readByte();
                int llength = this.readInt();
                notifyDescriptor = this.readShort();
                if (namespace == 2 && dcnevent != null) {
                    dcnevent.setAdditionalEventType(DatabaseChangeEvent.AdditionalEventType.getEventType(notifyDescriptor));
                    if (notifyDescriptor == 1) {
                        dcnevent.setEventType(DatabaseChangeEvent.EventType.DEREG);
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFConnection (" + this.connectionDescription + ") DCN timeout flag received.");
                        }
                    }
                } else if (namespace == 1 && aqevent != null) {
                    aqevent.setAdditionalEventType(AQNotificationEvent.AdditionalEventType.getEventType(notifyDescriptor));
                    if (notifyDescriptor == 1) {
                        aqevent.setEventType(AQNotificationEvent.EventType.DEREG);
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFConnection (" + this.connectionDescription + ") AQ timeout flag received.");
                        }
                    }
                }
            }
            if (nbOfHandles > 3 && bl) {
                OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFConnection (" + this.connectionDescription + "): ERROR: The notification contains more than 3 handles.");
            }
            if (ntfRegistrationArr != null) {
                if (namespace == 2) {
                    for (i2 = 0; i2 < ntfRegistrationArr.length; ++i2) {
                        if (ntfRegistrationArr[i2] == null || dcnevent == null) continue;
                        ntfRegistrationArr[i2].notify(dcnevent);
                    }
                } else if (namespace == 1) {
                    for (i2 = 0; i2 < ntfRegistrationArr.length; ++i2) {
                        if (ntfRegistrationArr[i2] == null || aqevent == null) continue;
                        ntfRegistrationArr[i2].notify(aqevent);
                    }
                } else if (bl) {
                    OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFConnection (" + this.connectionDescription + "): unknown namespace.");
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFConnection.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFConnection.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFConnection.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    void closeThisConnection() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFConnection.class, $$$methodRef$$$6, this, new Object[0]);
            }
            this.needsToBeClosed = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFConnection.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFConnection.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFConnection.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    byte readByte() throws IOException, InterruptedException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTFConnection.class, $$$methodRef$$$7, this, new Object[0]);
            }
            byte ret = 0;
            if (this.currentNSPacketDataBuffer.hasRemaining()) {
                ret = this.currentNSPacketDataBuffer.get();
            } else {
                this.getNextNSPacket();
                ret = this.currentNSPacketDataBuffer.get();
            }
            byte by = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTFConnection.class, $$$methodRef$$$7, this, by);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFConnection.class, $$$methodRef$$$7, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFConnection.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    short readShort() throws IOException, InterruptedException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTFConnection.class, $$$methodRef$$$8, this, new Object[0]);
            }
            short ret = 0;
            if (this.currentNSPacketDataBuffer.remaining() >= 2) {
                ret = this.currentNSPacketDataBuffer.getShort();
            } else {
                int b1 = this.readByte() & 0xFF;
                int b2 = this.readByte() & 0xFF;
                ret = (short)(b1 << 8 | b2);
            }
            short s2 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTFConnection.class, $$$methodRef$$$8, this, s2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFConnection.class, $$$methodRef$$$8, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFConnection.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    int readInt() throws IOException, InterruptedException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTFConnection.class, $$$methodRef$$$9, this, new Object[0]);
            }
            int ret = 0;
            if (this.currentNSPacketDataBuffer.remaining() >= 4) {
                ret = this.currentNSPacketDataBuffer.getInt();
            } else {
                int b1 = this.readByte() & 0xFF;
                int b2 = this.readByte() & 0xFF;
                int b3 = this.readByte() & 0xFF;
                int b4 = this.readByte() & 0xFF;
                ret = b1 << 24 | b2 << 16 | b3 << 8 | b4;
            }
            int n2 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTFConnection.class, $$$methodRef$$$9, this, n2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFConnection.class, $$$methodRef$$$9, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFConnection.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    long readLong() throws IOException, InterruptedException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTFConnection.class, $$$methodRef$$$10, this, new Object[0]);
            }
            long ret = 0L;
            if (this.currentNSPacketDataBuffer.remaining() >= 8) {
                ret = this.currentNSPacketDataBuffer.getLong();
            } else {
                long b1 = this.readByte() & 0xFF;
                long b2 = this.readByte() & 0xFF;
                long b3 = this.readByte() & 0xFF;
                long b4 = this.readByte() & 0xFF;
                long b5 = this.readByte() & 0xFF;
                long b6 = this.readByte() & 0xFF;
                long b7 = this.readByte() & 0xFF;
                long b8 = this.readByte() & 0xFF;
                ret = b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8;
            }
            long l2 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTFConnection.class, $$$methodRef$$$10, this, l2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFConnection.class, $$$methodRef$$$10, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFConnection.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void readBuffer(byte[] byArray, int n2, int n3) throws IOException, InterruptedException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void buff;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTFConnection.class, $$$methodRef$$$11, this, byArray, n2, n3);
            }
            if (this.currentNSPacketDataBuffer.remaining() >= length) {
                this.currentNSPacketDataBuffer.get((byte[])buff, (int)offset, (int)length);
            } else {
                boolean done = false;
                int bytesAlreadyRead = 0;
                int bytesToRead = 0;
                int remainingBytesInCurrentBuffer = this.currentNSPacketDataBuffer.remaining();
                this.currentNSPacketDataBuffer.get((byte[])buff, (int)offset, remainingBytesInCurrentBuffer);
                offset += remainingBytesInCurrentBuffer;
                bytesAlreadyRead += remainingBytesInCurrentBuffer;
                while (!done) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$11, Level.FINEST, this.getClass(), $$$methodRef$$$11, "NTFConnection (" + this.connectionDescription + "): bytesAlreadyRead = " + bytesAlreadyRead);
                    }
                    this.getNextNSPacket();
                    remainingBytesInCurrentBuffer = this.currentNSPacketDataBuffer.remaining();
                    bytesToRead = Math.min(remainingBytesInCurrentBuffer, (int)(length - bytesAlreadyRead));
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$11, Level.FINEST, this.getClass(), $$$methodRef$$$11, "NTFConnection (" + this.connectionDescription + "): bytesToRead = " + bytesToRead);
                    }
                    this.currentNSPacketDataBuffer.get((byte[])buff, (int)offset, bytesToRead);
                    offset += bytesToRead;
                    if ((bytesAlreadyRead += bytesToRead) != length) continue;
                    done = true;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFConnection.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFConnection.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFConnection.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String packetToString(ByteBuffer byteBuffer) throws IOException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void buff;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTFConnection.class, $$$methodRef$$$12, this, byteBuffer);
            }
            int offset = 0;
            char[] byteArr = new char[8];
            StringBuffer strbuff = new StringBuffer();
            int initialPosition = buff.position();
            while (buff.hasRemaining()) {
                byte b2 = buff.get();
                String hexRep = Integer.toHexString(b2 & 0xFF);
                if ((hexRep = hexRep.toUpperCase()).length() == 1) {
                    hexRep = "0" + hexRep;
                }
                strbuff.append(hexRep);
                strbuff.append(' ');
                byteArr[offset] = b2 > 32 && b2 < 127 ? (int)b2 : 46;
                if (++offset != 8) continue;
                strbuff.append('|');
                strbuff.append(byteArr);
                strbuff.append('|');
                strbuff.append('\n');
                offset = 0;
            }
            if (offset != 0) {
                int i2;
                int nbSpacesMissing = 8 - offset;
                for (i2 = 0; i2 < nbSpacesMissing * 3; ++i2) {
                    strbuff.append(' ');
                }
                strbuff.append('|');
                strbuff.append(byteArr, 0, offset);
                for (i2 = 0; i2 < nbSpacesMissing; ++i2) {
                    strbuff.append(' ');
                }
                strbuff.append('|');
                strbuff.append('\n');
            }
            strbuff.append("\nEnd of Packet\n\n");
            buff.position(initialPosition);
            String string = strbuff.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFConnection.class, $$$methodRef$$$12, this, string);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFConnection.class, $$$methodRef$$$12, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFConnection.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    private void validatePacketType() throws IOException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NTFConnection.class, $$$methodRef$$$13, this, new Object[0]);
            }
            if (this.currentNSPacketType < 1 || this.currentNSPacketType > 19) {
                IOException iOException = new IOException("Invalid NS packet type.");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, NTFConnection.class, $$$methodRef$$$13, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NTFConnection.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFConnection.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFConnection.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$14 = NTFConnection.class.getDeclaredConstructor(NTFManager.class, SocketChannel.class, NTFListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NTFConnection.class.getDeclaredMethod("validatePacketType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NTFConnection.class.getDeclaredMethod("packetToString", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFConnection.class.getDeclaredMethod("readBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFConnection.class.getDeclaredMethod("readLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFConnection.class.getDeclaredMethod("readInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFConnection.class.getDeclaredMethod("readShort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFConnection.class.getDeclaredMethod("readByte", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFConnection.class.getDeclaredMethod("closeThisConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFConnection.class.getDeclaredMethod("unmarshalNSDataPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFConnection.class.getDeclaredMethod("unmarshalOneNSPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFConnection.class.getDeclaredMethod("getNextNSPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFConnection.class.getDeclaredMethod("readFromNetwork", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFConnection.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFConnection.class.getDeclaredMethod("prepareSSL", SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

