/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// file generated from @vscode/web-custom-data NPM package
export const cssData = {
    "version": 1.1,
    "properties": [
        {
            "name": "additive-symbols",
            "browsers": [
                "FF33"
            ],
            "atRule": "@counter-style",
            "syntax": "[ <integer [0,∞]> && <symbol> ]#",
            "relevance": 50,
            "description": "@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor. Needs to be specified if the counter system is 'additive'.",
            "restrictions": [
                "integer",
                "string",
                "image",
                "identifier"
            ]
        },
        {
            "name": "align-content",
            "browsers": [
                "E12",
                "FF28",
                "FFA28",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O16"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Lines are packed toward the center of the flex container."
                },
                {
                    "name": "flex-end",
                    "description": "Lines are packed toward the end of the flex container."
                },
                {
                    "name": "flex-start",
                    "description": "Lines are packed toward the start of the flex container."
                },
                {
                    "name": "space-around",
                    "description": "Lines are evenly distributed in the flex container, with half-size spaces on either end."
                },
                {
                    "name": "space-between",
                    "description": "Lines are evenly distributed in the flex container."
                },
                {
                    "name": "stretch",
                    "description": "Lines stretch to take up the remaining space."
                },
                {
                    "name": "start"
                },
                {
                    "name": "end"
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S9",
                        "SM9",
                        "C29",
                        "CA29",
                        "IE11",
                        "O16"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-09-30",
                        "baseline_high_date": "2018-03-30"
                    }
                },
                {
                    "name": "baseline"
                },
                {
                    "name": "first baseline"
                },
                {
                    "name": "last baseline"
                },
                {
                    "name": "space-around"
                },
                {
                    "name": "space-between"
                },
                {
                    "name": "space-evenly"
                },
                {
                    "name": "stretch"
                },
                {
                    "name": "safe"
                },
                {
                    "name": "unsafe"
                }
            ],
            "syntax": "normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position>",
            "relevance": 68,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/align-content"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Aligns a flex container's lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "align-items",
            "browsers": [
                "E12",
                "FF20",
                "FFA20",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O16"
            ],
            "values": [
                {
                    "name": "baseline",
                    "description": "If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
                },
                {
                    "name": "center",
                    "description": "The flex item's margin box is centered in the cross axis within the line."
                },
                {
                    "name": "flex-end",
                    "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
                },
                {
                    "name": "flex-start",
                    "description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                },
                {
                    "name": "normal"
                },
                {
                    "name": "start"
                },
                {
                    "name": "end"
                },
                {
                    "name": "self-start"
                },
                {
                    "name": "self-end"
                },
                {
                    "name": "first baseline"
                },
                {
                    "name": "last baseline"
                },
                {
                    "name": "stretch"
                },
                {
                    "name": "safe"
                },
                {
                    "name": "unsafe"
                }
            ],
            "syntax": "normal | stretch | <baseline-position> | [ <overflow-position>? <self-position> ] | anchor-center",
            "relevance": 90,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/align-items"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Aligns flex items along the cross axis of the current line of the flex container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "justify-items",
            "browsers": [
                "E12",
                "FF20",
                "FFA20",
                "S9",
                "SM9",
                "C52",
                "CA52",
                "IE11",
                "O12.1"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "normal"
                },
                {
                    "name": "end"
                },
                {
                    "name": "start"
                },
                {
                    "name": "flex-end",
                    "description": "\"Flex items are packed toward the end of the line.\""
                },
                {
                    "name": "flex-start",
                    "description": "\"Flex items are packed toward the start of the line.\""
                },
                {
                    "name": "self-end",
                    "description": "The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."
                },
                {
                    "name": "self-start",
                    "description": "The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."
                },
                {
                    "name": "center",
                    "browsers": [
                        "E79",
                        "FF20",
                        "FFA20",
                        "S9",
                        "SM9",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The items are packed flush to each other toward the center of the of the alignment container."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E79",
                        "FF20",
                        "FFA20",
                        "S9",
                        "SM9",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "right",
                    "browsers": [
                        "E79",
                        "FF20",
                        "FFA20",
                        "S9",
                        "SM9",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "baseline"
                },
                {
                    "name": "first baseline"
                },
                {
                    "name": "last baseline"
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                },
                {
                    "name": "safe"
                },
                {
                    "name": "unsafe"
                },
                {
                    "name": "legacy",
                    "browsers": [
                        "E79",
                        "FF20",
                        "FFA20",
                        "S9",
                        "SM9",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                }
            ],
            "syntax": "normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ] | legacy | legacy && [ left | right | center ] | anchor-center",
            "relevance": 58,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/justify-items"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2016-07-27",
                "baseline_high_date": "2019-01-27"
            },
            "description": "Defines the default justify-self for all items of the box, giving them the default way of justifying each box along the appropriate axis",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "justify-self",
            "browsers": [
                "E16",
                "FF45",
                "FFA45",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "IE10",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF45",
                        "FFA45",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF45",
                        "FFA45",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "end"
                },
                {
                    "name": "start"
                },
                {
                    "name": "flex-end",
                    "description": "\"Flex items are packed toward the end of the line.\""
                },
                {
                    "name": "flex-start",
                    "description": "\"Flex items are packed toward the start of the line.\""
                },
                {
                    "name": "self-end",
                    "description": "The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."
                },
                {
                    "name": "self-start",
                    "description": "The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."
                },
                {
                    "name": "center",
                    "description": "The items are packed flush to each other toward the center of the of the alignment container."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E79",
                        "FF45",
                        "FFA45",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "right",
                    "browsers": [
                        "E79",
                        "FF45",
                        "FFA45",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "baseline"
                },
                {
                    "name": "first baseline"
                },
                {
                    "name": "last baseline"
                },
                {
                    "name": "stretch",
                    "browsers": [
                        "E79",
                        "FF45",
                        "FFA45",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                },
                {
                    "name": "save"
                },
                {
                    "name": "unsave"
                }
            ],
            "syntax": "auto | normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ] | anchor-center",
            "relevance": 59,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/justify-self"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Defines the way of justifying a box inside its container along the appropriate axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "align-self",
            "browsers": [
                "E12",
                "FF20",
                "FFA20",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE10",
                "O12.1"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Computes to the value of 'align-items' on the element's parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "self-end"
                },
                {
                    "name": "self-start"
                },
                {
                    "name": "baseline",
                    "description": "If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
                },
                {
                    "name": "center",
                    "description": "The flex item's margin box is centered in the cross axis within the line."
                },
                {
                    "name": "flex-end",
                    "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
                },
                {
                    "name": "flex-start",
                    "description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
                },
                {
                    "name": "stretch",
                    "browsers": [
                        "E79",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                },
                {
                    "name": "baseline"
                },
                {
                    "name": "first baseline"
                },
                {
                    "name": "last baseline"
                },
                {
                    "name": "safe"
                },
                {
                    "name": "unsafe"
                }
            ],
            "syntax": "auto | normal | stretch | <baseline-position> | <overflow-position>? <self-position> | anchor-center",
            "relevance": 76,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/align-self"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Allows the default alignment along the cross axis to be overridden for individual flex items.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "all",
            "browsers": [
                "E79",
                "FF27",
                "FFA27",
                "S9.1",
                "SM9.3",
                "C37",
                "CA37",
                "O24"
            ],
            "values": [],
            "syntax": "initial | inherit | unset | revert | revert-layer",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/all"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Shorthand that resets all properties except 'direction' and 'unicode-bidi'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "alt",
            "values": [],
            "relevance": 50,
            "baseline": {
                "status": "false"
            },
            "description": "Provides alternative text for assistive technology to replace the generated content of a ::before or ::after element.",
            "restrictions": [
                "string",
                "enum"
            ]
        },
        {
            "name": "animation",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C43",
                "CA43",
                "IE10",
                "O30"
            ],
            "values": [
                {
                    "name": "alternate",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "backwards",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "infinite",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Causes the animation to repeat forever."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No animation is performed"
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "syntax": "<single-animation>#",
            "relevance": 84,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/animation"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Shorthand property combines six of the animation properties into a single property.",
            "restrictions": [
                "time",
                "timing-function",
                "enum",
                "identifier",
                "number"
            ]
        },
        {
            "name": "animation-delay",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C43",
                "CA43",
                "IE10",
                "O30"
            ],
            "syntax": "<time>#",
            "relevance": 67,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/animation-delay"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Defines when the animation will start.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "animation-direction",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C43",
                "CA43",
                "IE10",
                "O30"
            ],
            "values": [
                {
                    "name": "alternate",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "browsers": [
                        "E12",
                        "FF16",
                        "FFA16",
                        "S6",
                        "SM6",
                        "C19",
                        "CA25",
                        "IE10",
                        "O12.1"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "browsers": [
                        "E12",
                        "FF16",
                        "FFA16",
                        "S6",
                        "SM6",
                        "C19",
                        "CA25",
                        "IE10",
                        "O12.1"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "syntax": "<single-animation-direction>#",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/animation-direction"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Defines whether or not the animation should play in reverse on alternate cycles.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "animation-duration",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C43",
                "CA43",
                "IE10",
                "O30"
            ],
            "syntax": "[ auto | <time [0s,∞]> ]#",
            "relevance": 72,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/animation-duration"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Defines the length of time that an animation takes to complete one cycle.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "animation-fill-mode",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C43",
                "CA43",
                "IE10",
                "O30"
            ],
            "values": [
                {
                    "name": "backwards",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S5",
                        "SM4.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S5",
                        "SM4.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S5",
                        "SM4.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S5",
                        "SM4.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."
                }
            ],
            "syntax": "<single-animation-fill-mode>#",
            "relevance": 63,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/animation-fill-mode"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Defines what values are applied by the animation outside the time it is executing.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "animation-iteration-count",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C43",
                "CA43",
                "IE10",
                "O30"
            ],
            "values": [
                {
                    "name": "infinite",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Causes the animation to repeat forever."
                }
            ],
            "syntax": "<single-animation-iteration-count>#",
            "relevance": 63,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/animation-iteration-count"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",
            "restrictions": [
                "number",
                "enum"
            ]
        },
        {
            "name": "animation-name",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C43",
                "CA43",
                "IE10",
                "O30"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No animation is performed"
                }
            ],
            "syntax": "[ none | <keyframes-name> ]#",
            "relevance": 71,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/animation-name"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",
            "restrictions": [
                "identifier",
                "enum"
            ]
        },
        {
            "name": "animation-play-state",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C43",
                "CA43",
                "IE10",
                "O30"
            ],
            "values": [
                {
                    "name": "paused",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "A running animation will be paused."
                },
                {
                    "name": "running",
                    "browsers": [
                        "E12",
                        "FF5",
                        "FFA5",
                        "S4",
                        "SM3.2",
                        "C3",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Resume playback of a paused animation."
                }
            ],
            "syntax": "<single-animation-play-state>#",
            "relevance": 57,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/animation-play-state"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Defines whether the animation is running or paused.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "animation-timing-function",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C43",
                "CA43",
                "IE10",
                "O30"
            ],
            "syntax": "<easing-function>#",
            "relevance": 73,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/animation-timing-function"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Describes how the animation will progress over one cycle of its duration.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "backface-visibility",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S15.4",
                "SM15.4",
                "C36",
                "CA36",
                "IE10",
                "O23"
            ],
            "values": [
                {
                    "name": "hidden",
                    "browsers": [
                        "E12",
                        "FF10",
                        "FFA10",
                        "S5.1",
                        "SM5",
                        "C12",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Back side is hidden."
                },
                {
                    "name": "visible",
                    "browsers": [
                        "E12",
                        "FF10",
                        "FFA10",
                        "S5.1",
                        "SM5",
                        "C12",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Back side is visible."
                }
            ],
            "syntax": "visible | hidden",
            "relevance": 60,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/backface-visibility"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2022-03-14",
                "baseline_high_date": "2024-09-14"
            },
            "description": "Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "background",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [
                {
                    "name": "fixed",
                    "browsers": [
                        "E15",
                        "FF50",
                        "FFA50",
                        "S9.1",
                        "SM9.3",
                        "C15",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."
                },
                {
                    "name": "local",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "A value of 'none' counts as an image layer but draws nothing."
                },
                {
                    "name": "scroll",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"
                }
            ],
            "syntax": "<bg-layer>#? , <final-bg-layer>",
            "relevance": 93,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property for setting most background properties at the same place in the style sheet.",
            "restrictions": [
                "enum",
                "image",
                "color",
                "position",
                "length",
                "repeat",
                "percentage",
                "box"
            ]
        },
        {
            "name": "background-attachment",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM3.2",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [
                {
                    "name": "fixed",
                    "browsers": [
                        "E12",
                        "FF2",
                        "FFA4",
                        "S15.4",
                        "C1",
                        "CA18",
                        "IE9",
                        "O10.5"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."
                },
                {
                    "name": "local",
                    "browsers": [
                        "E12",
                        "FF25",
                        "FFA25",
                        "S15.4",
                        "SM15.4",
                        "C1",
                        "CA18",
                        "IE9",
                        "O10.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."
                },
                {
                    "name": "scroll",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"
                }
            ],
            "syntax": "<attachment>#",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-attachment"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies whether the background images are fixed with regard to the viewport ('fixed') or scroll along with the element ('scroll') or its contents ('local').",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "background-blend-mode",
            "browsers": [
                "E79",
                "FF30",
                "FFA30",
                "S8",
                "SM8",
                "C35",
                "CA35",
                "O22"
            ],
            "values": [
                {
                    "name": "normal",
                    "description": "Default attribute which specifies no blending"
                },
                {
                    "name": "multiply",
                    "description": "The source color is multiplied by the destination color and replaces the destination."
                },
                {
                    "name": "screen",
                    "description": "Multiplies the complements of the backdrop and source color values, then complements the result."
                },
                {
                    "name": "overlay",
                    "description": "Multiplies or screens the colors, depending on the backdrop color value."
                },
                {
                    "name": "darken",
                    "description": "Selects the darker of the backdrop and source colors."
                },
                {
                    "name": "lighten",
                    "description": "Selects the lighter of the backdrop and source colors."
                },
                {
                    "name": "color-dodge",
                    "description": "Brightens the backdrop color to reflect the source color."
                },
                {
                    "name": "color-burn",
                    "description": "Darkens the backdrop color to reflect the source color."
                },
                {
                    "name": "hard-light",
                    "description": "Multiplies or screens the colors, depending on the source color value."
                },
                {
                    "name": "soft-light",
                    "description": "Darkens or lightens the colors, depending on the source color value."
                },
                {
                    "name": "difference",
                    "description": "Subtracts the darker of the two constituent colors from the lighter color.."
                },
                {
                    "name": "exclusion",
                    "description": "Produces an effect similar to that of the Difference mode but lower in contrast."
                },
                {
                    "name": "hue",
                    "browsers": [
                        "E79",
                        "FF30",
                        "FFA30",
                        "S8",
                        "SM8",
                        "C35",
                        "CA35",
                        "O22"
                    ],
                    "description": "Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."
                },
                {
                    "name": "saturation",
                    "browsers": [
                        "E79",
                        "FF30",
                        "FFA30",
                        "S8",
                        "SM8",
                        "C35",
                        "CA35",
                        "O22"
                    ],
                    "description": "Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."
                },
                {
                    "name": "color",
                    "browsers": [
                        "E79",
                        "FF30",
                        "FFA30",
                        "S8",
                        "SM8",
                        "C35",
                        "CA35",
                        "O22"
                    ],
                    "description": "Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."
                },
                {
                    "name": "luminosity",
                    "browsers": [
                        "E79",
                        "FF30",
                        "FFA30",
                        "S8",
                        "SM8",
                        "C35",
                        "CA35",
                        "O22"
                    ],
                    "description": "Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."
                }
            ],
            "syntax": "<blend-mode>#",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-blend-mode"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Defines the blending mode of each background layer.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "background-clip",
            "browsers": [
                "E12",
                "FF4",
                "FFA4",
                "S5",
                "SM5",
                "C1",
                "CA18",
                "IE9",
                "O10.5"
            ],
            "syntax": "<bg-clip>#",
            "relevance": 70,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-clip"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Determines the background painting area.",
            "restrictions": [
                "box"
            ]
        },
        {
            "name": "background-color",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<color>",
            "relevance": 94,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the background color of an element.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "background-image",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Counts as an image layer but draws nothing."
                }
            ],
            "syntax": "<bg-image>#",
            "relevance": 88,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-image"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the background image(s) of an element.",
            "restrictions": [
                "image",
                "enum"
            ]
        },
        {
            "name": "background-origin",
            "browsers": [
                "E12",
                "FF4",
                "FFA4",
                "S3",
                "SM1",
                "C1",
                "CA18",
                "IE9",
                "O10.5"
            ],
            "syntax": "<visual-box>#",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-origin"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",
            "restrictions": [
                "box"
            ]
        },
        {
            "name": "background-position",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<bg-position>#",
            "relevance": 87,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-position"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the initial position of the background image(s) (after any resizing) within their corresponding background positioning area.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "background-position-x",
            "browsers": [
                "E12",
                "FF49",
                "FFA49",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE6",
                "O15"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."
                },
                {
                    "name": "left",
                    "description": "Equivalent to '0%' for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset."
                },
                {
                    "name": "right",
                    "description": "Equivalent to '100%' for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset."
                }
            ],
            "syntax": "[ center | [ [ left | right | x-start | x-end ]? <length-percentage>? ]! ]#",
            "relevance": 57,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-position-x"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2016-09-20",
                "baseline_high_date": "2019-03-20"
            },
            "description": "If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "background-position-y",
            "browsers": [
                "E12",
                "FF49",
                "FFA49",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE6",
                "O15"
            ],
            "values": [
                {
                    "name": "bottom",
                    "description": "Equivalent to '100%' for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset."
                },
                {
                    "name": "center",
                    "description": "Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."
                },
                {
                    "name": "top",
                    "description": "Equivalent to '0%' for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."
                }
            ],
            "syntax": "[ center | [ [ top | bottom | y-start | y-end ]? <length-percentage>? ]! ]#",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-position-y"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2016-09-20",
                "baseline_high_date": "2019-03-20"
            },
            "description": "If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "background-repeat",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [],
            "syntax": "<repeat-style>#",
            "relevance": 86,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-repeat"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies how background images are tiled after they have been sized and positioned.",
            "restrictions": [
                "repeat"
            ]
        },
        {
            "name": "background-size",
            "browsers": [
                "E12",
                "FF4",
                "FFA4",
                "S5",
                "SM4.2",
                "C3",
                "CA18",
                "IE9",
                "O10"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF3.6",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Resolved by using the image's intrinsic ratio and the size of the other dimension, or failing that, using the image's intrinsic size, or failing that, treating it as 100%."
                },
                {
                    "name": "contain",
                    "browsers": [
                        "E12",
                        "FF3.6",
                        "FFA4",
                        "S5",
                        "SM4.2",
                        "C3",
                        "CA18",
                        "IE9",
                        "O10"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."
                },
                {
                    "name": "cover",
                    "browsers": [
                        "E12",
                        "FF3.6",
                        "FFA4",
                        "S5",
                        "SM4.2",
                        "C3",
                        "CA18",
                        "IE9",
                        "O10"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."
                }
            ],
            "syntax": "<bg-size>#",
            "relevance": 86,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/background-size"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the size of the background images.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "behavior",
            "browsers": [
                "IE6"
            ],
            "relevance": 50,
            "description": "IE only. Used to extend behaviors of the browser.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "block-size",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S5.1",
                        "SM5",
                        "C8",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Depends on the values of other properties."
                }
            ],
            "syntax": "<'width'>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/block-size"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Size of an element in the direction opposite that of the direction specified by 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "border",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<line-width> || <line-style> || <color>",
            "relevance": 95,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property for setting border width, style, and color.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-block-end",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-width'> || <'border-top-style'> || <color>",
            "relevance": 53,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-block-end"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-block-start",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-width'> || <'border-top-style'> || <color>",
            "relevance": 53,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-block-start"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-block-end-color",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-color'>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-block-end-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-bottom-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-block-start-color",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-color'>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-block-start-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-top-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-block-end-style",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-style'>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-block-end-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-bottom-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-block-start-style",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-style'>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-block-start-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-top-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-block-end-width",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-width'>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-block-end-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-bottom-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-block-start-width",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-width'>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-block-start-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-top-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-bottom",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<line-width> || <line-style> || <color>",
            "relevance": 87,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-bottom"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property for setting border width, style and color.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-bottom-color",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<'border-top-color'>",
            "relevance": 70,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-bottom-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the color of the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-bottom-left-radius",
            "browsers": [
                "E12",
                "FF4",
                "FFA4",
                "S5",
                "SM4.2",
                "C4",
                "CA18",
                "IE9",
                "O10.5"
            ],
            "syntax": "<length-percentage [0,∞]>{1,2}",
            "relevance": 75,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-bottom-left-radius"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Defines the radii of the bottom left outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-bottom-right-radius",
            "browsers": [
                "E12",
                "FF4",
                "FFA4",
                "S5",
                "SM4.2",
                "C4",
                "CA18",
                "IE9",
                "O10.5"
            ],
            "syntax": "<length-percentage [0,∞]>{1,2}",
            "relevance": 75,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-bottom-right-radius"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Defines the radii of the bottom right outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-bottom-style",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5.5",
                "O9.2"
            ],
            "syntax": "<line-style>",
            "relevance": 59,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-bottom-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the style of the bottom border.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-bottom-width",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<line-width>",
            "relevance": 67,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-bottom-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the thickness of the bottom border.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-collapse",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1.1",
                "SM1",
                "C1",
                "CA18",
                "IE5",
                "O4"
            ],
            "values": [
                {
                    "name": "collapse",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S1.1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Selects the collapsing borders model."
                },
                {
                    "name": "separate",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S1.1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Selects the separated borders border model."
                }
            ],
            "syntax": "separate | collapse",
            "relevance": 73,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-collapse"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Selects a table's border model.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-color",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [],
            "syntax": "<color>{1,4}",
            "relevance": 88,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "The color of the border around all four edges of an element.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-image",
            "browsers": [
                "E12",
                "FF15",
                "FFA15",
                "S6",
                "SM6",
                "C16",
                "CA18",
                "IE11",
                "O11"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
                },
                {
                    "name": "fill",
                    "browsers": [
                        "E12",
                        "FF15",
                        "FFA15",
                        "S6",
                        "SM6",
                        "C16",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Causes the middle part of the border-image to be preserved."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C16",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Use the border styles."
                },
                {
                    "name": "repeat",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C16",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The image is tiled (repeated) to fill the area."
                },
                {
                    "name": "round",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C16",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
                },
                {
                    "name": "space",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C16",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
                },
                {
                    "name": "stretch",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C16",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The image is stretched to fill the area."
                },
                {
                    "name": "url()"
                }
            ],
            "syntax": "<'border-image-source'> || <'border-image-slice'> [ / <'border-image-width'> | / <'border-image-width'>? / <'border-image-outset'> ]? || <'border-image-repeat'>",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-image"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "percentage",
                "number",
                "url",
                "enum"
            ]
        },
        {
            "name": "border-image-outset",
            "browsers": [
                "E12",
                "FF15",
                "FFA15",
                "S6",
                "SM6",
                "C15",
                "CA18",
                "IE11",
                "O15"
            ],
            "syntax": "[ <length [0,∞]> | <number [0,∞]> ]{1,4}",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-image-outset"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "The values specify the amount by which the border image area extends beyond the border box on the top, right, bottom, and left sides respectively. If the fourth value is absent, it is the same as the second. If the third one is also absent, it is the same as the first. If the second one is also absent, it is the same as the first. Numbers represent multiples of the corresponding border-width.",
            "restrictions": [
                "length",
                "number"
            ]
        },
        {
            "name": "border-image-repeat",
            "browsers": [
                "E12",
                "FF15",
                "FFA15",
                "S6",
                "SM9.3",
                "C15",
                "CA18",
                "IE11",
                "O15"
            ],
            "values": [
                {
                    "name": "repeat",
                    "browsers": [
                        "E12",
                        "FF15",
                        "FFA15",
                        "S6",
                        "SM9.3",
                        "C15",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-03-21",
                        "baseline_high_date": "2018-09-21"
                    },
                    "description": "The image is tiled (repeated) to fill the area."
                },
                {
                    "name": "round",
                    "browsers": [
                        "E12",
                        "FF15",
                        "FFA15",
                        "S9.1",
                        "SM9.3",
                        "C30",
                        "CA30",
                        "IE11",
                        "O17"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-03-21",
                        "baseline_high_date": "2018-09-21"
                    },
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
                },
                {
                    "name": "space",
                    "browsers": [
                        "E12",
                        "FF50",
                        "FFA50",
                        "S9.1",
                        "SM9.3",
                        "C56",
                        "CA56",
                        "IE11",
                        "O43"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-02-01",
                        "baseline_high_date": "2019-08-01"
                    },
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
                },
                {
                    "name": "stretch",
                    "browsers": [
                        "E12",
                        "FF15",
                        "FFA15",
                        "S6",
                        "SM9.3",
                        "C15",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-03-21",
                        "baseline_high_date": "2018-09-21"
                    },
                    "description": "The image is stretched to fill the area."
                }
            ],
            "syntax": "[ stretch | repeat | round | space ]{1,2}",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-image-repeat"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2016-03-21",
                "baseline_high_date": "2018-09-21"
            },
            "description": "Specifies how the images for the sides and the middle part of the border image are scaled and tiled. If the second keyword is absent, it is assumed to be the same as the first.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "border-image-slice",
            "browsers": [
                "E12",
                "FF15",
                "FFA15",
                "S6",
                "SM6",
                "C15",
                "CA18",
                "IE11",
                "O15"
            ],
            "values": [
                {
                    "name": "fill",
                    "description": "Causes the middle part of the border-image to be preserved."
                }
            ],
            "syntax": "[ <number [0,∞]> | <percentage [0,∞]> ]{1,4} && fill?",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-image-slice"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies inward offsets from the top, right, bottom, and left edges of the image, dividing it into nine regions: four corners, four edges and a middle.",
            "restrictions": [
                "number",
                "percentage"
            ]
        },
        {
            "name": "border-image-source",
            "browsers": [
                "E12",
                "FF15",
                "FFA15",
                "S6",
                "SM6",
                "C15",
                "CA18",
                "IE11",
                "O15"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF15",
                        "FFA15",
                        "S6",
                        "SM6",
                        "C15",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Use the border styles."
                }
            ],
            "syntax": "none | <image>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-image-source"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies an image to use instead of the border styles given by the 'border-style' properties and as an additional background layer for the element. If the value is 'none' or if the image cannot be displayed, the border styles will be used.",
            "restrictions": [
                "image"
            ]
        },
        {
            "name": "border-image-width",
            "browsers": [
                "E12",
                "FF13",
                "FFA14",
                "S6",
                "SM6",
                "C16",
                "CA18",
                "IE11",
                "O15"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF15",
                        "FFA15",
                        "S6",
                        "SM6",
                        "C16",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
                }
            ],
            "syntax": "[ <length-percentage [0,∞]> | <number [0,∞]> | auto ]{1,4}",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-image-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "The four values of 'border-image-width' specify offsets that are used to divide the border image area into nine parts. They represent inward distances from the top, right, bottom, and left sides of the area, respectively.",
            "restrictions": [
                "length",
                "percentage",
                "number"
            ]
        },
        {
            "name": "border-inline-end",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-width'> || <'border-top-style'> || <color>",
            "relevance": 53,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-inline-end"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-inline-start",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-width'> || <'border-top-style'> || <color>",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-inline-start"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-inline-end-color",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-color'>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-inline-end-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-right-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-inline-start-color",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-color'>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-inline-start-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-left-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-inline-end-style",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-style'>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-inline-end-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-right-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-inline-start-style",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-style'>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-inline-start-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-left-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-inline-end-width",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-width'>",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-inline-end-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-right-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-inline-start-width",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'border-top-width'>",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-inline-start-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'border-left-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-left",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<line-width> || <line-style> || <color>",
            "relevance": 80,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-left"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property for setting border width, style and color",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-left-color",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<color>",
            "relevance": 67,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-left-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the color of the left border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-left-style",
            "browsers": [
                "E12",
                "FF1",
                "FFA14",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5.5",
                "O9.2"
            ],
            "syntax": "<line-style>",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-left-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the style of the left border.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-left-width",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<line-width>",
            "relevance": 64,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-left-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the thickness of the left border.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-radius",
            "browsers": [
                "E12",
                "FF4",
                "FFA4",
                "S5",
                "SM4.2",
                "C4",
                "CA18",
                "IE9",
                "O10.5"
            ],
            "syntax": "<length-percentage [0,∞]>{1,4} [ / <length-percentage [0,∞]>{1,4} ]?",
            "relevance": 93,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-radius"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Defines the radii of the outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-right",
            "browsers": [
                "E12",
                "FF1",
                "FFA14",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5.5",
                "O9.2"
            ],
            "syntax": "<line-width> || <line-style> || <color>",
            "relevance": 79,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-right"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property for setting border width, style and color",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-right-color",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<color>",
            "relevance": 65,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-right-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the color of the right border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-right-style",
            "browsers": [
                "E12",
                "FF1",
                "FFA14",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5.5",
                "O9.2"
            ],
            "syntax": "<line-style>",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-right-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the style of the right border.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-right-width",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<line-width>",
            "relevance": 63,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-right-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the thickness of the right border.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-spacing",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE8",
                "O4"
            ],
            "syntax": "<length>{1,2}",
            "relevance": 65,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-spacing"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "The lengths specify the distance that separates adjoining cell borders. If one length is specified, it gives both the horizontal and vertical spacing. If two are specified, the first gives the horizontal spacing and the second the vertical spacing. Lengths may not be negative.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "border-style",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [],
            "syntax": "<line-style>{1,4}",
            "relevance": 80,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "The style of the border around edges of an element.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-top",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<line-width> || <line-style> || <color>",
            "relevance": 86,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-top"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property for setting border width, style and color",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "border-top-color",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<color>",
            "relevance": 70,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-top-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the color of the top border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "border-top-left-radius",
            "browsers": [
                "E12",
                "FF4",
                "FFA4",
                "S5",
                "SM4.2",
                "C4",
                "CA18",
                "IE9",
                "O10.5"
            ],
            "syntax": "<length-percentage [0,∞]>{1,2}",
            "relevance": 76,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-top-left-radius"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Defines the radii of the top left outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-top-right-radius",
            "browsers": [
                "E12",
                "FF4",
                "FFA4",
                "S5",
                "SM4.2",
                "C4",
                "CA18",
                "IE9",
                "O10.5"
            ],
            "syntax": "<length-percentage [0,∞]>{1,2}",
            "relevance": 76,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-top-right-radius"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Defines the radii of the top right outer border edge.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "border-top-style",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5.5",
                "O9.2"
            ],
            "syntax": "<line-style>",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-top-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the style of the top border.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "border-top-width",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<line-width>",
            "relevance": 66,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-top-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the thickness of the top border.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "border-width",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM3",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [],
            "syntax": "<line-width>{1,4}",
            "relevance": 82,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/border-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand that sets the four 'border-*-width' properties. If it has four values, they set top, right, bottom and left in that order. If left is missing, it is the same as right; if bottom is missing, it is the same as top; if right is missing, it is the same as top.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "bottom",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5",
                "O6"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
                }
            ],
            "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
            "relevance": 90,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/bottom"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies how far an absolutely positioned box's bottom margin edge is offset above the bottom edge of the box's 'containing block'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "box-decoration-break",
            "browsers": [
                "E130",
                "FF32",
                "FFA32",
                "C130",
                "CA130",
                "O115"
            ],
            "values": [
                {
                    "name": "clone",
                    "browsers": [
                        "E130",
                        "FF32",
                        "FFA32",
                        "S7",
                        "SM7",
                        "C130",
                        "CA130",
                        "O115"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2024-10-17"
                    },
                    "description": "Each box is independently wrapped with the border and padding."
                },
                {
                    "name": "slice",
                    "browsers": [
                        "E130",
                        "FF32",
                        "FFA32",
                        "S7",
                        "SM7",
                        "C130",
                        "CA130",
                        "O115"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2024-10-17"
                    },
                    "description": "The effect is as though the element were rendered with no breaks present, and then sliced by the breaks afterward."
                }
            ],
            "syntax": "slice | clone",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/box-decoration-break"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Specifies whether individual boxes are treated as broken pieces of one continuous box, or whether each box is individually wrapped with the border and padding.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "box-shadow",
            "browsers": [
                "E12",
                "FF4",
                "FFA4",
                "S5.1",
                "SM5",
                "C10",
                "CA18",
                "IE9",
                "O10.5"
            ],
            "values": [
                {
                    "name": "inset",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S5",
                        "SM4.2",
                        "C1",
                        "CA18",
                        "IE9",
                        "O10.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Changes the drop shadow from an outer shadow (one that shadows the box onto the canvas, as if it were lifted above the canvas) to an inner shadow (one that shadows the canvas onto the box, as if the box were cut out of the canvas and shifted behind it)."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No shadow."
                }
            ],
            "syntax": "none | <shadow>#",
            "relevance": 91,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/box-shadow"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Attaches one or more drop-shadows to the box. The property is a comma-separated list of shadows, each specified by 2-4 length values, an optional color, and an optional 'inset' keyword. Omitted lengths are 0; omitted colors are a user agent chosen color.",
            "restrictions": [
                "length",
                "color",
                "enum"
            ]
        },
        {
            "name": "box-sizing",
            "browsers": [
                "E12",
                "FF29",
                "FFA29",
                "S5.1",
                "SM6",
                "C10",
                "CA18",
                "IE8",
                "O7"
            ],
            "values": [
                {
                    "name": "border-box",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The specified width and height (and respective min/max properties) on this element determine the border box of the element."
                },
                {
                    "name": "content-box",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."
                }
            ],
            "syntax": "content-box | border-box",
            "relevance": 92,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/box-sizing"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the behavior of the 'width' and 'height' properties.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "break-after",
            "browsers": [
                "E12",
                "FF65",
                "FFA65",
                "S10",
                "SM10",
                "C50",
                "CA50",
                "IE10",
                "O37"
            ],
            "values": [
                {
                    "name": "always",
                    "browsers": [
                        "FF65",
                        "FFA65"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Always force a page break before/after the generated box."
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Neither force nor forbid a page/column break before/after the principal box."
                },
                {
                    "name": "avoid",
                    "browsers": [
                        "E79",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Avoid a break before/after the principal box."
                },
                {
                    "name": "avoid-column",
                    "browsers": [
                        "E79",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Avoid a column break before/after the principal box."
                },
                {
                    "name": "avoid-page",
                    "browsers": [
                        "E79",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Avoid a page break before/after the principal box."
                },
                {
                    "name": "column",
                    "browsers": [
                        "E79",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Always force a column break before/after the principal box."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."
                },
                {
                    "name": "page",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Always force a page break before/after the principal box."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."
                }
            ],
            "syntax": "auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/break-after"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2019-01-29",
                "baseline_high_date": "2021-07-29"
            },
            "description": "Describes the page/column/region break behavior after the generated box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "break-before",
            "browsers": [
                "E12",
                "FF65",
                "FFA65",
                "S10",
                "SM10",
                "C50",
                "CA50",
                "IE10",
                "O37"
            ],
            "values": [
                {
                    "name": "always",
                    "browsers": [
                        "FF65",
                        "FFA65"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Always force a page break before/after the generated box."
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Neither force nor forbid a page/column break before/after the principal box."
                },
                {
                    "name": "avoid",
                    "browsers": [
                        "E79",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Avoid a break before/after the principal box."
                },
                {
                    "name": "avoid-column",
                    "browsers": [
                        "E79",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Avoid a column break before/after the principal box."
                },
                {
                    "name": "avoid-page",
                    "browsers": [
                        "E79",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Avoid a page break before/after the principal box."
                },
                {
                    "name": "column",
                    "browsers": [
                        "E79",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Always force a column break before/after the principal box."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."
                },
                {
                    "name": "page",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Always force a page break before/after the principal box."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."
                }
            ],
            "syntax": "auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/break-before"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2019-01-29",
                "baseline_high_date": "2021-07-29"
            },
            "description": "Describes the page/column/region break behavior before the generated box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "break-inside",
            "browsers": [
                "E12",
                "FF65",
                "FFA65",
                "S10",
                "SM10",
                "C50",
                "CA50",
                "IE10",
                "O37"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Impose no additional breaking constraints within the box."
                },
                {
                    "name": "avoid",
                    "browsers": [
                        "E79",
                        "FF65",
                        "FFA65",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Avoid breaks within the box."
                },
                {
                    "name": "avoid-column",
                    "browsers": [
                        "E79",
                        "FF92",
                        "FFA92",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-09-07",
                        "baseline_high_date": "2024-03-07"
                    },
                    "description": "Avoid a column break within the box."
                },
                {
                    "name": "avoid-page",
                    "browsers": [
                        "E79",
                        "FF92",
                        "FFA92",
                        "S10",
                        "SM10",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-09-07",
                        "baseline_high_date": "2024-03-07"
                    },
                    "description": "Avoid a page break within the box."
                }
            ],
            "syntax": "auto | avoid | avoid-page | avoid-column | avoid-region",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/break-inside"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2019-01-29",
                "baseline_high_date": "2021-07-29"
            },
            "description": "Describes the page/column/region break behavior inside the principal box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "caption-side",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE8",
                "O4"
            ],
            "values": [
                {
                    "name": "bottom",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Positions the caption box below the table box."
                },
                {
                    "name": "top",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Positions the caption box above the table box."
                }
            ],
            "syntax": "top | bottom",
            "relevance": 53,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/caption-side"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the position of the caption box with respect to the table box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "caret-color",
            "browsers": [
                "E79",
                "FF53",
                "FFA53",
                "S11.1",
                "SM11.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF53",
                        "FFA53",
                        "S11.1",
                        "SM11.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The user agent selects an appropriate color for the caret. This is generally currentcolor, but the user agent may choose a different color to ensure good visibility and contrast with the surrounding content, taking into account the value of currentcolor, the background, shadows, and other factors."
                }
            ],
            "syntax": "auto | <color>",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/caret-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Controls the color of the text insertion indicator.",
            "restrictions": [
                "color",
                "enum"
            ]
        },
        {
            "name": "clear",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [
                {
                    "name": "both",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating and left-floating boxes that resulted from elements earlier in the source document."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any left-floating boxes that resulted from elements earlier in the source document."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No constraint on the box's position with respect to floats."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating boxes that resulted from elements earlier in the source document."
                }
            ],
            "syntax": "none | left | right | both | inline-start | inline-end",
            "relevance": 81,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/clear"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Indicates which sides of an element's box(es) may not be adjacent to an earlier floating box. The 'clear' property does not consider floats inside the element itself or in other block formatting contexts.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "clip",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The element does not clip."
                },
                {
                    "name": "rect()",
                    "description": "Specifies offsets from the edges of the border box."
                }
            ],
            "status": "obsolete",
            "syntax": "<shape> | auto",
            "relevance": 25,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/clip"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Deprecated. Use the 'clip-path' property when support allows. Defines the visible portion of an element's box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "clip-path",
            "browsers": [
                "E79",
                "FF3.5",
                "FFA4",
                "S9.1",
                "SM9.3",
                "C55",
                "CA55",
                "IE10",
                "O42"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No clipping path gets created."
                },
                {
                    "name": "url()",
                    "description": "References a <clipPath> element to create a clipping path."
                }
            ],
            "syntax": "<clip-source> | [ <basic-shape> || <geometry-box> ] | none",
            "relevance": 70,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/clip-path"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies a clipping path where everything inside the path is visible and everything outside is clipped out.",
            "restrictions": [
                "url",
                "shape",
                "geometry-box",
                "enum"
            ]
        },
        {
            "name": "clip-rule",
            "browsers": [
                "E79",
                "FF3.5",
                "FFA4",
                "S5",
                "SM4.2",
                "C15",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "evenodd",
                    "browsers": [
                        "E79",
                        "FF3.5",
                        "FFA4",
                        "S5",
                        "SM4.2",
                        "C15",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."
                },
                {
                    "name": "nonzero",
                    "browsers": [
                        "E79",
                        "FF3.5",
                        "FFA4",
                        "S5",
                        "SM4.2",
                        "C15",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."
                }
            ],
            "syntax": "nonzero | evenodd",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/clip-rule"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Indicates the algorithm which is to be used to determine what parts of the canvas are included inside the shape.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "color",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "syntax": "<color>",
            "relevance": 95,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the color of an element's text",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "color-interpolation-filters",
            "browsers": [
                "E79",
                "FF3",
                "FFA4",
                "S3",
                "SM2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF3",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Color operations are not required to occur in a particular color space."
                },
                {
                    "name": "linearRGB",
                    "browsers": [
                        "E79",
                        "FF22",
                        "FFA22",
                        "S9",
                        "SM9",
                        "C28",
                        "CA28",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Color operations should occur in the linearized RGB color space."
                },
                {
                    "name": "sRGB",
                    "browsers": [
                        "E79",
                        "FF22",
                        "FFA22",
                        "S9",
                        "SM9",
                        "C28",
                        "CA28",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Color operations should occur in the sRGB color space."
                }
            ],
            "syntax": "auto | sRGB | linearRGB",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/color-interpolation-filters"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies the color space for imaging operations performed via filter effects.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "column-count",
            "browsers": [
                "E12",
                "FF52",
                "FFA52",
                "S9",
                "SM9",
                "C50",
                "CA50",
                "IE10",
                "O37"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Determines the number of columns by the 'column-width' property and the element width."
                }
            ],
            "syntax": "<integer> | auto",
            "relevance": 53,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/column-count"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-03-07",
                "baseline_high_date": "2019-09-07"
            },
            "description": "Describes the optimal number of columns into which the content of the element will be flowed.",
            "restrictions": [
                "integer",
                "enum"
            ]
        },
        {
            "name": "column-fill",
            "browsers": [
                "E12",
                "FF52",
                "FFA52",
                "S9",
                "SM9",
                "C50",
                "CA50",
                "IE10",
                "O37"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF17",
                        "FFA17",
                        "S8",
                        "SM8",
                        "C50",
                        "CA50",
                        "IE11",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-04-13",
                        "baseline_high_date": "2018-10-13"
                    },
                    "description": "Fills columns sequentially."
                },
                {
                    "name": "balance",
                    "browsers": [
                        "E12",
                        "FF17",
                        "FFA17",
                        "S8",
                        "SM8",
                        "C50",
                        "CA50",
                        "IE11",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-04-13",
                        "baseline_high_date": "2018-10-13"
                    },
                    "description": "Balance content equally between columns, if possible."
                }
            ],
            "syntax": "auto | balance",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/column-fill"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-03-07",
                "baseline_high_date": "2019-09-07"
            },
            "description": "In continuous media, this property will only be consulted if the length of columns has been constrained. Otherwise, columns will automatically be balanced.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "column-gap",
            "browsers": [
                "E12",
                "FF1.5",
                "FFA4",
                "S3",
                "SM2",
                "C1",
                "CA18",
                "IE10",
                "O11.1"
            ],
            "values": [
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE10",
                        "O11.1"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "User agent specific and typically equivalent to 1em."
                }
            ],
            "syntax": "normal | <length-percentage>",
            "relevance": 67,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/column-gap"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",
            "restrictions": [
                "length",
                "enum"
            ]
        },
        {
            "name": "column-rule",
            "browsers": [
                "E12",
                "FF52",
                "FFA52",
                "S9",
                "SM9",
                "C50",
                "CA50",
                "IE10",
                "O11.1"
            ],
            "syntax": "<'column-rule-width'> || <'column-rule-style'> || <'column-rule-color'>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/column-rule"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-03-07",
                "baseline_high_date": "2019-09-07"
            },
            "description": "Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "column-rule-color",
            "browsers": [
                "E12",
                "FF52",
                "FFA52",
                "S9",
                "SM9",
                "C50",
                "CA50",
                "IE10",
                "O11.1"
            ],
            "syntax": "<color>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/column-rule-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-03-07",
                "baseline_high_date": "2019-09-07"
            },
            "description": "Sets the color of the column rule",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "column-rule-style",
            "browsers": [
                "E12",
                "FF52",
                "FFA52",
                "S9",
                "SM9",
                "C50",
                "CA50",
                "IE10",
                "O11.1"
            ],
            "syntax": "<'border-style'>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/column-rule-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-03-07",
                "baseline_high_date": "2019-09-07"
            },
            "description": "Sets the style of the rule between columns of an element.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "column-rule-width",
            "browsers": [
                "E12",
                "FF52",
                "FFA52",
                "S9",
                "SM9",
                "C50",
                "CA50",
                "IE10",
                "O11.1"
            ],
            "syntax": "<'border-width'>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/column-rule-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-03-07",
                "baseline_high_date": "2019-09-07"
            },
            "description": "Sets the width of the rule between columns. Negative values are not allowed.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "columns",
            "browsers": [
                "E12",
                "FF52",
                "FFA52",
                "S9",
                "SM9",
                "C50",
                "CA50",
                "IE10",
                "O11.1"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA22",
                        "S3",
                        "SM3.2",
                        "C50",
                        "CA50",
                        "O37"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-04-13",
                        "baseline_high_date": "2018-10-13"
                    },
                    "description": "The width depends on the values of other properties."
                }
            ],
            "syntax": "[ <'column-width'> || <'column-count'> ] [ / <'column-height'> ]?",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/columns"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-03-07",
                "baseline_high_date": "2019-09-07"
            },
            "description": "A shorthand property which sets both 'column-width' and 'column-count'.",
            "restrictions": [
                "length",
                "integer",
                "enum"
            ]
        },
        {
            "name": "column-span",
            "browsers": [
                "E12",
                "FF71",
                "FFA79",
                "S9",
                "SM9",
                "C50",
                "CA50",
                "IE10",
                "O37"
            ],
            "values": [
                {
                    "name": "all",
                    "browsers": [
                        "E12",
                        "FF71",
                        "FFA79",
                        "S5.1",
                        "SM5",
                        "C6",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-07-28",
                        "baseline_high_date": "2023-01-28"
                    },
                    "description": "The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appear."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF71",
                        "FFA79",
                        "S5.1",
                        "SM5",
                        "C6",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-07-28",
                        "baseline_high_date": "2023-01-28"
                    },
                    "description": "The element does not span multiple columns."
                }
            ],
            "syntax": "none | all",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/column-span"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-07-28",
                "baseline_high_date": "2023-01-28"
            },
            "description": "Describes the page/column break behavior after the generated box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "column-width",
            "browsers": [
                "E12",
                "FF50",
                "FFA50",
                "S9",
                "SM9",
                "C50",
                "CA50",
                "IE10",
                "O11.1"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The width depends on the values of other properties."
                }
            ],
            "syntax": "auto | <length [0,∞]>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/column-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2016-11-15",
                "baseline_high_date": "2019-05-15"
            },
            "description": "Describes the width of columns in multicol elements.",
            "restrictions": [
                "length",
                "enum"
            ]
        },
        {
            "name": "contain",
            "browsers": [
                "E79",
                "FF69",
                "FFA79",
                "S15.4",
                "SM15.4",
                "C52",
                "CA52",
                "O39"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S15.4",
                        "SM15.4",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "Indicates that the property has no effect."
                },
                {
                    "name": "strict",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S15.4",
                        "SM15.4",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "Turns on all forms of containment for the element."
                },
                {
                    "name": "content",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S15.4",
                        "SM15.4",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "All containment rules except size are applied to the element."
                },
                {
                    "name": "size",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S15.4",
                        "SM15.4",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "For properties that can have effects on more than just an element and its descendants, those effects don't escape the containing element."
                },
                {
                    "name": "layout",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S15.4",
                        "SM15.4",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "Turns on layout containment for the element."
                },
                {
                    "name": "style",
                    "browsers": [
                        "E79",
                        "FF103",
                        "FFA103",
                        "S15.4",
                        "SM15.4",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-07-26",
                        "baseline_high_date": "2025-01-26"
                    },
                    "description": "Turns on style containment for the element."
                },
                {
                    "name": "paint",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S15.4",
                        "SM15.4",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "Turns on paint containment for the element."
                }
            ],
            "syntax": "none | strict | content | [ [ size || inline-size ] || layout || style || paint ]",
            "relevance": 59,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/contain"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2022-03-14",
                "baseline_high_date": "2024-09-14"
            },
            "description": "Indicates that an element and its contents are, as much as possible, independent of the rest of the document tree.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "content",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE8",
                "O4"
            ],
            "values": [
                {
                    "name": "attr()",
                    "description": "The attr(n) function returns as a string the value of attribute n for the subject of the selector."
                },
                {
                    "name": "counter(name)",
                    "description": "Counters are denoted by identifiers (see the 'counter-increment' and 'counter-reset' properties)."
                },
                {
                    "name": "icon",
                    "description": "The (pseudo-)element is replaced in its entirety by the resource referenced by its 'icon' property, and treated as a replaced element."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "On elements, this inhibits the children of the element from being rendered as children of this element, as if the element was empty. On pseudo-elements it causes the pseudo-element to have no content."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "See http://www.w3.org/TR/css3-content/#content for computation rules."
                },
                {
                    "name": "url()"
                }
            ],
            "syntax": "normal | none | [ <content-replacement> | <content-list> ] [ / [ <string> | <counter> | <attr()> ]+ ]?",
            "relevance": 90,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/content"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Determines which page-based occurrence of a given element is applied to a counter or string value.",
            "restrictions": [
                "string",
                "url"
            ]
        },
        {
            "name": "counter-increment",
            "browsers": [
                "E12",
                "FF1",
                "FFA25",
                "S3",
                "SM1",
                "C2",
                "CA18",
                "IE8",
                "O9.2"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA25",
                        "S3",
                        "SM2",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "This element does not alter the value of any counters."
                }
            ],
            "syntax": "[ <counter-name> <integer>? ]+ | none",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/counter-increment"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Manipulate the value of existing counters.",
            "restrictions": [
                "identifier",
                "integer"
            ]
        },
        {
            "name": "counter-reset",
            "browsers": [
                "E12",
                "FF1",
                "FFA25",
                "S3",
                "SM1",
                "C2",
                "CA18",
                "IE8",
                "O9.2"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA25",
                        "S3",
                        "SM2",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The counter is not modified."
                }
            ],
            "syntax": "[ <counter-name> <integer>? | <reversed-counter-name> <integer>? ]+ | none",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/counter-reset"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Property accepts one or more names of counters (identifiers), each one optionally followed by an integer. The integer gives the value that the counter is set to on each occurrence of the element.",
            "restrictions": [
                "identifier",
                "integer"
            ]
        },
        {
            "name": "cursor",
            "browsers": [
                "E12",
                "FF1",
                "FFA95",
                "S1.2",
                "SM13.4",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "alias",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates an alias of/shortcut to something is to be created. Often rendered as an arrow with a small curved arrow next to it."
                },
                {
                    "name": "all-scroll",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE6",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that the something can be scrolled in any direction. Often rendered as arrows pointing up, down, left, and right with a dot in the middle."
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-12-07",
                        "baseline_high_date": "2024-06-07"
                    },
                    "description": "The UA determines the cursor to display based on the current context."
                },
                {
                    "name": "cell",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE10",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-12-07",
                        "baseline_high_date": "2024-06-07"
                    },
                    "description": "Indicates that a cell or set of cells may be selected. Often rendered as a thick plus-sign with a dot in the middle."
                },
                {
                    "name": "col-resize",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE6",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that the item/column can be resized horizontally. Often rendered as arrows pointing left and right with a vertical bar separating them."
                },
                {
                    "name": "context-menu",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "A context menu is available for the object under the cursor. Often rendered as an arrow with a small menu-like graphic next to it."
                },
                {
                    "name": "copy",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates something is to be copied. Often rendered as an arrow with a small plus sign next to it."
                },
                {
                    "name": "crosshair",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "A simple crosshair (e.g., short line segments resembling a '+' sign). Often used to indicate a two dimensional bitmap selection mode."
                },
                {
                    "name": "default",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The platform-dependent default cursor. Often rendered as an arrow."
                },
                {
                    "name": "e-resize",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that east edge is to be moved."
                },
                {
                    "name": "ew-resize",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates a bidirectional east-west resize cursor."
                },
                {
                    "name": "grab",
                    "browsers": [
                        "E14",
                        "FF27",
                        "FFA95",
                        "S11",
                        "C68",
                        "CA68",
                        "O55"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that something can be grabbed."
                },
                {
                    "name": "grabbing",
                    "browsers": [
                        "E79",
                        "FF27",
                        "FFA95",
                        "S11",
                        "C68",
                        "CA68",
                        "O55"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that something is being grabbed."
                },
                {
                    "name": "help",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Help is available for the object under the cursor. Often rendered as a question mark or a balloon."
                },
                {
                    "name": "move",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates something is to be moved."
                },
                {
                    "name": "-moz-grab",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Indicates that something can be grabbed."
                },
                {
                    "name": "-moz-grabbing",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Indicates that something is being grabbed."
                },
                {
                    "name": "-moz-zoom-in",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Indicates that something can be zoomed (magnified) in."
                },
                {
                    "name": "-moz-zoom-out",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Indicates that something can be zoomed (magnified) out."
                },
                {
                    "name": "ne-resize",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that movement starts from north-east corner."
                },
                {
                    "name": "nesw-resize",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates a bidirectional north-east/south-west cursor."
                },
                {
                    "name": "no-drop",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE6",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that the dragged item cannot be dropped at the current cursor location. Often rendered as a hand or pointer with a small circle with a line through it."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF3",
                        "FFA95",
                        "S5",
                        "C5",
                        "CA18",
                        "IE9",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "No cursor is rendered for the element."
                },
                {
                    "name": "not-allowed",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE6",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that the requested action will not be carried out. Often rendered as a circle with a line through it."
                },
                {
                    "name": "n-resize",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that north edge is to be moved."
                },
                {
                    "name": "ns-resize",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates a bidirectional north-south cursor."
                },
                {
                    "name": "nw-resize",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that movement starts from north-west corner."
                },
                {
                    "name": "nwse-resize",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates a bidirectional north-west/south-east cursor."
                },
                {
                    "name": "pointer",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE6",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The cursor is a pointer that indicates a link."
                },
                {
                    "name": "progress",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE6",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "A progress indicator. The program is performing some processing, but is different from 'wait' in that the user may still interact with the program. Often rendered as a spinning beach ball, or an arrow with a watch or hourglass."
                },
                {
                    "name": "row-resize",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "IE6",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that the item/row can be resized vertically. Often rendered as arrows pointing up and down with a horizontal bar separating them."
                },
                {
                    "name": "se-resize",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that movement starts from south-east corner."
                },
                {
                    "name": "s-resize",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that south edge is to be moved."
                },
                {
                    "name": "sw-resize",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that movement starts from south-west corner."
                },
                {
                    "name": "text",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-12-07",
                        "baseline_high_date": "2024-06-07"
                    },
                    "description": "Indicates text that may be selected. Often rendered as a vertical I-beam."
                },
                {
                    "name": "vertical-text",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA95",
                        "S3",
                        "C1",
                        "CA18",
                        "O10.6"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates vertical-text that may be selected. Often rendered as a horizontal I-beam."
                },
                {
                    "name": "wait",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that the program is busy and the user should wait. Often rendered as a watch or hourglass."
                },
                {
                    "name": "-webkit-grab",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Indicates that something can be grabbed."
                },
                {
                    "name": "-webkit-grabbing",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Indicates that something is being grabbed."
                },
                {
                    "name": "-webkit-zoom-in",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Indicates that something can be zoomed (magnified) in."
                },
                {
                    "name": "-webkit-zoom-out",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "SM13.4",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Indicates that something can be zoomed (magnified) out."
                },
                {
                    "name": "w-resize",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA95",
                        "S1.2",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that west edge is to be moved."
                },
                {
                    "name": "zoom-in",
                    "browsers": [
                        "E12",
                        "FF24",
                        "FFA95",
                        "S9",
                        "C37",
                        "CA37",
                        "O24"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that something can be zoomed (magnified) in."
                },
                {
                    "name": "zoom-out",
                    "browsers": [
                        "E12",
                        "FF24",
                        "FFA95",
                        "S9",
                        "C37",
                        "CA37",
                        "O24"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Indicates that something can be zoomed (magnified) out."
                }
            ],
            "syntax": "[ [ <url> [ <x> <y> ]? , ]* <cursor-predefined> ]",
            "relevance": 92,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/cursor"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2021-12-07",
                "baseline_high_date": "2024-06-07"
            },
            "description": "Allows control over cursor appearance in an element",
            "restrictions": [
                "url",
                "number",
                "enum"
            ]
        },
        {
            "name": "direction",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C2",
                "CA18",
                "IE5.5",
                "O9.2"
            ],
            "values": [
                {
                    "name": "ltr",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Left-to-right direction."
                },
                {
                    "name": "rtl",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Right-to-left direction."
                }
            ],
            "syntax": "ltr | rtl",
            "relevance": 72,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/direction"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the inline base direction or directionality of any bidi paragraph, embedding, isolate, or override established by the box. Note: for HTML content use the 'dir' attribute and 'bdo' element rather than this property.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "display",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "block",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The element generates a block-level box"
                },
                {
                    "name": "contents",
                    "browsers": [
                        "E79",
                        "FF37",
                        "FFA37",
                        "S11.1",
                        "SM11.3",
                        "C65",
                        "CA65",
                        "O52"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The element itself does not generate any boxes, but its children and pseudo-elements still generate boxes as normal."
                },
                {
                    "name": "flex",
                    "browsers": [
                        "E12",
                        "FF20",
                        "FFA20",
                        "S9",
                        "SM9",
                        "C29",
                        "CA29",
                        "IE11",
                        "O16"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-09-30",
                        "baseline_high_date": "2018-03-30"
                    },
                    "description": "The element generates a principal flex container box and establishes a flex formatting context."
                },
                {
                    "name": "flexbox",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
                },
                {
                    "name": "flow-root",
                    "browsers": [
                        "E79",
                        "FF53",
                        "FFA53",
                        "S13",
                        "SM13",
                        "C58",
                        "CA58",
                        "O45"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The element generates a block container box, and lays out its contents using flow layout."
                },
                {
                    "name": "grid",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "IE10",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "The element generates a principal grid container box, and establishes a grid formatting context."
                },
                {
                    "name": "inline",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The element generates an inline-level box."
                },
                {
                    "name": "inline-block",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "A block box, which itself is flowed as a single inline box, similar to a replaced element. The inside of an inline-block is formatted as a block box, and the box itself is formatted as an inline box."
                },
                {
                    "name": "inline-flex",
                    "browsers": [
                        "E12",
                        "FF20",
                        "FFA20",
                        "S9",
                        "SM9",
                        "C29",
                        "CA29",
                        "IE11",
                        "O16"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-09-30",
                        "baseline_high_date": "2018-03-30"
                    },
                    "description": "Inline-level flex container."
                },
                {
                    "name": "inline-flexbox",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Inline-level flex container. Standardized as 'inline-flex'"
                },
                {
                    "name": "inline-table",
                    "browsers": [
                        "E12",
                        "FF3",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Inline-level table wrapper box containing table box."
                },
                {
                    "name": "list-item",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE6",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "One or more block boxes and one marker box."
                },
                {
                    "name": "-moz-box",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
                },
                {
                    "name": "-moz-deck",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-moz-grid",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-moz-grid-group",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-moz-grid-line",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-moz-groupbox",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-moz-inline-box",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Inline-level flex container. Standardized as 'inline-flex'"
                },
                {
                    "name": "-moz-inline-grid",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-moz-inline-stack",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-moz-marker",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-moz-popup",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-moz-stack",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ]
                },
                {
                    "name": "-ms-flexbox",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
                },
                {
                    "name": "-ms-grid",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "The element generates a principal grid container box, and establishes a grid formatting context."
                },
                {
                    "name": "-ms-inline-flexbox",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Inline-level flex container. Standardized as 'inline-flex'"
                },
                {
                    "name": "-ms-inline-grid",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Inline-level grid container."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The element and its descendants generates no boxes."
                },
                {
                    "name": "ruby",
                    "browsers": [
                        "FF38",
                        "FFA38",
                        "C121",
                        "CA121",
                        "IE7",
                        "O107"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The element generates a principal ruby container box, and establishes a ruby formatting context."
                },
                {
                    "name": "ruby-base",
                    "browsers": [
                        "FF38",
                        "FFA38",
                        "IE7"
                    ],
                    "baseline": {
                        "status": "false"
                    }
                },
                {
                    "name": "ruby-base-container",
                    "browsers": [
                        "FF38",
                        "FFA38",
                        "IE7"
                    ],
                    "baseline": {
                        "status": "false"
                    }
                },
                {
                    "name": "ruby-text",
                    "browsers": [
                        "FF38",
                        "FFA38",
                        "C121",
                        "CA121",
                        "IE7",
                        "O107"
                    ],
                    "baseline": {
                        "status": "false"
                    }
                },
                {
                    "name": "ruby-text-container",
                    "browsers": [
                        "FF38",
                        "FFA38",
                        "IE7"
                    ],
                    "baseline": {
                        "status": "false"
                    }
                },
                {
                    "name": "run-in",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "The element generates a run-in box. Run-in elements act like inlines or blocks, depending on the surrounding elements."
                },
                {
                    "name": "table",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The element generates a principal table wrapper box containing an additionally-generated table box, and establishes a table formatting context."
                },
                {
                    "name": "table-caption",
                    "browsers": [
                        "E15",
                        "FF1",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    }
                },
                {
                    "name": "table-cell",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "table-column",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "table-column-group",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "table-footer-group",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "table-header-group",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "table-row",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "table-row-group",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "-webkit-box",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
                },
                {
                    "name": "-webkit-flex",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "The element lays out its contents using flow layout (block-and-inline layout)."
                },
                {
                    "name": "-webkit-inline-box",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Inline-level flex container. Standardized as 'inline-flex'"
                },
                {
                    "name": "-webkit-inline-flex",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Inline-level flex container."
                }
            ],
            "syntax": "[ <display-outside> || <display-inside> ] | <display-listitem> | <display-internal> | <display-box> | <display-legacy>",
            "relevance": 96,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/display"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "In combination with 'float' and 'position', determines the type of box or boxes that are generated for an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "empty-cells",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1.2",
                "SM1",
                "C1",
                "CA18",
                "IE8",
                "O4"
            ],
            "values": [
                {
                    "name": "hide",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O4"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No borders or backgrounds are drawn around/behind empty cells."
                },
                {
                    "name": "-moz-show-background",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O4"
                    ]
                },
                {
                    "name": "show",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O4"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Borders and backgrounds are drawn around/behind empty cells (like normal cells)."
                }
            ],
            "syntax": "show | hide",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/empty-cells"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "In the separated borders model, this property controls the rendering of borders and backgrounds around cells that have no visible content.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "enable-background",
            "values": [
                {
                    "name": "accumulate",
                    "description": "If the ancestor container element has a property of new, then all graphics elements within the current container are rendered both on the parent's background image and onto the target."
                },
                {
                    "name": "new",
                    "description": "Create a new background image canvas. All children of the current container element can access the background, and they will be rendered onto both the parent's background image canvas in addition to the target device."
                }
            ],
            "relevance": 50,
            "description": "Deprecated. Use 'isolation' property instead when support allows. Specifies how the accumulation of the background image is managed.",
            "restrictions": [
                "integer",
                "length",
                "percentage",
                "enum"
            ]
        },
        {
            "name": "fallback",
            "browsers": [
                "FF33"
            ],
            "atRule": "@counter-style",
            "syntax": "<counter-style-name>",
            "relevance": 50,
            "description": "@counter-style descriptor. Specifies a fallback counter style to be used when the current counter style can't create a representation for a given counter value.",
            "restrictions": [
                "identifier"
            ]
        },
        {
            "name": "fill",
            "browsers": [
                "E15",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "url()",
                    "description": "A URL reference to a paint server element, which is an element that defines a paint server: 'hatch', 'linearGradient', 'mesh', 'pattern', 'radialGradient' and 'solidcolor'."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E15",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "No paint is applied in this layer."
                }
            ],
            "syntax": "<paint>",
            "relevance": 81,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/fill"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Paints the interior of the given graphical element.",
            "restrictions": [
                "color",
                "enum",
                "url"
            ]
        },
        {
            "name": "fill-opacity",
            "browsers": [
                "E15",
                "FF1",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "syntax": "<'opacity'>",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/fill-opacity"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the opacity of the painting operation used to paint the interior the current object.",
            "restrictions": [
                "number(0-1)"
            ]
        },
        {
            "name": "fill-rule",
            "browsers": [
                "E15",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "evenodd",
                    "browsers": [
                        "E15",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."
                },
                {
                    "name": "nonzero",
                    "browsers": [
                        "E15",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."
                }
            ],
            "syntax": "nonzero | evenodd",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/fill-rule"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Indicates the algorithm (or winding rule) which is to be used to determine what parts of the canvas are included inside the shape.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "filter",
            "browsers": [
                "E12",
                "FF35",
                "FFA35",
                "S9.1",
                "SM9.3",
                "C53",
                "CA53",
                "O40"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF35",
                        "FFA35",
                        "S6",
                        "SM6",
                        "C18",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No filter effects are applied."
                },
                {
                    "name": "blur()",
                    "description": "Applies a Gaussian blur to the input image."
                },
                {
                    "name": "brightness()",
                    "description": "Applies a linear multiplier to input image, making it appear more or less bright."
                },
                {
                    "name": "contrast()",
                    "description": "Adjusts the contrast of the input."
                },
                {
                    "name": "drop-shadow()",
                    "description": "Applies a drop shadow effect to the input image."
                },
                {
                    "name": "grayscale()",
                    "description": "Converts the input image to grayscale."
                },
                {
                    "name": "hue-rotate()",
                    "description": "Applies a hue rotation on the input image. "
                },
                {
                    "name": "invert()",
                    "description": "Inverts the samples in the input image."
                },
                {
                    "name": "opacity()",
                    "description": "Applies transparency to the samples in the input image."
                },
                {
                    "name": "saturate()",
                    "description": "Saturates the input image."
                },
                {
                    "name": "sepia()",
                    "description": "Converts the input image to sepia."
                },
                {
                    "name": "url()",
                    "browsers": [
                        "E12",
                        "FF35",
                        "FFA35",
                        "S9.1",
                        "SM9.3",
                        "C53",
                        "CA53",
                        "O40"
                    ],
                    "description": "A filter reference to a <filter> element."
                }
            ],
            "syntax": "none | <filter-value-list>",
            "relevance": 74,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/filter"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2016-09-07",
                "baseline_high_date": "2019-03-07"
            },
            "description": "Processes an element's rendering before it is displayed in the document, by applying one or more filter effects.",
            "restrictions": [
                "enum",
                "url"
            ]
        },
        {
            "name": "flex",
            "browsers": [
                "E12",
                "FF22",
                "FFA22",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O12.1"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF22",
                        "FFA22",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Retrieves the value of the main size property as the used 'flex-basis'."
                },
                {
                    "name": "content",
                    "browsers": [
                        "E94",
                        "FF61",
                        "FFA61",
                        "S15",
                        "SM15",
                        "C94",
                        "CA94",
                        "O80"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-09-24",
                        "baseline_high_date": "2024-03-24"
                    },
                    "description": "Indicates automatic sizing, based on the flex item's content."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF22",
                        "FFA22",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Expands to '0 0 auto'."
                }
            ],
            "syntax": "none | [ <'flex-grow'> <'flex-shrink'>? || <'flex-basis'> ]",
            "relevance": 84,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/flex"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Specifies the components of a flexible length: the flex grow factor and flex shrink factor, and the flex basis.",
            "restrictions": [
                "length",
                "number",
                "percentage"
            ]
        },
        {
            "name": "flex-basis",
            "browsers": [
                "E12",
                "FF22",
                "FFA22",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O12.1"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF22",
                        "FFA22",
                        "S9",
                        "SM9",
                        "C22",
                        "CA25",
                        "IE11",
                        "O12.1"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-09-30",
                        "baseline_high_date": "2018-03-30"
                    },
                    "description": "Retrieves the value of the main size property as the used 'flex-basis'."
                },
                {
                    "name": "content",
                    "browsers": [
                        "E94",
                        "FF61",
                        "FFA61",
                        "S15.4",
                        "SM15.4",
                        "C94",
                        "CA94",
                        "O80"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "Indicates automatic sizing, based on the flex item's content."
                }
            ],
            "syntax": "content | <'width'>",
            "relevance": 71,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/flex-basis"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Sets the flex basis.",
            "restrictions": [
                "length",
                "number",
                "percentage"
            ]
        },
        {
            "name": "flex-direction",
            "browsers": [
                "E12",
                "FF22",
                "FFA22",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O12.1"
            ],
            "values": [
                {
                    "name": "column",
                    "browsers": [
                        "E12",
                        "FF22",
                        "FFA22",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The flex container's main axis has the same orientation as the block axis of the current writing mode."
                },
                {
                    "name": "column-reverse",
                    "browsers": [
                        "E12",
                        "FF81",
                        "FFA81",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-09-22",
                        "baseline_high_date": "2023-03-22"
                    },
                    "description": "Same as 'column', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "row",
                    "browsers": [
                        "E12",
                        "FF22",
                        "FFA22",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The flex container's main axis has the same orientation as the inline axis of the current writing mode."
                },
                {
                    "name": "row-reverse",
                    "browsers": [
                        "E12",
                        "FF81",
                        "FFA81",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-09-22",
                        "baseline_high_date": "2023-03-22"
                    },
                    "description": "Same as 'row', except the main-start and main-end directions are swapped."
                }
            ],
            "syntax": "row | row-reverse | column | column-reverse",
            "relevance": 87,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/flex-direction"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Specifies how flex items are placed in the flex container, by setting the direction of the flex container's main axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "flex-flow",
            "browsers": [
                "E12",
                "FF28",
                "FFA28",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O12.1"
            ],
            "values": [
                {
                    "name": "column",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The flex container's main axis has the same orientation as the block axis of the current writing mode."
                },
                {
                    "name": "column-reverse",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Same as 'column', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "nowrap",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The flex container is single-line."
                },
                {
                    "name": "row",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The flex container's main axis has the same orientation as the inline axis of the current writing mode."
                },
                {
                    "name": "row-reverse",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Same as 'row', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "wrap",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The flexbox is multi-line."
                },
                {
                    "name": "wrap-reverse",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
                }
            ],
            "syntax": "<'flex-direction'> || <'flex-wrap'>",
            "relevance": 65,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/flex-flow"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Specifies how flexbox items are placed in the flexbox.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "flex-grow",
            "browsers": [
                "E12",
                "FF20",
                "FFA20",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O12.1"
            ],
            "syntax": "<number>",
            "relevance": 79,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/flex-grow"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Sets the flex grow factor. Negative numbers are invalid.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "flex-shrink",
            "browsers": [
                "E12",
                "FF20",
                "FFA20",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE10",
                "O12.1"
            ],
            "syntax": "<number>",
            "relevance": 80,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/flex-shrink"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Sets the flex shrink factor. Negative numbers are invalid.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "flex-wrap",
            "browsers": [
                "E12",
                "FF28",
                "FFA28",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O16"
            ],
            "values": [
                {
                    "name": "nowrap",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The flex container is single-line."
                },
                {
                    "name": "wrap",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The flexbox is multi-line."
                },
                {
                    "name": "wrap-reverse",
                    "browsers": [
                        "E12",
                        "FF28",
                        "FFA28",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
                }
            ],
            "syntax": "nowrap | wrap | wrap-reverse",
            "relevance": 85,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/flex-wrap"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "float",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "inline-end",
                    "browsers": [
                        "E118",
                        "FF55",
                        "FFA55",
                        "S15",
                        "SM15",
                        "C118",
                        "CA118",
                        "O104"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2023-10-13"
                    },
                    "description": "A keyword indicating that the element must float on the end side of its containing block. That is the right side with ltr scripts, and the left side with rtl scripts."
                },
                {
                    "name": "inline-start",
                    "browsers": [
                        "E118",
                        "FF55",
                        "FFA55",
                        "S15",
                        "SM15",
                        "C118",
                        "CA118",
                        "O104"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2023-10-13"
                    },
                    "description": "A keyword indicating that the element must float on the start side of its containing block. That is the left side with ltr scripts, and the right side with rtl scripts."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The element generates a block box that is floated to the left. Content flows on the right side of the box, starting at the top (subject to the 'clear' property)."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The box is not floated."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Similar to 'left', except the box is floated to the right, and content flows on the left side of the box, starting at the top."
                }
            ],
            "syntax": "left | right | none | inline-start | inline-end",
            "relevance": 87,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/float"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies how a box should be floated. It may be set for any element, but only applies to elements that generate boxes that are not absolutely positioned.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "flood-color",
            "browsers": [
                "E12",
                "FF3",
                "FFA4",
                "S6",
                "SM6",
                "C5",
                "CA18",
                "IE11",
                "O15"
            ],
            "syntax": "<color>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/flood-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Indicates what color to use to flood the current filter primitive subregion.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "flood-opacity",
            "browsers": [
                "E12",
                "FF3",
                "FFA4",
                "S6",
                "SM6",
                "C5",
                "CA18",
                "IE11",
                "O15"
            ],
            "syntax": "<'opacity'>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/flood-opacity"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Indicates what opacity to use to flood the current filter primitive subregion.",
            "restrictions": [
                "number(0-1)",
                "percentage"
            ]
        },
        {
            "name": "font",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "100",
                    "description": "Thin"
                },
                {
                    "name": "200",
                    "description": "Extra Light (Ultra Light)"
                },
                {
                    "name": "300",
                    "description": "Light"
                },
                {
                    "name": "400",
                    "description": "Normal"
                },
                {
                    "name": "500",
                    "description": "Medium"
                },
                {
                    "name": "600",
                    "description": "Semi Bold (Demi Bold)"
                },
                {
                    "name": "700",
                    "description": "Bold"
                },
                {
                    "name": "800",
                    "description": "Extra Bold (Ultra Bold)"
                },
                {
                    "name": "900",
                    "description": "Black (Heavy)"
                },
                {
                    "name": "bold",
                    "description": "Same as 700"
                },
                {
                    "name": "bolder",
                    "description": "Specifies the weight of the face bolder than the inherited value."
                },
                {
                    "name": "caption",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The font used for captioned controls (e.g., buttons, drop-downs, etc.)."
                },
                {
                    "name": "icon",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The font used to label icons."
                },
                {
                    "name": "italic",
                    "description": "Selects a font that is labeled 'italic', or, if that is not available, one labeled 'oblique'."
                },
                {
                    "name": "large"
                },
                {
                    "name": "larger"
                },
                {
                    "name": "lighter",
                    "description": "Specifies the weight of the face lighter than the inherited value."
                },
                {
                    "name": "medium"
                },
                {
                    "name": "menu",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The font used in menus (e.g., dropdown menus and menu lists)."
                },
                {
                    "name": "message-box",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The font used in dialog boxes."
                },
                {
                    "name": "normal",
                    "description": "Specifies a face that is not labeled as a small-caps font."
                },
                {
                    "name": "oblique",
                    "description": "Selects a font that is labeled 'oblique'."
                },
                {
                    "name": "small"
                },
                {
                    "name": "small-caps",
                    "description": "Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."
                },
                {
                    "name": "small-caption",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The font used for labeling small controls."
                },
                {
                    "name": "smaller"
                },
                {
                    "name": "status-bar",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The font used in window status bars."
                },
                {
                    "name": "x-large"
                },
                {
                    "name": "x-small"
                },
                {
                    "name": "xx-large"
                },
                {
                    "name": "xx-small"
                }
            ],
            "syntax": "[ [ <'font-style'> || <font-variant-css2> || <'font-weight'> || <font-width-css3> ]? <'font-size'> [ / <'line-height'> ]? <'font-family'># ] | <system-family-name>",
            "relevance": 82,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property for setting 'font-style', 'font-variant', 'font-weight', 'font-size', 'line-height', and 'font-family', at the same place in the style sheet. The syntax of this property is based on a traditional typographical shorthand notation to set multiple properties related to fonts.",
            "restrictions": [
                "font"
            ]
        },
        {
            "name": "font-family",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif"
                },
                {
                    "name": "Arial, Helvetica, sans-serif"
                },
                {
                    "name": "Cambria, Cochin, Georgia, Times, 'Times New Roman', serif"
                },
                {
                    "name": "'Courier New', Courier, monospace"
                },
                {
                    "name": "cursive",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "fantasy",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif"
                },
                {
                    "name": "Georgia, 'Times New Roman', Times, serif"
                },
                {
                    "name": "'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif"
                },
                {
                    "name": "Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif"
                },
                {
                    "name": "'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif"
                },
                {
                    "name": "monospace",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "sans-serif",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"
                },
                {
                    "name": "serif",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "'Times New Roman', Times, serif"
                },
                {
                    "name": "'Trebuchet MS', 'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Arial, sans-serif"
                },
                {
                    "name": "Verdana, Geneva, Tahoma, sans-serif"
                }
            ],
            "atRule": "@font-palette-values",
            "syntax": "<family-name>#",
            "relevance": 94,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-family"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies a prioritized list of font family names or generic family names. A user agent iterates through the list of family names until it matches an available font that contains a glyph for the character to be rendered.",
            "restrictions": [
                "font"
            ]
        },
        {
            "name": "font-feature-settings",
            "browsers": [
                "E15",
                "FF34",
                "FFA34",
                "S9.1",
                "SM9.3",
                "C48",
                "CA48",
                "IE10",
                "O35"
            ],
            "values": [
                {
                    "name": "\"aalt\"",
                    "description": "Access All Alternates."
                },
                {
                    "name": "\"abvf\"",
                    "description": "Above-base Forms. Required in Khmer script."
                },
                {
                    "name": "\"abvm\"",
                    "description": "Above-base Mark Positioning. Required in Indic scripts."
                },
                {
                    "name": "\"abvs\"",
                    "description": "Above-base Substitutions. Required in Indic scripts."
                },
                {
                    "name": "\"afrc\"",
                    "description": "Alternative Fractions."
                },
                {
                    "name": "\"akhn\"",
                    "description": "Akhand. Required in most Indic scripts."
                },
                {
                    "name": "\"blwf\"",
                    "description": "Below-base Form. Required in a number of Indic scripts."
                },
                {
                    "name": "\"blwm\"",
                    "description": "Below-base Mark Positioning. Required in Indic scripts."
                },
                {
                    "name": "\"blws\"",
                    "description": "Below-base Substitutions. Required in Indic scripts."
                },
                {
                    "name": "\"calt\"",
                    "description": "Contextual Alternates."
                },
                {
                    "name": "\"case\"",
                    "description": "Case-Sensitive Forms. Applies only to European scripts; particularly prominent in Spanish-language setting."
                },
                {
                    "name": "\"ccmp\"",
                    "description": "Glyph Composition/Decomposition."
                },
                {
                    "name": "\"cfar\"",
                    "description": "Conjunct Form After Ro. Required in Khmer scripts."
                },
                {
                    "name": "\"cjct\"",
                    "description": "Conjunct Forms. Required in Indic scripts that show similarity to Devanagari."
                },
                {
                    "name": "\"clig\"",
                    "description": "Contextual Ligatures."
                },
                {
                    "name": "\"cpct\"",
                    "description": "Centered CJK Punctuation. Used primarily in Chinese fonts."
                },
                {
                    "name": "\"cpsp\"",
                    "description": "Capital Spacing. Should not be used in connecting scripts (e.g. most Arabic)."
                },
                {
                    "name": "\"cswh\"",
                    "description": "Contextual Swash."
                },
                {
                    "name": "\"curs\"",
                    "description": "Cursive Positioning. Can be used in any cursive script."
                },
                {
                    "name": "\"c2pc\"",
                    "description": "Petite Capitals From Capitals. Applies only to bicameral scripts."
                },
                {
                    "name": "\"c2sc\"",
                    "description": "Small Capitals From Capitals. Applies only to bicameral scripts."
                },
                {
                    "name": "\"dist\"",
                    "description": "Distances. Required in Indic scripts."
                },
                {
                    "name": "\"dlig\"",
                    "description": "Discretionary ligatures."
                },
                {
                    "name": "\"dnom\"",
                    "description": "Denominators."
                },
                {
                    "name": "\"dtls\"",
                    "description": "Dotless Forms. Applied to math formula layout."
                },
                {
                    "name": "\"expt\"",
                    "description": "Expert Forms. Applies only to Japanese."
                },
                {
                    "name": "\"falt\"",
                    "description": "Final Glyph on Line Alternates. Can be used in any cursive script."
                },
                {
                    "name": "\"fin2\"",
                    "description": "Terminal Form #2. Used only with the Syriac script."
                },
                {
                    "name": "\"fin3\"",
                    "description": "Terminal Form #3. Used only with the Syriac script."
                },
                {
                    "name": "\"fina\"",
                    "description": "Terminal Forms. Can be used in any alphabetic script."
                },
                {
                    "name": "\"flac\"",
                    "description": "Flattened ascent forms. Applied to math formula layout."
                },
                {
                    "name": "\"frac\"",
                    "description": "Fractions."
                },
                {
                    "name": "\"fwid\"",
                    "description": "Full Widths. Applies to any script which can use monospaced forms."
                },
                {
                    "name": "\"half\"",
                    "description": "Half Forms. Required in Indic scripts that show similarity to Devanagari."
                },
                {
                    "name": "\"haln\"",
                    "description": "Halant Forms. Required in Indic scripts."
                },
                {
                    "name": "\"halt\"",
                    "description": "Alternate Half Widths. Used only in CJKV fonts."
                },
                {
                    "name": "\"hist\"",
                    "description": "Historical Forms."
                },
                {
                    "name": "\"hkna\"",
                    "description": "Horizontal Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."
                },
                {
                    "name": "\"hlig\"",
                    "description": "Historical Ligatures."
                },
                {
                    "name": "\"hngl\"",
                    "description": "Hangul. Korean only."
                },
                {
                    "name": "\"hojo\"",
                    "description": "Hojo Kanji Forms (JIS X 0212-1990 Kanji Forms). Used only with Kanji script."
                },
                {
                    "name": "\"hwid\"",
                    "description": "Half Widths. Generally used only in CJKV fonts."
                },
                {
                    "name": "\"init\"",
                    "description": "Initial Forms. Can be used in any alphabetic script."
                },
                {
                    "name": "\"isol\"",
                    "description": "Isolated Forms. Can be used in any cursive script."
                },
                {
                    "name": "\"ital\"",
                    "description": "Italics. Applies mostly to Latin; note that many non-Latin fonts contain Latin as well."
                },
                {
                    "name": "\"jalt\"",
                    "description": "Justification Alternates. Can be used in any cursive script."
                },
                {
                    "name": "\"jp78\"",
                    "description": "JIS78 Forms. Applies only to Japanese."
                },
                {
                    "name": "\"jp83\"",
                    "description": "JIS83 Forms. Applies only to Japanese."
                },
                {
                    "name": "\"jp90\"",
                    "description": "JIS90 Forms. Applies only to Japanese."
                },
                {
                    "name": "\"jp04\"",
                    "description": "JIS2004 Forms. Applies only to Japanese."
                },
                {
                    "name": "\"kern\"",
                    "description": "Kerning."
                },
                {
                    "name": "\"lfbd\"",
                    "description": "Left Bounds."
                },
                {
                    "name": "\"liga\"",
                    "description": "Standard Ligatures."
                },
                {
                    "name": "\"ljmo\"",
                    "description": "Leading Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."
                },
                {
                    "name": "\"lnum\"",
                    "description": "Lining Figures."
                },
                {
                    "name": "\"locl\"",
                    "description": "Localized Forms."
                },
                {
                    "name": "\"ltra\"",
                    "description": "Left-to-right glyph alternates."
                },
                {
                    "name": "\"ltrm\"",
                    "description": "Left-to-right mirrored forms."
                },
                {
                    "name": "\"mark\"",
                    "description": "Mark Positioning."
                },
                {
                    "name": "\"med2\"",
                    "description": "Medial Form #2. Used only with the Syriac script."
                },
                {
                    "name": "\"medi\"",
                    "description": "Medial Forms."
                },
                {
                    "name": "\"mgrk\"",
                    "description": "Mathematical Greek."
                },
                {
                    "name": "\"mkmk\"",
                    "description": "Mark to Mark Positioning."
                },
                {
                    "name": "\"nalt\"",
                    "description": "Alternate Annotation Forms."
                },
                {
                    "name": "\"nlck\"",
                    "description": "NLC Kanji Forms. Used only with Kanji script."
                },
                {
                    "name": "\"nukt\"",
                    "description": "Nukta Forms. Required in Indic scripts.."
                },
                {
                    "name": "\"numr\"",
                    "description": "Numerators."
                },
                {
                    "name": "\"onum\"",
                    "description": "Oldstyle Figures."
                },
                {
                    "name": "\"opbd\"",
                    "description": "Optical Bounds."
                },
                {
                    "name": "\"ordn\"",
                    "description": "Ordinals. Applies mostly to Latin script."
                },
                {
                    "name": "\"ornm\"",
                    "description": "Ornaments."
                },
                {
                    "name": "\"palt\"",
                    "description": "Proportional Alternate Widths. Used mostly in CJKV fonts."
                },
                {
                    "name": "\"pcap\"",
                    "description": "Petite Capitals."
                },
                {
                    "name": "\"pkna\"",
                    "description": "Proportional Kana. Generally used only in Japanese fonts."
                },
                {
                    "name": "\"pnum\"",
                    "description": "Proportional Figures."
                },
                {
                    "name": "\"pref\"",
                    "description": "Pre-base Forms. Required in Khmer and Myanmar (Burmese) scripts and southern Indic scripts that may display a pre-base form of Ra."
                },
                {
                    "name": "\"pres\"",
                    "description": "Pre-base Substitutions. Required in Indic scripts."
                },
                {
                    "name": "\"pstf\"",
                    "description": "Post-base Forms. Required in scripts of south and southeast Asia that have post-base forms for consonants eg: Gurmukhi, Malayalam, Khmer."
                },
                {
                    "name": "\"psts\"",
                    "description": "Post-base Substitutions."
                },
                {
                    "name": "\"pwid\"",
                    "description": "Proportional Widths."
                },
                {
                    "name": "\"qwid\"",
                    "description": "Quarter Widths. Generally used only in CJKV fonts."
                },
                {
                    "name": "\"rand\"",
                    "description": "Randomize."
                },
                {
                    "name": "\"rclt\"",
                    "description": "Required Contextual Alternates. May apply to any script, but is especially important for many styles of Arabic."
                },
                {
                    "name": "\"rlig\"",
                    "description": "Required Ligatures. Applies to Arabic and Syriac. May apply to some other scripts."
                },
                {
                    "name": "\"rkrf\"",
                    "description": "Rakar Forms. Required in Devanagari and Gujarati scripts."
                },
                {
                    "name": "\"rphf\"",
                    "description": "Reph Form. Required in Indic scripts. E.g. Devanagari, Kannada."
                },
                {
                    "name": "\"rtbd\"",
                    "description": "Right Bounds."
                },
                {
                    "name": "\"rtla\"",
                    "description": "Right-to-left alternates."
                },
                {
                    "name": "\"rtlm\"",
                    "description": "Right-to-left mirrored forms."
                },
                {
                    "name": "\"ruby\"",
                    "description": "Ruby Notation Forms. Applies only to Japanese."
                },
                {
                    "name": "\"salt\"",
                    "description": "Stylistic Alternates."
                },
                {
                    "name": "\"sinf\"",
                    "description": "Scientific Inferiors."
                },
                {
                    "name": "\"size\"",
                    "description": "Optical size."
                },
                {
                    "name": "\"smcp\"",
                    "description": "Small Capitals. Applies only to bicameral scripts."
                },
                {
                    "name": "\"smpl\"",
                    "description": "Simplified Forms. Applies only to Chinese and Japanese."
                },
                {
                    "name": "\"ssty\"",
                    "description": "Math script style alternates."
                },
                {
                    "name": "\"stch\"",
                    "description": "Stretching Glyph Decomposition."
                },
                {
                    "name": "\"subs\"",
                    "description": "Subscript."
                },
                {
                    "name": "\"sups\"",
                    "description": "Superscript."
                },
                {
                    "name": "\"swsh\"",
                    "description": "Swash. Does not apply to ideographic scripts."
                },
                {
                    "name": "\"titl\"",
                    "description": "Titling."
                },
                {
                    "name": "\"tjmo\"",
                    "description": "Trailing Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."
                },
                {
                    "name": "\"tnam\"",
                    "description": "Traditional Name Forms. Applies only to Japanese."
                },
                {
                    "name": "\"tnum\"",
                    "description": "Tabular Figures."
                },
                {
                    "name": "\"trad\"",
                    "description": "Traditional Forms. Applies only to Chinese and Japanese."
                },
                {
                    "name": "\"twid\"",
                    "description": "Third Widths. Generally used only in CJKV fonts."
                },
                {
                    "name": "\"unic\"",
                    "description": "Unicase."
                },
                {
                    "name": "\"valt\"",
                    "description": "Alternate Vertical Metrics. Applies only to scripts with vertical writing modes."
                },
                {
                    "name": "\"vatu\"",
                    "description": "Vattu Variants. Used for Indic scripts. E.g. Devanagari."
                },
                {
                    "name": "\"vert\"",
                    "description": "Vertical Alternates. Applies only to scripts with vertical writing modes."
                },
                {
                    "name": "\"vhal\"",
                    "description": "Alternate Vertical Half Metrics. Used only in CJKV fonts."
                },
                {
                    "name": "\"vjmo\"",
                    "description": "Vowel Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."
                },
                {
                    "name": "\"vkna\"",
                    "description": "Vertical Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."
                },
                {
                    "name": "\"vkrn\"",
                    "description": "Vertical Kerning."
                },
                {
                    "name": "\"vpal\"",
                    "description": "Proportional Alternate Vertical Metrics. Used mostly in CJKV fonts."
                },
                {
                    "name": "\"vrt2\"",
                    "description": "Vertical Alternates and Rotation. Applies only to scripts with vertical writing modes."
                },
                {
                    "name": "\"zero\"",
                    "description": "Slashed Zero."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E15",
                        "FF15",
                        "FFA15",
                        "S9.1",
                        "SM9.3",
                        "C16",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "No change in glyph substitution or positioning occurs."
                },
                {
                    "name": "off",
                    "description": "Disable feature."
                },
                {
                    "name": "on",
                    "description": "Enable feature."
                }
            ],
            "atRule": "@font-face",
            "syntax": "normal | <feature-tag-value>#",
            "relevance": 59,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-feature-settings"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",
            "restrictions": [
                "string",
                "integer"
            ]
        },
        {
            "name": "font-kerning",
            "browsers": [
                "E79",
                "FF32",
                "FFA32",
                "S9",
                "SM9",
                "C33",
                "CA33",
                "O20"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S9",
                        "SM9",
                        "C33",
                        "CA33",
                        "O20"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Specifies that kerning is applied at the discretion of the user agent."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S9",
                        "SM9",
                        "C33",
                        "CA33",
                        "O20"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Specifies that kerning is not applied."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S9",
                        "SM9",
                        "C33",
                        "CA33",
                        "O20"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Specifies that kerning is applied."
                }
            ],
            "syntax": "auto | normal | none",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-kerning"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Kerning is the contextual adjustment of inter-glyph spacing. This property controls metric kerning, kerning that utilizes adjustment data contained in the font.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-language-override",
            "browsers": [
                "E143",
                "FF34",
                "FFA34",
                "C143",
                "CA143"
            ],
            "values": [
                {
                    "name": "normal",
                    "browsers": [
                        "E143",
                        "FF4",
                        "FFA4",
                        "C143",
                        "CA143"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering."
                }
            ],
            "syntax": "normal | <string>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-language-override"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "The value of 'normal' implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "font-size",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5.5",
                "O7"
            ],
            "values": [
                {
                    "name": "large"
                },
                {
                    "name": "larger"
                },
                {
                    "name": "medium"
                },
                {
                    "name": "small"
                },
                {
                    "name": "smaller"
                },
                {
                    "name": "x-large"
                },
                {
                    "name": "x-small"
                },
                {
                    "name": "xx-large"
                },
                {
                    "name": "xx-small"
                }
            ],
            "syntax": "<absolute-size> | <relative-size> | <length-percentage [0,∞]> | math",
            "relevance": 94,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-size"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Indicates the desired height of glyphs from the font. For scalable fonts, the font-size is a scale factor applied to the EM unit of the font. (Note that certain glyphs may bleed outside their EM box.) For non-scalable fonts, the font-size is converted into absolute units and matched against the declared font-size of the font, using the same absolute coordinate space for both of the matched values.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "font-size-adjust",
            "browsers": [
                "E127",
                "FF3",
                "FFA4",
                "S16.4",
                "SM16.4",
                "C127",
                "CA127",
                "O113"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E127",
                        "FF3",
                        "FFA4",
                        "S16.4",
                        "SM16.4",
                        "C127",
                        "CA127",
                        "O113"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2024-07-25"
                    },
                    "description": "Do not preserve the font's x-height."
                }
            ],
            "syntax": "none | [ ex-height | cap-height | ch-width | ic-width | ic-height ]? [ from-font | <number> ]",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-size-adjust"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2024-07-25"
            },
            "description": "Preserves the readability of text when font fallback occurs by adjusting the font-size so that the x-height is the same regardless of the font used.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "font-stretch",
            "browsers": [
                "E12",
                "FF9",
                "FFA9",
                "S11",
                "SM11",
                "C60",
                "CA60",
                "IE9",
                "O47"
            ],
            "values": [
                {
                    "name": "condensed",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "O47"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-09-19",
                        "baseline_high_date": "2020-03-19"
                    }
                },
                {
                    "name": "expanded",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "O47"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-09-19",
                        "baseline_high_date": "2020-03-19"
                    }
                },
                {
                    "name": "extra-condensed",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "O47"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-09-19",
                        "baseline_high_date": "2020-03-19"
                    }
                },
                {
                    "name": "extra-expanded",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "O47"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-09-19",
                        "baseline_high_date": "2020-03-19"
                    }
                },
                {
                    "name": "narrower",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "IE9",
                        "O47"
                    ],
                    "description": "Indicates a narrower value relative to the width of the parent element."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "O47"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-09-19",
                        "baseline_high_date": "2020-03-19"
                    }
                },
                {
                    "name": "semi-condensed",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "O47"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-09-19",
                        "baseline_high_date": "2020-03-19"
                    }
                },
                {
                    "name": "semi-expanded",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "O47"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-09-19",
                        "baseline_high_date": "2020-03-19"
                    }
                },
                {
                    "name": "ultra-condensed",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "O47"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-09-19",
                        "baseline_high_date": "2020-03-19"
                    }
                },
                {
                    "name": "ultra-expanded",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "O47"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-09-19",
                        "baseline_high_date": "2020-03-19"
                    }
                },
                {
                    "name": "wider",
                    "browsers": [
                        "E12",
                        "FF9",
                        "FFA9",
                        "S11",
                        "SM11",
                        "C60",
                        "CA60",
                        "IE9",
                        "O47"
                    ],
                    "description": "Indicates a wider value relative to the width of the parent element."
                }
            ],
            "atRule": "@font-face",
            "status": "obsolete",
            "syntax": "<font-stretch-absolute>{1,2}",
            "relevance": 13,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-stretch"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-09-19",
                "baseline_high_date": "2020-03-19"
            },
            "description": "Selects a normal, condensed, or expanded face from a font family.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-style",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "italic",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Selects a font that is labeled as an 'italic' face, or an 'oblique' face if one is not"
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Selects a face that is classified as 'normal'."
                },
                {
                    "name": "oblique",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Selects a font that is labeled as an 'oblique' face, or an 'italic' face if one is not."
                }
            ],
            "atRule": "@font-face",
            "syntax": "normal | italic | oblique <angle>{0,2}",
            "relevance": 89,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Allows italic or oblique faces to be selected. Italic forms are generally cursive in nature while oblique faces are typically sloped versions of the regular face.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-synthesis",
            "browsers": [
                "E97",
                "FF34",
                "FFA34",
                "S9",
                "SM9",
                "C97",
                "CA97",
                "O83"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E97",
                        "FF34",
                        "FFA34",
                        "S9",
                        "SM9",
                        "C97",
                        "CA97",
                        "O83"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-01-06",
                        "baseline_high_date": "2024-07-06"
                    },
                    "description": "Disallow all synthetic faces."
                },
                {
                    "name": "style",
                    "browsers": [
                        "E97",
                        "FF34",
                        "FFA34",
                        "S10.1",
                        "SM10.3",
                        "C97",
                        "CA97",
                        "O83"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-01-06",
                        "baseline_high_date": "2024-07-06"
                    },
                    "description": "Allow synthetic italic faces."
                },
                {
                    "name": "weight",
                    "browsers": [
                        "E97",
                        "FF34",
                        "FFA34",
                        "S10.1",
                        "SM10.3",
                        "C97",
                        "CA97",
                        "O83"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-01-06",
                        "baseline_high_date": "2024-07-06"
                    },
                    "description": "Allow synthetic bold faces."
                }
            ],
            "syntax": "none | [ weight || style || small-caps || position]",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-synthesis"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2022-01-06",
                "baseline_high_date": "2024-07-06"
            },
            "description": "Controls whether user agents are allowed to synthesize bold or oblique font faces when a font family lacks bold or italic faces.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Specifies a face that is not labeled as a small-caps font."
                },
                {
                    "name": "small-caps",
                    "description": "Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."
                }
            ],
            "syntax": "normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> || stylistic( <feature-value-name> ) || historical-forms || styleset( <feature-value-name># ) || character-variant( <feature-value-name># ) || swash( <feature-value-name> ) || ornaments( <feature-value-name> ) || annotation( <feature-value-name> ) || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero || <east-asian-variant-values> || <east-asian-width-values> || ruby ]",
            "relevance": 64,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-variant"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies variant representations of the font",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-alternates",
            "browsers": [
                "E111",
                "FF34",
                "FFA34",
                "S9.1",
                "SM9.3",
                "C111",
                "CA111",
                "O97"
            ],
            "values": [
                {
                    "name": "annotation()",
                    "description": "Enables display of alternate annotation forms."
                },
                {
                    "name": "character-variant()",
                    "description": "Enables display of specific character variants."
                },
                {
                    "name": "historical-forms",
                    "browsers": [
                        "E111",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C111",
                        "CA111",
                        "O97"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2023-03-13",
                        "baseline_high_date": "2025-09-13"
                    },
                    "description": "Enables display of historical forms."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E111",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C111",
                        "CA111",
                        "O97"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2023-03-13",
                        "baseline_high_date": "2025-09-13"
                    },
                    "description": "None of the features are enabled."
                },
                {
                    "name": "ornaments()",
                    "description": "Enables replacement of default glyphs with ornaments, if provided in the font."
                },
                {
                    "name": "styleset()",
                    "description": "Enables display with stylistic sets."
                },
                {
                    "name": "stylistic()",
                    "description": "Enables display of stylistic alternates."
                },
                {
                    "name": "swash()",
                    "description": "Enables display of swash glyphs."
                }
            ],
            "syntax": "normal | [ stylistic( <feature-value-name> ) || historical-forms || styleset( <feature-value-name># ) || character-variant( <feature-value-name># ) || swash( <feature-value-name> ) || ornaments( <feature-value-name> ) || annotation( <feature-value-name> ) ]",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-variant-alternates"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2023-03-13",
                "baseline_high_date": "2025-09-13"
            },
            "description": "For any given character, fonts can provide a variety of alternate glyphs in addition to the default glyph for that character. This property provides control over the selection of these alternate glyphs.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-caps",
            "browsers": [
                "E79",
                "FF34",
                "FFA34",
                "S9.1",
                "SM9.3",
                "C52",
                "CA52",
                "O39"
            ],
            "values": [
                {
                    "name": "all-petite-caps",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of petite capitals for both upper and lowercase letters."
                },
                {
                    "name": "all-small-caps",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of small capitals for both upper and lowercase letters."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "None of the features are enabled."
                },
                {
                    "name": "petite-caps",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of petite capitals."
                },
                {
                    "name": "small-caps",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of small capitals. Small-caps glyphs typically use the form of uppercase letters but are reduced to the size of lowercase letters."
                },
                {
                    "name": "titling-caps",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of titling capitals."
                },
                {
                    "name": "unicase",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of mixture of small capitals for uppercase letters with normal lowercase letters."
                }
            ],
            "syntax": "normal | small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-variant-caps"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies control over capitalized forms.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-east-asian",
            "browsers": [
                "E79",
                "FF34",
                "FFA34",
                "S9.1",
                "SM9.3",
                "C63",
                "CA63",
                "O50"
            ],
            "values": [
                {
                    "name": "full-width",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables rendering of full-width variants."
                },
                {
                    "name": "jis04",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables rendering of JIS04 forms."
                },
                {
                    "name": "jis78",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables rendering of JIS78 forms."
                },
                {
                    "name": "jis83",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables rendering of JIS83 forms."
                },
                {
                    "name": "jis90",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables rendering of JIS90 forms."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "None of the features are enabled."
                },
                {
                    "name": "proportional-width",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables rendering of proportionally-spaced variants."
                },
                {
                    "name": "ruby",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of ruby variant glyphs."
                },
                {
                    "name": "simplified",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables rendering of simplified forms."
                },
                {
                    "name": "traditional",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C63",
                        "CA63",
                        "O50"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables rendering of traditional forms."
                }
            ],
            "syntax": "normal | [ <east-asian-variant-values> || <east-asian-width-values> || ruby ]",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-variant-east-asian"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Allows control of glyph substitute and positioning in East Asian text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-ligatures",
            "browsers": [
                "E79",
                "FF34",
                "FFA34",
                "S9.1",
                "SM9.3",
                "C34",
                "CA34",
                "O21"
            ],
            "values": [
                {
                    "name": "additional-ligatures",
                    "description": "Enables display of additional ligatures."
                },
                {
                    "name": "common-ligatures",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of common ligatures."
                },
                {
                    "name": "contextual",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of contextual alternates."
                },
                {
                    "name": "discretionary-ligatures",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of discretionary ligatures."
                },
                {
                    "name": "historical-ligatures",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of historical ligatures."
                },
                {
                    "name": "no-additional-ligatures",
                    "description": "Disables display of additional ligatures."
                },
                {
                    "name": "no-common-ligatures",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Disables display of common ligatures."
                },
                {
                    "name": "no-contextual",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Disables display of contextual alternates."
                },
                {
                    "name": "no-discretionary-ligatures",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Disables display of discretionary ligatures."
                },
                {
                    "name": "no-historical-ligatures",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Disables display of historical ligatures."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Disables all ligatures."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Implies that the defaults set by the font are used."
                }
            ],
            "syntax": "normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> ]",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-variant-ligatures"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies control over which ligatures are enabled or disabled. A value of 'normal' implies that the defaults set by the font are used.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-numeric",
            "browsers": [
                "E79",
                "FF34",
                "FFA34",
                "S9.1",
                "SM9.3",
                "C52",
                "CA52",
                "O39"
            ],
            "values": [
                {
                    "name": "diagonal-fractions",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of lining diagonal fractions."
                },
                {
                    "name": "lining-nums",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of lining numerals."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "None of the features are enabled."
                },
                {
                    "name": "oldstyle-nums",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of old-style numerals."
                },
                {
                    "name": "ordinal",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of letter forms used with ordinal numbers."
                },
                {
                    "name": "proportional-nums",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of proportional numerals."
                },
                {
                    "name": "slashed-zero",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of slashed zeros."
                },
                {
                    "name": "stacked-fractions",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of lining stacked fractions."
                },
                {
                    "name": "tabular-nums",
                    "browsers": [
                        "E79",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C52",
                        "CA52",
                        "O39"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Enables display of tabular numerals."
                }
            ],
            "syntax": "normal | [ <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero ]",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-variant-numeric"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies control over numerical forms.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-variant-position",
            "browsers": [
                "E117",
                "FF34",
                "FFA34",
                "S9.1",
                "SM9.3",
                "C117",
                "CA117",
                "O103"
            ],
            "values": [
                {
                    "name": "normal",
                    "browsers": [
                        "E117",
                        "FF34",
                        "FFA34",
                        "S9.1",
                        "SM9.3",
                        "C117",
                        "CA117",
                        "O103"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2023-09-15"
                    },
                    "description": "None of the features are enabled."
                },
                {
                    "name": "sub",
                    "browsers": [
                        "FF34",
                        "FFA34",
                        "O103"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Enables display of subscript variants (OpenType feature: subs)."
                },
                {
                    "name": "super",
                    "browsers": [
                        "FF34",
                        "FFA34",
                        "O103"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Enables display of superscript variants (OpenType feature: sups)."
                }
            ],
            "syntax": "normal | sub | super",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-variant-position"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2023-09-15"
            },
            "description": "Specifies the vertical position",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "font-weight",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C2",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "100",
                    "description": "Thin"
                },
                {
                    "name": "200",
                    "description": "Extra Light (Ultra Light)"
                },
                {
                    "name": "300",
                    "description": "Light"
                },
                {
                    "name": "400",
                    "description": "Normal"
                },
                {
                    "name": "500",
                    "description": "Medium"
                },
                {
                    "name": "600",
                    "description": "Semi Bold (Demi Bold)"
                },
                {
                    "name": "700",
                    "description": "Bold"
                },
                {
                    "name": "800",
                    "description": "Extra Bold (Ultra Bold)"
                },
                {
                    "name": "900",
                    "description": "Black (Heavy)"
                },
                {
                    "name": "bold",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Same as 700"
                },
                {
                    "name": "bolder",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Specifies the weight of the face bolder than the inherited value."
                },
                {
                    "name": "lighter",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Specifies the weight of the face lighter than the inherited value."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Same as 400"
                }
            ],
            "atRule": "@font-face",
            "syntax": "<font-weight-absolute>{1,2}",
            "relevance": 93,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/font-weight"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies weight of glyphs in the font, their degree of blackness or stroke thickness.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "glyph-orientation-horizontal",
            "relevance": 50,
            "description": "Controls glyph orientation when the inline-progression-direction is horizontal.",
            "restrictions": [
                "angle",
                "number"
            ]
        },
        {
            "name": "glyph-orientation-vertical",
            "browsers": [
                "S4",
                "SM3.2"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Sets the orientation based on the fullwidth or non-fullwidth characters and the most common orientation."
                }
            ],
            "relevance": 50,
            "baseline": {
                "status": "false"
            },
            "description": "Controls glyph orientation when the inline-progression-direction is vertical.",
            "restrictions": [
                "angle",
                "number",
                "enum"
            ]
        },
        {
            "name": "grid-area",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line> [ / <grid-line> ]{0,3}",
            "relevance": 61,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-area"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement. Shorthand for 'grid-row-start', 'grid-column-start', 'grid-row-end', and 'grid-column-end'.",
            "restrictions": [
                "identifier",
                "integer"
            ]
        },
        {
            "name": "grid",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "syntax": "<'grid-template'> | <'grid-template-rows'> / [ auto-flow && dense? ] <'grid-auto-columns'>? | [ auto-flow && dense? ] <'grid-auto-rows'>? / <'grid-template-columns'>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "The grid CSS property is a shorthand property that sets all of the explicit grid properties ('grid-template-rows', 'grid-template-columns', and 'grid-template-areas'), and all the implicit grid properties ('grid-auto-rows', 'grid-auto-columns', and 'grid-auto-flow'), in a single declaration.",
            "restrictions": [
                "identifier",
                "length",
                "percentage",
                "string",
                "enum"
            ]
        },
        {
            "name": "grid-auto-columns",
            "browsers": [
                "E16",
                "FF70",
                "FFA79",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "IE10",
                "O44"
            ],
            "values": [
                {
                    "name": "min-content",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S11",
                        "SM11",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S11",
                        "SM11",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                }
            ],
            "syntax": "<track-size>+",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-auto-columns"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-07-28",
                "baseline_high_date": "2023-01-28"
            },
            "description": "Specifies the size of implicitly created columns.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "grid-auto-flow",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "row",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The auto-placement algorithm places items by filling each row in turn, adding new rows as necessary."
                },
                {
                    "name": "column",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The auto-placement algorithm places items by filling each column in turn, adding new columns as necessary."
                },
                {
                    "name": "dense",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "If specified, the auto-placement algorithm uses a \"dense\" packing algorithm, which attempts to fill in holes earlier in the grid if smaller items come up later."
                }
            ],
            "syntax": "[ row | column ] || dense",
            "relevance": 57,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-auto-flow"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Controls how the auto-placement algorithm works, specifying exactly how auto-placed items get flowed into the grid.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "grid-auto-rows",
            "browsers": [
                "E16",
                "FF70",
                "FFA79",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "IE10",
                "O44"
            ],
            "values": [
                {
                    "name": "min-content",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S11",
                        "SM11",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S11",
                        "SM11",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                }
            ],
            "syntax": "<track-size>+",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-auto-rows"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-07-28",
                "baseline_high_date": "2023-01-28"
            },
            "description": "Specifies the size of implicitly created rows.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "grid-column",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line> [ / <grid-line> ]?",
            "relevance": 62,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-column"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Shorthand for 'grid-column-start' and 'grid-column-end'.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "grid-column-end",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line>",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-column-end"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "grid-column-gap",
            "browsers": [
                "FF52",
                "C57",
                "S10.1",
                "O44"
            ],
            "status": "obsolete",
            "syntax": "<length-percentage>",
            "relevance": 0,
            "description": "Specifies the gutters between grid columns. Replaced by 'column-gap' property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "grid-column-start",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line>",
            "relevance": 53,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-column-start"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "grid-gap",
            "browsers": [
                "FF52",
                "C57",
                "S10.1",
                "O44"
            ],
            "status": "obsolete",
            "syntax": "<'grid-row-gap'> <'grid-column-gap'>?",
            "relevance": 0,
            "description": "Shorthand that specifies the gutters between grid columns and grid rows in one declaration. Replaced by 'gap' property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "grid-row",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line> [ / <grid-line> ]?",
            "relevance": 57,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-row"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Shorthand for 'grid-row-start' and 'grid-row-end'.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "grid-row-end",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line>",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-row-end"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "grid-row-gap",
            "browsers": [
                "FF52",
                "C57",
                "S10.1",
                "O44"
            ],
            "status": "obsolete",
            "syntax": "<length-percentage>",
            "relevance": 0,
            "description": "Specifies the gutters between grid rows. Replaced by 'row-gap' property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "grid-row-start",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E16",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-10-17",
                        "baseline_high_date": "2020-04-17"
                    },
                    "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
                },
                {
                    "name": "span",
                    "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
                }
            ],
            "syntax": "<grid-line>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-row-start"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
            "restrictions": [
                "identifier",
                "integer",
                "enum"
            ]
        },
        {
            "name": "grid-template",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Sets all three properties to their initial values."
                },
                {
                    "name": "min-content",
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "subgrid",
                    "description": "Sets 'grid-template-rows' and 'grid-template-columns' to 'subgrid', and 'grid-template-areas' to its initial value."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                },
                {
                    "name": "repeat()",
                    "description": "Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."
                }
            ],
            "syntax": "none | [ <'grid-template-rows'> / <'grid-template-columns'> ] | [ <line-names>? <string> <track-size>? <line-names>? ]+ [ / <explicit-track-list> ]?",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-template"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Shorthand for setting grid-template-columns, grid-template-rows, and grid-template-areas in a single declaration.",
            "restrictions": [
                "identifier",
                "length",
                "percentage",
                "string",
                "enum"
            ]
        },
        {
            "name": "grid-template-areas",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The grid container doesn't define any named grid areas."
                }
            ],
            "syntax": "none | <string>+",
            "relevance": 58,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-template-areas"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "Specifies named grid areas, which are not associated with any particular grid item, but can be referenced from the grid-placement properties.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "grid-template-columns",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "IE10",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "There is no explicit grid; any rows/columns will be implicitly generated."
                },
                {
                    "name": "min-content",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "subgrid",
                    "browsers": [
                        "E117",
                        "FF71",
                        "FFA79",
                        "S16",
                        "SM16",
                        "C117",
                        "CA117",
                        "O103"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2023-09-15"
                    },
                    "description": "Indicates that the grid will align to its parent grid in that axis."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                },
                {
                    "name": "repeat()",
                    "description": "Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."
                }
            ],
            "syntax": "none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",
            "relevance": 72,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-template-columns"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "specifies, as a space-separated track list, the line names and track sizing functions of the grid.",
            "restrictions": [
                "identifier",
                "length",
                "percentage",
                "enum"
            ]
        },
        {
            "name": "grid-template-rows",
            "browsers": [
                "E16",
                "FF52",
                "FFA52",
                "S10.1",
                "SM10.3",
                "C57",
                "CA57",
                "IE10",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "There is no explicit grid; any rows/columns will be implicitly generated."
                },
                {
                    "name": "min-content",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "max-content",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF52",
                        "FFA52",
                        "S10.1",
                        "SM10.3",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
                },
                {
                    "name": "subgrid",
                    "browsers": [
                        "E117",
                        "FF71",
                        "FFA79",
                        "S16",
                        "SM16",
                        "C117",
                        "CA117",
                        "O103"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2023-09-15"
                    },
                    "description": "Indicates that the grid will align to its parent grid in that axis."
                },
                {
                    "name": "minmax()",
                    "description": "Defines a size range greater than or equal to min and less than or equal to max."
                },
                {
                    "name": "repeat()",
                    "description": "Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."
                }
            ],
            "syntax": "none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",
            "relevance": 63,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/grid-template-rows"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-10-17",
                "baseline_high_date": "2020-04-17"
            },
            "description": "specifies, as a space-separated track list, the line names and track sizing functions of the grid.",
            "restrictions": [
                "identifier",
                "length",
                "percentage",
                "string",
                "enum"
            ]
        },
        {
            "name": "height",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The height depends on the values of other properties."
                },
                {
                    "name": "fit-content",
                    "browsers": [
                        "E79",
                        "FF94",
                        "FFA94",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O33"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-11-02",
                        "baseline_high_date": "2024-05-02"
                    },
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "auto | <length-percentage [0,∞]> | min-content | max-content | fit-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()>",
            "relevance": 96,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/height"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the height of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "hyphens",
            "browsers": [
                "E79",
                "FF43",
                "FFA43",
                "S17",
                "SM17",
                "C55",
                "CA55",
                "IE10",
                "O42"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E88",
                        "FF6",
                        "FFA6",
                        "S5.1",
                        "SM4.2",
                        "C88",
                        "CA55",
                        "O74"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-01-21",
                        "baseline_high_date": "2023-07-21"
                    },
                    "description": "Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."
                },
                {
                    "name": "manual",
                    "browsers": [
                        "E88",
                        "FF6",
                        "FFA6",
                        "S5.1",
                        "SM4.2",
                        "C88",
                        "CA55",
                        "O74"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-01-21",
                        "baseline_high_date": "2023-07-21"
                    },
                    "description": "Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"
                },
                {
                    "name": "none",
                    "browsers": [
                        "E88",
                        "FF6",
                        "FFA6",
                        "S5.1",
                        "SM4.2",
                        "C88",
                        "CA55",
                        "O74"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-01-21",
                        "baseline_high_date": "2023-07-21"
                    },
                    "description": "Words are not broken at line breaks, even if characters inside the word suggest line break points."
                }
            ],
            "syntax": "none | manual | auto",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/hyphens"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2023-09-18"
            },
            "description": "Controls whether hyphenation is allowed to create more break opportunities within a line of text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "image-orientation",
            "browsers": [
                "E81",
                "FF26",
                "FFA26",
                "S13.1",
                "SM13.4",
                "C81",
                "CA81",
                "O67"
            ],
            "values": [
                {
                    "name": "flip",
                    "description": "After rotating by the precededing angle, the image is flipped horizontally. Defaults to 0deg if the angle is ommitted."
                },
                {
                    "name": "from-image",
                    "browsers": [
                        "E81",
                        "FF26",
                        "FFA26",
                        "S13.1",
                        "SM13.4",
                        "C81",
                        "CA81",
                        "O68"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-04-13",
                        "baseline_high_date": "2022-10-13"
                    },
                    "description": "If the image has an orientation specified in its metadata, such as EXIF, this value computes to the angle that the metadata specifies is necessary to correctly orient the image."
                }
            ],
            "syntax": "from-image | <angle> | [ <angle>? flip ]",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/image-orientation"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-04-13",
                "baseline_high_date": "2022-10-13"
            },
            "description": "Specifies an orthogonal rotation to be applied to an image before it is laid out.",
            "restrictions": [
                "angle"
            ]
        },
        {
            "name": "image-rendering",
            "browsers": [
                "E79",
                "FF3.6",
                "FFA4",
                "S6",
                "SM6",
                "C13",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF3.6",
                        "FFA4",
                        "S6",
                        "SM6",
                        "C13",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The image should be scaled with an algorithm that maximizes the appearance of the image."
                },
                {
                    "name": "crisp-edges",
                    "browsers": [
                        "FF65",
                        "FFA65",
                        "S7",
                        "SM7",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The image must be scaled with an algorithm that preserves contrast and edges in the image, and which does not smooth colors or introduce blur to the image in the process."
                },
                {
                    "name": "-moz-crisp-edges",
                    "browsers": [
                        "E79",
                        "FF3.6",
                        "FFA4",
                        "S6",
                        "SM6",
                        "C13",
                        "CA18",
                        "O15"
                    ]
                },
                {
                    "name": "optimizeQuality",
                    "browsers": [
                        "FF3.6",
                        "FFA4",
                        "S7",
                        "SM7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Deprecated."
                },
                {
                    "name": "optimizeSpeed",
                    "browsers": [
                        "FF3.6",
                        "FFA4",
                        "S7",
                        "SM7"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Deprecated."
                },
                {
                    "name": "pixelated",
                    "browsers": [
                        "E79",
                        "FF93",
                        "FFA93",
                        "S10",
                        "SM10",
                        "C41",
                        "CA41",
                        "O26"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-10-05",
                        "baseline_high_date": "2024-04-05"
                    },
                    "description": "When scaling the image up, the 'nearest neighbor' or similar algorithm must be used, so that the image appears to be simply composed of very large pixels."
                }
            ],
            "syntax": "auto | crisp-edges | pixelated | smooth",
            "relevance": 53,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/image-rendering"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Provides a hint to the user-agent about what aspects of an image are most important to preserve when the image is scaled, to aid the user-agent in the choice of an appropriate scaling algorithm.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "ime-mode",
            "browsers": [
                "FF3",
                "FFA4",
                "IE5"
            ],
            "values": [
                {
                    "name": "active",
                    "description": "The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."
                },
                {
                    "name": "auto",
                    "description": "No change is made to the current input method editor state. This is the default."
                },
                {
                    "name": "disabled",
                    "description": "The input method editor is disabled and may not be activated by the user."
                },
                {
                    "name": "inactive",
                    "description": "The input method editor is initially inactive, but the user may activate it if they wish."
                },
                {
                    "name": "normal",
                    "description": "The IME state should be normal; this value can be used in a user style sheet to override the page setting."
                }
            ],
            "status": "obsolete",
            "syntax": "auto | normal | active | inactive | disabled",
            "relevance": 0,
            "baseline": {
                "status": "false"
            },
            "description": "Controls the state of the input method editor for text fields.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "inline-size",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S5.1",
                        "SM5",
                        "C8",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Depends on the values of other properties."
                }
            ],
            "syntax": "<'width'>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/inline-size"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Size of an element in the direction specified by 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "isolation",
            "browsers": [
                "E79",
                "FF36",
                "FFA36",
                "S8",
                "SM8",
                "C41",
                "CA41",
                "O28"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF36",
                        "FFA36",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Elements are not isolated unless an operation is applied that causes the creation of a stacking context."
                },
                {
                    "name": "isolate",
                    "browsers": [
                        "E79",
                        "FF36",
                        "FFA36",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "In CSS will turn the element into a stacking context."
                }
            ],
            "syntax": "auto | isolate",
            "relevance": 57,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/isolation"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "In CSS setting to 'isolate' will turn the element into a stacking context. In SVG, it defines whether an element is isolated or not.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "justify-content",
            "browsers": [
                "E12",
                "FF20",
                "FFA20",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O12.1"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Flex items are packed toward the center of the line."
                },
                {
                    "name": "start",
                    "description": "The items are packed flush to each other toward the start edge of the alignment container in the main axis."
                },
                {
                    "name": "end",
                    "description": "The items are packed flush to each other toward the end edge of the alignment container in the main axis."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E79",
                        "FF20",
                        "FFA20",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The items are packed flush to each other toward the left edge of the alignment container in the main axis."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E79",
                        "FF20",
                        "FFA20",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The items are packed flush to each other toward the right edge of the alignment container in the main axis."
                },
                {
                    "name": "safe",
                    "description": "If the size of the item overflows the alignment container, the item is instead aligned as if the alignment mode were start."
                },
                {
                    "name": "unsafe",
                    "description": "Regardless of the relative sizes of the item and alignment container, the given alignment value is honored."
                },
                {
                    "name": "stretch",
                    "description": "If the combined size of the alignment subjects is less than the size of the alignment container, any auto-sized alignment subjects have their size increased equally (not proportionally), while still respecting the constraints imposed by max-height/max-width (or equivalent functionality), so that the combined size exactly fills the alignment container."
                },
                {
                    "name": "space-evenly",
                    "description": "The items are evenly distributed within the alignment container along the main axis."
                },
                {
                    "name": "flex-end",
                    "description": "Flex items are packed toward the end of the line."
                },
                {
                    "name": "flex-start",
                    "description": "Flex items are packed toward the start of the line."
                },
                {
                    "name": "space-around",
                    "description": "Flex items are evenly distributed in the line, with half-size spaces on either end."
                },
                {
                    "name": "space-between",
                    "description": "Flex items are evenly distributed in the line."
                },
                {
                    "name": "baseline",
                    "description": "Specifies participation in first-baseline alignment."
                },
                {
                    "name": "first baseline",
                    "description": "Specifies participation in first-baseline alignment."
                },
                {
                    "name": "last baseline",
                    "description": "Specifies participation in last-baseline alignment."
                }
            ],
            "syntax": "normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ]",
            "relevance": 90,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/justify-content"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Aligns flex items along the main axis of the current line of the flex container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "kerning",
            "values": [
                {
                    "name": "auto",
                    "description": "Indicates that the user agent should adjust inter-glyph spacing based on kerning tables that are included in the font that will be used."
                }
            ],
            "relevance": 50,
            "description": "Indicates whether the user agent should adjust inter-glyph spacing based on kerning tables that are included in the relevant font or instead disable auto-kerning and set inter-character spacing to a specific length.",
            "restrictions": [
                "length",
                "enum"
            ]
        },
        {
            "name": "left",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5.5",
                "O5"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
                }
            ],
            "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
            "relevance": 94,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/left"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies how far an absolutely positioned box's left margin edge is offset to the right of the left edge of the box's 'containing block'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "letter-spacing",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The spacing is the normal spacing for the current font. It is typically zero-length."
                }
            ],
            "syntax": "normal | <length>",
            "relevance": 83,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/letter-spacing"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the minimum, maximum, and optimal spacing between grapheme clusters.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "lighting-color",
            "browsers": [
                "E12",
                "FF3",
                "FFA4",
                "S6",
                "SM6",
                "C5",
                "CA18",
                "IE11",
                "O15"
            ],
            "syntax": "<color>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/lighting-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Defines the color of the light source for filter primitives 'feDiffuseLighting' and 'feSpecularLighting'.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "line-break",
            "browsers": [
                "E14",
                "FF69",
                "FFA79",
                "S11",
                "SM11",
                "C58",
                "CA58",
                "IE5.5",
                "O45"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S7",
                        "SM7",
                        "C25",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-07-28",
                        "baseline_high_date": "2023-01-28"
                    },
                    "description": "The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."
                },
                {
                    "name": "loose",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S8",
                        "SM8",
                        "C25",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-07-28",
                        "baseline_high_date": "2023-01-28"
                    },
                    "description": "Breaks text using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S2",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-07-28",
                        "baseline_high_date": "2023-01-28"
                    },
                    "description": "Breaks text using the most common set of line-breaking rules."
                },
                {
                    "name": "strict",
                    "browsers": [
                        "E79",
                        "FF69",
                        "FFA79",
                        "S8",
                        "SM8",
                        "C25",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-07-28",
                        "baseline_high_date": "2023-01-28"
                    },
                    "description": "Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."
                },
                {
                    "name": "anywhere",
                    "browsers": [
                        "E83",
                        "FF69",
                        "FFA79",
                        "S13",
                        "SM13",
                        "C83",
                        "CA83",
                        "O69"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-07-28",
                        "baseline_high_date": "2023-01-28"
                    },
                    "description": "There is a soft wrap opportunity around every typographic character unit, including around any punctuation character or preserved white spaces, or in the middle of words, disregarding any prohibition against line breaks, even those introduced by characters with the GL, WJ, or ZWJ line breaking classes or mandated by the word-break property."
                }
            ],
            "syntax": "auto | loose | normal | strict | anywhere",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/line-break"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-07-28",
                "baseline_high_date": "2023-01-28"
            },
            "description": "Specifies what set of line breaking restrictions are in effect within the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "line-height",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Tells user agents to set the computed value to a 'reasonable' value based on the font size of the element."
                }
            ],
            "syntax": "normal | <number> | <length> | <percentage>",
            "relevance": 93,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/line-height"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Determines the block-progression dimension of the text content area of an inline box.",
            "restrictions": [
                "number",
                "length",
                "percentage"
            ]
        },
        {
            "name": "list-style",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "armenian"
                },
                {
                    "name": "circle",
                    "description": "A hollow circle."
                },
                {
                    "name": "decimal"
                },
                {
                    "name": "decimal-leading-zero"
                },
                {
                    "name": "disc",
                    "description": "A filled circle."
                },
                {
                    "name": "georgian"
                },
                {
                    "name": "inside",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."
                },
                {
                    "name": "lower-alpha"
                },
                {
                    "name": "lower-greek"
                },
                {
                    "name": "lower-latin"
                },
                {
                    "name": "lower-roman"
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "outside",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."
                },
                {
                    "name": "square",
                    "description": "A filled square."
                },
                {
                    "name": "symbols()",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Allows a counter style to be defined inline."
                },
                {
                    "name": "upper-alpha"
                },
                {
                    "name": "upper-latin"
                },
                {
                    "name": "upper-roman"
                },
                {
                    "name": "url()"
                }
            ],
            "syntax": "<'list-style-type'> || <'list-style-position'> || <'list-style-image'>",
            "relevance": 83,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/list-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand for setting 'list-style-type', 'list-style-position' and 'list-style-image'",
            "restrictions": [
                "image",
                "enum",
                "url"
            ]
        },
        {
            "name": "list-style-image",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The default contents of the of the list item's marker are given by 'list-style-type' instead."
                }
            ],
            "syntax": "<image> | none",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/list-style-image"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Sets the image that will be used as the list item marker. When the image is available, it will replace the marker set with the 'list-style-type' marker.",
            "restrictions": [
                "image"
            ]
        },
        {
            "name": "list-style-position",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [
                {
                    "name": "inside",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."
                },
                {
                    "name": "outside",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."
                }
            ],
            "syntax": "inside | outside",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/list-style-position"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the position of the '::marker' pseudo-element's box in the list item.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "list-style-type",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [
                {
                    "name": "armenian",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Traditional uppercase Armenian numbering."
                },
                {
                    "name": "circle",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O3.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "A hollow circle."
                },
                {
                    "name": "decimal",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O3.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Western decimal numbers."
                },
                {
                    "name": "decimal-leading-zero",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O8"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Decimal numbers padded by initial zeros."
                },
                {
                    "name": "disc",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O3.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "A filled circle."
                },
                {
                    "name": "georgian",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Traditional Georgian numbering."
                },
                {
                    "name": "lower-alpha",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Lowercase ASCII letters."
                },
                {
                    "name": "lower-greek",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Lowercase classical Greek."
                },
                {
                    "name": "lower-latin",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Lowercase ASCII letters."
                },
                {
                    "name": "lower-roman",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Lowercase ASCII Roman numerals."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No marker"
                },
                {
                    "name": "square",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O3.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "A filled square."
                },
                {
                    "name": "symbols()",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O3.5"
                    ],
                    "description": "Allows a counter style to be defined inline."
                },
                {
                    "name": "upper-alpha",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Uppercase ASCII letters."
                },
                {
                    "name": "upper-latin",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Uppercase ASCII letters."
                },
                {
                    "name": "upper-roman",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O6"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Uppercase ASCII Roman numerals."
                }
            ],
            "syntax": "<counter-style> | <string> | none",
            "relevance": 73,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/list-style-type"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Used to construct the default contents of a list item's marker",
            "restrictions": [
                "enum",
                "string"
            ]
        },
        {
            "name": "margin",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE6",
                        "O3.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                }
            ],
            "syntax": "<'margin-top'>{1,4}",
            "relevance": 95,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/margin"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-block-end",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S12.1",
                        "SM12.2",
                        "C69",
                        "CA69",
                        "O56"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                }
            ],
            "syntax": "<'margin-top'>",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/margin-block-end"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'margin-bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-block-start",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S12.1",
                        "SM12.2",
                        "C69",
                        "CA69",
                        "O56"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                }
            ],
            "syntax": "<'margin-top'>",
            "relevance": 58,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/margin-block-start"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'margin-top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-bottom",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE6",
                        "O3.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                }
            ],
            "syntax": "<length-percentage> | auto | <anchor-size()>",
            "relevance": 91,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/margin-bottom"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-inline-end",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S12.1",
                        "SM12.2",
                        "C69",
                        "CA69",
                        "O56"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                }
            ],
            "syntax": "<'margin-top'>",
            "relevance": 61,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/margin-inline-end"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'margin-right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-inline-start",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S12.1",
                        "SM12.2",
                        "C69",
                        "CA69",
                        "O56"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                }
            ],
            "syntax": "<'margin-top'>",
            "relevance": 62,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/margin-inline-start"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'margin-left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-left",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE6",
                        "O3.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                }
            ],
            "syntax": "<length-percentage> | auto | <anchor-size()>",
            "relevance": 91,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/margin-left"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-right",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE6",
                        "O3.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                }
            ],
            "syntax": "<length-percentage> | auto | <anchor-size()>",
            "relevance": 91,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/margin-right"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "margin-top",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE6",
                        "O3.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                }
            ],
            "syntax": "<length-percentage> | auto | <anchor-size()>",
            "relevance": 94,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/margin-top"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "marker",
            "browsers": [
                "E15",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E15",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
                },
                {
                    "name": "url()",
                    "description": "Indicates that the <marker> element referenced will be used."
                }
            ],
            "syntax": "none | <url>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/marker"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the marker symbol that shall be used for all points on the sets the value for all vertices on the given 'path' element or basic shape.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "marker-end",
            "browsers": [
                "E15",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E15",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
                },
                {
                    "name": "url()",
                    "description": "Indicates that the <marker> element referenced will be used."
                }
            ],
            "syntax": "none | <url>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/marker-end"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the marker that will be drawn at the last vertices of the given markable element.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "marker-mid",
            "browsers": [
                "E15",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E15",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
                },
                {
                    "name": "url()",
                    "description": "Indicates that the <marker> element referenced will be used."
                }
            ],
            "syntax": "none | <url>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/marker-mid"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the marker that will be drawn at all vertices except the first and last.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "marker-start",
            "browsers": [
                "E15",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E15",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
                },
                {
                    "name": "url()",
                    "description": "Indicates that the <marker> element referenced will be used."
                }
            ],
            "syntax": "none | <url>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/marker-start"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the marker that will be drawn at the first vertices of the given markable element.",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "mask-image",
            "browsers": [
                "E120",
                "FF53",
                "FFA53",
                "S15.4",
                "SM15.4",
                "C120",
                "CA120",
                "O15"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "Counts as a transparent black image layer."
                },
                {
                    "name": "url()",
                    "description": "Reference to a <mask element or to a CSS image."
                }
            ],
            "syntax": "<mask-reference>#",
            "relevance": 61,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/mask-image"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2023-12-07"
            },
            "description": "Sets the mask layer image of an element.",
            "restrictions": [
                "url",
                "image",
                "enum"
            ]
        },
        {
            "name": "mask-mode",
            "browsers": [
                "E120",
                "FF53",
                "FFA53",
                "S15.4",
                "SM15.4",
                "C120",
                "CA120",
                "O106"
            ],
            "values": [
                {
                    "name": "alpha",
                    "browsers": [
                        "E120",
                        "FF53",
                        "FFA53",
                        "S15.4",
                        "SM15.4",
                        "C120",
                        "CA120",
                        "O106"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2023-12-07"
                    },
                    "description": "Alpha values of the mask layer image should be used as the mask values."
                },
                {
                    "name": "auto",
                    "description": "Use alpha values if 'mask-image' is an image, luminance if a <mask> element or a CSS image."
                },
                {
                    "name": "luminance",
                    "browsers": [
                        "E120",
                        "FF53",
                        "FFA53",
                        "S15.4",
                        "SM15.4",
                        "C120",
                        "CA120",
                        "O106"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2023-12-07"
                    },
                    "description": "Luminance values of the mask layer image should be used as the mask values."
                }
            ],
            "syntax": "<masking-mode>#",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/mask-mode"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2023-12-07"
            },
            "description": "Indicates whether the mask layer image is treated as luminance mask or alpha mask.",
            "restrictions": [
                "url",
                "image",
                "enum"
            ]
        },
        {
            "name": "mask-origin",
            "browsers": [
                "E120",
                "FF53",
                "FFA53",
                "S15.4",
                "SM15.4",
                "C120",
                "CA120",
                "O106"
            ],
            "syntax": "<coord-box>#",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/mask-origin"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2023-12-07"
            },
            "description": "Specifies the mask positioning area.",
            "restrictions": [
                "geometry-box",
                "enum"
            ]
        },
        {
            "name": "mask-position",
            "browsers": [
                "E120",
                "FF53",
                "FFA53",
                "S15.4",
                "SM15.4",
                "C120",
                "CA120",
                "O106"
            ],
            "syntax": "<position>#",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/mask-position"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2023-12-07"
            },
            "description": "Specifies how mask layer images are positioned.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "mask-repeat",
            "browsers": [
                "E120",
                "FF53",
                "FFA53",
                "S15.4",
                "SM15.4",
                "C120",
                "CA120",
                "O106"
            ],
            "syntax": "<repeat-style>#",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/mask-repeat"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2023-12-07"
            },
            "description": "Specifies how mask layer images are tiled after they have been sized and positioned.",
            "restrictions": [
                "repeat"
            ]
        },
        {
            "name": "mask-size",
            "browsers": [
                "E120",
                "FF53",
                "FFA53",
                "S15.4",
                "SM15.4",
                "C120",
                "CA120",
                "O106"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Resolved by using the image's intrinsic ratio and the size of the other dimension, or failing that, using the image's intrinsic size, or failing that, treating it as 100%."
                },
                {
                    "name": "contain",
                    "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."
                },
                {
                    "name": "cover",
                    "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."
                }
            ],
            "syntax": "<bg-size>#",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/mask-size"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2023-12-07"
            },
            "description": "Specifies the size of the mask layer images.",
            "restrictions": [
                "length",
                "percentage",
                "enum"
            ]
        },
        {
            "name": "mask-type",
            "browsers": [
                "E79",
                "FF35",
                "FFA35",
                "S7",
                "SM7",
                "C24",
                "CA25",
                "O15"
            ],
            "values": [
                {
                    "name": "alpha",
                    "browsers": [
                        "E79",
                        "FF35",
                        "FFA35",
                        "S7",
                        "SM7",
                        "C24",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Indicates that the alpha values of the mask should be used."
                },
                {
                    "name": "luminance",
                    "browsers": [
                        "E79",
                        "FF35",
                        "FFA35",
                        "S7",
                        "SM7",
                        "C24",
                        "CA25",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Indicates that the luminance values of the mask should be used."
                }
            ],
            "syntax": "luminance | alpha",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/mask-type"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Defines whether the content of the <mask> element is treated as as luminance mask or alpha mask.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "max-block-size",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S12.1",
                        "SM12.2",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "No limit on the width of the box."
                }
            ],
            "syntax": "<'max-width'>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/max-block-size"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Maximum size of an element in the direction opposite that of the direction specified by 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "max-height",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1.3",
                "SM1",
                "C1",
                "CA18",
                "IE7",
                "O7"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.3",
                        "SM1",
                        "C18",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No limit on the height of the box."
                },
                {
                    "name": "fit-content",
                    "browsers": [
                        "E79",
                        "FF94",
                        "FFA94",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-11-02",
                        "baseline_high_date": "2024-05-02"
                    },
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "none | <length-percentage [0,∞]> | min-content | max-content | fit-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()>",
            "relevance": 86,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/max-height"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Allows authors to constrain content height to a certain range.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "max-inline-size",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S12.1",
                        "SM12.2",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "No limit on the height of the box."
                }
            ],
            "syntax": "<'max-width'>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/max-inline-size"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Maximum size of an element in the direction specified by 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "max-width",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE7",
                "O4"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No limit on the width of the box."
                },
                {
                    "name": "fit-content",
                    "browsers": [
                        "E79",
                        "FF94",
                        "FFA94",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-11-02",
                        "baseline_high_date": "2024-05-02"
                    },
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "none | <length-percentage [0,∞]> | min-content | max-content | fit-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()>",
            "relevance": 91,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/max-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Allows authors to constrain content width to a certain range.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "min-block-size",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C57",
                "CA57",
                "O44"
            ],
            "syntax": "<'min-width'>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/min-block-size"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Minimal size of an element in the direction opposite that of the direction specified by 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "min-height",
            "browsers": [
                "E12",
                "FF3",
                "FFA4",
                "S1.3",
                "SM1",
                "C1",
                "CA18",
                "IE7",
                "O4"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O12.1"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "fit-content",
                    "browsers": [
                        "E79",
                        "FF94",
                        "FFA94",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-11-02",
                        "baseline_high_date": "2024-05-02"
                    },
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "auto | <length-percentage [0,∞]> | min-content | max-content | fit-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()>",
            "relevance": 90,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/min-height"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Allows authors to constrain content height to a certain range.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "min-inline-size",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C57",
                "CA57",
                "O44"
            ],
            "syntax": "<'min-width'>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/min-inline-size"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Minimal size of an element in the direction specified by 'writing-mode'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "min-width",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE7",
                "O4"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF34",
                        "FFA34",
                        "S7",
                        "SM7",
                        "C21",
                        "CA25",
                        "O12.1"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "fit-content",
                    "browsers": [
                        "E79",
                        "FF94",
                        "FFA94",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O33"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-11-02",
                        "baseline_high_date": "2024-05-02"
                    },
                    "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "max-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O33"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
                },
                {
                    "name": "min-content",
                    "browsers": [
                        "E79",
                        "FF66",
                        "FFA66",
                        "S11",
                        "SM11",
                        "C46",
                        "CA46",
                        "O33"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
                }
            ],
            "syntax": "auto | <length-percentage [0,∞]> | min-content | max-content | fit-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()>",
            "relevance": 88,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/min-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Allows authors to constrain content width to a certain range.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "mix-blend-mode",
            "browsers": [
                "E79",
                "FF32",
                "FFA32",
                "S8",
                "SM8",
                "C41",
                "CA41",
                "O28"
            ],
            "values": [
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Default attribute which specifies no blending"
                },
                {
                    "name": "multiply",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The source color is multiplied by the destination color and replaces the destination."
                },
                {
                    "name": "screen",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Multiplies the complements of the backdrop and source color values, then complements the result."
                },
                {
                    "name": "overlay",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Multiplies or screens the colors, depending on the backdrop color value."
                },
                {
                    "name": "darken",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Selects the darker of the backdrop and source colors."
                },
                {
                    "name": "lighten",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Selects the lighter of the backdrop and source colors."
                },
                {
                    "name": "color-dodge",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Brightens the backdrop color to reflect the source color."
                },
                {
                    "name": "color-burn",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Darkens the backdrop color to reflect the source color."
                },
                {
                    "name": "hard-light",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Multiplies or screens the colors, depending on the source color value."
                },
                {
                    "name": "soft-light",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Darkens or lightens the colors, depending on the source color value."
                },
                {
                    "name": "difference",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Subtracts the darker of the two constituent colors from the lighter color.."
                },
                {
                    "name": "exclusion",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S8",
                        "SM8",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Produces an effect similar to that of the Difference mode but lower in contrast."
                },
                {
                    "name": "hue",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S10",
                        "SM10",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."
                },
                {
                    "name": "saturation",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S10",
                        "SM10",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."
                },
                {
                    "name": "color",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S10",
                        "SM10",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."
                },
                {
                    "name": "luminosity",
                    "browsers": [
                        "E79",
                        "FF32",
                        "FFA32",
                        "S10",
                        "SM10",
                        "C41",
                        "CA41",
                        "O28"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."
                }
            ],
            "syntax": "<blend-mode> | plus-darker | plus-lighter",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/mix-blend-mode"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Defines the formula that must be used to mix the colors with the backdrop.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "motion",
            "browsers": [
                "C46",
                "O33"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No motion path gets created."
                },
                {
                    "name": "path()",
                    "description": "Defines an SVG path as a string, with optional 'fill-rule' as the first argument."
                },
                {
                    "name": "auto",
                    "description": "Indicates that the object is rotated by the angle of the direction of the motion path."
                },
                {
                    "name": "reverse",
                    "description": "Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."
                }
            ],
            "relevance": 50,
            "description": "Shorthand property for setting 'motion-path', 'motion-offset' and 'motion-rotation'.",
            "restrictions": [
                "url",
                "length",
                "percentage",
                "angle",
                "shape",
                "geometry-box",
                "enum"
            ]
        },
        {
            "name": "motion-offset",
            "browsers": [
                "C46",
                "O33"
            ],
            "relevance": 50,
            "description": "A distance that describes the position along the specified motion path.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "motion-path",
            "browsers": [
                "C46",
                "O33"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No motion path gets created."
                },
                {
                    "name": "path()",
                    "description": "Defines an SVG path as a string, with optional 'fill-rule' as the first argument."
                }
            ],
            "relevance": 50,
            "description": "Specifies the motion path the element gets positioned at.",
            "restrictions": [
                "url",
                "shape",
                "geometry-box",
                "enum"
            ]
        },
        {
            "name": "motion-rotation",
            "browsers": [
                "C46",
                "O33"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Indicates that the object is rotated by the angle of the direction of the motion path."
                },
                {
                    "name": "reverse",
                    "description": "Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."
                }
            ],
            "relevance": 50,
            "description": "Defines the direction of the element while positioning along the motion path.",
            "restrictions": [
                "angle"
            ]
        },
        {
            "name": "-moz-animation",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "backwards",
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                },
                {
                    "name": "none",
                    "description": "No animation is performed"
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "relevance": 50,
            "description": "Shorthand property combines six of the animation properties into a single property.",
            "restrictions": [
                "time",
                "enum",
                "timing-function",
                "identifier",
                "number"
            ]
        },
        {
            "name": "-moz-animation-delay",
            "browsers": [
                "FF9"
            ],
            "relevance": 50,
            "description": "Defines when the animation will start.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-moz-animation-direction",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "relevance": 50,
            "description": "Defines whether or not the animation should play in reverse on alternate cycles.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-animation-duration",
            "browsers": [
                "FF9"
            ],
            "relevance": 50,
            "description": "Defines the length of time that an animation takes to complete one cycle.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-moz-animation-iteration-count",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                }
            ],
            "relevance": 50,
            "description": "Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",
            "restrictions": [
                "number",
                "enum"
            ]
        },
        {
            "name": "-moz-animation-name",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No animation is performed"
                }
            ],
            "relevance": 50,
            "description": "Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",
            "restrictions": [
                "identifier",
                "enum"
            ]
        },
        {
            "name": "-moz-animation-play-state",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "paused",
                    "description": "A running animation will be paused."
                },
                {
                    "name": "running",
                    "description": "Resume playback of a paused animation."
                }
            ],
            "relevance": 50,
            "description": "Defines whether the animation is running or paused.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-animation-timing-function",
            "browsers": [
                "FF9"
            ],
            "relevance": 50,
            "description": "Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "-moz-appearance",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "button"
                },
                {
                    "name": "button-arrow-down"
                },
                {
                    "name": "button-arrow-next"
                },
                {
                    "name": "button-arrow-previous"
                },
                {
                    "name": "button-arrow-up"
                },
                {
                    "name": "button-bevel"
                },
                {
                    "name": "checkbox"
                },
                {
                    "name": "checkbox-container"
                },
                {
                    "name": "checkbox-label"
                },
                {
                    "name": "dialog"
                },
                {
                    "name": "groupbox"
                },
                {
                    "name": "listbox"
                },
                {
                    "name": "menuarrow"
                },
                {
                    "name": "menuimage"
                },
                {
                    "name": "menuitem"
                },
                {
                    "name": "menuitemtext"
                },
                {
                    "name": "menulist"
                },
                {
                    "name": "menulist-button"
                },
                {
                    "name": "menulist-text"
                },
                {
                    "name": "menulist-textfield"
                },
                {
                    "name": "menupopup"
                },
                {
                    "name": "menuradio"
                },
                {
                    "name": "menuseparator"
                },
                {
                    "name": "-moz-mac-unified-toolbar"
                },
                {
                    "name": "-moz-win-borderless-glass"
                },
                {
                    "name": "-moz-win-browsertabbar-toolbox"
                },
                {
                    "name": "-moz-win-communications-toolbox"
                },
                {
                    "name": "-moz-win-glass"
                },
                {
                    "name": "-moz-win-media-toolbox"
                },
                {
                    "name": "none"
                },
                {
                    "name": "progressbar"
                },
                {
                    "name": "progresschunk"
                },
                {
                    "name": "radio"
                },
                {
                    "name": "radio-container"
                },
                {
                    "name": "radio-label"
                },
                {
                    "name": "radiomenuitem"
                },
                {
                    "name": "resizer"
                },
                {
                    "name": "resizerpanel"
                },
                {
                    "name": "scrollbarbutton-down"
                },
                {
                    "name": "scrollbarbutton-left"
                },
                {
                    "name": "scrollbarbutton-right"
                },
                {
                    "name": "scrollbarbutton-up"
                },
                {
                    "name": "scrollbar-small"
                },
                {
                    "name": "scrollbartrack-horizontal"
                },
                {
                    "name": "scrollbartrack-vertical"
                },
                {
                    "name": "separator"
                },
                {
                    "name": "spinner"
                },
                {
                    "name": "spinner-downbutton"
                },
                {
                    "name": "spinner-textfield"
                },
                {
                    "name": "spinner-upbutton"
                },
                {
                    "name": "statusbar"
                },
                {
                    "name": "statusbarpanel"
                },
                {
                    "name": "tab"
                },
                {
                    "name": "tabpanels"
                },
                {
                    "name": "tab-scroll-arrow-back"
                },
                {
                    "name": "tab-scroll-arrow-forward"
                },
                {
                    "name": "textfield"
                },
                {
                    "name": "textfield-multiline"
                },
                {
                    "name": "toolbar"
                },
                {
                    "name": "toolbox"
                },
                {
                    "name": "tooltip"
                },
                {
                    "name": "treeheadercell"
                },
                {
                    "name": "treeheadersortarrow"
                },
                {
                    "name": "treeitem"
                },
                {
                    "name": "treetwistyopen"
                },
                {
                    "name": "treeview"
                },
                {
                    "name": "treewisty"
                },
                {
                    "name": "window"
                }
            ],
            "status": "nonstandard",
            "syntax": "none | button | button-arrow-down | button-arrow-next | button-arrow-previous | button-arrow-up | button-bevel | button-focus | caret | checkbox | checkbox-container | checkbox-label | checkmenuitem | dualbutton | groupbox | listbox | listitem | menuarrow | menubar | menucheckbox | menuimage | menuitem | menuitemtext | menulist | menulist-button | menulist-text | menulist-textfield | menupopup | menuradio | menuseparator | meterbar | meterchunk | progressbar | progressbar-vertical | progresschunk | progresschunk-vertical | radio | radio-container | radio-label | radiomenuitem | range | range-thumb | resizer | resizerpanel | scale-horizontal | scalethumbend | scalethumb-horizontal | scalethumbstart | scalethumbtick | scalethumb-vertical | scale-vertical | scrollbarbutton-down | scrollbarbutton-left | scrollbarbutton-right | scrollbarbutton-up | scrollbarthumb-horizontal | scrollbarthumb-vertical | scrollbartrack-horizontal | scrollbartrack-vertical | searchfield | separator | sheet | spinner | spinner-downbutton | spinner-textfield | spinner-upbutton | splitter | statusbar | statusbarpanel | tab | tabpanel | tabpanels | tab-scroll-arrow-back | tab-scroll-arrow-forward | textfield | textfield-multiline | toolbar | toolbarbutton | toolbarbutton-dropdown | toolbargripper | toolbox | tooltip | treeheader | treeheadercell | treeheadersortarrow | treeitem | treeline | treetwisty | treetwistyopen | treeview | -moz-mac-unified-toolbar | -moz-win-borderless-glass | -moz-win-browsertabbar-toolbox | -moz-win-communicationstext | -moz-win-communications-toolbox | -moz-win-exclude-glass | -moz-win-glass | -moz-win-mediatext | -moz-win-media-toolbox | -moz-window-button-box | -moz-window-button-box-maximized | -moz-window-button-close | -moz-window-button-maximize | -moz-window-button-minimize | -moz-window-button-restore | -moz-window-frame-bottom | -moz-window-frame-left | -moz-window-frame-right | -moz-window-titlebar | -moz-window-titlebar-maximized",
            "relevance": 0,
            "description": "Used in Gecko (Firefox) to display an element using a platform-native styling based on the operating system's theme.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-backface-visibility",
            "browsers": [
                "FF10"
            ],
            "values": [
                {
                    "name": "hidden"
                },
                {
                    "name": "visible"
                }
            ],
            "relevance": 50,
            "description": "Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-background-clip",
            "browsers": [
                "FF1-3.6"
            ],
            "values": [
                {
                    "name": "padding"
                }
            ],
            "relevance": 50,
            "description": "Determines the background painting area.",
            "restrictions": [
                "box",
                "enum"
            ]
        },
        {
            "name": "-moz-background-inline-policy",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "bounding-box"
                },
                {
                    "name": "continuous"
                },
                {
                    "name": "each-box"
                }
            ],
            "relevance": 50,
            "description": "In Gecko-based applications like Firefox, the -moz-background-inline-policy CSS property specifies how the background image of an inline element is determined when the content of the inline element wraps onto multiple lines. The choice of position has significant effects on repetition.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-background-origin",
            "browsers": [
                "FF1"
            ],
            "relevance": 50,
            "description": "For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",
            "restrictions": [
                "box"
            ]
        },
        {
            "name": "-moz-border-bottom-colors",
            "browsers": [
                "FF1"
            ],
            "status": "nonstandard",
            "syntax": "<color>+ | none",
            "relevance": 0,
            "description": "Sets a list of colors for the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-border-image",
            "browsers": [
                "FF3.6"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
                },
                {
                    "name": "fill",
                    "description": "Causes the middle part of the border-image to be preserved."
                },
                {
                    "name": "none"
                },
                {
                    "name": "repeat",
                    "description": "The image is tiled (repeated) to fill the area."
                },
                {
                    "name": "round",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
                },
                {
                    "name": "space",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
                },
                {
                    "name": "stretch",
                    "description": "The image is stretched to fill the area."
                },
                {
                    "name": "url()"
                }
            ],
            "relevance": 50,
            "description": "Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "percentage",
                "number",
                "url",
                "enum"
            ]
        },
        {
            "name": "-moz-border-left-colors",
            "browsers": [
                "FF1"
            ],
            "status": "nonstandard",
            "syntax": "<color>+ | none",
            "relevance": 0,
            "description": "Sets a list of colors for the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-border-right-colors",
            "browsers": [
                "FF1"
            ],
            "status": "nonstandard",
            "syntax": "<color>+ | none",
            "relevance": 0,
            "description": "Sets a list of colors for the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-border-top-colors",
            "browsers": [
                "FF1"
            ],
            "status": "nonstandard",
            "syntax": "<color>+ | none",
            "relevance": 0,
            "description": "Ske Firefox, -moz-border-bottom-colors sets a list of colors for the bottom border.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-box-align",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "baseline",
                    "description": "If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used."
                },
                {
                    "name": "center",
                    "description": "Any extra space is divided evenly, with half placed above the child and the other half placed after the child."
                },
                {
                    "name": "end",
                    "description": "For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element."
                },
                {
                    "name": "start",
                    "description": "For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element."
                },
                {
                    "name": "stretch",
                    "description": "The height of each child is adjusted to that of the containing block."
                }
            ],
            "relevance": 50,
            "description": "Specifies how a XUL box aligns its contents across (perpendicular to) the direction of its layout. The effect of this is only visible if there is extra space in the box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-box-direction",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "normal",
                    "description": "A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom."
                },
                {
                    "name": "reverse",
                    "description": "A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top."
                }
            ],
            "relevance": 50,
            "description": "Specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge).",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-box-flex",
            "browsers": [
                "FF1"
            ],
            "relevance": 50,
            "description": "Specifies how a box grows to fill the box that contains it, in the direction of the containing box's layout.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "-moz-box-flexgroup",
            "browsers": [
                "FF1"
            ],
            "relevance": 50,
            "description": "Flexible elements can be assigned to flex groups using the 'box-flex-group' property.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-moz-box-ordinal-group",
            "browsers": [
                "FF1"
            ],
            "relevance": 50,
            "description": "Indicates the ordinal group the element belongs to. Elements with a lower ordinal group are displayed before those with a higher ordinal group.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-moz-box-orient",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "block-axis",
                    "description": "Elements are oriented along the box's axis."
                },
                {
                    "name": "horizontal",
                    "description": "The box displays its children from left to right in a horizontal line."
                },
                {
                    "name": "inline-axis",
                    "description": "Elements are oriented vertically."
                },
                {
                    "name": "vertical",
                    "description": "The box displays its children from stacked from top to bottom vertically."
                }
            ],
            "relevance": 50,
            "description": "In Mozilla applications, -moz-box-orient specifies whether a box lays out its contents horizontally or vertically.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-box-pack",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "The extra space is divided evenly, with half placed before the first child and the other half placed after the last child."
                },
                {
                    "name": "end",
                    "description": "For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child."
                },
                {
                    "name": "justify",
                    "description": "The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start."
                },
                {
                    "name": "start",
                    "description": "For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child."
                }
            ],
            "relevance": 50,
            "description": "Specifies how a box packs its contents in the direction of its layout. The effect of this is only visible if there is extra space in the box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-box-sizing",
            "browsers": [
                "FF1"
            ],
            "values": [
                {
                    "name": "border-box",
                    "description": "The specified width and height (and respective min/max properties) on this element determine the border box of the element."
                },
                {
                    "name": "content-box",
                    "description": "Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."
                },
                {
                    "name": "padding-box",
                    "description": "The specified width and height (and respective min/max properties) on this element determine the padding box of the element."
                }
            ],
            "relevance": 50,
            "description": "Box Model addition in CSS3.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-column-count",
            "browsers": [
                "FF3.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Determines the number of columns by the 'column-width' property and the element width."
                }
            ],
            "relevance": 50,
            "description": "Describes the optimal number of columns into which the content of the element will be flowed.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-moz-column-gap",
            "browsers": [
                "FF3.5"
            ],
            "values": [
                {
                    "name": "normal",
                    "description": "User agent specific and typically equivalent to 1em."
                }
            ],
            "relevance": 50,
            "description": "Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-moz-column-rule",
            "browsers": [
                "FF3.5"
            ],
            "relevance": 50,
            "description": "Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color"
            ]
        },
        {
            "name": "-moz-column-rule-color",
            "browsers": [
                "FF3.5"
            ],
            "relevance": 50,
            "description": "Sets the color of the column rule",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-column-rule-style",
            "browsers": [
                "FF3.5"
            ],
            "relevance": 50,
            "description": "Sets the style of the rule between columns of an element.",
            "restrictions": [
                "line-style"
            ]
        },
        {
            "name": "-moz-column-rule-width",
            "browsers": [
                "FF3.5"
            ],
            "relevance": 50,
            "description": "Sets the width of the rule between columns. Negative values are not allowed.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "-moz-columns",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The width depends on the values of other properties."
                }
            ],
            "relevance": 50,
            "description": "A shorthand property which sets both 'column-width' and 'column-count'.",
            "restrictions": [
                "length",
                "integer"
            ]
        },
        {
            "name": "-moz-column-width",
            "browsers": [
                "FF3.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The width depends on the values of other properties."
                }
            ],
            "relevance": 50,
            "description": "This property describes the width of columns in multicol elements.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-moz-font-feature-settings",
            "browsers": [
                "FF4"
            ],
            "values": [
                {
                    "name": "\"c2cs\""
                },
                {
                    "name": "\"dlig\""
                },
                {
                    "name": "\"kern\""
                },
                {
                    "name": "\"liga\""
                },
                {
                    "name": "\"lnum\""
                },
                {
                    "name": "\"onum\""
                },
                {
                    "name": "\"smcp\""
                },
                {
                    "name": "\"swsh\""
                },
                {
                    "name": "\"tnum\""
                },
                {
                    "name": "normal",
                    "description": "No change in glyph substitution or positioning occurs."
                },
                {
                    "name": "off",
                    "browsers": [
                        "FF4"
                    ]
                },
                {
                    "name": "on",
                    "browsers": [
                        "FF4"
                    ]
                }
            ],
            "relevance": 50,
            "description": "Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",
            "restrictions": [
                "string",
                "integer"
            ]
        },
        {
            "name": "-moz-hyphens",
            "browsers": [
                "FF9"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."
                },
                {
                    "name": "manual",
                    "description": "Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"
                },
                {
                    "name": "none",
                    "description": "Words are not broken at line breaks, even if characters inside the word suggest line break points."
                }
            ],
            "relevance": 50,
            "description": "Controls whether hyphenation is allowed to create more break opportunities within a line of text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-perspective",
            "browsers": [
                "FF10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No perspective transform is applied."
                }
            ],
            "relevance": 50,
            "description": "Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-moz-perspective-origin",
            "browsers": [
                "FF10"
            ],
            "relevance": 50,
            "description": "Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "-moz-text-align-last",
            "browsers": [
                "FF12"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "center",
                    "description": "The inline contents are centered within the line box."
                },
                {
                    "name": "justify",
                    "description": "The text is justified according to the method specified by the 'text-justify' property."
                },
                {
                    "name": "left",
                    "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
                },
                {
                    "name": "right",
                    "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
                }
            ],
            "relevance": 50,
            "description": "Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-text-decoration-color",
            "browsers": [
                "FF6"
            ],
            "relevance": 50,
            "description": "Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-moz-text-decoration-line",
            "browsers": [
                "FF6"
            ],
            "values": [
                {
                    "name": "line-through",
                    "description": "Each line of text has a line through the middle."
                },
                {
                    "name": "none",
                    "description": "Neither produces nor inhibits text decoration."
                },
                {
                    "name": "overline",
                    "description": "Each line of text has a line above it."
                },
                {
                    "name": "underline",
                    "description": "Each line of text is underlined."
                }
            ],
            "relevance": 50,
            "description": "Specifies what line decorations, if any, are added to the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-text-decoration-style",
            "browsers": [
                "FF6"
            ],
            "values": [
                {
                    "name": "dashed",
                    "description": "Produces a dashed line style."
                },
                {
                    "name": "dotted",
                    "description": "Produces a dotted line."
                },
                {
                    "name": "double",
                    "description": "Produces a double line."
                },
                {
                    "name": "none",
                    "description": "Produces no line."
                },
                {
                    "name": "solid",
                    "description": "Produces a solid line."
                },
                {
                    "name": "wavy",
                    "description": "Produces a wavy line."
                }
            ],
            "relevance": 50,
            "description": "Specifies the line style for underline, line-through and overline text decoration.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-text-size-adjust",
            "browsers": [
                "FF"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Renderers must use the default size adjustment when displaying on a small device."
                },
                {
                    "name": "none",
                    "description": "Renderers must not do size adjustment when displaying on a small device."
                }
            ],
            "relevance": 50,
            "description": "Specifies a size adjustment for displaying text content in mobile browsers.",
            "restrictions": [
                "enum",
                "percentage"
            ]
        },
        {
            "name": "-moz-transform",
            "browsers": [
                "FF3.5"
            ],
            "values": [
                {
                    "name": "matrix()",
                    "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
                },
                {
                    "name": "matrix3d()",
                    "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
                },
                {
                    "name": "none"
                },
                {
                    "name": "perspective",
                    "description": "Specifies a perspective projection matrix."
                },
                {
                    "name": "rotate()",
                    "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
                },
                {
                    "name": "rotate3d()",
                    "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
                },
                {
                    "name": "rotateX('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the X axis."
                },
                {
                    "name": "rotateY('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Y axis."
                },
                {
                    "name": "rotateZ('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Z axis."
                },
                {
                    "name": "scale()",
                    "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
                },
                {
                    "name": "scale3d()",
                    "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
                },
                {
                    "name": "scaleX()",
                    "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
                },
                {
                    "name": "scaleY()",
                    "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
                },
                {
                    "name": "scaleZ()",
                    "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
                },
                {
                    "name": "skew()",
                    "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
                },
                {
                    "name": "skewX()",
                    "description": "Specifies a skew transformation along the X axis by the given angle."
                },
                {
                    "name": "skewY()",
                    "description": "Specifies a skew transformation along the Y axis by the given angle."
                },
                {
                    "name": "translate()",
                    "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
                },
                {
                    "name": "translate3d()",
                    "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
                },
                {
                    "name": "translateX()",
                    "description": "Specifies a translation by the given amount in the X direction."
                },
                {
                    "name": "translateY()",
                    "description": "Specifies a translation by the given amount in the Y direction."
                },
                {
                    "name": "translateZ()",
                    "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
                }
            ],
            "relevance": 50,
            "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-moz-transform-origin",
            "browsers": [
                "FF3.5"
            ],
            "relevance": 50,
            "description": "Establishes the origin of transformation for an element.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-moz-transition",
            "browsers": [
                "FF4"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "relevance": 50,
            "description": "Shorthand property combines four of the transition properties into a single property.",
            "restrictions": [
                "time",
                "property",
                "timing-function",
                "enum"
            ]
        },
        {
            "name": "-moz-transition-delay",
            "browsers": [
                "FF4"
            ],
            "relevance": 50,
            "description": "Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-moz-transition-duration",
            "browsers": [
                "FF4"
            ],
            "relevance": 50,
            "description": "Specifies how long the transition from the old value to the new value should take.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-moz-transition-property",
            "browsers": [
                "FF4"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "relevance": 50,
            "description": "Specifies the name of the CSS property to which the transition is applied.",
            "restrictions": [
                "property"
            ]
        },
        {
            "name": "-moz-transition-timing-function",
            "browsers": [
                "FF4"
            ],
            "relevance": 50,
            "description": "Describes how the intermediate values used during a transition will be calculated.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "-moz-user-focus",
            "values": [
                {
                    "name": "ignore"
                },
                {
                    "name": "normal"
                }
            ],
            "status": "obsolete",
            "syntax": "ignore | normal | select-after | select-before | select-menu | select-same | select-all | none",
            "relevance": 0,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/-moz-user-focus"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Used to indicate whether the element can have focus."
        },
        {
            "name": "-moz-user-select",
            "browsers": [
                "FF1.5"
            ],
            "values": [
                {
                    "name": "all"
                },
                {
                    "name": "element"
                },
                {
                    "name": "elements"
                },
                {
                    "name": "-moz-all"
                },
                {
                    "name": "-moz-none"
                },
                {
                    "name": "none"
                },
                {
                    "name": "text"
                },
                {
                    "name": "toggle"
                }
            ],
            "relevance": 50,
            "description": "Controls the appearance of selection.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-accelerator",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "false",
                    "description": "The element does not contain an accelerator key sequence."
                },
                {
                    "name": "true",
                    "description": "The element contains an accelerator key sequence."
                }
            ],
            "status": "nonstandard",
            "syntax": "false | true",
            "relevance": 0,
            "description": "IE only. Has the ability to turn off its system underlines for accelerator keys until the ALT key is pressed",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-behavior",
            "browsers": [
                "IE8"
            ],
            "relevance": 50,
            "description": "IE only. Used to extend behaviors of the browser",
            "restrictions": [
                "url"
            ]
        },
        {
            "name": "-ms-block-progression",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "bt",
                    "description": "Bottom-to-top block flow. Layout is horizontal."
                },
                {
                    "name": "lr",
                    "description": "Left-to-right direction. The flow orientation is vertical."
                },
                {
                    "name": "rl",
                    "description": "Right-to-left direction. The flow orientation is vertical."
                },
                {
                    "name": "tb",
                    "description": "Top-to-bottom direction. The flow orientation is horizontal."
                }
            ],
            "status": "nonstandard",
            "syntax": "tb | rl | bt | lr",
            "relevance": 0,
            "description": "Sets the block-progression value and the flow orientation",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-content-zoom-chaining",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "chained",
                    "description": "The nearest zoomable parent element begins zooming when the user hits a zoom limit during a manipulation. No bounce effect is shown."
                },
                {
                    "name": "none",
                    "description": "A bounce effect is shown when the user hits a zoom limit during a manipulation."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | chained",
            "relevance": 0,
            "description": "Specifies the zoom behavior that occurs when a user hits the zoom limit during a manipulation."
        },
        {
            "name": "-ms-content-zooming",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The element is not zoomable."
                },
                {
                    "name": "zoom",
                    "description": "The element is zoomable."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | zoom",
            "relevance": 0,
            "description": "Specifies whether zooming is enabled.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-content-zoom-limit",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-content-zoom-limit-min'> <'-ms-content-zoom-limit-max'>",
            "relevance": 0,
            "description": "Shorthand property for the -ms-content-zoom-limit-min and -ms-content-zoom-limit-max properties.",
            "restrictions": [
                "percentage"
            ]
        },
        {
            "name": "-ms-content-zoom-limit-max",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<percentage>",
            "relevance": 0,
            "description": "Specifies the maximum zoom factor.",
            "restrictions": [
                "percentage"
            ]
        },
        {
            "name": "-ms-content-zoom-limit-min",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<percentage>",
            "relevance": 0,
            "description": "Specifies the minimum zoom factor.",
            "restrictions": [
                "percentage"
            ]
        },
        {
            "name": "-ms-content-zoom-snap",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "mandatory",
                    "description": "Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."
                },
                {
                    "name": "none",
                    "description": "Indicates that zooming is unaffected by any defined snap-points."
                },
                {
                    "name": "proximity",
                    "description": "Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop \"close enough\" to a snap-point."
                },
                {
                    "name": "snapInterval(100%, 100%)",
                    "description": "Specifies where the snap-points will be placed."
                },
                {
                    "name": "snapList()",
                    "description": "Specifies the position of individual snap-points as a comma-separated list of zoom factors."
                }
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-content-zoom-snap-type'> || <'-ms-content-zoom-snap-points'>",
            "relevance": 0,
            "description": "Shorthand property for the -ms-content-zoom-snap-type and -ms-content-zoom-snap-points properties."
        },
        {
            "name": "-ms-content-zoom-snap-points",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "snapInterval(100%, 100%)",
                    "description": "Specifies where the snap-points will be placed."
                },
                {
                    "name": "snapList()",
                    "description": "Specifies the position of individual snap-points as a comma-separated list of zoom factors."
                }
            ],
            "status": "nonstandard",
            "syntax": "snapInterval( <percentage>, <percentage> ) | snapList( <percentage># )",
            "relevance": 0,
            "description": "Defines where zoom snap-points are located."
        },
        {
            "name": "-ms-content-zoom-snap-type",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "mandatory",
                    "description": "Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."
                },
                {
                    "name": "none",
                    "description": "Indicates that zooming is unaffected by any defined snap-points."
                },
                {
                    "name": "proximity",
                    "description": "Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop \"close enough\" to a snap-point."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | proximity | mandatory",
            "relevance": 0,
            "description": "Specifies how zooming is affected by defined snap-points.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-filter",
            "browsers": [
                "IE8-9"
            ],
            "status": "nonstandard",
            "syntax": "<string>",
            "relevance": 0,
            "description": "IE only. Used to produce visual effects.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "-ms-flex",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Retrieves the value of the main size property as the used 'flex-basis'."
                },
                {
                    "name": "none",
                    "description": "Expands to '0 0 auto'."
                }
            ],
            "relevance": 50,
            "description": "specifies the parameters of a flexible length: the positive and negative flexibility, and the preferred size.",
            "restrictions": [
                "length",
                "number",
                "percentage"
            ]
        },
        {
            "name": "-ms-flex-align",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "baseline",
                    "description": "If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
                },
                {
                    "name": "center",
                    "description": "The flex item's margin box is centered in the cross axis within the line."
                },
                {
                    "name": "end",
                    "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
                },
                {
                    "name": "start",
                    "description": "The cross-start margin edge of the flexbox item is placed flush with the cross-start edge of the line."
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flexbox item is anything other than 'auto', this value is identical to 'start'."
                }
            ],
            "relevance": 50,
            "description": "Aligns flex items along the cross axis of the current line of the flex container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-direction",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "column",
                    "description": "The flex container's main axis has the same orientation as the block axis of the current writing mode."
                },
                {
                    "name": "column-reverse",
                    "description": "Same as 'column', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "row",
                    "description": "The flex container's main axis has the same orientation as the inline axis of the current writing mode."
                },
                {
                    "name": "row-reverse",
                    "description": "Same as 'row', except the main-start and main-end directions are swapped."
                }
            ],
            "relevance": 50,
            "description": "Specifies how flex items are placed in the flex container, by setting the direction of the flex container's main axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-flow",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "column",
                    "description": "The flex container's main axis has the same orientation as the block axis of the current writing mode."
                },
                {
                    "name": "column-reverse",
                    "description": "Same as 'column', except the main-start and main-end directions are swapped."
                },
                {
                    "name": "nowrap",
                    "description": "The flex container is single-line."
                },
                {
                    "name": "row",
                    "description": "The flex container's main axis has the same orientation as the inline axis of the current writing mode."
                },
                {
                    "name": "wrap",
                    "description": "The flexbox is multi-line."
                },
                {
                    "name": "wrap-reverse",
                    "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
                }
            ],
            "relevance": 50,
            "description": "Specifies how flexbox items are placed in the flexbox.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-item-align",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Computes to the value of 'align-items' on the element's parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."
                },
                {
                    "name": "baseline",
                    "description": "If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
                },
                {
                    "name": "center",
                    "description": "The flex item's margin box is centered in the cross axis within the line."
                },
                {
                    "name": "end",
                    "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
                },
                {
                    "name": "start",
                    "description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
                },
                {
                    "name": "stretch",
                    "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
                }
            ],
            "relevance": 50,
            "description": "Allows the default alignment along the cross axis to be overridden for individual flex items.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-line-pack",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Lines are packed toward the center of the flex container."
                },
                {
                    "name": "distribute",
                    "description": "Lines are evenly distributed in the flex container, with half-size spaces on either end."
                },
                {
                    "name": "end",
                    "description": "Lines are packed toward the end of the flex container."
                },
                {
                    "name": "justify",
                    "description": "Lines are evenly distributed in the flex container."
                },
                {
                    "name": "start",
                    "description": "Lines are packed toward the start of the flex container."
                },
                {
                    "name": "stretch",
                    "description": "Lines stretch to take up the remaining space."
                }
            ],
            "relevance": 50,
            "description": "Aligns a flex container's lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-order",
            "browsers": [
                "IE10"
            ],
            "relevance": 50,
            "description": "Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-flex-pack",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Flex items are packed toward the center of the line."
                },
                {
                    "name": "distribute",
                    "description": "Flex items are evenly distributed in the line, with half-size spaces on either end."
                },
                {
                    "name": "end",
                    "description": "Flex items are packed toward the end of the line."
                },
                {
                    "name": "justify",
                    "description": "Flex items are evenly distributed in the line."
                },
                {
                    "name": "start",
                    "description": "Flex items are packed toward the start of the line."
                }
            ],
            "relevance": 50,
            "description": "Aligns flex items along the main axis of the current line of the flex container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flex-wrap",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "nowrap",
                    "description": "The flex container is single-line."
                },
                {
                    "name": "wrap",
                    "description": "The flexbox is multi-line."
                },
                {
                    "name": "wrap-reverse",
                    "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
                }
            ],
            "relevance": 50,
            "description": "Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-flow-from",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The block container is not a CSS Region."
                }
            ],
            "status": "nonstandard",
            "syntax": "[ none | <custom-ident> ]#",
            "relevance": 0,
            "description": "Makes a block container a region and associates it with a named flow.",
            "restrictions": [
                "identifier"
            ]
        },
        {
            "name": "-ms-flow-into",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The element is not moved to a named flow and normal CSS processing takes place."
                }
            ],
            "status": "nonstandard",
            "syntax": "[ none | <custom-ident> ]#",
            "relevance": 0,
            "description": "Places an element or its contents into a named flow.",
            "restrictions": [
                "identifier"
            ]
        },
        {
            "name": "-ms-grid-column",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "end"
                },
                {
                    "name": "start"
                }
            ],
            "relevance": 50,
            "description": "Used to place grid items and explicitly defined grid cells in the Grid.",
            "restrictions": [
                "integer",
                "string",
                "enum"
            ]
        },
        {
            "name": "-ms-grid-column-align",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Places the center of the Grid Item's margin box at the center of the Grid Item's column."
                },
                {
                    "name": "end",
                    "description": "Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's column."
                },
                {
                    "name": "start",
                    "description": "Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's column."
                },
                {
                    "name": "stretch",
                    "description": "Ensures that the Grid Item's margin box is equal to the size of the Grid Item's column."
                }
            ],
            "relevance": 50,
            "description": "Aligns the columns in a grid.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-grid-columns",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "none | <track-list> | <auto-track-list>",
            "relevance": 0,
            "description": "Lays out the columns of the grid."
        },
        {
            "name": "-ms-grid-column-span",
            "browsers": [
                "E",
                "IE10"
            ],
            "relevance": 50,
            "description": "Specifies the number of columns to span.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-grid-layer",
            "browsers": [
                "E",
                "IE10"
            ],
            "relevance": 50,
            "description": "Grid-layer is similar in concept to z-index, but avoids overloading the meaning of the z-index property, which is applicable only to positioned elements.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-grid-row",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "end"
                },
                {
                    "name": "start"
                }
            ],
            "relevance": 50,
            "description": "grid-row is used to place grid items and explicitly defined grid cells in the Grid.",
            "restrictions": [
                "integer",
                "string",
                "enum"
            ]
        },
        {
            "name": "-ms-grid-row-align",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "center",
                    "description": "Places the center of the Grid Item's margin box at the center of the Grid Item's row."
                },
                {
                    "name": "end",
                    "description": "Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's row."
                },
                {
                    "name": "start",
                    "description": "Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's row."
                },
                {
                    "name": "stretch",
                    "description": "Ensures that the Grid Item's margin box is equal to the size of the Grid Item's row."
                }
            ],
            "relevance": 50,
            "description": "Aligns the rows in a grid.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-grid-rows",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "none | <track-list> | <auto-track-list>",
            "relevance": 0,
            "description": "Lays out the columns of the grid."
        },
        {
            "name": "-ms-grid-row-span",
            "browsers": [
                "E",
                "IE10"
            ],
            "relevance": 50,
            "description": "Specifies the number of rows to span.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-high-contrast-adjust",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Properties will be adjusted as applicable."
                },
                {
                    "name": "none",
                    "description": "No adjustments will be applied."
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | none",
            "relevance": 0,
            "description": "Specifies if properties should be adjusted in high contrast mode.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-hyphenate-limit-chars",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent chooses a value that adapts to the current layout."
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | <integer>{1,3}",
            "relevance": 0,
            "description": "Specifies the minimum number of characters in a hyphenated word.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-hyphenate-limit-lines",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "no-limit",
                    "description": "There is no limit."
                }
            ],
            "status": "nonstandard",
            "syntax": "no-limit | <integer>",
            "relevance": 0,
            "description": "Indicates the maximum number of successive hyphenated lines in an element.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-ms-hyphenate-limit-zone",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<percentage> | <length>",
            "relevance": 0,
            "description": "Specifies the maximum amount of unfilled space (before justification) that may be left in the line box before hyphenation is triggered to pull part of a word from the next line back up into the current line.",
            "restrictions": [
                "percentage",
                "length"
            ]
        },
        {
            "name": "-ms-hyphens",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."
                },
                {
                    "name": "manual",
                    "description": "Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"
                },
                {
                    "name": "none",
                    "description": "Words are not broken at line breaks, even if characters inside the word suggest line break points."
                }
            ],
            "relevance": 50,
            "description": "Controls whether hyphenation is allowed to create more break opportunities within a line of text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-ime-mode",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "active",
                    "description": "The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."
                },
                {
                    "name": "auto",
                    "description": "No change is made to the current input method editor state. This is the default."
                },
                {
                    "name": "disabled",
                    "description": "The input method editor is disabled and may not be activated by the user."
                },
                {
                    "name": "inactive",
                    "description": "The input method editor is initially inactive, but the user may activate it if they wish."
                },
                {
                    "name": "normal",
                    "description": "The IME state should be normal; this value can be used in a user style sheet to override the page setting."
                }
            ],
            "relevance": 50,
            "description": "Controls the state of the input method editor for text fields.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-interpolation-mode",
            "browsers": [
                "IE7"
            ],
            "values": [
                {
                    "name": "bicubic"
                },
                {
                    "name": "nearest-neighbor"
                }
            ],
            "relevance": 50,
            "description": "Gets or sets the interpolation (resampling) method used to stretch images.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-layout-grid",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "char",
                    "description": "Any of the range of character values available to the -ms-layout-grid-char property."
                },
                {
                    "name": "line",
                    "description": "Any of the range of line values available to the -ms-layout-grid-line property."
                },
                {
                    "name": "mode",
                    "description": "Any of the range of mode values available to the -ms-layout-grid-mode property."
                },
                {
                    "name": "type",
                    "description": "Any of the range of type values available to the -ms-layout-grid-type property."
                }
            ],
            "relevance": 50,
            "description": "Sets or retrieves the composite document grid properties that specify the layout of text characters."
        },
        {
            "name": "-ms-layout-grid-char",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Largest character in the font of the element is used to set the character grid."
                },
                {
                    "name": "none",
                    "description": "Default. No character grid is set."
                }
            ],
            "relevance": 50,
            "description": "Sets or retrieves the size of the character grid used for rendering the text content of an element.",
            "restrictions": [
                "enum",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-layout-grid-line",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Largest character in the font of the element is used to set the character grid."
                },
                {
                    "name": "none",
                    "description": "Default. No grid line is set."
                }
            ],
            "relevance": 50,
            "description": "Sets or retrieves the gridline value used for rendering the text content of an element.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-layout-grid-mode",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "both",
                    "description": "Default. Both the char and line grid modes are enabled. This setting is necessary to fully enable the layout grid on an element."
                },
                {
                    "name": "char",
                    "description": "Only a character grid is used. This is recommended for use with block-level elements, such as a blockquote, where the line grid is intended to be disabled."
                },
                {
                    "name": "line",
                    "description": "Only a line grid is used. This is recommended for use with inline elements, such as a span, to disable the horizontal grid on runs of text that act as a single entity in the grid layout."
                },
                {
                    "name": "none",
                    "description": "No grid is used."
                }
            ],
            "relevance": 50,
            "description": "Gets or sets whether the text layout grid uses two dimensions.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-layout-grid-type",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "fixed",
                    "description": "Grid used for monospaced layout. All noncursive characters are treated as equal; every character is centered within a single grid space by default."
                },
                {
                    "name": "loose",
                    "description": "Default. Grid used for Japanese and Korean characters."
                },
                {
                    "name": "strict",
                    "description": "Grid used for Chinese, as well as Japanese (Genko) and Korean characters. Only the ideographs, kanas, and wide characters are snapped to the grid."
                }
            ],
            "relevance": 50,
            "description": "Sets or retrieves the type of grid used for rendering the text content of an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-line-break",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."
                },
                {
                    "name": "keep-all",
                    "description": "Sequences of CJK characters can no longer break on implied break points. This option should only be used where the presence of word separator characters still creates line-breaking opportunities, as in Korean."
                },
                {
                    "name": "newspaper",
                    "description": "Breaks CJK scripts using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."
                },
                {
                    "name": "normal",
                    "description": "Breaks CJK scripts using a normal set of line-breaking rules."
                },
                {
                    "name": "strict",
                    "description": "Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."
                }
            ],
            "relevance": 50,
            "description": "Specifies what set of line breaking restrictions are in effect within the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-overflow-style",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "No preference, UA should use the first scrolling method in the list that it supports."
                },
                {
                    "name": "-ms-autohiding-scrollbar",
                    "description": "Indicates the element displays auto-hiding scrollbars during mouse interactions and panning indicators during touch and keyboard interactions."
                },
                {
                    "name": "none",
                    "description": "Indicates the element does not display scrollbars or panning indicators, even when its content overflows."
                },
                {
                    "name": "scrollbar",
                    "description": "Scrollbars are typically narrow strips inserted on one or two edges of an element and which often have arrows to click on and a \"thumb\" to drag up and down (or left and right) to move the contents of the element."
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | none | scrollbar | -ms-autohiding-scrollbar",
            "relevance": 0,
            "description": "Specify whether content is clipped when it overflows the element's content area.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-perspective",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No perspective transform is applied."
                }
            ],
            "relevance": 50,
            "description": "Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-perspective-origin",
            "browsers": [
                "IE10"
            ],
            "relevance": 50,
            "description": "Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "-ms-perspective-origin-x",
            "browsers": [
                "IE10"
            ],
            "relevance": 50,
            "description": "Establishes the origin for the perspective property. It effectively sets the X  position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "-ms-perspective-origin-y",
            "browsers": [
                "IE10"
            ],
            "relevance": 50,
            "description": "Establishes the origin for the perspective property. It effectively sets the Y position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "-ms-progress-appearance",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "bar"
                },
                {
                    "name": "ring"
                }
            ],
            "relevance": 50,
            "description": "Gets or sets a value that specifies whether a progress control displays as a bar or a ring.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scrollbar-3dlight-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "relevance": 0,
            "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-arrow-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "relevance": 0,
            "description": "Determines the color of the arrow elements of a scroll arrow.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-base-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "relevance": 0,
            "description": "Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-darkshadow-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "relevance": 0,
            "description": "Determines the color of the gutter of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-face-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "relevance": 0,
            "description": "Determines the color of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-highlight-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "relevance": 0,
            "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-shadow-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "relevance": 0,
            "description": "Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scrollbar-track-color",
            "browsers": [
                "IE8"
            ],
            "status": "nonstandard",
            "syntax": "<color>",
            "relevance": 0,
            "description": "Determines the color of the track element of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "-ms-scroll-chaining",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "chained"
                },
                {
                    "name": "none"
                }
            ],
            "status": "nonstandard",
            "syntax": "chained | none",
            "relevance": 0,
            "description": "Gets or sets a value that indicates the scrolling behavior that occurs when a user hits the content boundary during a manipulation.",
            "restrictions": [
                "enum",
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-scroll-limit-x-min'> <'-ms-scroll-limit-y-min'> <'-ms-scroll-limit-x-max'> <'-ms-scroll-limit-y-max'>",
            "relevance": 0,
            "description": "Gets or sets a shorthand value that sets values for the -ms-scroll-limit-x-min, -ms-scroll-limit-y-min, -ms-scroll-limit-x-max, and -ms-scroll-limit-y-max properties.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit-x-max",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | <length>",
            "relevance": 0,
            "description": "Gets or sets a value that specifies the maximum value for the scrollLeft property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit-x-min",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<length>",
            "relevance": 0,
            "description": "Gets or sets a value that specifies the minimum value for the scrollLeft property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit-y-max",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto"
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | <length>",
            "relevance": 0,
            "description": "Gets or sets a value that specifies the maximum value for the scrollTop property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-limit-y-min",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<length>",
            "relevance": 0,
            "description": "Gets or sets a value that specifies the minimum value for the scrollTop property.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "-ms-scroll-rails",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none"
                },
                {
                    "name": "railed"
                }
            ],
            "status": "nonstandard",
            "syntax": "none | railed",
            "relevance": 0,
            "description": "Gets or sets a value that indicates whether or not small motions perpendicular to the primary axis of motion will result in either changes to both the scrollTop and scrollLeft properties or a change to the primary axis (for instance, either the scrollTop or scrollLeft properties will change, but not both).",
            "restrictions": [
                "enum",
                "length"
            ]
        },
        {
            "name": "-ms-scroll-snap-points-x",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "snapInterval(100%, 100%)"
                },
                {
                    "name": "snapList()"
                }
            ],
            "status": "nonstandard",
            "syntax": "snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",
            "relevance": 0,
            "description": "Gets or sets a value that defines where snap-points will be located along the x-axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-snap-points-y",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "snapInterval(100%, 100%)"
                },
                {
                    "name": "snapList()"
                }
            ],
            "status": "nonstandard",
            "syntax": "snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",
            "relevance": 0,
            "description": "Gets or sets a value that defines where snap-points will be located along the y-axis.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-snap-type",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The visual viewport of this scroll container must ignore snap points, if any, when scrolled."
                },
                {
                    "name": "mandatory",
                    "description": "The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."
                },
                {
                    "name": "proximity",
                    "description": "The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | proximity | mandatory",
            "relevance": 0,
            "description": "Gets or sets a value that defines what type of snap-point should be used for the current element. There are two type of snap-points, with the primary difference being whether or not the user is guaranteed to always stop on a snap-point.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-snap-x",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "mandatory"
                },
                {
                    "name": "none"
                },
                {
                    "name": "proximity"
                },
                {
                    "name": "snapInterval(100%, 100%)"
                },
                {
                    "name": "snapList()"
                }
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-x'>",
            "relevance": 0,
            "description": "Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-x properties.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-snap-y",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "mandatory"
                },
                {
                    "name": "none"
                },
                {
                    "name": "proximity"
                },
                {
                    "name": "snapInterval(100%, 100%)"
                },
                {
                    "name": "snapList()"
                }
            ],
            "status": "nonstandard",
            "syntax": "<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-y'>",
            "relevance": 0,
            "description": "Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-y properties.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-scroll-translation",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none"
                },
                {
                    "name": "vertical-to-horizontal"
                }
            ],
            "status": "nonstandard",
            "syntax": "none | vertical-to-horizontal",
            "relevance": 0,
            "description": "Gets or sets a value that specifies whether vertical-to-horizontal scroll wheel translation occurs on the specified element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-align-last",
            "browsers": [
                "E",
                "IE8"
            ],
            "values": [
                {
                    "name": "auto"
                },
                {
                    "name": "center",
                    "description": "The inline contents are centered within the line box."
                },
                {
                    "name": "justify",
                    "description": "The text is justified according to the method specified by the 'text-justify' property."
                },
                {
                    "name": "left",
                    "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
                },
                {
                    "name": "right",
                    "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
                }
            ],
            "relevance": 50,
            "description": "Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-autospace",
            "browsers": [
                "E",
                "IE8"
            ],
            "values": [
                {
                    "name": "ideograph-alpha",
                    "description": "Creates 1/4em extra spacing between runs of ideographic letters and non-ideographic letters, such as Latin-based, Cyrillic, Greek, Arabic or Hebrew."
                },
                {
                    "name": "ideograph-numeric",
                    "description": "Creates 1/4em extra spacing between runs of ideographic letters and numeric glyphs."
                },
                {
                    "name": "ideograph-parenthesis",
                    "description": "Creates extra spacing between normal (non wide) parenthesis and ideographs."
                },
                {
                    "name": "ideograph-space",
                    "description": "Extends the width of the space character while surrounded by ideographs."
                },
                {
                    "name": "none",
                    "description": "No extra space is created."
                },
                {
                    "name": "punctuation",
                    "description": "Creates extra non-breaking spacing around punctuation as required by language-specific typographic conventions."
                }
            ],
            "status": "nonstandard",
            "syntax": "none | ideograph-alpha | ideograph-numeric | ideograph-parenthesis | ideograph-space",
            "relevance": 0,
            "description": "Determines whether or not a full-width punctuation mark character should be trimmed if it appears at the beginning of a line, so that its 'ink' lines up with the first glyph in the line above and below.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-combine-horizontal",
            "browsers": [
                "E",
                "IE11"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Attempt to typeset horizontally all consecutive characters within the box such that they take up the space of a single character within the vertical line box."
                },
                {
                    "name": "digits",
                    "description": "Attempt to typeset horizontally each maximal sequence of consecutive ASCII digits (U+0030-U+0039) that has as many or fewer characters than the specified integer such that it takes up the space of a single character within the vertical line box."
                },
                {
                    "name": "none",
                    "description": "No special processing."
                }
            ],
            "relevance": 50,
            "description": "This property specifies the combination of multiple characters into the space of a single character.",
            "restrictions": [
                "enum",
                "integer"
            ]
        },
        {
            "name": "-ms-text-justify",
            "browsers": [
                "E",
                "IE8"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."
                },
                {
                    "name": "distribute",
                    "description": "Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."
                },
                {
                    "name": "inter-cluster",
                    "description": "Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."
                },
                {
                    "name": "inter-ideograph",
                    "description": "Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."
                },
                {
                    "name": "inter-word",
                    "description": "Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."
                },
                {
                    "name": "kashida",
                    "description": "Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."
                }
            ],
            "relevance": 50,
            "description": "Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-kashida-space",
            "browsers": [
                "E",
                "IE10"
            ],
            "relevance": 50,
            "description": "Sets or retrieves the ratio of kashida expansion to white space expansion when justifying lines of text in the object.",
            "restrictions": [
                "percentage"
            ]
        },
        {
            "name": "-ms-text-overflow",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "clip",
                    "description": "Clip inline content that overflows. Characters may be only partially rendered."
                },
                {
                    "name": "ellipsis",
                    "description": "Render an ellipsis character (U+2026) to represent clipped inline content."
                }
            ],
            "relevance": 50,
            "description": "Text can overflow for example when it is prevented from wrapping",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-text-size-adjust",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Renderers must use the default size adjustment when displaying on a small device."
                },
                {
                    "name": "none",
                    "description": "Renderers must not do size adjustment when displaying on a small device."
                }
            ],
            "relevance": 50,
            "description": "Specifies a size adjustment for displaying text content in mobile browsers.",
            "restrictions": [
                "enum",
                "percentage"
            ]
        },
        {
            "name": "-ms-text-underline-position",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "alphabetic",
                    "description": "The underline is aligned with the alphabetic baseline. In this case the underline is likely to cross some descenders."
                },
                {
                    "name": "auto",
                    "description": "The user agent may use any algorithm to determine the underline's position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."
                },
                {
                    "name": "over",
                    "description": "The underline is aligned with the 'top' (right in vertical writing) edge of the element's em-box. In this mode, an overline also switches sides."
                },
                {
                    "name": "under",
                    "description": "The underline is aligned with the 'bottom' (left in vertical writing) edge of the element's em-box. In this case the underline usually does not cross the descenders. This is sometimes called 'accounting' underline."
                }
            ],
            "relevance": 50,
            "description": "Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements.This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-touch-action",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The element is a passive element, with several exceptions."
                },
                {
                    "name": "double-tap-zoom",
                    "description": "The element will zoom on double-tap."
                },
                {
                    "name": "manipulation",
                    "description": "The element is a manipulation-causing element."
                },
                {
                    "name": "none",
                    "description": "The element is a manipulation-blocking element."
                },
                {
                    "name": "pan-x",
                    "description": "The element permits touch-driven panning on the horizontal axis. The touch pan is performed on the nearest ancestor with horizontally scrollable content."
                },
                {
                    "name": "pan-y",
                    "description": "The element permits touch-driven panning on the vertical axis. The touch pan is performed on the nearest ancestor with vertically scrollable content."
                },
                {
                    "name": "pinch-zoom",
                    "description": "The element permits pinch-zooming. The pinch-zoom is performed on the nearest ancestor with zoomable content."
                }
            ],
            "relevance": 50,
            "description": "Gets or sets a value that indicates whether and how a given region can be manipulated by the user.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-touch-select",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "grippers",
                    "description": "Grippers are always on."
                },
                {
                    "name": "none",
                    "description": "Grippers are always off."
                }
            ],
            "status": "nonstandard",
            "syntax": "grippers | none",
            "relevance": 0,
            "description": "Gets or sets a value that toggles the 'gripper' visual elements that enable touch text selection.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-transform",
            "browsers": [
                "IE9-9"
            ],
            "values": [
                {
                    "name": "matrix()",
                    "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
                },
                {
                    "name": "matrix3d()",
                    "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
                },
                {
                    "name": "none"
                },
                {
                    "name": "rotate()",
                    "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
                },
                {
                    "name": "rotate3d()",
                    "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
                },
                {
                    "name": "rotateX('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the X axis."
                },
                {
                    "name": "rotateY('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Y axis."
                },
                {
                    "name": "rotateZ('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Z axis."
                },
                {
                    "name": "scale()",
                    "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
                },
                {
                    "name": "scale3d()",
                    "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
                },
                {
                    "name": "scaleX()",
                    "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
                },
                {
                    "name": "scaleY()",
                    "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
                },
                {
                    "name": "scaleZ()",
                    "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
                },
                {
                    "name": "skew()",
                    "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
                },
                {
                    "name": "skewX()",
                    "description": "Specifies a skew transformation along the X axis by the given angle."
                },
                {
                    "name": "skewY()",
                    "description": "Specifies a skew transformation along the Y axis by the given angle."
                },
                {
                    "name": "translate()",
                    "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
                },
                {
                    "name": "translate3d()",
                    "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
                },
                {
                    "name": "translateX()",
                    "description": "Specifies a translation by the given amount in the X direction."
                },
                {
                    "name": "translateY()",
                    "description": "Specifies a translation by the given amount in the Y direction."
                },
                {
                    "name": "translateZ()",
                    "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
                }
            ],
            "relevance": 50,
            "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-transform-origin",
            "browsers": [
                "IE9-9"
            ],
            "relevance": 50,
            "description": "Establishes the origin of transformation for an element.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-transform-origin-x",
            "browsers": [
                "IE10"
            ],
            "relevance": 50,
            "description": "The x coordinate of the origin for transforms applied to an element with respect to its border box.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-transform-origin-y",
            "browsers": [
                "IE10"
            ],
            "relevance": 50,
            "description": "The y coordinate of the origin for transforms applied to an element with respect to its border box.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-transform-origin-z",
            "browsers": [
                "IE10"
            ],
            "relevance": 50,
            "description": "The z coordinate of the origin for transforms applied to an element with respect to its border box.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-user-select",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "element"
                },
                {
                    "name": "none"
                },
                {
                    "name": "text"
                }
            ],
            "status": "nonstandard",
            "syntax": "none | element | text",
            "relevance": 0,
            "description": "Controls the appearance of selection.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-word-break",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "break-all",
                    "description": "Lines may break between any two grapheme clusters for non-CJK scripts."
                },
                {
                    "name": "keep-all",
                    "description": "Block characters can no longer create implied break points."
                },
                {
                    "name": "normal",
                    "description": "Breaks non-CJK scripts according to their own rules."
                }
            ],
            "relevance": 50,
            "description": "Specifies line break opportunities for non-CJK scripts.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-word-wrap",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "break-word",
                    "description": "An unbreakable 'word' may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."
                },
                {
                    "name": "normal",
                    "description": "Lines may break only at allowed break points."
                }
            ],
            "relevance": 50,
            "description": "Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-wrap-flow",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For floats an exclusion is created, for all other elements an exclusion is not created."
                },
                {
                    "name": "both",
                    "description": "Inline flow content can flow on all sides of the exclusion."
                },
                {
                    "name": "clear",
                    "description": "Inline flow content can only wrap on top and bottom of the exclusion and must leave the areas to the start and end edges of the exclusion box empty."
                },
                {
                    "name": "end",
                    "description": "Inline flow content can wrap on the end side of the exclusion area but must leave the area to the start edge of the exclusion area empty."
                },
                {
                    "name": "maximum",
                    "description": "Inline flow content can wrap on the side of the exclusion with the largest available space for the given line, and must leave the other side of the exclusion empty."
                },
                {
                    "name": "minimum",
                    "description": "Inline flow content can flow around the edge of the exclusion with the smallest available space within the flow content's containing block, and must leave the other edge of the exclusion empty."
                },
                {
                    "name": "start",
                    "description": "Inline flow content can wrap on the start edge of the exclusion area but must leave the area to end edge of the exclusion area empty."
                }
            ],
            "status": "nonstandard",
            "syntax": "auto | both | start | end | maximum | clear",
            "relevance": 0,
            "description": "An element becomes an exclusion when its 'wrap-flow' property has a computed value other than 'auto'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-wrap-margin",
            "browsers": [
                "E",
                "IE10"
            ],
            "status": "nonstandard",
            "syntax": "<length>",
            "relevance": 0,
            "description": "Gets or sets a value that is used to offset the inner wrap shape from other shapes.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "-ms-wrap-through",
            "browsers": [
                "E",
                "IE10"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "The exclusion element does not inherit its parent node's wrapping context. Its descendants are only subject to exclusion shapes defined inside the element."
                },
                {
                    "name": "wrap",
                    "description": "The exclusion element inherits its parent node's wrapping context. Its descendant inline content wraps around exclusions defined outside the element."
                }
            ],
            "status": "nonstandard",
            "syntax": "wrap | none",
            "relevance": 0,
            "description": "Specifies if an element inherits its parent wrapping context. In other words if it is subject to the exclusions defined outside the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-writing-mode",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "bt-lr"
                },
                {
                    "name": "bt-rl"
                },
                {
                    "name": "lr-bt"
                },
                {
                    "name": "lr-tb"
                },
                {
                    "name": "rl-bt"
                },
                {
                    "name": "rl-tb"
                },
                {
                    "name": "tb-lr"
                },
                {
                    "name": "tb-rl"
                }
            ],
            "relevance": 50,
            "description": "Shorthand property for both 'direction' and 'block-progression'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-ms-zoom",
            "browsers": [
                "IE8"
            ],
            "values": [
                {
                    "name": "normal"
                }
            ],
            "relevance": 50,
            "description": "Sets or retrieves the magnification scale of the object.",
            "restrictions": [
                "enum",
                "integer",
                "number",
                "percentage"
            ]
        },
        {
            "name": "-ms-zoom-animation",
            "browsers": [
                "IE10"
            ],
            "values": [
                {
                    "name": "default"
                },
                {
                    "name": "none"
                }
            ],
            "relevance": 50,
            "description": "Gets or sets a value that indicates whether an animation is used when zooming.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "nav-down",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
                },
                {
                    "name": "current",
                    "description": "Indicates that the user agent should target the frame that the element is in."
                },
                {
                    "name": "root",
                    "description": "Indicates that the user agent should target the full window."
                }
            ],
            "relevance": 50,
            "description": "Provides an way to control directional focus navigation.",
            "restrictions": [
                "enum",
                "identifier",
                "string"
            ]
        },
        {
            "name": "nav-index",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The element's sequential navigation order is assigned automatically by the user agent."
                }
            ],
            "relevance": 50,
            "description": "Provides an input-method-neutral way of specifying the sequential navigation order (also known as 'tabbing order').",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "nav-left",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
                },
                {
                    "name": "current",
                    "description": "Indicates that the user agent should target the frame that the element is in."
                },
                {
                    "name": "root",
                    "description": "Indicates that the user agent should target the full window."
                }
            ],
            "relevance": 50,
            "description": "Provides an way to control directional focus navigation.",
            "restrictions": [
                "enum",
                "identifier",
                "string"
            ]
        },
        {
            "name": "nav-right",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
                },
                {
                    "name": "current",
                    "description": "Indicates that the user agent should target the frame that the element is in."
                },
                {
                    "name": "root",
                    "description": "Indicates that the user agent should target the full window."
                }
            ],
            "relevance": 50,
            "description": "Provides an way to control directional focus navigation.",
            "restrictions": [
                "enum",
                "identifier",
                "string"
            ]
        },
        {
            "name": "nav-up",
            "browsers": [
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
                },
                {
                    "name": "current",
                    "description": "Indicates that the user agent should target the frame that the element is in."
                },
                {
                    "name": "root",
                    "description": "Indicates that the user agent should target the full window."
                }
            ],
            "relevance": 50,
            "description": "Provides an way to control directional focus navigation.",
            "restrictions": [
                "enum",
                "identifier",
                "string"
            ]
        },
        {
            "name": "negative",
            "browsers": [
                "FF33"
            ],
            "atRule": "@counter-style",
            "syntax": "<symbol> <symbol>?",
            "relevance": 50,
            "description": "@counter-style descriptor. Defines how to alter the representation when the counter value is negative.",
            "restrictions": [
                "image",
                "identifier",
                "string"
            ]
        },
        {
            "name": "-o-animation",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "backwards",
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                },
                {
                    "name": "none",
                    "description": "No animation is performed"
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "relevance": 50,
            "description": "Shorthand property combines six of the animation properties into a single property.",
            "restrictions": [
                "time",
                "enum",
                "timing-function",
                "identifier",
                "number"
            ]
        },
        {
            "name": "-o-animation-delay",
            "browsers": [
                "O12"
            ],
            "relevance": 50,
            "description": "Defines when the animation will start.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-o-animation-direction",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "alternate",
                    "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
                },
                {
                    "name": "alternate-reverse",
                    "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
                },
                {
                    "name": "normal",
                    "description": "Normal playback."
                },
                {
                    "name": "reverse",
                    "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
                }
            ],
            "relevance": 50,
            "description": "Defines whether or not the animation should play in reverse on alternate cycles.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-animation-duration",
            "browsers": [
                "O12"
            ],
            "relevance": 50,
            "description": "Defines the length of time that an animation takes to complete one cycle.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-o-animation-fill-mode",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "backwards",
                    "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
                },
                {
                    "name": "both",
                    "description": "Both forwards and backwards fill modes are applied."
                },
                {
                    "name": "forwards",
                    "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
                },
                {
                    "name": "none",
                    "description": "There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."
                }
            ],
            "relevance": 50,
            "description": "Defines what values are applied by the animation outside the time it is executing.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-animation-iteration-count",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "infinite",
                    "description": "Causes the animation to repeat forever."
                }
            ],
            "relevance": 50,
            "description": "Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",
            "restrictions": [
                "number",
                "enum"
            ]
        },
        {
            "name": "-o-animation-name",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No animation is performed"
                }
            ],
            "relevance": 50,
            "description": "Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",
            "restrictions": [
                "identifier",
                "enum"
            ]
        },
        {
            "name": "-o-animation-play-state",
            "browsers": [
                "O12"
            ],
            "values": [
                {
                    "name": "paused",
                    "description": "A running animation will be paused."
                },
                {
                    "name": "running",
                    "description": "Resume playback of a paused animation."
                }
            ],
            "relevance": 50,
            "description": "Defines whether the animation is running or paused.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-animation-timing-function",
            "browsers": [
                "O12"
            ],
            "relevance": 50,
            "description": "Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "object-fit",
            "browsers": [
                "E79",
                "FF36",
                "FFA36",
                "S10",
                "SM10",
                "C32",
                "CA32",
                "O19"
            ],
            "values": [
                {
                    "name": "contain",
                    "browsers": [
                        "E79",
                        "FF36",
                        "FFA36",
                        "S10",
                        "SM10",
                        "C32",
                        "CA32",
                        "O19"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The replaced content is sized to maintain its aspect ratio while fitting within the element's content box: its concrete object size is resolved as a contain constraint against the element's used width and height."
                },
                {
                    "name": "cover",
                    "browsers": [
                        "E79",
                        "FF36",
                        "FFA36",
                        "S10",
                        "SM10",
                        "C32",
                        "CA32",
                        "O19"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element's used width and height."
                },
                {
                    "name": "fill",
                    "browsers": [
                        "E79",
                        "FF36",
                        "FFA36",
                        "S10",
                        "SM10",
                        "C32",
                        "CA32",
                        "O19"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The replaced content is sized to fill the element's content box: the object's concrete object size is the element's used width and height."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF36",
                        "FFA36",
                        "S10",
                        "SM10",
                        "C32",
                        "CA32",
                        "O19"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The replaced content is not resized to fit inside the element's content box"
                },
                {
                    "name": "scale-down",
                    "browsers": [
                        "E79",
                        "FF36",
                        "FFA36",
                        "S10",
                        "SM10",
                        "C32",
                        "CA32",
                        "O19"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Size the content as if 'none' or 'contain' were specified, whichever would result in a smaller concrete object size."
                }
            ],
            "syntax": "fill | contain | cover | none | scale-down",
            "relevance": 76,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/object-fit"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "object-position",
            "browsers": [
                "E79",
                "FF36",
                "FFA36",
                "S10",
                "SM10",
                "C32",
                "CA32",
                "O19"
            ],
            "syntax": "<position>",
            "relevance": 59,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/object-position"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Determines the alignment of the replaced element inside its box.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-o-border-image",
            "browsers": [
                "O11.6"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
                },
                {
                    "name": "fill",
                    "description": "Causes the middle part of the border-image to be preserved."
                },
                {
                    "name": "none"
                },
                {
                    "name": "repeat",
                    "description": "The image is tiled (repeated) to fill the area."
                },
                {
                    "name": "round",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
                },
                {
                    "name": "space",
                    "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
                },
                {
                    "name": "stretch",
                    "description": "The image is stretched to fill the area."
                }
            ],
            "relevance": 50,
            "description": "Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",
            "restrictions": [
                "length",
                "percentage",
                "number",
                "image",
                "enum"
            ]
        },
        {
            "name": "-o-object-fit",
            "browsers": [
                "O10.6"
            ],
            "values": [
                {
                    "name": "contain",
                    "description": "The replaced content is sized to maintain its aspect ratio while fitting within the element's content box: its concrete object size is resolved as a contain constraint against the element's used width and height."
                },
                {
                    "name": "cover",
                    "description": "The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element's used width and height."
                },
                {
                    "name": "fill",
                    "description": "The replaced content is sized to fill the element's content box: the object's concrete object size is the element's used width and height."
                },
                {
                    "name": "none",
                    "description": "The replaced content is not resized to fit inside the element's content box"
                },
                {
                    "name": "scale-down",
                    "description": "Size the content as if 'none' or 'contain' were specified, whichever would result in a smaller concrete object size."
                }
            ],
            "relevance": 50,
            "description": "Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-object-position",
            "browsers": [
                "O10.6"
            ],
            "relevance": 50,
            "description": "Determines the alignment of the replaced element inside its box.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "opacity",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S2",
                "SM1",
                "C1",
                "CA18",
                "IE9",
                "O9"
            ],
            "syntax": "<opacity-value>",
            "relevance": 93,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/opacity"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Opacity of an element's text, where 1 is opaque and 0 is entirely transparent.",
            "restrictions": [
                "number(0-1)"
            ]
        },
        {
            "name": "order",
            "browsers": [
                "E12",
                "FF20",
                "FFA20",
                "S9",
                "SM9",
                "C29",
                "CA29",
                "IE11",
                "O12.1"
            ],
            "syntax": "<integer>",
            "relevance": 70,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/order"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "orphans",
            "browsers": [
                "E12",
                "S1.3",
                "SM1",
                "C25",
                "CA25",
                "IE8",
                "O9.2"
            ],
            "syntax": "<integer>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/orphans"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Specifies the minimum number of line boxes in a block container that must be left in a fragment before a fragmentation break.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-o-table-baseline",
            "browsers": [
                "O9.6"
            ],
            "relevance": 50,
            "description": "Determines which row of a inline-table should be used as baseline of inline-table.",
            "restrictions": [
                "integer"
            ]
        },
        {
            "name": "-o-tab-size",
            "browsers": [
                "O10.6"
            ],
            "relevance": 50,
            "description": "This property determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",
            "restrictions": [
                "integer",
                "length"
            ]
        },
        {
            "name": "-o-text-overflow",
            "browsers": [
                "O10"
            ],
            "values": [
                {
                    "name": "clip",
                    "description": "Clip inline content that overflows. Characters may be only partially rendered."
                },
                {
                    "name": "ellipsis",
                    "description": "Render an ellipsis character (U+2026) to represent clipped inline content."
                }
            ],
            "relevance": 50,
            "description": "Text can overflow for example when it is prevented from wrapping",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-transform",
            "browsers": [
                "O10.5"
            ],
            "values": [
                {
                    "name": "matrix()",
                    "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
                },
                {
                    "name": "matrix3d()",
                    "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
                },
                {
                    "name": "none"
                },
                {
                    "name": "rotate()",
                    "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
                },
                {
                    "name": "rotate3d()",
                    "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
                },
                {
                    "name": "rotateX('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the X axis."
                },
                {
                    "name": "rotateY('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Y axis."
                },
                {
                    "name": "rotateZ('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Z axis."
                },
                {
                    "name": "scale()",
                    "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
                },
                {
                    "name": "scale3d()",
                    "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
                },
                {
                    "name": "scaleX()",
                    "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
                },
                {
                    "name": "scaleY()",
                    "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
                },
                {
                    "name": "scaleZ()",
                    "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
                },
                {
                    "name": "skew()",
                    "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
                },
                {
                    "name": "skewX()",
                    "description": "Specifies a skew transformation along the X axis by the given angle."
                },
                {
                    "name": "skewY()",
                    "description": "Specifies a skew transformation along the Y axis by the given angle."
                },
                {
                    "name": "translate()",
                    "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
                },
                {
                    "name": "translate3d()",
                    "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
                },
                {
                    "name": "translateX()",
                    "description": "Specifies a translation by the given amount in the X direction."
                },
                {
                    "name": "translateY()",
                    "description": "Specifies a translation by the given amount in the Y direction."
                },
                {
                    "name": "translateZ()",
                    "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
                }
            ],
            "relevance": 50,
            "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "-o-transform-origin",
            "browsers": [
                "O10.5"
            ],
            "relevance": 50,
            "description": "Establishes the origin of transformation for an element.",
            "restrictions": [
                "positon",
                "length",
                "percentage"
            ]
        },
        {
            "name": "-o-transition",
            "browsers": [
                "O11.5"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "relevance": 50,
            "description": "Shorthand property combines four of the transition properties into a single property.",
            "restrictions": [
                "time",
                "property",
                "timing-function",
                "enum"
            ]
        },
        {
            "name": "-o-transition-delay",
            "browsers": [
                "O11.5"
            ],
            "relevance": 50,
            "description": "Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-o-transition-duration",
            "browsers": [
                "O11.5"
            ],
            "relevance": 50,
            "description": "Specifies how long the transition from the old value to the new value should take.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "-o-transition-property",
            "browsers": [
                "O11.5"
            ],
            "values": [
                {
                    "name": "all",
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "description": "No property will transition."
                }
            ],
            "relevance": 50,
            "description": "Specifies the name of the CSS property to which the transition is applied.",
            "restrictions": [
                "property"
            ]
        },
        {
            "name": "-o-transition-timing-function",
            "browsers": [
                "O11.5"
            ],
            "relevance": 50,
            "description": "Describes how the intermediate values used during a transition will be calculated.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "offset-block-end",
            "browsers": [
                "FF41"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
                }
            ],
            "relevance": 50,
            "description": "Logical 'bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "offset-block-start",
            "browsers": [
                "FF41"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
                }
            ],
            "relevance": 50,
            "description": "Logical 'top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "offset-inline-end",
            "browsers": [
                "FF41"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
                }
            ],
            "relevance": 50,
            "description": "Logical 'right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "offset-inline-start",
            "browsers": [
                "FF41"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
                }
            ],
            "relevance": 50,
            "description": "Logical 'left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "outline",
            "browsers": [
                "E94",
                "FF88",
                "FFA88",
                "S16.4",
                "SM16.4",
                "C94",
                "CA94",
                "IE8",
                "O80"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Permits the user agent to render a custom outline style, typically the default platform style."
                },
                {
                    "name": "invert",
                    "browsers": [
                        "E94",
                        "FF88",
                        "FFA88",
                        "S16.4",
                        "SM16.4",
                        "C94",
                        "CA94",
                        "IE8",
                        "O80"
                    ],
                    "description": "Performs a color inversion on the pixels on the screen."
                }
            ],
            "syntax": "<'outline-width'> || <'outline-style'> || <'outline-color'>",
            "relevance": 88,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/outline"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2023-03-27",
                "baseline_high_date": "2025-09-27"
            },
            "description": "Shorthand property for 'outline-style', 'outline-width', and 'outline-color'.",
            "restrictions": [
                "length",
                "line-width",
                "line-style",
                "color",
                "enum"
            ]
        },
        {
            "name": "outline-color",
            "browsers": [
                "E12",
                "FF1.5",
                "FFA4",
                "S1.2",
                "SM1",
                "C1",
                "CA18",
                "IE8",
                "O7"
            ],
            "values": [
                {
                    "name": "invert",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE8",
                        "O7"
                    ],
                    "description": "Performs a color inversion on the pixels on the screen."
                }
            ],
            "syntax": "auto | <color>",
            "relevance": 63,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/outline-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "The color of the outline.",
            "restrictions": [
                "enum",
                "color"
            ]
        },
        {
            "name": "outline-offset",
            "browsers": [
                "E15",
                "FF1.5",
                "FFA4",
                "S1.2",
                "SM1",
                "C1",
                "CA18",
                "O9.5"
            ],
            "syntax": "<length>",
            "relevance": 71,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/outline-offset"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Offset the outline and draw it beyond the border edge.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "outline-style",
            "browsers": [
                "E12",
                "FF1.5",
                "FFA4",
                "S1.2",
                "SM1",
                "C1",
                "CA18",
                "IE8",
                "O7"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Permits the user agent to render a custom outline style, typically the default platform style."
                }
            ],
            "syntax": "auto | <outline-line-style>",
            "relevance": 61,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/outline-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Style of the outline.",
            "restrictions": [
                "line-style",
                "enum"
            ]
        },
        {
            "name": "outline-width",
            "browsers": [
                "E12",
                "FF1.5",
                "FFA4",
                "S1.2",
                "SM1",
                "C1",
                "CA18",
                "IE8",
                "O7"
            ],
            "syntax": "<line-width>",
            "relevance": 64,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/outline-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Width of the outline.",
            "restrictions": [
                "length",
                "line-width"
            ]
        },
        {
            "name": "overflow",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
                },
                {
                    "name": "hidden",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
                },
                {
                    "name": "-moz-hidden-unscrollable",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "description": "Same as the standardized 'clip', except doesn't establish a block formatting context."
                },
                {
                    "name": "scroll",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
                },
                {
                    "name": "visible",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Content is not clipped, i.e., it may be rendered outside the content box."
                }
            ],
            "syntax": "[ visible | hidden | clip | scroll | auto ]{1,2}",
            "relevance": 93,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/overflow"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand for setting 'overflow-x' and 'overflow-y'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "overflow-wrap",
            "browsers": [
                "E18",
                "FF49",
                "FFA49",
                "S7",
                "SM7",
                "C23",
                "CA25",
                "IE5.5",
                "O12.1"
            ],
            "values": [
                {
                    "name": "break-word",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE5.5",
                        "O10.5"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Lines may break only at allowed break points."
                },
                {
                    "name": "anywhere",
                    "browsers": [
                        "E80",
                        "FF65",
                        "FFA65",
                        "S15.4",
                        "SM15.4",
                        "C80",
                        "CA80",
                        "O67"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "There is a soft wrap opportunity around every typographic character unit, including around any punctuation character or preserved white spaces, or in the middle of words, disregarding any prohibition against line breaks, even those introduced by characters with the GL, WJ, or ZWJ line breaking classes or mandated by the word-break property."
                }
            ],
            "syntax": "normal | break-word | anywhere",
            "relevance": 69,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/overflow-wrap"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2018-10-02",
                "baseline_high_date": "2021-04-02"
            },
            "description": "Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit within the line box.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "overflow-x",
            "browsers": [
                "E12",
                "FF3.5",
                "FFA4",
                "S3",
                "SM1",
                "C1",
                "CA18",
                "IE5",
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
                },
                {
                    "name": "hidden",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
                },
                {
                    "name": "scroll",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
                },
                {
                    "name": "visible",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Content is not clipped, i.e., it may be rendered outside the content box."
                }
            ],
            "syntax": "visible | hidden | clip | scroll | auto",
            "relevance": 82,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/overflow-x"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the handling of overflow in the horizontal direction.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "overflow-y",
            "browsers": [
                "E12",
                "FF3.5",
                "FFA4",
                "S3",
                "SM1",
                "C1",
                "CA18",
                "IE5",
                "O9.5"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
                },
                {
                    "name": "hidden",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
                },
                {
                    "name": "scroll",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
                },
                {
                    "name": "visible",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Content is not clipped, i.e., it may be rendered outside the content box."
                }
            ],
            "syntax": "visible | hidden | clip | scroll | auto",
            "relevance": 83,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/overflow-y"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the handling of overflow in the vertical direction.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "pad",
            "browsers": [
                "FF33"
            ],
            "atRule": "@counter-style",
            "syntax": "<integer [0,∞]> && <symbol>",
            "relevance": 50,
            "description": "@counter-style descriptor. Specifies a \"fixed-width\" counter style, where representations shorter than the pad value are padded with a particular <symbol>",
            "restrictions": [
                "integer",
                "image",
                "string",
                "identifier"
            ]
        },
        {
            "name": "padding",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "values": [],
            "syntax": "<'padding-top'>{1,4}",
            "relevance": 95,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/padding"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-bottom",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<length-percentage [0,∞]>",
            "relevance": 89,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/padding-bottom"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-block-end",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'padding-top'>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/padding-block-end"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'padding-bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-block-start",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'padding-top'>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/padding-block-start"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'padding-top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-inline-end",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'padding-top'>",
            "relevance": 59,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/padding-inline-end"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'padding-right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-inline-start",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S12.1",
                "SM12.2",
                "C69",
                "CA69",
                "O56"
            ],
            "syntax": "<'padding-top'>",
            "relevance": 61,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/padding-inline-start"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Logical 'padding-left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-left",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<length-percentage [0,∞]>",
            "relevance": 89,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/padding-left"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-right",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<length-percentage [0,∞]>",
            "relevance": 89,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/padding-right"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "padding-top",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O3.5"
            ],
            "syntax": "<length-percentage [0,∞]>",
            "relevance": 89,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/padding-top"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "page-break-after",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1.2",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "always",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Always force a page break after the generated box."
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Neither force nor forbid a page break after generated box."
                },
                {
                    "name": "avoid",
                    "browsers": [
                        "E12",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Avoid a page break after the generated box."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Force one or two page breaks after the generated box so that the next page is formatted as a left page."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Force one or two page breaks after the generated box so that the next page is formatted as a right page."
                }
            ],
            "status": "obsolete",
            "syntax": "auto | always | avoid | left | right | recto | verso",
            "relevance": 1,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/page-break-after"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Defines rules for page breaks after an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "page-break-before",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1.2",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "always",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Always force a page break before the generated box."
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Neither force nor forbid a page break before the generated box."
                },
                {
                    "name": "avoid",
                    "browsers": [
                        "E12",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Avoid a page break before the generated box."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Force one or two page breaks before the generated box so that the next page is formatted as a left page."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.2",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Force one or two page breaks before the generated box so that the next page is formatted as a right page."
                }
            ],
            "status": "obsolete",
            "syntax": "auto | always | avoid | left | right | recto | verso",
            "relevance": 0,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/page-break-before"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Defines rules for page breaks before an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "page-break-inside",
            "browsers": [
                "E12",
                "FF19",
                "FFA19",
                "S1.3",
                "SM1",
                "C1",
                "CA18",
                "IE8",
                "O7"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF19",
                        "FFA19",
                        "S1.3",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Neither force nor forbid a page break inside the generated box."
                },
                {
                    "name": "avoid",
                    "browsers": [
                        "E12",
                        "FF19",
                        "FFA19",
                        "S1.3",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Avoid a page break inside the generated box."
                }
            ],
            "status": "obsolete",
            "syntax": "auto | avoid",
            "relevance": 2,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/page-break-inside"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Defines rules for page breaks inside an element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "paint-order",
            "browsers": [
                "E123",
                "FF60",
                "FFA60",
                "S11",
                "SM11",
                "C123",
                "CA123",
                "O109"
            ],
            "values": [
                {
                    "name": "fill",
                    "browsers": [
                        "E79",
                        "FF60",
                        "FFA60",
                        "S8",
                        "SM8",
                        "C35",
                        "CA35",
                        "O22"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "markers",
                    "browsers": [
                        "E79",
                        "FF60",
                        "FFA60",
                        "S8",
                        "SM8",
                        "C35",
                        "CA35",
                        "O22"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E79",
                        "FF60",
                        "FFA60",
                        "S8",
                        "SM8",
                        "C35",
                        "CA35",
                        "O22"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The element is painted with the standard order of painting operations: the 'fill' is painted first, then its 'stroke' and finally its markers."
                },
                {
                    "name": "stroke",
                    "browsers": [
                        "E79",
                        "FF60",
                        "FFA60",
                        "S8",
                        "SM8",
                        "C35",
                        "CA35",
                        "O22"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                }
            ],
            "syntax": "normal | [ fill || stroke || markers ]",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/paint-order"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2024-03-22"
            },
            "description": "Controls the order that the three paint operations that shapes and text are rendered with: their fill, their stroke and any markers they might have.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "perspective",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C36",
                "CA36",
                "IE10",
                "O23"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF10",
                        "FFA10",
                        "S4",
                        "SM3.2",
                        "C12",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No perspective transform is applied."
                }
            ],
            "syntax": "none | <length>",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/perspective"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",
            "restrictions": [
                "length",
                "enum"
            ]
        },
        {
            "name": "perspective-origin",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C36",
                "CA36",
                "IE10",
                "O23"
            ],
            "syntax": "<position>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/perspective-origin"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",
            "restrictions": [
                "position",
                "percentage",
                "length"
            ]
        },
        {
            "name": "pointer-events",
            "browsers": [
                "E12",
                "FF1.5",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "IE11",
                "O9"
            ],
            "values": [
                {
                    "name": "all",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The given element can be the target element for pointer events whenever the pointer is over either the interior or the perimeter of the element."
                },
                {
                    "name": "fill",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The given element can be the target element for pointer events whenever the pointer is over the interior of the element."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The given element does not receive pointer events."
                },
                {
                    "name": "painted",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The given element can be the target element for pointer events when the pointer is over a \"painted\" area. "
                },
                {
                    "name": "stroke",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The given element can be the target element for pointer events whenever the pointer is over the perimeter of the element."
                },
                {
                    "name": "visible",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The given element can be the target element for pointer events when the 'visibility' property is set to visible and the pointer is over either the interior or the perimeter of the element."
                },
                {
                    "name": "visibleFill",
                    "browsers": [
                        "E12",
                        "FF50",
                        "FFA50",
                        "S4",
                        "SM3.2",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-11-15",
                        "baseline_high_date": "2019-05-15"
                    },
                    "description": "The given element can be the target element for pointer events when the 'visibility' property is set to visible and when the pointer is over the interior of the element."
                },
                {
                    "name": "visiblePainted",
                    "browsers": [
                        "E12",
                        "FF50",
                        "FFA50",
                        "S4",
                        "SM3.2",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-11-15",
                        "baseline_high_date": "2019-05-15"
                    },
                    "description": "The given element can be the target element for pointer events when the 'visibility' property is set to visible and when the pointer is over a 'painted' area."
                },
                {
                    "name": "visibleStroke",
                    "browsers": [
                        "E12",
                        "FF50",
                        "FFA50",
                        "S4",
                        "SM3.2",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-11-15",
                        "baseline_high_date": "2019-05-15"
                    },
                    "description": "The given element can be the target element for pointer events when the 'visibility' property is set to visible and when the pointer is over the perimeter of the element."
                }
            ],
            "syntax": "auto | none | visiblePainted | visibleFill | visibleStroke | visible | painted | fill | stroke | all | inherit",
            "relevance": 84,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/pointer-events"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies under what circumstances a given element can be the target element for a pointer event.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "position",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O4"
            ],
            "values": [
                {
                    "name": "absolute",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The box's position (and possibly size) is specified with the 'top', 'right', 'bottom', and 'left' properties. These properties specify offsets with respect to the box's 'containing block'."
                },
                {
                    "name": "fixed",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE7",
                        "O4"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The box's position is calculated according to the 'absolute' model, but in addition, the box is fixed with respect to some reference. As with the 'absolute' model, the box's margins do not collapse with any other margins."
                },
                {
                    "name": "-ms-page",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O4"
                    ],
                    "description": "The box's position is calculated according to the 'absolute' model."
                },
                {
                    "name": "relative",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The box's position is calculated according to the normal flow (this is called the position in normal flow). Then the box is offset relative to its normal position."
                },
                {
                    "name": "static",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The box is a normal box, laid out according to the normal flow. The 'top', 'right', 'bottom', and 'left' properties do not apply."
                },
                {
                    "name": "sticky",
                    "browsers": [
                        "E16",
                        "FF32",
                        "FFA32",
                        "S13",
                        "SM13",
                        "C56",
                        "CA56",
                        "O43"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2019-09-19",
                        "baseline_high_date": "2022-03-19"
                    },
                    "description": "The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."
                },
                {
                    "name": "-webkit-sticky",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O4"
                    ],
                    "description": "The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."
                }
            ],
            "syntax": "static | relative | absolute | sticky | fixed",
            "relevance": 95,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/position"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "The position CSS property sets how an element is positioned in a document. The top, right, bottom, and left properties determine the final location of positioned elements.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "prefix",
            "browsers": [
                "FF33"
            ],
            "atRule": "@counter-style",
            "syntax": "<symbol>",
            "relevance": 50,
            "description": "@counter-style descriptor. Specifies a <symbol> that is prepended to the marker representation.",
            "restrictions": [
                "image",
                "string",
                "identifier"
            ]
        },
        {
            "name": "quotes",
            "browsers": [
                "E12",
                "FF1.5",
                "FFA4",
                "S9",
                "SM9",
                "C11",
                "CA18",
                "IE8",
                "O4"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1.5",
                        "FFA4",
                        "S9",
                        "SM9",
                        "C11",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-09-30",
                        "baseline_high_date": "2018-03-30"
                    },
                    "description": "The 'open-quote' and 'close-quote' values of the 'content' property produce no quotations marks, as if they were 'no-open-quote' and 'no-close-quote' respectively."
                }
            ],
            "syntax": "none | auto | [ <string> <string> ]+",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/quotes"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Specifies quotation marks for any number of embedded quotations.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "range",
            "browsers": [
                "FF33"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The range depends on the counter system."
                },
                {
                    "name": "infinite",
                    "description": "If used as the first value in a range, it represents negative infinity; if used as the second value, it represents positive infinity."
                }
            ],
            "atRule": "@counter-style",
            "syntax": "[ [ <integer> | infinite ]{2} ]# | auto",
            "relevance": 50,
            "description": "@counter-style descriptor. Defines the ranges over which the counter style is defined.",
            "restrictions": [
                "integer",
                "enum"
            ]
        },
        {
            "name": "resize",
            "browsers": [
                "E79",
                "FF4",
                "S3",
                "C1",
                "CA18",
                "O12.1"
            ],
            "values": [
                {
                    "name": "both",
                    "browsers": [
                        "E79",
                        "FF4",
                        "FFA4",
                        "S3",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The UA presents a bidirectional resizing mechanism to allow the user to adjust both the height and the width of the element."
                },
                {
                    "name": "horizontal",
                    "browsers": [
                        "E79",
                        "FF4",
                        "FFA4",
                        "S3",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The UA presents a unidirectional horizontal resizing mechanism to allow the user to adjust only the width of the element."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF4",
                        "FFA4",
                        "S3",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The UA does not present a resizing mechanism on the element, and the user is given no direct manipulation mechanism to resize the element."
                },
                {
                    "name": "vertical",
                    "browsers": [
                        "E79",
                        "FF4",
                        "FFA4",
                        "S3",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The UA presents a unidirectional vertical resizing mechanism to allow the user to adjust only the height of the element."
                }
            ],
            "syntax": "none | both | horizontal | vertical | block | inline",
            "relevance": 66,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/resize"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Specifies whether or not an element is resizable by the user, and if so, along which axis/axes.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "right",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5.5",
                "O5"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
                }
            ],
            "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
            "relevance": 91,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/right"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies how far an absolutely positioned box's right margin edge is offset to the left of the right edge of the box's 'containing block'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "ruby-align",
            "browsers": [
                "E128",
                "FF38",
                "FFA38",
                "S18.2",
                "SM18.2",
                "C128",
                "CA128",
                "O114"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E128",
                        "FF38",
                        "FFA38",
                        "S18.2",
                        "SM18.2",
                        "C128",
                        "CA128",
                        "O114"
                    ],
                    "description": "The user agent determines how the ruby contents are aligned. This is the initial value."
                },
                {
                    "name": "center",
                    "browsers": [
                        "E128",
                        "FF38",
                        "FFA38",
                        "S18.2",
                        "SM18.2",
                        "C128",
                        "CA128",
                        "O114"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2024-12-11"
                    },
                    "description": "The ruby content is centered within its box."
                },
                {
                    "name": "distribute-letter",
                    "browsers": [
                        "E128",
                        "FF38",
                        "FFA38",
                        "S18.2",
                        "SM18.2",
                        "C128",
                        "CA128",
                        "O114"
                    ],
                    "description": "If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with the first and last ruby text glyphs lining up with the corresponding first and last base glyphs. If the width of the ruby text is at least the width of the base, then the letters of the base are evenly distributed across the width of the ruby text."
                },
                {
                    "name": "distribute-space",
                    "browsers": [
                        "E128",
                        "FF38",
                        "FFA38",
                        "S18.2",
                        "SM18.2",
                        "C128",
                        "CA128",
                        "O114"
                    ],
                    "description": "If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with a certain amount of white space preceding the first and following the last character in the ruby text. That amount of white space is normally equal to half the amount of inter-character space of the ruby text."
                },
                {
                    "name": "left",
                    "description": "The ruby text content is aligned with the start edge of the base."
                },
                {
                    "name": "line-edge",
                    "browsers": [
                        "E128",
                        "FF38",
                        "FFA38",
                        "S18.2",
                        "SM18.2",
                        "C128",
                        "CA128",
                        "O114"
                    ],
                    "description": "If the ruby text is not adjacent to a line edge, it is aligned as in 'auto'. If it is adjacent to a line edge, then it is still aligned as in auto, but the side of the ruby text that touches the end of the line is lined up with the corresponding edge of the base."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E128",
                        "FF38",
                        "FFA38",
                        "S18.2",
                        "SM18.2",
                        "C128",
                        "CA128",
                        "O114"
                    ],
                    "description": "The ruby text content is aligned with the end edge of the base."
                },
                {
                    "name": "start",
                    "browsers": [
                        "E128",
                        "FF38",
                        "FFA38",
                        "S18.2",
                        "SM18.2",
                        "C128",
                        "CA128",
                        "O114"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2024-12-11"
                    },
                    "description": "The ruby text content is aligned with the start edge of the base."
                },
                {
                    "name": "space-between",
                    "browsers": [
                        "E128",
                        "FF38",
                        "FFA38",
                        "S18.2",
                        "SM18.2",
                        "C128",
                        "CA128",
                        "O114"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2024-12-11"
                    },
                    "description": "The ruby content expands as defined for normal text justification (as defined by 'text-justify'),"
                },
                {
                    "name": "space-around",
                    "browsers": [
                        "E128",
                        "FF38",
                        "FFA38",
                        "S18.2",
                        "SM18.2",
                        "C128",
                        "CA128",
                        "O114"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2024-12-11"
                    },
                    "description": "As for 'space-between' except that there exists an extra justification opportunities whose space is distributed half before and half after the ruby content."
                }
            ],
            "syntax": "start | center | space-between | space-around",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/ruby-align"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2024-12-11"
            },
            "description": "Specifies how text is distributed within the various ruby boxes when their contents do not exactly fill their respective boxes.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "ruby-overhang",
            "browsers": [
                "S18.2",
                "SM18.2"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "S18.2",
                        "SM18.2"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The ruby text can overhang text adjacent to the base on either side. This is the initial value."
                },
                {
                    "name": "end",
                    "description": "The ruby text can overhang the text that follows it."
                },
                {
                    "name": "none",
                    "browsers": [
                        "S18.2",
                        "SM18.2"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The ruby text cannot overhang any text adjacent to its base, only its own base."
                },
                {
                    "name": "start",
                    "description": "The ruby text can overhang the text that precedes it."
                }
            ],
            "syntax": "auto | none",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/ruby-overhang"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "ruby-position",
            "browsers": [
                "E84",
                "FF38",
                "FFA38",
                "S18.2",
                "SM18.2",
                "C84",
                "CA84",
                "O70"
            ],
            "values": [
                {
                    "name": "after",
                    "description": "The ruby text appears after the base. This is a relatively rare setting used in ideographic East Asian writing systems, most easily found in educational text."
                },
                {
                    "name": "before",
                    "description": "The ruby text appears before the base. This is the most common setting used in ideographic East Asian writing systems."
                },
                {
                    "name": "inline"
                },
                {
                    "name": "right",
                    "description": "The ruby text appears on the right of the base. Unlike 'before' and 'after', this value is not relative to the text flow direction."
                }
            ],
            "syntax": "[ alternate || [ over | under ] ] | inter-character",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/ruby-position"
                }
            ],
            "baseline": {
                "status": "low",
                "baseline_low_date": "2024-12-11"
            },
            "description": "Used by the parent of elements with display: ruby-text to control the position of the ruby text with respect to its base.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "ruby-span",
            "browsers": [
                "FF10"
            ],
            "values": [
                {
                    "name": "attr(x)",
                    "description": "The value of attribute 'x' is a string value. The string value is evaluated as a <number> to determine the number of ruby base elements to be spanned by the annotation element."
                },
                {
                    "name": "none",
                    "description": "No spanning. The computed value is '1'."
                }
            ],
            "relevance": 50,
            "description": "Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "scrollbar-3dlight-color",
            "browsers": [
                "IE6"
            ],
            "relevance": 50,
            "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "scrollbar-arrow-color",
            "browsers": [
                "IE6"
            ],
            "relevance": 50,
            "description": "Determines the color of the arrow elements of a scroll arrow.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "scrollbar-base-color",
            "browsers": [
                "IE6"
            ],
            "relevance": 50,
            "description": "Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "scrollbar-darkshadow-color",
            "browsers": [
                "IE6"
            ],
            "relevance": 50,
            "description": "Determines the color of the gutter of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "scrollbar-face-color",
            "browsers": [
                "IE6"
            ],
            "relevance": 50,
            "description": "Determines the color of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "scrollbar-highlight-color",
            "browsers": [
                "IE6"
            ],
            "relevance": 50,
            "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "scrollbar-shadow-color",
            "browsers": [
                "IE6"
            ],
            "relevance": 50,
            "description": "Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "scrollbar-track-color",
            "browsers": [
                "IE6"
            ],
            "relevance": 50,
            "description": "Determines the color of the track element of a scroll bar.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "scroll-behavior",
            "browsers": [
                "E79",
                "FF36",
                "FFA36",
                "S15.4",
                "SM15.4",
                "C61",
                "CA61",
                "O48"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF36",
                        "FFA36",
                        "S15.4",
                        "SM15.4",
                        "C61",
                        "CA61",
                        "O48"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "Scrolls in an instant fashion."
                },
                {
                    "name": "smooth",
                    "browsers": [
                        "E79",
                        "FF36",
                        "FFA36",
                        "S15.4",
                        "SM15.4",
                        "C61",
                        "CA61",
                        "O48"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-03-14",
                        "baseline_high_date": "2024-09-14"
                    },
                    "description": "Scrolls in a smooth fashion using a user-agent-defined timing function and time period."
                }
            ],
            "syntax": "auto | smooth",
            "relevance": 60,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/scroll-behavior"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2022-03-14",
                "baseline_high_date": "2024-09-14"
            },
            "description": "Specifies the scrolling behavior for a scrolling box, when scrolling happens due to navigation or CSSOM scrolling APIs.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "scroll-snap-coordinate",
            "browsers": [
                "FF39"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "Specifies that this element does not contribute a snap point."
                }
            ],
            "status": "obsolete",
            "syntax": "none | <position>#",
            "relevance": 0,
            "description": "Defines the x and y coordinate within the element which will align with the nearest ancestor scroll container's snap-destination for the respective axis.",
            "restrictions": [
                "position",
                "length",
                "percentage",
                "enum"
            ]
        },
        {
            "name": "scroll-snap-destination",
            "browsers": [
                "FF39"
            ],
            "status": "obsolete",
            "syntax": "<position>",
            "relevance": 0,
            "description": "Define the x and y coordinate within the scroll container's visual viewport which element snap points will align with.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "scroll-snap-points-x",
            "browsers": [
                "FF39"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No snap points are defined by this scroll container."
                },
                {
                    "name": "repeat()",
                    "description": "Defines an interval at which snap points are defined, starting from the container's relevant start edge."
                }
            ],
            "status": "obsolete",
            "syntax": "none | repeat( <length-percentage> )",
            "relevance": 0,
            "description": "Defines the positioning of snap points along the x axis of the scroll container it is applied to.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "scroll-snap-points-y",
            "browsers": [
                "FF39"
            ],
            "values": [
                {
                    "name": "none",
                    "description": "No snap points are defined by this scroll container."
                },
                {
                    "name": "repeat()",
                    "description": "Defines an interval at which snap points are defined, starting from the container's relevant start edge."
                }
            ],
            "status": "obsolete",
            "syntax": "none | repeat( <length-percentage> )",
            "relevance": 0,
            "description": "Defines the positioning of snap points along the y axis of the scroll container it is applied to.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "scroll-snap-type",
            "browsers": [
                "E79",
                "FF99",
                "FFA68",
                "S11",
                "SM11",
                "C69",
                "CA69",
                "IE10",
                "O56"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF39",
                        "FFA39",
                        "S11",
                        "SM11",
                        "C69",
                        "CA69",
                        "O56"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The visual viewport of this scroll container must ignore snap points, if any, when scrolled."
                },
                {
                    "name": "mandatory",
                    "description": "The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."
                },
                {
                    "name": "proximity",
                    "description": "The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."
                }
            ],
            "syntax": "none | [ x | y | block | inline | both ] [ mandatory | proximity ]?",
            "relevance": 58,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/scroll-snap-type"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2022-04-05",
                "baseline_high_date": "2024-10-05"
            },
            "description": "Defines how strictly snap points are enforced on the scroll container.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "shape-image-threshold",
            "browsers": [
                "E79",
                "FF62",
                "FFA62",
                "S10.1",
                "SM10.3",
                "C37",
                "CA37",
                "O24"
            ],
            "syntax": "<opacity-value>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/shape-image-threshold"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Defines the alpha channel threshold used to extract the shape using an image. A value of 0.5 means that the shape will enclose all the pixels that are more than 50% opaque.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "shape-margin",
            "browsers": [
                "E79",
                "FF62",
                "FFA62",
                "S10.1",
                "SM10.3",
                "C37",
                "CA37",
                "O24"
            ],
            "syntax": "<length-percentage>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/shape-margin"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Adds a margin to a 'shape-outside'. This defines a new shape that is the smallest contour that includes all the points that are the 'shape-margin' distance outward in the perpendicular direction from a point on the underlying shape.",
            "restrictions": [
                "url",
                "length",
                "percentage"
            ]
        },
        {
            "name": "shape-outside",
            "browsers": [
                "E79",
                "FF62",
                "FFA62",
                "S10.1",
                "SM10.3",
                "C37",
                "CA37",
                "O24"
            ],
            "values": [
                {
                    "name": "margin-box",
                    "browsers": [
                        "E79",
                        "FF62",
                        "FFA62",
                        "S10.1",
                        "SM10.3",
                        "C37",
                        "CA37",
                        "O24"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The background is painted within (clipped to) the margin box."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF62",
                        "FFA62",
                        "S10.1",
                        "SM10.3",
                        "C37",
                        "CA37",
                        "O24"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The float area is unaffected."
                }
            ],
            "syntax": "none | [ <shape-box> || <basic-shape> ] | <image>",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/shape-outside"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies an orthogonal rotation to be applied to an image before it is laid out.",
            "restrictions": [
                "image",
                "box",
                "shape",
                "enum"
            ]
        },
        {
            "name": "shape-rendering",
            "browsers": [
                "E79",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Suppresses aural rendering."
                },
                {
                    "name": "crispEdges",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S4",
                        "SM3.2",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Emphasize the contrast between clean edges of artwork over rendering speed and geometric precision."
                },
                {
                    "name": "geometricPrecision",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S4",
                        "SM3.2",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Emphasize geometric precision over speed and crisp edges."
                },
                {
                    "name": "optimizeSpeed",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S4",
                        "SM3.2",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Emphasize rendering speed over geometric precision and crisp edges."
                }
            ],
            "syntax": "auto | optimizeSpeed | crispEdges | geometricPrecision",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/shape-rendering"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Provides hints about what tradeoffs to make as it renders vector graphics elements such as <path> elements and basic shapes such as circles and rectangles.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "size",
            "browsers": [
                "C",
                "O8"
            ],
            "atRule": "@page",
            "syntax": "<length [0,∞]>{1,2} | auto | [ <page-size> || [ portrait | landscape ] ]",
            "relevance": 53,
            "description": "The size CSS at-rule descriptor, used with the @page at-rule, defines the size and orientation of the box which is used to represent a page. Most of the time, this size corresponds to the target size of the printed page if applicable.",
            "restrictions": [
                "length"
            ]
        },
        {
            "name": "src",
            "values": [
                {
                    "name": "url()",
                    "description": "Reference font by URL"
                },
                {
                    "name": "format()",
                    "description": "Optional hint describing the format of the font resource."
                },
                {
                    "name": "local()",
                    "description": "Format-specific string that identifies a locally available copy of a given font."
                }
            ],
            "atRule": "@font-face",
            "syntax": "[ <url> [ format( <string># ) ]? | local( <family-name> ) ]#",
            "relevance": 85,
            "description": "@font-face descriptor. Specifies the resource containing font data. It is required, whether the font is downloadable or locally installed.",
            "restrictions": [
                "enum",
                "url",
                "identifier"
            ]
        },
        {
            "name": "stop-color",
            "browsers": [
                "E15",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "syntax": "<'color'>",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stop-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Indicates what color to use at that gradient stop.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "stop-opacity",
            "browsers": [
                "E15",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "syntax": "<'opacity'>",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stop-opacity"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Defines the opacity of a given gradient stop.",
            "restrictions": [
                "number(0-1)"
            ]
        },
        {
            "name": "stroke",
            "browsers": [
                "E15",
                "FF1.5",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "url()",
                    "description": "A URL reference to a paint server element, which is an element that defines a paint server: 'hatch', 'linearGradient', 'mesh', 'pattern', 'radialGradient' and 'solidcolor'."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E15",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "No paint is applied in this layer."
                }
            ],
            "syntax": "<paint>",
            "relevance": 69,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stroke"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Paints along the outline of the given graphical element.",
            "restrictions": [
                "color",
                "enum",
                "url"
            ]
        },
        {
            "name": "stroke-dasharray",
            "browsers": [
                "E15",
                "FF1.5",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E15",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that no dashing is used."
                }
            ],
            "syntax": "none | <dasharray>",
            "relevance": 63,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stroke-dasharray"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Controls the pattern of dashes and gaps used to stroke paths.",
            "restrictions": [
                "length",
                "percentage",
                "number",
                "enum"
            ]
        },
        {
            "name": "stroke-dashoffset",
            "browsers": [
                "E15",
                "FF1.5",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "syntax": "<length-percentage> | <number>",
            "relevance": 64,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stroke-dashoffset"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the distance into the dash pattern to start the dash.",
            "restrictions": [
                "percentage",
                "length"
            ]
        },
        {
            "name": "stroke-linecap",
            "browsers": [
                "E15",
                "FF1.5",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "butt",
                    "browsers": [
                        "E15",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that the stroke for each subpath does not extend beyond its two endpoints."
                },
                {
                    "name": "round",
                    "browsers": [
                        "E15",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that at each end of each subpath, the shape representing the stroke will be extended by a half circle with a radius equal to the stroke width."
                },
                {
                    "name": "square",
                    "browsers": [
                        "E15",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that at the end of each subpath, the shape representing the stroke will be extended by a rectangle with the same width as the stroke width and whose length is half of the stroke width."
                }
            ],
            "syntax": "butt | round | square",
            "relevance": 55,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stroke-linecap"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the shape to be used at the end of open subpaths when they are stroked.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "stroke-linejoin",
            "browsers": [
                "E15",
                "FF1.5",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "bevel",
                    "browsers": [
                        "E15",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that a bevelled corner is to be used to join path segments."
                },
                {
                    "name": "miter",
                    "browsers": [
                        "E15",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that a sharp corner is to be used to join path segments."
                },
                {
                    "name": "round",
                    "browsers": [
                        "E15",
                        "FF1.5",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2017-04-05",
                        "baseline_high_date": "2019-10-05"
                    },
                    "description": "Indicates that a round corner is to be used to join path segments."
                }
            ],
            "syntax": "miter | miter-clip | round | bevel | arcs",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stroke-linejoin"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the shape to be used at the corners of paths or basic shapes when they are stroked.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "stroke-miterlimit",
            "browsers": [
                "E15",
                "FF1.5",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "syntax": "<number>",
            "relevance": 54,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stroke-miterlimit"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "When two line segments meet at a sharp angle and miter joins have been specified for 'stroke-linejoin', it is possible for the miter to extend far beyond the thickness of the line stroking the path.",
            "restrictions": [
                "number"
            ]
        },
        {
            "name": "stroke-opacity",
            "browsers": [
                "E15",
                "FF1.5",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "syntax": "<'opacity'>",
            "relevance": 53,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stroke-opacity"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the opacity of the painting operation used to stroke the current object.",
            "restrictions": [
                "number(0-1)"
            ]
        },
        {
            "name": "stroke-width",
            "browsers": [
                "E15",
                "FF1.5",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "syntax": "<length-percentage> | <number>",
            "relevance": 71,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/stroke-width"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2017-04-05",
                "baseline_high_date": "2019-10-05"
            },
            "description": "Specifies the width of the stroke on the current object.",
            "restrictions": [
                "percentage",
                "length"
            ]
        },
        {
            "name": "suffix",
            "browsers": [
                "FF33"
            ],
            "atRule": "@counter-style",
            "syntax": "<symbol>",
            "relevance": 50,
            "description": "@counter-style descriptor. Specifies a <symbol> that is appended to the marker representation.",
            "restrictions": [
                "image",
                "string",
                "identifier"
            ]
        },
        {
            "name": "system",
            "browsers": [
                "FF33"
            ],
            "values": [
                {
                    "name": "additive",
                    "description": "Represents \"sign-value\" numbering systems, which, rather than using reusing digits in different positions to change their value, define additional digits with much larger values, so that the value of the number can be obtained by adding all the digits together."
                },
                {
                    "name": "alphabetic",
                    "description": "Interprets the list of counter symbols as digits to an alphabetic numbering system, similar to the default lower-alpha counter style, which wraps from \"a\", \"b\", \"c\", to \"aa\", \"ab\", \"ac\"."
                },
                {
                    "name": "cyclic",
                    "description": "Cycles repeatedly through its provided symbols, looping back to the beginning when it reaches the end of the list."
                },
                {
                    "name": "extends",
                    "description": "Use the algorithm of another counter style, but alter other aspects."
                },
                {
                    "name": "fixed",
                    "description": "Runs through its list of counter symbols once, then falls back."
                },
                {
                    "name": "numeric",
                    "description": "interprets the list of counter symbols as digits to a \"place-value\" numbering system, similar to the default 'decimal' counter style."
                },
                {
                    "name": "symbolic",
                    "description": "Cycles repeatedly through its provided symbols, doubling, tripling, etc. the symbols on each successive pass through the list."
                }
            ],
            "atRule": "@counter-style",
            "syntax": "cyclic | numeric | alphabetic | symbolic | additive | [ fixed <integer>? ] | [ extends <counter-style-name> ]",
            "relevance": 50,
            "description": "@counter-style descriptor. Specifies which algorithm will be used to construct the counter's representation based on the counter value.",
            "restrictions": [
                "enum",
                "integer"
            ]
        },
        {
            "name": "symbols",
            "browsers": [
                "FF33"
            ],
            "atRule": "@counter-style",
            "syntax": "<symbol>+",
            "relevance": 50,
            "description": "@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor.",
            "restrictions": [
                "image",
                "string",
                "identifier"
            ]
        },
        {
            "name": "table-layout",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM3",
                "C14",
                "CA18",
                "IE5",
                "O7"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM3",
                        "C14",
                        "CA18",
                        "IE5",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Use any automatic table layout algorithm."
                },
                {
                    "name": "fixed",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM3",
                        "C14",
                        "CA18",
                        "IE5",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Use the fixed table layout algorithm."
                }
            ],
            "syntax": "auto | fixed",
            "relevance": 59,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/table-layout"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Controls the algorithm used to lay out the table cells, rows, and columns.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "tab-size",
            "browsers": [
                "E79",
                "FF91",
                "FFA91",
                "S7",
                "SM7",
                "C21",
                "CA25",
                "O15"
            ],
            "syntax": "<integer> | <length>",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/tab-size"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2021-08-10",
                "baseline_high_date": "2024-02-10"
            },
            "description": "Determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",
            "restrictions": [
                "integer",
                "length"
            ]
        },
        {
            "name": "text-align",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "center",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The inline contents are centered within the line box."
                },
                {
                    "name": "end",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S3.1",
                        "SM2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The inline contents are aligned to the end edge of the line box."
                },
                {
                    "name": "justify",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The text is justified according to the method specified by the 'text-justify' property."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
                },
                {
                    "name": "start",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S3.1",
                        "SM2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The inline contents are aligned to the start edge of the line box."
                }
            ],
            "syntax": "start | end | left | right | center | justify | match-parent",
            "relevance": 93,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-align"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Describes how inline contents of a block are horizontally aligned if the contents do not completely fill the line box.",
            "restrictions": [
                "string"
            ]
        },
        {
            "name": "text-align-last",
            "browsers": [
                "E12",
                "FF49",
                "FFA49",
                "S16",
                "SM16",
                "C47",
                "CA47",
                "IE5.5",
                "O34"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF12",
                        "FFA14",
                        "S16",
                        "SM16",
                        "C47",
                        "CA47",
                        "IE11",
                        "O34"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-09-12",
                        "baseline_high_date": "2025-03-12"
                    },
                    "description": "Content on the affected line is aligned per 'text-align' unless 'text-align' is set to 'justify', in which case it is 'start-aligned'."
                },
                {
                    "name": "center",
                    "browsers": [
                        "E12",
                        "FF12",
                        "FFA14",
                        "S16",
                        "SM16",
                        "C47",
                        "CA47",
                        "O34"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-09-12",
                        "baseline_high_date": "2025-03-12"
                    },
                    "description": "The inline contents are centered within the line box."
                },
                {
                    "name": "justify",
                    "browsers": [
                        "E12",
                        "FF12",
                        "FFA14",
                        "S16",
                        "SM16",
                        "C47",
                        "CA47",
                        "O34"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-09-12",
                        "baseline_high_date": "2025-03-12"
                    },
                    "description": "The text is justified according to the method specified by the 'text-justify' property."
                },
                {
                    "name": "left",
                    "browsers": [
                        "E12",
                        "FF12",
                        "FFA14",
                        "S16",
                        "SM16",
                        "C47",
                        "CA47",
                        "O34"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-09-12",
                        "baseline_high_date": "2025-03-12"
                    },
                    "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
                },
                {
                    "name": "right",
                    "browsers": [
                        "E12",
                        "FF12",
                        "FFA14",
                        "S16",
                        "SM16",
                        "C47",
                        "CA47",
                        "O34"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-09-12",
                        "baseline_high_date": "2025-03-12"
                    },
                    "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
                }
            ],
            "syntax": "auto | start | end | left | right | center | justify",
            "relevance": 51,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-align-last"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2022-09-12",
                "baseline_high_date": "2025-03-12"
            },
            "description": "Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-anchor",
            "browsers": [
                "E14",
                "FF3",
                "FFA4",
                "S4",
                "SM3.2",
                "C1",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "end",
                    "browsers": [
                        "E14",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-08-02",
                        "baseline_high_date": "2019-02-02"
                    },
                    "description": "The rendered characters are aligned such that the end of the resulting rendered text is at the initial current text position."
                },
                {
                    "name": "middle",
                    "browsers": [
                        "E14",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-08-02",
                        "baseline_high_date": "2019-02-02"
                    },
                    "description": "The rendered characters are aligned such that the geometric middle of the resulting rendered text is at the initial current text position."
                },
                {
                    "name": "start",
                    "browsers": [
                        "E14",
                        "FF3",
                        "FFA4",
                        "S4",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2016-08-02",
                        "baseline_high_date": "2019-02-02"
                    },
                    "description": "The rendered characters are aligned such that the start of the resulting rendered text is at the initial current text position."
                }
            ],
            "syntax": "start | middle | end",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-anchor"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2016-08-02",
                "baseline_high_date": "2019-02-02"
            },
            "description": "Used to align (start-, middle- or end-alignment) a string of text relative to a given point.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-decoration",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [
                {
                    "name": "dashed",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S26.2",
                        "SM26.2",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2025-12-12"
                    },
                    "description": "Produces a dashed line style."
                },
                {
                    "name": "dotted",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S26.2",
                        "SM26.2",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2025-12-12"
                    },
                    "description": "Produces a dotted line."
                },
                {
                    "name": "double",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S26.2",
                        "SM26.2",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2025-12-12"
                    },
                    "description": "Produces a double line."
                },
                {
                    "name": "line-through",
                    "browsers": [
                        "E12",
                        "FF3",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Each line of text has a line through the middle."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF3",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Produces no line."
                },
                {
                    "name": "overline",
                    "browsers": [
                        "E12",
                        "FF3",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Each line of text has a line above it."
                },
                {
                    "name": "solid",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S26.2",
                        "SM26.2",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2025-12-12"
                    },
                    "description": "Produces a solid line."
                },
                {
                    "name": "underline",
                    "browsers": [
                        "E12",
                        "FF3",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Each line of text is underlined."
                },
                {
                    "name": "wavy",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S26.2",
                        "SM26.2",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "low",
                        "baseline_low_date": "2025-12-12"
                    },
                    "description": "Produces a wavy line."
                }
            ],
            "syntax": "<'text-decoration-line'> || <'text-decoration-style'> || <'text-decoration-color'> || <'text-decoration-thickness'>",
            "relevance": 92,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-decoration"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Decorations applied to font used for an element's text.",
            "restrictions": [
                "enum",
                "color"
            ]
        },
        {
            "name": "text-decoration-color",
            "browsers": [
                "E79",
                "FF36",
                "FFA36",
                "S12.1",
                "SM12.2",
                "C57",
                "CA57",
                "O44"
            ],
            "syntax": "<color>",
            "relevance": 58,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-decoration-color"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",
            "restrictions": [
                "color"
            ]
        },
        {
            "name": "text-decoration-line",
            "browsers": [
                "E79",
                "FF36",
                "FFA36",
                "S12.1",
                "SM12.2",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "line-through",
                    "browsers": [
                        "E79",
                        "FF6",
                        "FFA6",
                        "S8",
                        "SM8",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Each line of text has a line through the middle."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E79",
                        "FF6",
                        "FFA6",
                        "S8",
                        "SM8",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Neither produces nor inhibits text decoration."
                },
                {
                    "name": "overline",
                    "browsers": [
                        "E79",
                        "FF6",
                        "FFA6",
                        "S8",
                        "SM8",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Each line of text has a line above it."
                },
                {
                    "name": "underline",
                    "browsers": [
                        "E79",
                        "FF6",
                        "FFA6",
                        "S8",
                        "SM8",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Each line of text is underlined."
                }
            ],
            "syntax": "none | [ underline || overline || line-through || blink ] | spelling-error | grammar-error",
            "relevance": 61,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-decoration-line"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies what line decorations, if any, are added to the element.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-decoration-style",
            "browsers": [
                "E79",
                "FF36",
                "FFA36",
                "S12.1",
                "SM12.2",
                "C57",
                "CA57",
                "O44"
            ],
            "values": [
                {
                    "name": "dashed",
                    "browsers": [
                        "E79",
                        "FF6",
                        "FFA6",
                        "S8",
                        "SM8",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Produces a dashed line style."
                },
                {
                    "name": "dotted",
                    "browsers": [
                        "E79",
                        "FF6",
                        "FFA6",
                        "S8",
                        "SM8",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Produces a dotted line."
                },
                {
                    "name": "double",
                    "browsers": [
                        "E79",
                        "FF6",
                        "FFA6",
                        "S8",
                        "SM8",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Produces a double line."
                },
                {
                    "name": "none",
                    "description": "Produces no line."
                },
                {
                    "name": "solid",
                    "browsers": [
                        "E79",
                        "FF6",
                        "FFA6",
                        "S8",
                        "SM8",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Produces a solid line."
                },
                {
                    "name": "wavy",
                    "browsers": [
                        "E79",
                        "FF6",
                        "FFA6",
                        "S8",
                        "SM8",
                        "C57",
                        "CA57",
                        "O44"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Produces a wavy line."
                }
            ],
            "syntax": "solid | double | dotted | dashed | wavy",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-decoration-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "Specifies the line style for underline, line-through and overline text decoration.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-indent",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE3",
                "O3.5"
            ],
            "values": [],
            "syntax": "<length-percentage> && hanging? && each-line?",
            "relevance": 69,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-indent"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies the indentation applied to lines of inline content in a block. The indentation only affects the first line of inline content in the block unless the 'hanging' keyword is specified, in which case it affects all lines except the first.",
            "restrictions": [
                "percentage",
                "length"
            ]
        },
        {
            "name": "text-justify",
            "browsers": [
                "E145",
                "FF55",
                "FFA55",
                "C145",
                "CA145",
                "IE11"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E145",
                        "FF55",
                        "FFA55",
                        "C145",
                        "CA145"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."
                },
                {
                    "name": "distribute",
                    "description": "Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."
                },
                {
                    "name": "distribute-all-lines"
                },
                {
                    "name": "inter-cluster",
                    "description": "Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."
                },
                {
                    "name": "inter-ideograph",
                    "description": "Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."
                },
                {
                    "name": "inter-word",
                    "browsers": [
                        "E145",
                        "FF55",
                        "FFA55",
                        "C145",
                        "CA145"
                    ],
                    "baseline": {
                        "status": "false"
                    },
                    "description": "Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."
                },
                {
                    "name": "kashida",
                    "description": "Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."
                },
                {
                    "name": "newspaper"
                }
            ],
            "syntax": "auto | inter-character | inter-word | none",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-justify"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-orientation",
            "browsers": [
                "E79",
                "FF41",
                "FFA41",
                "S14",
                "SM14",
                "C48",
                "CA48",
                "O35"
            ],
            "values": [
                {
                    "name": "sideways",
                    "browsers": [
                        "E79",
                        "FF44",
                        "FFA44",
                        "S7",
                        "SM7",
                        "C12",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "This value is equivalent to 'sideways-right' in 'vertical-rl' writing mode and equivalent to 'sideways-left' in 'vertical-lr' writing mode."
                },
                {
                    "name": "sideways-right",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S14",
                        "SM14",
                        "C48",
                        "CA48",
                        "O35"
                    ],
                    "description": "In vertical writing modes, this causes text to be set as if in a horizontal layout, but rotated 90° clockwise."
                },
                {
                    "name": "upright",
                    "browsers": [
                        "E79",
                        "FF41",
                        "FFA41",
                        "S13.1",
                        "SM13.4",
                        "C12",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-03-24",
                        "baseline_high_date": "2022-09-24"
                    },
                    "description": "In vertical writing modes, characters from horizontal-only scripts are rendered upright, i.e. in their standard horizontal orientation."
                }
            ],
            "syntax": "mixed | upright | sideways",
            "relevance": 50,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-orientation"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-09-16",
                "baseline_high_date": "2023-03-16"
            },
            "description": "Specifies the orientation of text within a line.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-overflow",
            "browsers": [
                "E12",
                "FF7",
                "FFA7",
                "S1.3",
                "SM1",
                "C1",
                "CA18",
                "IE6",
                "O11"
            ],
            "values": [
                {
                    "name": "clip",
                    "browsers": [
                        "E12",
                        "FF7",
                        "FFA7",
                        "S1.3",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Clip inline content that overflows. Characters may be only partially rendered."
                },
                {
                    "name": "ellipsis",
                    "browsers": [
                        "E12",
                        "FF7",
                        "FFA7",
                        "S1.3",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Render an ellipsis character (U+2026) to represent clipped inline content."
                }
            ],
            "syntax": "[ clip | ellipsis | <string> ]{1,2}",
            "relevance": 82,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-overflow"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Text can overflow for example when it is prevented from wrapping.",
            "restrictions": [
                "enum",
                "string"
            ]
        },
        {
            "name": "text-rendering",
            "browsers": [
                "E79",
                "FF1",
                "FFA46",
                "S5",
                "SM4.2",
                "C4",
                "CA18",
                "O15"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA46",
                        "S5",
                        "SM4.2",
                        "C4",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    }
                },
                {
                    "name": "geometricPrecision",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA46",
                        "S6",
                        "SM6",
                        "C13",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Indicates that the user agent shall emphasize geometric precision over legibility and rendering speed."
                },
                {
                    "name": "optimizeLegibility",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S5",
                        "SM4.2",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Indicates that the user agent shall emphasize legibility over rendering speed and geometric precision."
                },
                {
                    "name": "optimizeSpeed",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S5",
                        "SM4.2",
                        "C31",
                        "CA31",
                        "O18"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "Indicates that the user agent shall emphasize rendering speed over legibility and geometric precision."
                }
            ],
            "syntax": "auto | optimizeSpeed | optimizeLegibility | geometricPrecision",
            "relevance": 66,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-rendering"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-01-15",
                "baseline_high_date": "2022-07-15"
            },
            "description": "The creator of SVG content might want to provide a hint to the implementation about what tradeoffs to make as it renders text. The 'text-rendering' property provides these hints.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-shadow",
            "browsers": [
                "E12",
                "FF3.5",
                "FFA4",
                "S1.1",
                "SM1",
                "C2",
                "CA18",
                "IE10",
                "O9.5"
            ],
            "values": [
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S1.1",
                        "SM1",
                        "C2",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No shadow."
                }
            ],
            "syntax": "none | <shadow-t>#",
            "relevance": 72,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-shadow"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Enables shadow effects to be applied to the text of the element.",
            "restrictions": [
                "length",
                "color"
            ]
        },
        {
            "name": "text-transform",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O7"
            ],
            "values": [
                {
                    "name": "capitalize",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE4",
                        "O7"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Puts the first typographic letter unit of each word in titlecase."
                },
                {
                    "name": "lowercase",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Puts all letters in lowercase."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No effects."
                },
                {
                    "name": "uppercase",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Puts all letters in uppercase."
                }
            ],
            "syntax": "none | [ capitalize | uppercase | lowercase ] || full-width || full-size-kana | math-auto",
            "relevance": 86,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-transform"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Controls capitalization effects of an element's text.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "text-underline-position",
            "browsers": [
                "E12",
                "FF74",
                "FFA79",
                "S12.1",
                "SM12.2",
                "C33",
                "CA33",
                "IE6",
                "O20"
            ],
            "values": [
                {
                    "name": "above"
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E79",
                        "FF74",
                        "FFA79",
                        "S12.1",
                        "SM12.2",
                        "C33",
                        "CA33",
                        "IE6",
                        "O20"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-07-28",
                        "baseline_high_date": "2023-01-28"
                    },
                    "description": "The user agent may use any algorithm to determine the underline's position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."
                },
                {
                    "name": "below",
                    "description": "The underline is aligned with the under edge of the element's content box."
                }
            ],
            "syntax": "auto | from-font | [ under || [ left | right ] ]",
            "relevance": 52,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/text-underline-position"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2020-07-28",
                "baseline_high_date": "2023-01-28"
            },
            "description": "Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements. This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "top",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE5",
                "O6"
            ],
            "values": [
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
                }
            ],
            "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
            "relevance": 95,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/top"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "Specifies how far an absolutely positioned box's top margin edge is offset below the top edge of the box's 'containing block'.",
            "restrictions": [
                "length",
                "percentage"
            ]
        },
        {
            "name": "touch-action",
            "browsers": [
                "E12",
                "FF52",
                "FFA52",
                "S13",
                "SM9.3",
                "C36",
                "CA36",
                "IE11",
                "O23"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "The user agent may determine any permitted touch behaviors for touches that begin on the element."
                },
                {
                    "name": "cross-slide-x",
                    "browsers": [
                        "E12",
                        "FF52",
                        "FFA52",
                        "S13",
                        "SM9.3",
                        "C36",
                        "CA36",
                        "IE11",
                        "O23"
                    ]
                },
                {
                    "name": "cross-slide-y",
                    "browsers": [
                        "E12",
                        "FF52",
                        "FFA52",
                        "S13",
                        "SM9.3",
                        "C36",
                        "CA36",
                        "IE11",
                        "O23"
                    ]
                },
                {
                    "name": "double-tap-zoom",
                    "browsers": [
                        "E12",
                        "FF52",
                        "FFA52",
                        "S13",
                        "SM9.3",
                        "C36",
                        "CA36",
                        "IE11",
                        "O23"
                    ]
                },
                {
                    "name": "manipulation",
                    "browsers": [
                        "E12",
                        "FF52",
                        "FFA52",
                        "S13",
                        "SM9.3",
                        "C36",
                        "CA36",
                        "IE11",
                        "O23"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2019-09-19",
                        "baseline_high_date": "2022-03-19"
                    },
                    "description": "The user agent may consider touches that begin on the element only for the purposes of scrolling and continuous zooming."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF52",
                        "FFA52",
                        "S13",
                        "SM13",
                        "C36",
                        "CA36",
                        "IE11",
                        "O23"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2019-09-19",
                        "baseline_high_date": "2022-03-19"
                    },
                    "description": "Touches that begin on the element must not trigger default touch behaviors."
                },
                {
                    "name": "pan-x",
                    "browsers": [
                        "E12",
                        "FF52",
                        "FFA52",
                        "S13",
                        "SM13",
                        "C36",
                        "CA36",
                        "IE11",
                        "O23"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2019-09-19",
                        "baseline_high_date": "2022-03-19"
                    },
                    "description": "The user agent may consider touches that begin on the element only for the purposes of horizontally scrolling the element's nearest ancestor with horizontally scrollable content."
                },
                {
                    "name": "pan-y",
                    "browsers": [
                        "E12",
                        "FF52",
                        "FFA52",
                        "S13",
                        "SM13",
                        "C36",
                        "CA36",
                        "IE11",
                        "O23"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2019-09-19",
                        "baseline_high_date": "2022-03-19"
                    },
                    "description": "The user agent may consider touches that begin on the element only for the purposes of vertically scrolling the element's nearest ancestor with vertically scrollable content."
                },
                {
                    "name": "pinch-zoom",
                    "browsers": [
                        "E12",
                        "FF85",
                        "FFA85",
                        "S13",
                        "SM13",
                        "C56",
                        "CA56",
                        "IE11",
                        "O43"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2021-01-26",
                        "baseline_high_date": "2023-07-26"
                    }
                }
            ],
            "syntax": "auto | none | [ [ pan-x | pan-left | pan-right ] || [ pan-y | pan-up | pan-down ] || pinch-zoom ] | manipulation",
            "relevance": 71,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/touch-action"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2019-09-19",
                "baseline_high_date": "2022-03-19"
            },
            "description": "Determines whether touch input may trigger default behavior supplied by user agent.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "transform",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C36",
                "CA36",
                "IE10",
                "O23"
            ],
            "values": [
                {
                    "name": "matrix()",
                    "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
                },
                {
                    "name": "matrix3d()",
                    "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF3.5",
                        "FFA4",
                        "S3.1",
                        "SM3.2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "perspective()",
                    "description": "Specifies a perspective projection matrix."
                },
                {
                    "name": "rotate()",
                    "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
                },
                {
                    "name": "rotate3d()",
                    "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
                },
                {
                    "name": "rotateX('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the X axis."
                },
                {
                    "name": "rotateY('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Y axis."
                },
                {
                    "name": "rotateZ('angle')",
                    "description": "Specifies a clockwise rotation by the given angle about the Z axis."
                },
                {
                    "name": "scale()",
                    "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
                },
                {
                    "name": "scale3d()",
                    "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
                },
                {
                    "name": "scaleX()",
                    "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
                },
                {
                    "name": "scaleY()",
                    "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
                },
                {
                    "name": "scaleZ()",
                    "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
                },
                {
                    "name": "skew()",
                    "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
                },
                {
                    "name": "skewX()",
                    "description": "Specifies a skew transformation along the X axis by the given angle."
                },
                {
                    "name": "skewY()",
                    "description": "Specifies a skew transformation along the Y axis by the given angle."
                },
                {
                    "name": "translate()",
                    "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
                },
                {
                    "name": "translate3d()",
                    "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
                },
                {
                    "name": "translateX()",
                    "description": "Specifies a translation by the given amount in the X direction."
                },
                {
                    "name": "translateY()",
                    "description": "Specifies a translation by the given amount in the Y direction."
                },
                {
                    "name": "translateZ()",
                    "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
                }
            ],
            "syntax": "none | <transform-list>",
            "relevance": 92,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/transform"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "transform-origin",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C36",
                "CA36",
                "IE10",
                "O23"
            ],
            "syntax": "[ <length-percentage> | left | center | right | top | bottom ] | [ [ <length-percentage> | left | center | right ] && [ <length-percentage> | top | center | bottom ] ] <length>?",
            "relevance": 77,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/transform-origin"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Establishes the origin of transformation for an element.",
            "restrictions": [
                "position",
                "length",
                "percentage"
            ]
        },
        {
            "name": "transform-style",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C36",
                "CA36",
                "O23"
            ],
            "values": [
                {
                    "name": "flat",
                    "browsers": [
                        "E12",
                        "FF10",
                        "FFA10",
                        "S4",
                        "SM3.2",
                        "C12",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "All children of this element are rendered flattened into the 2D plane of the element."
                },
                {
                    "name": "preserve-3d",
                    "browsers": [
                        "E12",
                        "FF10",
                        "FFA10",
                        "S4",
                        "SM3.2",
                        "C12",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Flattening is not performed, so children maintain their position in 3D space."
                }
            ],
            "syntax": "flat | preserve-3d",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/transform-style"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Defines how nested elements are rendered in 3D space.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "transition",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C26",
                "CA26",
                "IE10",
                "O12.1"
            ],
            "values": [
                {
                    "name": "all",
                    "browsers": [
                        "E12",
                        "FF4",
                        "FFA4",
                        "S3.1",
                        "SM2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF4",
                        "FFA4",
                        "S3.1",
                        "SM2",
                        "C1",
                        "CA18",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No property will transition."
                }
            ],
            "syntax": "<single-transition>#",
            "relevance": 90,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/transition"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Shorthand property combines four of the transition properties into a single property.",
            "restrictions": [
                "time",
                "property",
                "timing-function",
                "enum"
            ]
        },
        {
            "name": "transition-delay",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C26",
                "CA26",
                "IE10",
                "O12.1"
            ],
            "syntax": "<time>#",
            "relevance": 64,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/transition-delay"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "transition-duration",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C26",
                "CA26",
                "IE10",
                "O12.1"
            ],
            "syntax": "<time>#",
            "relevance": 71,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/transition-duration"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Specifies how long the transition from the old value to the new value should take.",
            "restrictions": [
                "time"
            ]
        },
        {
            "name": "transition-property",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C26",
                "CA26",
                "IE10",
                "O12.1"
            ],
            "values": [
                {
                    "name": "all",
                    "browsers": [
                        "E12",
                        "FF4",
                        "FFA4",
                        "S3.1",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Every property that is able to undergo a transition will do so."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF4",
                        "FFA4",
                        "S3.1",
                        "SM2",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "No property will transition."
                }
            ],
            "syntax": "none | <single-transition-property>#",
            "relevance": 71,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/transition-property"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Specifies the name of the CSS property to which the transition is applied.",
            "restrictions": [
                "property"
            ]
        },
        {
            "name": "transition-timing-function",
            "browsers": [
                "E12",
                "FF16",
                "FFA16",
                "S9",
                "SM9",
                "C26",
                "CA26",
                "IE10",
                "O12.1"
            ],
            "syntax": "<easing-function>#",
            "relevance": 69,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/transition-timing-function"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-09-30",
                "baseline_high_date": "2018-03-30"
            },
            "description": "Describes how the intermediate values used during a transition will be calculated.",
            "restrictions": [
                "timing-function"
            ]
        },
        {
            "name": "unicode-bidi",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1.3",
                "SM1",
                "C2",
                "CA18",
                "IE5.5",
                "O9.2"
            ],
            "values": [
                {
                    "name": "bidi-override",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.3",
                        "SM1",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Inside the element, reordering is strictly in sequence according to the 'direction' property; the implicit part of the bidirectional algorithm is ignored."
                },
                {
                    "name": "embed",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.3",
                        "SM1",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "If the element is inline-level, this value opens an additional level of embedding with respect to the bidirectional algorithm. The direction of this embedding level is given by the 'direction' property."
                },
                {
                    "name": "isolate",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S11",
                        "SM11",
                        "C48",
                        "CA48",
                        "O35"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "The contents of the element are considered to be inside a separate, independent paragraph."
                },
                {
                    "name": "isolate-override",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S11",
                        "SM11",
                        "C48",
                        "CA48",
                        "O35"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "This combines the isolation behavior of 'isolate' with the directional override behavior of 'bidi-override'"
                },
                {
                    "name": "normal",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1.3",
                        "SM1",
                        "C2",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The element does not open an additional level of embedding with respect to the bidirectional algorithm. For inline-level elements, implicit reordering works across element boundaries."
                },
                {
                    "name": "plaintext",
                    "browsers": [
                        "E79",
                        "FF50",
                        "FFA50",
                        "S11",
                        "SM11",
                        "C48",
                        "CA48",
                        "O35"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2020-01-15",
                        "baseline_high_date": "2022-07-15"
                    },
                    "description": "For the purposes of the Unicode bidirectional algorithm, the base directionality of each bidi paragraph for which the element forms the containing block is determined not by the element's computed 'direction'."
                }
            ],
            "syntax": "normal | embed | isolate | bidi-override | isolate-override | plaintext",
            "relevance": 56,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/unicode-bidi"
                }
            ],
            "baseline": {
                "status": "high",
                "baseline_low_date": "2015-07-29",
                "baseline_high_date": "2018-01-29"
            },
            "description": "The level of embedding with respect to the bidirectional algorithm.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "unicode-range",
            "values": [
                {
                    "name": "U+26",
                    "description": "Ampersand."
                },
                {
                    "name": "U+20-24F, U+2B0-2FF, U+370-4FF, U+1E00-1EFF, U+2000-20CF, U+2100-23FF, U+2500-26FF, U+E000-F8FF, U+FB00-FB4F",
                    "description": "WGL4 character set (Pan-European)."
                },
                {
                    "name": "U+20-17F, U+2B0-2FF, U+2000-206F, U+20A0-20CF, U+2100-21FF, U+2600-26FF",
                    "description": "The Multilingual European Subset No. 1. Latin. Covers ~44 languages."
                },
                {
                    "name": "U+20-2FF, U+370-4FF, U+1E00-20CF, U+2100-23FF, U+2500-26FF, U+FB00-FB4F, U+FFF0-FFFD",
                    "description": "The Multilingual European Subset No. 2. Latin, Greek, and Cyrillic. Covers ~128 language."
                },
                {
                    "name": "U+20-4FF, U+530-58F, U+10D0-10FF, U+1E00-23FF, U+2440-245F, U+2500-26FF, U+FB00-FB4F, U+FE20-FE2F, U+FFF0-FFFD",
                    "description": "The Multilingual European Subset No. 3. Covers all characters belonging to European scripts."
                },
                {
                    "name": "U+00-7F",
                    "description": "Basic Latin (ASCII)."
                },
                {
                    "name": "U+80-FF",
                    "description": "Latin-1 Supplement. Accented characters for Western European languages, common punctuation characters, multiplication and division signs."
                },
                {
                    "name": "U+100-17F",
                    "description": "Latin Extended-A. Accented characters for for Czech, Dutch, Polish, and Turkish."
                },
                {
                    "name": "U+180-24F",
                    "description": "Latin Extended-B. Croatian, Slovenian, Romanian, Non-European and historic latin, Khoisan, Pinyin, Livonian, Sinology."
                },
                {
                    "name": "U+1E00-1EFF",
                    "description": "Latin Extended Additional. Vietnamese, German captial sharp s, Medievalist, Latin general use."
                },
                {
                    "name": "U+250-2AF",
                    "description": "International Phonetic Alphabet Extensions."
                },
                {
                    "name": "U+370-3FF",
                    "description": "Greek and Coptic."
                },
                {
                    "name": "U+1F00-1FFF",
                    "description": "Greek Extended. Accented characters for polytonic Greek."
                },
                {
                    "name": "U+400-4FF",
                    "description": "Cyrillic."
                },
                {
                    "name": "U+500-52F",
                    "description": "Cyrillic Supplement. Extra letters for Komi, Khanty, Chukchi, Mordvin, Kurdish, Aleut, Chuvash, Abkhaz, Azerbaijani, and Orok."
                },
                {
                    "name": "U+00-52F, U+1E00-1FFF, U+2200-22FF",
                    "description": "Latin, Greek, Cyrillic, some punctuation and symbols."
                },
                {
                    "name": "U+530-58F",
                    "description": "Armenian."
                },
                {
                    "name": "U+590-5FF",
                    "description": "Hebrew."
                },
                {
                    "name": "U+600-6FF",
                    "description": "Arabic."
                },
                {
                    "name": "U+750-77F",
                    "description": "Arabic Supplement. Additional letters for African languages, Khowar, Torwali, Burushaski, and early Persian."
                },
                {
                    "name": "U+8A0-8FF",
                    "description": "Arabic Extended-A. Additional letters for African languages, European and Central Asian languages, Rohingya, Tamazight, Arwi, and Koranic annotation signs."
                },
                {
                    "name": "U+700-74F",
                    "description": "Syriac."
                },
                {
                    "name": "U+900-97F",
                    "description": "Devanagari."
                },
                {
                    "name": "U+980-9FF",
                    "description": "Bengali."
                },
                {
                    "name": "U+A00-A7F",
                    "description": "Gurmukhi."
                },
                {
                    "name": "U+A80-AFF",
                    "description": "Gujarati."
                },
                {
                    "name": "U+B00-B7F",
                    "description": "Oriya."
                },
                {
                    "name": "U+B80-BFF",
                    "description": "Tamil."
                },
                {
                    "name": "U+C00-C7F",
                    "description": "Telugu."
                },
                {
                    "name": "U+C80-CFF",
                    "description": "Kannada."
                },
                {
                    "name": "U+D00-D7F",
                    "description": "Malayalam."
                },
                {
                    "name": "U+D80-DFF",
                    "description": "Sinhala."
                },
                {
                    "name": "U+118A0-118FF",
                    "description": "Warang Citi."
                },
                {
                    "name": "U+E00-E7F",
                    "description": "Thai."
                },
                {
                    "name": "U+1A20-1AAF",
                    "description": "Tai Tham."
                },
                {
                    "name": "U+AA80-AADF",
                    "description": "Tai Viet."
                },
                {
                    "name": "U+E80-EFF",
                    "description": "Lao."
                },
                {
                    "name": "U+F00-FFF",
                    "description": "Tibetan."
                },
                {
                    "name": "U+1000-109F",
                    "description": "Myanmar (Burmese)."
                },
                {
                    "name": "U+10A0-10FF",
                    "description": "Georgian."
                },
                {
                    "name": "U+1200-137F",
                    "description": "Ethiopic."
                },
                {
                    "name": "U+1380-139F",
                    "description": "Ethiopic Supplement. Extra Syllables for Sebatbeit, and Tonal marks"
                },
                {
                    "name": "U+2D80-2DDF",
                    "description": "Ethiopic Extended. Extra Syllables for Me'en, Blin, and Sebatbeit."
                },
                {
                    "name": "U+AB00-AB2F",
                    "description": "Ethiopic Extended-A. Extra characters for Gamo-Gofa-Dawro, Basketo, and Gumuz."
                },
                {
                    "name": "U+1780-17FF",
                    "description": "Khmer."
                },
                {
                    "name": "U+1800-18AF",
                    "description": "Mongolian."
                },
                {
                    "name": "U+1B80-1BBF",
                    "description": "Sundanese."
                },
                {
                    "name": "U+1CC0-1CCF",
                    "description": "Sundanese Supplement. Punctuation."
                },
                {
                    "name": "U+4E00-9FD5",
                    "description": "CJK (Chinese, Japanese, Korean) Unified Ideographs. Most common ideographs for modern Chinese and Japanese."
                },
                {
                    "name": "U+3400-4DB5",
                    "description": "CJK Unified Ideographs Extension A. Rare ideographs."
                },
                {
                    "name": "U+2F00-2FDF",
                    "description": "Kangxi Radicals."
                },
                {
                    "name": "U+2E80-2EFF",
                    "description": "CJK Radicals Supplement. Alternative forms of Kangxi Radicals."
                },
                {
                    "name": "U+1100-11FF",
                    "description": "Hangul Jamo."
                },
                {
                    "name": "U+AC00-D7AF",
                    "description": "Hangul Syllables."
                },
                {
                    "name": "U+3040-309F",
                    "description": "Hiragana."
                },
                {
                    "name": "U+30A0-30FF",
                    "description": "Katakana."
                },
                {
                    "name": "U+A5, U+4E00-9FFF, U+30??, U+FF00-FF9F",
                    "description": "Japanese Kanji, Hiragana and Katakana characters plus Yen/Yuan symbol."
                },
                {
                    "name": "U+A4D0-A4FF",
                    "description": "Lisu."
                },
                {
                    "name": "U+A000-A48F",
                    "description": "Yi Syllables."
                },
                {
                    "name": "U+A490-A4CF",
                    "description": "Yi Radicals."
                },
                {
                    "name": "U+2000-206F",
                    "description": "General Punctuation."
                },
                {
                    "name": "U+3000-303F",
                    "description": "CJK Symbols and Punctuation."
                },
                {
                    "name": "U+2070-209F",
                    "description": "Superscripts and Subscripts."
                },
                {
                    "name": "U+20A0-20CF",
                    "description": "Currency Symbols."
                },
                {
                    "name": "U+2100-214F",
                    "description": "Letterlike Symbols."
                },
                {
                    "name": "U+2150-218F",
                    "description": "Number Forms."
                },
                {
                    "name": "U+2190-21FF",
                    "description": "Arrows."
                },
                {
                    "name": "U+2200-22FF",
                    "description": "Mathematical Operators."
                },
                {
                    "name": "U+2300-23FF",
                    "description": "Miscellaneous Technical."
                },
                {
                    "name": "U+E000-F8FF",
                    "description": "Private Use Area."
                },
                {
                    "name": "U+FB00-FB4F",
                    "description": "Alphabetic Presentation Forms. Ligatures for latin, Armenian, and Hebrew."
                },
                {
                    "name": "U+FB50-FDFF",
                    "description": "Arabic Presentation Forms-A. Contextual forms / ligatures for Persian, Urdu, Sindhi, Central Asian languages, etc, Arabic pedagogical symbols, word ligatures."
                },
                {
                    "name": "U+1F600-1F64F",
                    "description": "Emoji: Emoticons."
                },
                {
                    "name": "U+2600-26FF",
                    "description": "Emoji: Miscellaneous Symbols."
                },
                {
                    "name": "U+1F300-1F5FF",
                    "description": "Emoji: Miscellaneous Symbols and Pictographs."
                },
                {
                    "name": "U+1F900-1F9FF",
                    "description": "Emoji: Supplemental Symbols and Pictographs."
                },
                {
                    "name": "U+1F680-1F6FF",
                    "description": "Emoji: Transport and Map Symbols."
                }
            ],
            "atRule": "@font-face",
            "syntax": "<unicode-range-token>#",
            "relevance": 72,
            "description": "@font-face descriptor. Defines the set of Unicode codepoints that may be supported by the font face for which it is declared.",
            "restrictions": [
                "unicode-range"
            ]
        },
        {
            "name": "user-select",
            "browsers": [
                "E79",
                "FF69",
                "FFA79",
                "C54",
                "CA54",
                "IE10",
                "O41"
            ],
            "values": [
                {
                    "name": "all",
                    "browsers": [
                        "E79",
                        "FF1",
                        "FFA4",
                        "S16",
                        "SM16",
                        "C53",
                        "CA53",
                        "O40"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2022-09-12",
                        "baseline_high_date": "2025-03-12"
                    },
                    "description": "The content of the element must be selected atomically"
                },
                {
                    "name": "auto",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S2",
                        "SM3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    }
                },
                {
                    "name": "contain",
                    "description": "UAs must not allow a selection which is started in this element to be extended outside of this element."
                },
                {
                    "name": "none",
                    "browsers": [
                        "E12",
                        "FF21",
                        "FFA21",
                        "S2",
                        "SM3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The UA must not allow selections to be started in this element."
                },
                {
                    "name": "text",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S2",
                        "SM3",
                        "C1",
                        "CA18",
                        "IE10",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "The element imposes no constraint on the selection."
                }
            ],
            "syntax": "auto | text | none | all",
            "relevance": 83,
            "references": [
                {
                    "name": "MDN Reference",
                    "url": "https://developer.mozilla.org/docs/Web/CSS/Reference/Properties/user-select"
                }
            ],
            "baseline": {
                "status": "false"
            },
            "description": "Controls the appearance of selection.",
            "restrictions": [
                "enum"
            ]
        },
        {
            "name": "vertical-align",
            "browsers": [
                "E12",
                "FF1",
                "FFA4",
                "S1",
                "SM1",
                "C1",
                "CA18",
                "IE4",
                "O4"
            ],
            "values": [
                {
                    "name": "auto",
                    "description": "Align the dominant baseline of the parent box with the equivalent, or heuristically reconstructed, baseline of the element inline box."
                },
                {
                    "name": "baseline",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Align the 'alphabetic' baseline of the element with the 'alphabetic' baseline of the parent element."
                },
                {
                    "name": "bottom",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Align the after edge of the extended inline box with the after-edge of the line box."
                },
                {
                    "name": "middle",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Align the 'middle' baseline of the inline element with the middle baseline of the parent."
                },
                {
                    "name": "sub",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "CA18",
                        "IE11",
                        "O15"
                    ],
                    "baseline": {
                        "status": "high",
                        "baseline_low_date": "2015-07-29",
                        "baseline_high_date": "2018-01-29"
                    },
                    "description": "Lower the baseline of the box to the proper position for subscripts of the parent's box. (This value has no effect on the font size of the element's text.)"
                },
                {
                    "name": "super",
                    "browsers": [
                        "E12",
                        "FF1",
                        "FFA4",
                        "S1",
                        "SM1",
                        "C1",
                        "